/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PutDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "put";

    public PutDropBoxOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)this.syntax.setAction("PUT").addParameter((AbstractParameter)((StringParameter)new DropBoxPathParameter("src local file").setCompleter(new SLFilePathCompleter(false))).setName("src"))).addParameter((AbstractParameter)new DropBoxPathParameter("dst dropbox path").setName("dst"));
        this.syntax.setDescription("Put a local file into a dropbox.\n\nAutocompletion can be used to explore file locations based on Server or Client session context.");
        this.syntax.setExamples("put \"./data/samples/CORD19-metadata.csv\" \"my-metadata.csv\"");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("src").getValue(), statement.getParameter("dst").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            Path dstParentPath;
            String dstParent;
            String src = PutDropBoxOperation.unquote(((Definition)statement).src);
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, src);
            if (!utils.exists(src)) {
                throw new Exception("Source file doesn't exist.");
            }
            if (utils.isDirectory(src)) {
                throw new Exception("Source file is a directory.");
            }
            String dst = PutDropBoxOperation.unquote(((Definition)statement).dst);
            if (fileSystem.exists(dst) && fileSystem.isDirectory(dst) || dst.endsWith("/")) {
                dst = Paths.get(dst, new File(src).getName()).toString();
            }
            String string = dstParent = (dstParentPath = Paths.get(dst, new String[0]).getParent()) != null ? dstParentPath.toString() + "/" : "./";
            if (!fileSystem.exists(dstParent)) {
                throw new Exception("Destination directory doesn't exist.");
            }
            if (!fileSystem.exists(dstParent) || !fileSystem.isDirectory(dstParent)) {
                throw new Exception("Destination directory is not a directory.");
            }
            try (SLFileInputStream inputStream = utils.createSLFileInputStream(src);
                 OutputStream outputStream = fileSystem.create(dst, false);){
                inputStream.open();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, session.getSLSessionData().getTransferBufferSize());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, session.getSLSessionData().getTransferBufferSize());
                FileIOUtils.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                bufferedOutputStream.flush();
            }
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private final String src;
        private final String dst;

        protected Definition(String src, String dst) {
            super(PutDropBoxOperation.NAME);
            this.src = src;
            this.dst = dst;
        }
    }
}

