/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileCodec;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.mf.operation.MergeFilesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxFileSystemProxy;
import com.streamscape.sef.dropbox.DropBoxFileSystemWithNotifications;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.BadRequestException;
import org.apache.commons.io.FilenameUtils;

public class MputDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "mput";

    public MputDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MPUT");
        this.syntax.addParameter((AbstractParameter)((StringParameter)new DropBoxPathParameter("src file name part").setCompleter(new SLFilePathCompleter(false))).setName("src"));
        this.syntax.addParameter((AbstractParameter)new DropBoxPathParameter("dst dropbox filename").setName("dst"));
        this.syntax.addParameter((AbstractParameter)new IntegerParameter("part ID").setName("partId"));
        this.syntax.addModifier((AbstractModifier)new Modifier("CODEC").addParameter(new EnumParameter("codecType", FileCodec.FileCodecType.class)));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("CLOSE").setName("close")).setRequired(false));
        this.syntax.setDescription("Puts part files to dropbox and merges them.\n\nParameters:\n\n   source file         - path to source\n   path to target file - path to target file in dropbox\n   part ID             - ID of current part\n   codec               - one of binary or audio\n                            - binary - simple append files\n                            - audio  - merge files using ffmpeg library\n   close               - if set then all uploaded part will be merged and to single target file and all parts will be removed\n");
        this.syntax.setExamples("mput my/path/file1.txt myfolder/fullfile.txt 1 codec binary\nmput my/path/file2.txt myfolder/fullfile.txt 2 codec binary\nmput my/path/file3.txt myfolder/fullfile.txt 3 codec binary close\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, final MFSession session, final DropBoxConnectionService callable, final DropBoxAccessor accessor) throws Exception {
        SLOperationLogger.setCurrentSession(session);
        DSLStatement statement = ((Definition)definition).statement;
        String sourceFile = MputDropBoxOperation.unquote(statement.getParameter("src").getValue());
        String destinationFile = MputDropBoxOperation.unquote(statement.getParameter("dst").getValue());
        int partId = statement.getParameter("partId").getValue(0);
        FileCodec.FileCodecType codec = FileCodec.FileCodecType.valueOf(statement.getParameter("codecType").getValue().toUpperCase());
        boolean close = statement.existsModifier("close");
        String destinationFileWithDropBoxName = callable.getDropBoxName() + "/" + DropBoxUtils.normalizePath(callable.getCurrentPath() + "/" + destinationFile);
        final SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, sourceFile);
        if (!utils.exists(sourceFile)) {
            throw new Exception("Source file doesn't exist.");
        }
        if (utils.isDirectory(sourceFile)) {
            throw new Exception("Source file is a directory.");
        }
        MputDropBoxOperation.mput(new MputHelper(){

            @Override
            public DropBox checkAndGetDropBox(String targetFile) {
                return callable.getDropBoxAccessor().getDropBox();
            }

            @Override
            public FileSystem getFileSystem(DropBox dropBox) {
                FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
                if (fileSystem instanceof DropBoxFileSystemProxy) {
                    ((DropBoxFileSystemProxy)fileSystem).setCloseAccessorOnClose();
                }
                return fileSystem;
            }

            @Override
            public void uploadFile(String sourceFile, String targetPathInDropBox, String targetFileNamePart) throws Exception {
                try (FileSystem fileSystem = DropBoxFileSystemWithNotifications.withDisabledNotifications(accessor.createFileSystem(session.getOwnerName(), callable.getDropBoxPathNotation()));){
                    String dstParent;
                    Object dst = targetPathInDropBox + "/" + targetFileNamePart;
                    dst = AbstractDropBoxConnectionOperation.unquote((String)dst);
                    Path dstParentPath = Paths.get((String)dst, new String[0]).getParent();
                    String string = dstParent = dstParentPath != null ? dstParentPath.toString() : ".";
                    if (!fileSystem.exists(dstParent)) {
                        throw new Exception("Destination directory doesn't exist.");
                    }
                    if (!fileSystem.exists(dstParent) || !fileSystem.isDirectory(dstParent)) {
                        throw new Exception("Destination directory is not a directory.");
                    }
                    try (SLFileInputStream inputStream = utils.createSLFileInputStream(sourceFile);
                         OutputStream outputStream = fileSystem.create((String)dst, false);){
                        if (inputStream instanceof SLFileInputStream) {
                            inputStream.setVerbose(false);
                        }
                        inputStream.open();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, session.getSLSessionData().getTransferBufferSize());
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, session.getSLSessionData().getTransferBufferSize());
                        FileIOUtils.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                        bufferedOutputStream.flush();
                    }
                }
            }
        }, sourceFile, destinationFileWithDropBoxName, partId, codec, close);
        return new SLResponse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mput(MputHelper mputHelper, String sourceFile, String targetFileWithDropBoxName, int partId, FileCodec.FileCodecType codecType, boolean close) {
        try {
            String fileNameExtension = FilenameUtils.getExtension(targetFileWithDropBoxName);
            String fileNameExtensionAppend = fileNameExtension != null && fileNameExtension.length() > 0 ? "." + fileNameExtension : "";
            String targetFileName = new File(DropBoxUtils.removeDropBoxPrefix(targetFileWithDropBoxName)).getName();
            String targetPathInDropBox = new File(DropBoxUtils.getDropBoxPathFromURL(targetFileWithDropBoxName)).getParent();
            String targetFilePathInDropBox = DropBoxUtils.getDropBoxPathFromURL(targetFileWithDropBoxName);
            String targetFileNamePart = targetFileName + ".part." + partId + fileNameExtensionAppend;
            String targetFilePartPathInDropBox = targetPathInDropBox + "/" + targetFileNamePart;
            String targetFileMergedTmpPathInDropBox = targetPathInDropBox + "/" + targetFileName + ".merged." + System.currentTimeMillis() + fileNameExtensionAppend;
            DropBox dropBox = mputHelper.checkAndGetDropBox(targetFileWithDropBoxName);
            try (FileSystem fileSystem = mputHelper.getFileSystem(dropBox);){
                if (fileSystem.exists(targetFilePathInDropBox)) {
                    throw new BadRequestException("Target file already exist.");
                }
                if (fileSystem.exists(targetFilePartPathInDropBox)) {
                    throw new BadRequestException("Target file part " + partId + " already exists.");
                }
                SLOperationLogger.log("Uploading file part " + partId + " to " + targetPathInDropBox + "/" + targetFileNamePart + "...\n");
                mputHelper.uploadFile(sourceFile, targetPathInDropBox, targetFileNamePart);
                if (close) {
                    List<String> targetFileParts = IntStream.range(1, partId + 1).mapToObj(i -> {
                        String targetFilePartI = targetFilePathInDropBox + ".part." + i + fileNameExtensionAppend;
                        try {
                            if (fileSystem.exists(targetFilePartI)) {
                                return targetFilePartI;
                            }
                            throw new DropBoxException("File part " + targetFilePartI + " doesn't exist.");
                        }
                        catch (IOException e) {
                            throw new DropBoxException("File part " + targetFilePartI + " doesn't exist.");
                        }
                    }).collect(Collectors.toList());
                    SLOperationLogger.log("Merging file parts " + targetFileParts.stream().collect(Collectors.joining(",")) + " to " + targetFileMergedTmpPathInDropBox + ".\n");
                    MergeFilesOperation.mergeFiles(file -> DropBoxFileSystemWithNotifications.withDisabledNotifications(mputHelper.getFileSystem(dropBox)), targetFileParts, targetFileMergedTmpPathInDropBox, codecType, null, true);
                    SLOperationLogger.log("Renaming tmp merged file " + targetFileMergedTmpPathInDropBox + " to " + targetFilePathInDropBox + ".\n");
                    fileSystem.rename(targetFileMergedTmpPathInDropBox, targetFilePathInDropBox);
                    String string2 = targetFileName;
                    return string2;
                }
                String string = targetFileNamePart;
                return string;
            }
        }
        catch (Exception exception) {
            if (exception instanceof DropBoxException) throw (DropBoxException)exception;
            if (exception.getCause() instanceof DropBoxException) {
                exception = (Exception)exception.getCause();
                throw (DropBoxException)exception;
            }
            exception = new DropBoxException("File upload failed.", exception);
            throw (DropBoxException)exception;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(MputDropBoxOperation.NAME);
            this.statement = statement;
        }
    }

    public static interface MputHelper {
        public DropBox checkAndGetDropBox(String var1);

        public FileSystem getFileSystem(DropBox var1);

        public void uploadFile(String var1, String var2, String var3) throws Exception;
    }
}

