/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.AbstractParameter;

public class MkdirDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "mkdir";

    public MkdirDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MKDIR").addParameter((AbstractParameter)new DropBoxPathParameter("path").setEndDelimiterToCommandEnd());
        this.syntax.setDescription("Creates new directory[s].");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("path").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            ((Definition)statement).path = MkdirDropBoxOperation.unquote(((Definition)statement).path);
            if (fileSystem.exists(((Definition)statement).path)) {
                throw new Exception("Specified file/directory already exist.");
            }
            fileSystem.mkdir(((Definition)statement).path);
            SLResponse sLResponse = new SLResponse();
            return sLResponse;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        private String path;

        protected Definition(String path) {
            super(MkdirDropBoxOperation.NAME);
            this.path = path;
        }
    }
}

