/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.BinaryFileCodec;
import com.streamscape.lib.fs.client.FileCodec;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathCompleter;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class MergeFilesDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "merge files";

    public MergeFilesDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MERGE FILES").addActionParameter(new SetParameter("inputFilesSet").addParameter((AbstractParameter)new DropBoxPathParameter("input file").setCompleter(new DropBoxPathCompleter(DropBoxPathCompleter.PathScope.DIRECTORIES))));
        this.syntax.addModifier((AbstractModifier)new Modifier("TO").addParameter(new DropBoxPathParameter("output file")));
        this.syntax.addModifier(MergeFilesDropBoxOperation.createCodecCompound());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DELETE SOURCE").setName("deleteSource")).setRequired(false));
        this.syntax.setDescription("Merges file into single one using specified file.\n\nParameters:\n\n   input file     - path to input files in dropbox\n   ouput file     - path to output files in dropbox\n   codec          - one of binary or audio\n                    - binary - simple append files\n                    - audio  - merge files using ffmpeg library\n   delete source  - delete all input files\n");
        this.syntax.setExamples("");
    }

    public static CompoundModifier createCodecCompound() {
        return new CompoundModifier("CODEC_COMP").addModifier((AbstractModifier)new Modifier("CODEC").addParameter(new EnumParameter("codecTyoe", FileCodec.FileCodecType.class))).addModifier((AbstractModifier)new Modifier("ARGS").addParameter(new StringParameter("args")));
    }

    public static CodecCompound parseCodecCompound(DSLStatement statement) {
        FileCodec.FileCodecType codecType = FileCodec.FileCodecType.valueOf(statement.getParameter("codecTyoe").getValue());
        String args = statement.getParameter("args").getValue(null);
        return new CodecCompound(codecType, args);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        List inputFiles = statement.getSet("inputFilesSet").getElements().stream().map(element -> element.getParameter("input file").getValue()).collect(Collectors.toList());
        String outputFile = statement.getParameter("output file").getValue();
        boolean deleteSource = statement.existsModifier("deleteSource");
        CodecCompound codecCompound = MergeFilesDropBoxOperation.parseCodecCompound(statement);
        List inputFilesFullPath = inputFiles.stream().map(file -> DropBoxUtils.isEmptyOrDotPath(callable.getCurrentPath()) ? file : DropBoxUtils.normalizePath(callable.getCurrentPath() + "/" + file)).collect(Collectors.toList());
        String outputFileFullPath = DropBoxUtils.isEmptyOrDotPath(callable.getCurrentPath()) ? outputFile : DropBoxUtils.normalizePath(callable.getCurrentPath() + "/" + outputFile);
        FileCodec fileCodec = null;
        switch (codecCompound.codecType) {
            case AUDIO: {
                try {
                    Class audioFileCodecClass;
                    try {
                        audioFileCodecClass = ClassUtils.loadClass("com.streamscape.codec.AudioFileCodec", RuntimeContext.getInstance().getSystemClassLoaderChain());
                    }
                    catch (ClassNotFoundException e) {
                        audioFileCodecClass = ClassUtils.loadClass("com.streamscape.codec.AudioFileCodec", null);
                    }
                    fileCodec = (FileCodec)audioFileCodecClass.newInstance();
                    break;
                }
                catch (Exception exception) {
                    throw new DropBoxException("Audio codec is not available.");
                }
            }
            case BINARY: {
                fileCodec = new BinaryFileCodec();
            }
        }
        try (DropBoxFileSystem fileSystem = (DropBoxFileSystem)accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);){
            for (int i = 0; i < inputFilesFullPath.size(); ++i) {
                if (fileSystem.exists((String)inputFilesFullPath.get(i)) && fileSystem.isFile((String)inputFilesFullPath.get(i))) continue;
                throw new Exception("Input file " + (String)inputFiles.get(i) + " doesn't exist.");
            }
            if (fileSystem.exists(outputFileFullPath)) {
                throw new Exception("Output file " + outputFile + " already exist.");
            }
            List<String> inputFilesFullPathOs = inputFilesFullPath.stream().map(file -> {
                try {
                    return fileSystem.getFullOsPath((String)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            String outputFileFullPathOs = fileSystem.getFullOsPath(outputFileFullPath);
            fileCodec.mergeFiles(outputFileFullPathOs, inputFilesFullPathOs, codecCompound.args);
            if (deleteSource) {
                for (int i = 0; i < inputFilesFullPath.size(); ++i) {
                    fileSystem.delete((String)inputFilesFullPath.get(i), false);
                }
            }
        }
        return new SLResponse();
    }

    public static class CodecCompound {
        public FileCodec.FileCodecType codecType;
        public String args;

        public CodecCompound(FileCodec.FileCodecType codecType, String args) {
            this.codecType = codecType;
            this.args = args;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(MergeFilesDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

