/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxFileInfo;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LsDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "ls";

    public LsDropBoxOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)this.syntax.setAction("LS").addParameter((AbstractParameter)((ExpressionParameter)((ExpressionParameter)((ExpressionParameter)new ExpressionParameter("rmi").setName("modifiers")).setPrefix("-")).setRequired(false)).setCompletionAdviser(new CompletionAdviser<Object>(this){

            @Override
            public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
                return Arrays.asList("-r", "-m", "u", "-rm", "-ru", "-rmu", "-mu");
            }

            @Override
            public boolean isCaseSensitive() {
                return false;
            }
        }))).addParameter((AbstractParameter)((StringParameter)new DropBoxPathParameter("path").setEndDelimiterToCommandEnd()).setRequired(false));
        this.syntax.setDescription("Returns list of files in current directory.\n\n   -r - recursively managed and unmanaged resources\n   -m - only managed resources\n   -u - only unmanaged resources\n");
        this.syntax.setExamples("ls\nls -r\nls -r -m\nls -r -m -u\nls *.xml\nls ./*.xml\nls some/path/*.csv");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("modifiers").getValue(), statement.getParameter("path").getValue(null));
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        Definition definition = (Definition)statement;
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            SLResponse sLResponse = LsDropBoxOperation.ls(definition.path, definition.recursive, definition.onlyManaged, definition.onlyUnmanaged, fileSystem);
            return sLResponse;
        }
    }

    public static SLResponse ls(String path, boolean recursive, boolean onlyManaged, boolean onlyUnmanaged, FileSystem fileSystem) throws IOException, SQLException {
        if ((path = LsDropBoxOperation.unquote(path)) == null) {
            path = ".";
        }
        List<DropBoxFileInfo> list = ((DropBoxFileSystem)fileSystem).listDropBox(path, recursive);
        if (onlyManaged || onlyUnmanaged && (!onlyManaged || !onlyUnmanaged)) {
            if (onlyManaged) {
                list = list.stream().filter(i -> i.getManagedResourceName() != null).collect(Collectors.toList());
            } else if (onlyUnmanaged) {
                list = list.stream().filter(i -> i.getManagedResourceName() == null).collect(Collectors.toList());
            }
        }
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("File Name", String.class).addColumn("Size", String.class).addColumn("Type", String.class).addColumn("Managed Resource Name", String.class).addColumn("Shared", String.class).addColumn("Creation Time", String.class).addColumn("Modification Time", String.class).addColumn("Permissions", String.class).addColumn("OS Permissions", String.class).addColumn("OS Owner", String.class));
        for (DropBoxFileInfo info : list) {
            rowSet.addToRowSet(new Object[]{info.getName(), SizeUnit.convertToBestFractional(info.getSize(), SizeUnit.BYTES).toStringWithPrecision(2), info.getResourceType() != null ? info.getResourceType().getValue() : "n/a", info.getManagedResourceName() != null ? info.getManagedResourceName() : "n/a", info.getSharedResources().size() > 0 ? "true" : "false", info.getCreationTime() > 0L ? DataspaceDateTime.trimMills(LsDropBoxOperation.formatDateMillis(info.getCreationTime())) : "n/a", info.getModificationTime() > 0L ? DataspaceDateTime.trimMills(LsDropBoxOperation.formatDateMillis(info.getModificationTime())) : "n/a", info.getFolderType() != null ? info.getFolderType().getNameForDescribe() : "-", info.getPermissions().toString(), info.getOwner()});
        }
        return new SLResponse(rowSet);
    }

    static class Definition
    extends AbstractSLStatement {
        private final boolean recursive;
        private final boolean onlyManaged;
        private final boolean onlyUnmanaged;
        private final String path;

        protected Definition(String modifiers, String path) {
            super(LsDropBoxOperation.NAME);
            this.path = path;
            this.onlyUnmanaged = modifiers != null && modifiers.contains("u");
            this.recursive = modifiers != null && modifiers.contains("r");
            this.onlyManaged = modifiers != null && modifiers.contains("m");
        }
    }

    public static enum DropBoxResourceType {
        MANAGED_RESOURCE("Managed Resource"),
        UNMANAGED_RESOURCE("Unmanaged Resource"),
        MISSING_RESOURCE("Missing Resource"),
        DIRECTORY("Directory"),
        FILE("File"),
        UNKNOWN("Unknown");

        private String value;

        private DropBoxResourceType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

