/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;

public class GetDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "get";

    public GetDropBoxOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)this.syntax.setAction("GET").addParameter((AbstractParameter)new DropBoxPathParameter("src dropbox file").setName("src"))).addParameter((AbstractParameter)((StringParameter)new DropBoxPathParameter("dst local path").setCompleter(new SLFilePathCompleter(false))).setName("dst"));
        this.syntax.setDescription("Gets file from drop box and saves it locally.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("src").getValue(), statement.getParameter("dst").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), callable.getDropBoxPathNotation());){
            String dstParent;
            String src = GetDropBoxOperation.unquote(((Definition)statement).src);
            if (!fileSystem.exists(src)) {
                throw new Exception("Source file doesn't exist.");
            }
            if (fileSystem.isDirectory(src)) {
                throw new Exception("Source file is a directory.");
            }
            String dst = GetDropBoxOperation.unquote(((Definition)statement).dst);
            SLFileUtils utils = (SLFileUtils)new SLFileUtilsFactory().create(session, dst);
            if (utils.isDirectory() || dst.endsWith("/")) {
                dst = Paths.get(dst, new File(src).getName()).toString();
            }
            String string = dstParent = Paths.get(dst, new String[0]).getParent() != null ? Paths.get(dst, new String[0]).getParent().toString() : "./";
            if (!utils.exists(dstParent)) {
                throw new Exception("Destination directory doesn't exist.");
            }
            if (!utils.isDirectory(dstParent)) {
                throw new Exception("Destination directory is not a directory.");
            }
            try (InputStream inputStream = fileSystem.open(src);
                 SLFileOutputStream outputStream = utils.createSLFileOutputStream(dst);){
                outputStream.open();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, session.getSLSessionData().getTransferBufferSize());
                FileIOUtils.copy(inputStream, (OutputStream)bufferedOutputStream);
                bufferedOutputStream.flush();
            }
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private final String src;
        private final String dst;

        protected Definition(String src, String dst) {
            super(GetDropBoxOperation.NAME);
            this.src = src;
            this.dst = dst;
        }
    }
}

