/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.dsl.DropBoxPathCompleter;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.lexer.BufferUtils;

public class DropBoxPathParameter
extends StringParameter {
    private final String pathExcludeDelimiters = "\"'=()[]~!@#$%^&*+-_={}|:;<>,.?` ";

    public DropBoxPathParameter(String token) {
        this(token, null);
    }

    public DropBoxPathParameter(String token, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        super(token, Character.valueOf('\"'), Character.valueOf('\"'));
        this.setCompleter(new DropBoxPathCompleter(DropBoxPathCompleter.PathScope.ALL, dropBoxPathNotation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        String remainingScript = parser.getRemainingScript().trim();
        Character next = remainingScript.length() > 0 ? Character.valueOf(remainingScript.charAt(0)) : null;
        StatementParameterValue parameterValue = null;
        if (next != null && (next.charValue() == '[' || next.charValue() == '\"')) {
            Character startDelimiterOld = this.startDelimiter;
            Character endDelimiterOld = this.endDelimiter;
            if (next != null) {
                if (next.charValue() == '[') {
                    this.startDelimiter = Character.valueOf('[');
                    this.endDelimiter = Character.valueOf(']');
                } else {
                    this.startDelimiter = Character.valueOf('\"');
                    this.endDelimiter = Character.valueOf('\"');
                }
            }
            try {
                parameterValue = super.parse(statement, parser);
            }
            finally {
                this.startDelimiter = startDelimiterOld;
                this.endDelimiter = endDelimiterOld;
            }
        } else {
            ExpressionParameter expressionParamter = new ExpressionParameter(this.getName());
            expressionParamter.setExcludedDelimiters("\"'=()[]~!@#$%^&*+-_={}|:;<>,.?` ");
            expressionParamter.setRequired(false);
            parameterValue = expressionParamter.parse(statement, parser);
        }
        if (parameterValue != null && parameterValue.isPresent()) {
            parameterValue.setValue(BufferUtils.unslashPath(parameterValue.getValue()).replace("\\", "/"));
        }
        return parameterValue;
    }
}

