/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;

public class DropBoxPathCompleter
implements ScriptCompleter<DropBoxConnectionService> {
    private PathScope pathScope;
    private DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation;
    private boolean quoted;

    public DropBoxPathCompleter() {
        this(PathScope.ALL);
    }

    public DropBoxPathCompleter(PathScope pathScope) {
        this(pathScope, null);
    }

    public DropBoxPathCompleter(PathScope pathScope, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        this.pathScope = pathScope;
        this.dropBoxPathNotation = dropBoxPathNotation;
        this.quoted = true;
    }

    @Override
    public DSLCompletion complete(String script, String processedScript, DropBoxConnectionService callable, MFSession session) {
        DSLCompletion completion;
        String namePrefix = "";
        Object basePath = script;
        boolean isThisScriptQuoted = false;
        char quoteOpenSymbol = '[';
        char quoteCloseSymbol = '\u0000';
        if (((String)basePath).startsWith("[") || ((String)basePath).startsWith("\"")) {
            quoteOpenSymbol = ((String)basePath).charAt(0);
            basePath = ((String)basePath).substring(1);
            isThisScriptQuoted = true;
            char c = quoteCloseSymbol = quoteOpenSymbol == '[' ? (char)']' : quoteOpenSymbol;
        }
        if (((String)basePath).indexOf("/") != -1) {
            isThisScriptQuoted = false;
        }
        if (!((String)basePath).endsWith("/")) {
            int pos = ((String)basePath).lastIndexOf(File.separatorChar);
            namePrefix = ((String)basePath).substring(pos + 1);
            basePath = ((String)basePath).substring(0, pos + 1);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (namePrefix.equals(".")) {
            suggestions.add("./");
        }
        if (((String)basePath).length() == 0) {
            basePath = ".";
        }
        String namePrefixFinal = namePrefix;
        if (this.dropBoxPathNotation != null && this.dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.OS || this.dropBoxPathNotation == null && callable.getDropBoxPathNotation() == DropBoxAccessor.DropBoxPathNotation.OS || !DropBoxUtils.isEmptyOrDotPath(callable.getCurrentPath()) || !DropBoxUtils.isEmptyOrDotPath((String)basePath)) {
            DropBoxAccessor accessor = callable.getDropBoxAccessor();
            if (accessor.isS3() && !((String)basePath).endsWith("/")) {
                basePath = (String)basePath + "/";
            }
            try (FileSystem fileSystem = accessor.createFileSystemOnPath(callable.getCurrentPath(), session.getOwnerName(), this.dropBoxPathNotation != null ? this.dropBoxPathNotation : callable.getDropBoxPathNotation());){
                ArrayList fileSuggestions = new ArrayList();
                fileSystem.list((String)basePath).stream().filter(info -> (this.pathScope == PathScope.ALL || this.pathScope == PathScope.DIRECTORIES && info.isDirectory() || this.pathScope == PathScope.FILES && !info.isDirectory()) && info.getName().startsWith(namePrefixFinal)).forEach(info -> {
                    if (info.isDirectory()) {
                        suggestions.add((String)(info.getName().endsWith("/") ? info.getName() : info.getName() + "/"));
                    } else {
                        fileSuggestions.add(info.getName());
                    }
                });
                Collections.sort(suggestions, String::compareTo);
                Collections.sort(fileSuggestions, String::compareTo);
                suggestions.addAll(fileSuggestions);
            }
            catch (Exception exception) {
                throw new DropBoxException(Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        }
        if (!(!DropBoxUtils.isEmptyOrDotPath(callable.getCurrentPath()) || this.pathScope != PathScope.ALL && this.pathScope != PathScope.DIRECTORIES || script != null && script.contains("/"))) {
            boolean finalIsQuoted = isThisScriptQuoted;
            char finalQuoteOpenSymbol = quoteOpenSymbol;
            suggestions.addAll(callable.getDropBoxAccessor().getDropBox().getFolders().stream().filter(f -> DropBoxUtils.getUserAcl(f.getAclFolderContext(), session.getOwnerName(), null).size() > 0).map(f -> DropBoxUtils.buildFolderShortcut(f.getName())).filter(n -> n.startsWith(namePrefixFinal)).map(n -> this.quoted || finalIsQuoted ? finalQuoteOpenSymbol + n : n).collect(Collectors.toList()));
        }
        if ((completion = DSLCompletion.buildPrefixAndCompletion((String)(isThisScriptQuoted ? quoteOpenSymbol + namePrefix : namePrefix), suggestions)) != null) {
            for (String suggestion : suggestions) {
                completion.addSuggestion(new TokenSuggestion(suggestion, SuggestionGroup.PATH).setOffset((String)(isThisScriptQuoted ? quoteOpenSymbol + namePrefix : namePrefix)));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    public static enum PathScope {
        ALL,
        FILES,
        DIRECTORIES;

    }
}

