/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox.dsl;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathCompleter;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CdDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "cd";

    public CdDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CD").addParameter((AbstractParameter)((StringParameter)new DropBoxPathParameter("path").setCompleter(new DropBoxPathCompleter(DropBoxPathCompleter.PathScope.DIRECTORIES))).setEndDelimiterToCommandEnd());
        this.syntax.setDescription("Changes the current directory.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("path").getValue());
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        try (FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), callable.getDropBoxPathNotation());){
            String pathString = CdDropBoxOperation.unquote(((Definition)statement).path);
            Path path = pathString.equalsIgnoreCase("/") ? Paths.get(".", new String[0]) : Paths.get(callable.getCurrentPath(), pathString);
            path = path.normalize();
            Object pathPathString = path.toString();
            if (accessor.isS3() && !((String)pathPathString).endsWith("/")) {
                if (((String)pathPathString).length() == 0) {
                    pathPathString = ".";
                }
                pathPathString = (String)pathPathString + "/";
            }
            if (!fileSystem.exists((String)pathPathString)) {
                throw new Exception("Specified path doesn't exist.");
            }
            if (!fileSystem.isDirectory((String)pathPathString)) {
                throw new Exception("Specified path points to a file.");
            }
            if (pathString.length() == 0) {
                path = Paths.get(".", new String[0]);
                if (path.normalize().toString().contains("..")) {
                    throw new Exception("Specified path points out of drop box location.");
                }
                pathString = path.normalize().toString();
                pathPathString = pathString;
                if (accessor.isS3() && !((String)pathPathString).endsWith("/")) {
                    pathPathString = (String)pathPathString + "/";
                }
            }
            fileSystem.list((String)pathPathString);
            if (((String)pathPathString).equals(".") || ((String)pathPathString).equals("./")) {
                pathPathString = "";
            }
            callable.setCurrentPath((String)pathPathString);
            PromptSLResponse response = new PromptSLResponse(session.getOwnerName(), RuntimeContext.getInstance().getName(), "DropBox", accessor.getDropBox().getName() + (String)(((String)pathPathString).length() > 0 ? "/" + (String)pathPathString : ""));
            response.setPrompt(response.getPrompt(false));
            PromptSLResponse promptSLResponse = response;
            return promptSLResponse;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        private String path;

        protected Definition(String path) {
            super(CdDropBoxOperation.NAME);
            this.path = path;
        }
    }
}

