/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.ds.session.InputStreamWrapper;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dropbox.InputStreamProxy;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamAccessibleObject
extends InputStreamWrapper
implements AccessibleObject {
    private Runnable onCloseCallback;

    public InputStreamAccessibleObject(InputStream outputStream) {
        super(outputStream);
    }

    public byte[] readInternal(int len) throws IOException {
        if (len == 0) {
            return new byte[0];
        }
        byte[] bytesRead = new byte[len];
        int lenRead = this.read(bytesRead, 0, len);
        if (lenRead == len) {
            return bytesRead;
        }
        if (lenRead == -1) {
            return null;
        }
        if (lenRead == 0) {
            return new byte[0];
        }
        byte[] bytesTrim = new byte[lenRead];
        System.arraycopy(bytesRead, 0, bytesTrim, 0, lenRead);
        return bytesTrim;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new InputStreamProxy();
    }

    public InputStreamAccessibleObject setOnCloseCallback(Runnable onCloseCallback) {
        this.onCloseCallback = onCloseCallback;
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.run();
            }
        }
    }
}

