/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.persist.FlobManager;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxACL;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DropBoxUtils {
    public static final String URL_PROTOCOL = "dropbox";
    public static final String URL_PROTOCOL_PREFIX = "dropbox://";
    public static final String URL_PROTOCOL_PREFIX_TRIMMED = "dropbox:/";
    public static final String URL_USERNAME = "?username=";

    public static boolean isDropBoxURL(String url) {
        return url != null && url.trim().startsWith(URL_PROTOCOL_PREFIX_TRIMMED);
    }

    public static String getDropBoxNameFromURL(String url) {
        int pos = (url = DropBoxUtils.removeDropBoxPrefix(url)).indexOf("/");
        if (pos == -1) {
            pos = url.length();
        }
        return DropBoxUtils.removeDropBoxUsername(url.substring(0, pos));
    }

    public static String getDropBoxPathFromURL(String url) {
        int pos = (url = DropBoxUtils.removeDropBoxPrefix(url)).indexOf("/");
        if (pos == -1) {
            return "";
        }
        return DropBoxUtils.removeDropBoxUsername(url.substring(pos + 1));
    }

    public static String removeDropBoxPrefix(String url) {
        if (!DropBoxUtils.isDropBoxURL(url)) {
            return url;
        }
        url = url.substring(URL_PROTOCOL_PREFIX_TRIMMED.length());
        while (url.startsWith("/")) {
            url = url.substring(1);
        }
        return DropBoxUtils.normalizePath(url);
    }

    public static String removeDropBoxPrefixAndName(String url) {
        if (!DropBoxUtils.isDropBoxURL(url)) {
            return null;
        }
        url = url.substring(URL_PROTOCOL_PREFIX_TRIMMED.length());
        while (url.startsWith("/")) {
            url = url.substring(1);
        }
        int pos = (url = DropBoxUtils.normalizePath(url)).indexOf("/");
        if (pos != -1) {
            return url.substring(pos + 1);
        }
        return null;
    }

    public static String removeDropBoxUsername(String url) {
        int pos = url.indexOf(URL_USERNAME);
        if (pos >= 0) {
            url = url.substring(0, pos);
        }
        return url;
    }

    public static String getDropBoxUsername(String url) {
        int pos = url.indexOf(URL_USERNAME);
        if (pos >= 0) {
            return url.substring(pos + URL_USERNAME.length());
        }
        return null;
    }

    public static String getDropBoxURL(String dropboxName, String path) {
        return DropBoxUtils.getDropBoxURL(DropBoxUtils.getDropBoxPath(dropboxName, path));
    }

    public static String getDropBoxPath(String dropboxName, String path) {
        if (path == null) {
            path = "";
        }
        path = path.trim();
        return dropboxName + (String)((path = DropBoxUtils.replaceFolderShortcutToFolderName(path)).length() > 0 && !path.equals(".") && !path.equals("./") ? "/" + path : "");
    }

    public static String getDropBoxURL(String path) {
        return URL_PROTOCOL_PREFIX + path;
    }

    public static String normalizePath(String name) {
        while (((String)name).startsWith("./")) {
            name = ((String)name).substring(2);
        }
        while (((String)name).length() > 0 && (((String)name).charAt(0) == '/' || ((String)name).charAt(0) == '\\')) {
            name = ((String)name).substring(1);
        }
        String prefix = DropBoxUtils.getProtocolPrefix((String)name);
        if (prefix != null) {
            name = ((String)name).substring(prefix.length());
        }
        if (DropBoxUtils.isS3Path((String)name)) {
            Pair<String, String> pair = DropBoxUtils.splitS3Prefix((String)name);
            name = (String)pair.first + Paths.get((String)pair.second, new String[0]).normalize().toString();
        } else {
            name = Paths.get((String)name, new String[0]).normalize().toString();
        }
        while (((String)name).length() > 0 && (((String)name).charAt(((String)name).length() - 1) == '/' || ((String)name).charAt(((String)name).length() - 1) == '\\')) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
        }
        if (prefix != null) {
            name = URL_PROTOCOL_PREFIX_TRIMMED + (String)name;
        }
        return ((String)name).replace('\\', '/');
    }

    public static boolean isEmptyOrDotPath(String path) {
        return path == null || path.trim().equalsIgnoreCase(".") || path.trim().equalsIgnoreCase("") || path.trim().equals("./");
    }

    public static String getProtocolPrefix(String path) {
        if (path.startsWith(URL_PROTOCOL_PREFIX)) {
            return URL_PROTOCOL_PREFIX;
        }
        if (path.startsWith(URL_PROTOCOL_PREFIX_TRIMMED)) {
            return URL_PROTOCOL_PREFIX_TRIMMED;
        }
        return null;
    }

    public static void checkDropBoxRootFolderPath(DropBox dropBox) {
        DropBoxUtils.checkDropBoxRootFolderPath(DataspaceStoreManager.getRuntimeContext(), dropBox);
    }

    public static boolean isS3Path(String path) {
        return path.startsWith("s3:/");
    }

    public static String addTailingSlashForS3(String path) {
        return DropBoxUtils.isS3Path(path) && !path.endsWith("/") ? path + "/" : path;
    }

    public static Pair<String, String> splitS3Prefix(String path) {
        if (DropBoxUtils.isS3Path(path)) {
            int pos;
            for (pos = "s3:/".length(); pos < path.length() && path.charAt(pos) == '/'; ++pos) {
            }
            return new Pair<String, String>(path.substring(0, pos), path.substring(pos));
        }
        return new Pair<Object, String>(null, path);
    }

    public static void checkDropBoxRootFolderPath(RuntimeContext context, DropBox dropBox) {
        Path rootFolderPath;
        if (dropBox.getFsClientFactory() != null && !dropBox.getFsClientFactory().equals(DropBox.LOCAL_FACTORY) && !dropBox.getFsClientFactory().equals(DropBox.STFS_FACTORY) && DropBoxUtils.isS3Path(new MacroProcessor().process(dropBox.getRootFolder()))) {
            return;
        }
        Path rootFolderRelativePath = null;
        String rootFolder = new MacroProcessor().process(dropBox.getRootFolder());
        Path nodeRootPath = new File(".").getAbsoluteFile().toPath().normalize();
        if (nodeRootPath.startsWith(rootFolderPath = new File(rootFolder).getAbsoluteFile().toPath().normalize())) {
            throw new IllegalArgumentException("DropBox root folder cannot be parent of node working directory.");
        }
        if (rootFolderPath.startsWith(nodeRootPath)) {
            rootFolderRelativePath = nodeRootPath.relativize(rootFolderPath);
        }
        if (rootFolderRelativePath != null && (rootFolderRelativePath.getNameCount() == 0 || rootFolderRelativePath.getNameCount() == 1 && rootFolderRelativePath.startsWith(".") || rootFolderRelativePath.startsWith(".tfcache") || rootFolderRelativePath.getNameCount() == 1 && rootFolderRelativePath.startsWith(".dscache") || rootFolderRelativePath.startsWith(".tfcache"))) {
            throw new IllegalArgumentException("DropBox root folder cannot point to node root directory, .tfcache or .dscache.");
        }
        if (context.isDataspaceBound() && !context.getDataspaceManager().isAllowedPath(rootFolder)) {
            throw new DropBoxException("Access is blocked to dropbox path. Contact administrator to enable full_path access.").status(403);
        }
    }

    public static void checkAccessAny(DropBox dropBox, String username) {
        if (!DropBoxUtils.hasUserAccessAny(dropBox, username)) {
            throw new DropBoxException("Access Denied. No operations are allowed for user '" + username + "' on dropbox '" + dropBox.getName() + "'.").status(403);
        }
    }

    public static void checkUserAccess(DropBox dropBox, String username, DropBoxAccessControlOperation operation) {
        if (!DropBoxUtils.hasUserAccess(dropBox, username, operation)) {
            throw new DropBoxException("Access Denied. Operation '" + String.valueOf((Object)operation) + "' is not allowed for user '" + username + "' on dropbox '" + dropBox.getName() + "'.").status(403);
        }
    }

    public static void checkUserAccessOneOf(DropBox dropBox, String username, DropBoxAccessControlOperation ... operations) {
        for (DropBoxAccessControlOperation operation : operations) {
            if (!DropBoxUtils.hasUserAccess(dropBox, username, operation)) continue;
            return;
        }
        throw new DropBoxException("Access Denied. No one of operations '" + Arrays.stream(operations).map(o -> o.name()).collect(Collectors.joining(",")) + "' is allowed for user '" + username + "' on dropbox '" + dropBox.getName() + "'.").status(403);
    }

    public static boolean hasFullAccessAny(DropBox dropBox, String username, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        try {
            DropBoxUtils.checkFullAccessOneOf(dropBox, username, path, dropBoxPathNotation, DropBoxAccessControlOperation.FULL, DropBoxAccessControlOperation.LIST, DropBoxAccessControlOperation.PUBLIC, DropBoxAccessControlOperation.READ, DropBoxAccessControlOperation.WRITE);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void checkFullAccessAny(DropBox dropBox, String username, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        DropBoxUtils.checkFullAccessOneOf(dropBox, username, path, dropBoxPathNotation, DropBoxAccessControlOperation.FULL, DropBoxAccessControlOperation.LIST, DropBoxAccessControlOperation.PUBLIC, DropBoxAccessControlOperation.READ, DropBoxAccessControlOperation.WRITE);
    }

    public static void checkFullAccessOneOf(DropBox dropBox, String username, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation, DropBoxAccessControlOperation ... operations) {
        for (DropBoxAccessControlOperation operation : operations) {
            try {
                DropBoxUtils.checkFullAccess(dropBox, username, operation, path, dropBoxPathNotation);
                return;
            }
            catch (Exception exception) {
            }
        }
        throw new DropBoxException("Access Denied. No one of operations '" + Arrays.stream(operations).map(o -> o.name()).collect(Collectors.joining(",")) + "' is allowed for user '" + username + "' on dropbox '" + dropBox.getName() + "' and path '" + path + "'.").status(403);
    }

    public static void checkFullAccess(DropBox dropBox, String username, DropBoxAccessControlOperation operation, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        Set<DropBoxAccessControlOperation> userAcls = DropBoxUtils.getUserAclMerged(dropBox, username, path, dropBoxPathNotation, null);
        if (!DropBoxACL.isAllowed(userAcls, operation)) {
            throw new DropBoxException("Access Denied. Operation '" + String.valueOf((Object)operation) + "' is not allowed for user '" + username + "' on dropbox '" + dropBox.getName() + "' and path '" + path + "'.").status(403);
        }
        DropBoxUtils.checkFolderAccess(dropBox, userAcls, operation, path, dropBoxPathNotation);
    }

    private static void checkFolderAccess(DropBox dropBox, Set<DropBoxAccessControlOperation> userAcls, DropBoxAccessControlOperation operation, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        String normalizedPath = DropBoxUtils.normalizePath(path);
        if (DropBoxUtils.isEmptyOrDotPath(normalizedPath)) {
            if (dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS && operation != DropBoxAccessControlOperation.LIST) {
                throw new DropBoxException("Folder name is not specified in path " + path);
            }
            return;
        }
        DropBoxFolder folder = (DropBoxFolder)DropBoxUtils.getDropBoxFolderAndPathOrNull((DropBox)dropBox, (String)path, (DropBoxAccessor.DropBoxPathNotation)dropBoxPathNotation).first;
        if (folder == null) {
            if (userAcls.contains((Object)DropBoxAccessControlOperation.FULL) || dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS && DropBoxUtils.isEmptyOrDotPath(path) && (userAcls.contains((Object)DropBoxAccessControlOperation.LIST) || userAcls.contains((Object)DropBoxAccessControlOperation.FULL))) {
                return;
            }
            throw new DropBoxException("Path '" + normalizedPath + "' is not Dropbox Managed Resource.").status(404);
        }
        if (!userAcls.contains((Object)DropBoxAccessControlOperation.FULL) && folder.getType() == FolderType.DISABLED) {
            throw new DropBoxException("Only DropBox owners or users with FULL permissions can access DISABLED directories.").status(403);
        }
        if (operation == DropBoxAccessControlOperation.WRITE && !userAcls.contains((Object)DropBoxAccessControlOperation.WRITE) && folder.getType() != FolderType.UPLOAD && folder.getType() != FolderType.UPLOAD_AND_DOWNLOAD) {
            throw new DropBoxException("Folder '" + folder.getPath() + "' doesn't allow WRITE operation.").status(403);
        }
        if (operation == DropBoxAccessControlOperation.READ && !userAcls.contains((Object)DropBoxAccessControlOperation.READ) && folder.getType() != FolderType.DOWNLOAD && folder.getType() != FolderType.UPLOAD_AND_DOWNLOAD) {
            throw new DropBoxException("Folder '" + folder.getPath() + "' doesn't allow READ operation.").status(403);
        }
    }

    public static Pair<DropBoxFolder, String> getDropBoxFolderAndPath(DropBox dropBox, String path) {
        if (DropBoxUtils.isEmptyOrDotPath(path)) {
            throw new DropBoxException("Folder name is not specified in path " + path);
        }
        path = DropBoxUtils.normalizePath(path);
        int pos = (path = DropBoxUtils.replaceFolderShortcutToFolderName(path)).indexOf("/");
        String folderName = pos > 0 ? path.substring(0, pos) : path;
        String remainingPath = pos > 0 ? path.substring(pos + 1) : "";
        DropBoxFolder folder = dropBox.getFolderByName(folderName);
        if (folder == null) {
            throw new DropBoxException("Folder with name " + folderName + " doesn't exist.");
        }
        return new Pair<DropBoxFolder, String>(folder, remainingPath);
    }

    public static Pair<DropBoxFolder, String> getDropBoxFolderAndPathOrNull(DropBox dropBox, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        String normalizedPath = DropBoxUtils.normalizePath(path);
        if (dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS || normalizedPath.startsWith("$")) {
            try {
                return DropBoxUtils.getDropBoxFolderAndPath(dropBox, normalizedPath);
            }
            catch (Exception exception) {
                return new Pair<Object, Object>(null, null);
            }
        }
        DropBoxFolder folder = dropBox.getFolderBest(normalizedPath);
        if (normalizedPath.length() == 0) {
            folder = dropBox.getFolderBest(".");
        }
        if (folder == null) {
            return new Pair<Object, Object>(null, null);
        }
        String remainingPath = normalizedPath.length() > folder.getPath().length() ? normalizedPath.substring(folder.getPath().length()) : "";
        return new Pair<DropBoxFolder, String>(folder, remainingPath);
    }

    public static boolean hasUserAccessAny(DropBox dropBox, String username) {
        return DropBoxUtils.hasUserAccess(dropBox, username, null);
    }

    public static boolean hasUserAccess(DropBox dropBox, String username, DropBoxAccessControlOperation operation) {
        Set<DropBoxAccessControlOperation> userAcl = DropBoxUtils.getUserAclDropBox(dropBox, username, null);
        if (operation == null && userAcl.size() != 0 || DropBoxACL.isAllowed(userAcl, operation)) {
            return true;
        }
        for (DropBoxFolder folder : dropBox.getFolders()) {
            Set<DropBoxAccessControlOperation> acl = DropBoxUtils.getUserAcl(folder.getAclFolderContext(), username, operation);
            if ((operation != null || acl.size() == 0) && !DropBoxACL.isAllowed(acl, operation)) continue;
            return true;
        }
        return false;
    }

    public static Set<DropBoxAccessControlOperation> getUserAclDropBox(DropBox dropBox, String username, DropBoxAccessControlOperation operation) {
        if (username.equalsIgnoreCase(dropBox.getOwner())) {
            return DropBoxACL.FULL_EXTENDED;
        }
        return DropBoxUtils.getUserAcl(dropBox.getAclContext(), username, operation);
    }

    public static Set<DropBoxAccessControlOperation> getUserAclFolder(DropBox dropBox, String username, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation, DropBoxAccessControlOperation operation) {
        DropBoxFolder folder = (DropBoxFolder)DropBoxUtils.getDropBoxFolderAndPathOrNull((DropBox)dropBox, (String)path, (DropBoxAccessor.DropBoxPathNotation)dropBoxPathNotation).first;
        if (folder == null) {
            return new HashSet<DropBoxAccessControlOperation>();
        }
        return DropBoxUtils.getUserAcl(folder.getAclFolderContext(), username, operation);
    }

    public static Set<DropBoxAccessControlOperation> getUserAclMerged(DropBox dropBox, String username, String path, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation, DropBoxAccessControlOperation operation) {
        if (DropBoxUtils.isEmptyOrDotPath(path)) {
            return DropBoxUtils.getUserAclDropBox(dropBox, username, operation);
        }
        Set<DropBoxAccessControlOperation> aclFolder = DropBoxUtils.getUserAclFolder(dropBox, username, path, dropBoxPathNotation, operation);
        if (aclFolder.size() != 0) {
            return aclFolder;
        }
        return DropBoxUtils.getUserAclDropBox(dropBox, username, operation);
    }

    public static Set<DropBoxAccessControlOperation> getUserAcl(DropBoxACLContext aclContext, String username, DropBoxAccessControlOperation operation) {
        try {
            User user = DataspaceStoreManager.getRuntimeContext().getSecurityManager().lookupUser(username);
            if (user == null) {
                return DropBoxACL.NONE_EXTENDED;
            }
            if (user != null && user.isAdministrator() || "sysadmin".equalsIgnoreCase(username)) {
                return DropBoxACL.FULL_EXTENDED;
            }
            HashSet<DropBoxAccessControlOperation> result = new HashSet<DropBoxAccessControlOperation>();
            DropBoxACL acl = aclContext.getUsers().getAcl(username);
            if (acl != null) {
                result.addAll(acl.getOperationsExtended());
            }
            if (result.contains((Object)DropBoxAccessControlOperation.FULL)) {
                return result;
            }
            if (operation != null && DropBoxACL.isAllowed(result, operation)) {
                return result;
            }
            for (String groupname : user.listGroups()) {
                acl = aclContext.getGroups().getAcl(groupname);
                if (acl == null) continue;
                result.addAll(acl.getOperationsExtended());
            }
            return result;
        }
        catch (SecurityManagerException exception) {
            throw new DropBoxException("Cannot access security manager.", exception).status(406);
        }
    }

    public static boolean isOwner(DropBox dropBox, String username) {
        return dropBox.getOwner().equalsIgnoreCase(username);
    }

    public static List<String> listAcceptorsForDropBox(RuntimeContext runtime, String name) {
        try {
            AcceptorFactory factory = runtime.getAcceptorManager().lookupFactory("HTTPAcceptorFactory");
            if (factory == null) {
                throw new DropBoxException("Cannot get HTTPAcceptorFactory.");
            }
            return factory.listAcceptors().stream().filter(acceptorName -> {
                try {
                    return ((HTTPAcceptor)factory.lookupAcceptor((String)acceptorName)).getConfiguration().isEnableDropBox();
                }
                catch (Exception exception) {
                    return false;
                }
            }).collect(Collectors.toList());
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public static boolean isAdmin(RuntimeContext context, String username) {
        try {
            return "sysadmin".equalsIgnoreCase(username) || context.getSecurityManager().lookupUser(username) != null && context.getSecurityManager().lookupUser(username).isAdministrator();
        }
        catch (SecurityManagerException securityManagerException) {
            return false;
        }
    }

    public static String getURLForAcceptor(RuntimeContext context, String acceptorName, String url) {
        return DropBoxUtils.getAcceptorUrl(context, acceptorName) + url;
    }

    public static String getDropBoxHTTPDownloadURL(String dropBoxPath) {
        Object url = "/dropbox/download";
        dropBoxPath = DropBoxUtils.isDropBoxURL(dropBoxPath) ? DropBoxUtils.getDropBoxPathFromURL(dropBoxPath) : dropBoxPath;
        url = (String)url + (String)(dropBoxPath.startsWith("/") ? dropBoxPath : "/" + dropBoxPath);
        return url;
    }

    private static String getAcceptorUrl(RuntimeContext context, String acceptorName) {
        String prefix;
        AcceptorFactory factory = context.getAcceptorManager().lookupFactory("HTTPAcceptorFactory");
        HTTPAcceptor acceptor = null;
        if (acceptorName != null) {
            acceptor = (HTTPAcceptor)factory.lookupAcceptor(acceptorName);
            if (acceptor == null) {
                throw new DropBoxException("Acceptor '" + acceptorName + "' doesn't exist.");
            }
        } else {
            String name;
            Iterator<String> iterator = factory.listAcceptors().iterator();
            while (!(!iterator.hasNext() || (acceptor = (HTTPAcceptor)factory.lookupAcceptor(name = iterator.next())).isStarted() && acceptor.getConfiguration().isEnableDropBox())) {
                acceptor = null;
            }
            if (acceptor == null) {
                iterator = factory.listAcceptors().iterator();
                while (iterator.hasNext() && !(acceptor = (HTTPAcceptor)factory.lookupAcceptor(name = iterator.next())).isStarted()) {
                    acceptor = null;
                }
            }
            if (acceptor == null && (iterator = factory.listAcceptors().iterator()).hasNext()) {
                name = iterator.next();
                acceptor = (HTTPAcceptor)factory.lookupAcceptor(name);
            }
        }
        Object url = acceptor.getConfiguration().getURL();
        url = new MacroProcessor().process((String)url);
        String string = prefix = acceptor.getConfiguration().getEnableSSL() ? "https://" : "http://";
        if (!((String)url).startsWith(prefix)) {
            url = prefix + (String)url;
        }
        return url;
    }

    public static FileSystem createFileSystem(RuntimeContext context, String username, String path) {
        DropBoxAccessor accessor = context.getDropBoxManagerRemote().createDropBoxAccessor(DropBoxUtils.getDropBoxNameFromURL(path));
        return accessor.createFileSystem(username, DropBoxAccessor.DropBoxPathNotation.FOLDERS);
    }

    public static String buildFolderNameFromPath(String path) {
        return FlobManager.unifyPath(path).replace("/", "_");
    }

    public static String replaceFolderShortcutToFolderName(String path) {
        if (path != null && path.startsWith("$")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String buildFolderShortcut(String path) {
        if (path != null && !((String)path).startsWith("$")) {
            path = "$" + (String)path;
        }
        return path;
    }

    public static String resolveFolderShortcutToOsPath(DropBox dropBox, String path) {
        if (DropBoxUtils.isEmptyOrDotPath((String)path)) {
            return ".";
        }
        if (((String)path).startsWith("$")) {
            String folderName;
            DropBoxFolder folder;
            int pos = ((String)path).indexOf("/");
            if (pos == -1) {
                pos = ((String)path).length();
            }
            if ((folder = dropBox.getFolderByName(folderName = ((String)path).substring(1, pos))) == null) {
                throw new DropBoxException("Folder with name $" + folderName + " not found.");
            }
            path = folder.getPath() + ((String)path).substring(pos);
        }
        return DropBoxUtils.normalizePath((String)path);
    }

    public static String buildPath(String first, String second) {
        Object result;
        if (DropBoxUtils.isS3Path(first)) {
            Pair<String, String> pair = DropBoxUtils.splitS3Prefix(first);
            result = (String)pair.first + Paths.get((String)pair.second, second).toString();
            result = ((String)result).replace('\\', '/');
        } else {
            result = Paths.get(first, second).toString();
        }
        Trace.logDebug(DropBoxUtils.class, "buildPath, first: {}, second: {}, result: {}", first, second, result);
        return result;
    }

    public static String pathNormalize(String first, String ... second) {
        Object result;
        if (DropBoxUtils.isS3Path(first)) {
            Pair<String, String> pair = DropBoxUtils.splitS3Prefix(first);
            result = (String)pair.first + Paths.get((String)pair.second, second).normalize().toString();
            result = ((String)result).replace('\\', '/');
        } else {
            result = Paths.get(first, second).normalize().toString();
        }
        Trace.logDebug(DropBoxUtils.class, "pathNormalize, first: {}, second: {}", second != null ? Arrays.asList(second).stream().collect(Collectors.joining(",")) : null);
        return result;
    }

    public static String pathGetParent(String path) {
        Object result = null;
        if (DropBoxUtils.isS3Path(path)) {
            Pair<String, String> pair = DropBoxUtils.splitS3Prefix(path);
            Path pathParent = Paths.get((String)pair.second, new String[0]).getParent();
            if (pathParent != null) {
                result = (String)pair.first + pathParent.toString();
            }
            if (result != null) {
                result = ((String)result).replace('\\', '/');
            }
        } else {
            Path pathParent = Paths.get(path, new String[0]).getParent();
            if (pathParent != null) {
                result = pathParent.toString();
            }
        }
        Trace.logDebug(DropBoxUtils.class, "pathGetParent, path: {}, result: {}", path, result);
        return result;
    }

    public static String pathRelativize(String path, String other) {
        String result = null;
        if (DropBoxUtils.isS3Path(path)) {
            Pair<String, String> pathPair = DropBoxUtils.splitS3Prefix(path);
            Pair<Object, Object> otherPair = other != null ? DropBoxUtils.splitS3Prefix(other) : new Pair<Object, Object>(null, null);
            Path resultPath = Paths.get((String)pathPair.second, new String[0]).relativize(otherPair.second != null ? Paths.get((String)otherPair.second, new String[0]) : Paths.get(".", new String[0]));
            result = resultPath.toString();
            result = result.replace('\\', '/');
        } else {
            result = Paths.get(path, new String[0]).relativize(other != null ? Paths.get(other, new String[0]) : Paths.get(".", new String[0])).toString();
        }
        Trace.logDebug(DropBoxUtils.class, "pathRelativize, path: {}, other: {}, result: {}", path, other, result);
        return result;
    }

    public static String pathGetFilename(String path) {
        String result = null;
        if (DropBoxUtils.isS3Path(path)) {
            Pair<String, String> pair = DropBoxUtils.splitS3Prefix(path);
            result = new File((String)pair.second).getName();
        } else {
            result = new File(path).getName();
        }
        Trace.logDebug(DropBoxUtils.class, "pathGetFilename, path: {}, result: {}", path, result);
        return result;
    }
}

