/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractDropBoxTableManager;
import com.streamscape.sef.dropbox.DropBoxManager;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxTableFactory;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.tools.mnode.MNodeContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DropBoxTableManager
extends AbstractDropBoxTableManager {
    private RuntimeContext context;
    private DropBoxManager dropBoxManagerLocal;
    private DropBoxTableFactory dropBoxTableFactory;
    private DropBoxTable dropBoxTable;
    private DropBoxTableSynchronizationMonitor dropBoxTableSynchronizationMonitor;

    public DropBoxTableManager(RuntimeContext context, DropBoxManager dropBoxManagerLocal) throws FabricException {
        super(context);
        this.context = context;
        this.dropBoxManagerLocal = dropBoxManagerLocal;
        this.dropBoxTableFactory = new DropBoxTableFactory();
        this.dropBoxTable = (DropBoxTable)this.dropBoxTableFactory.create();
        if (this.dropBoxTable.updateOldStates()) {
            this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
        }
        this.synchronizeLocalDropBoxes();
    }

    @Override
    public void open() {
        if (this.isMNode()) {
            this.dropBoxTableSynchronizationMonitor = new DropBoxTableSynchronizationMonitor();
            this.dropBoxTableSynchronizationMonitor.start();
        }
        super.open();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.dropBoxTableSynchronizationMonitor != null) {
            this.dropBoxTableSynchronizationMonitor.stop();
            this.dropBoxTableSynchronizationMonitor = null;
        }
        if (this.dropBoxTableFactory != null) {
            this.dropBoxTableFactory.destroy();
            this.dropBoxTable = null;
        }
    }

    public DropBoxTable getDropBoxTable() {
        return this.dropBoxTable.clone();
    }

    private boolean isMNode() {
        return this.context.getNodeRole() == FabricNodeRole.MANAGEMENT_NODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeLocalDropBoxes() {
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            for (DropBox dropBox : this.dropBoxManagerLocal.getDropBoxes()) {
                List<DropBoxTable.DropBoxTableItem> itemsWithTheSameName;
                DropBoxTable.DropBoxTableItem localItem;
                if (!dropBox.isEnabled() || (localItem = this.dropBoxTable.lookupDropBoxTableItem(dropBox.getName(), this.context.getName())) != null) continue;
                localItem = this.dropBoxTable.addDropBoxTableItem(dropBox.getName(), this.context.getName(), dropBox.getOwner(), null);
                Trace.logInfo(this, "DropBox {}@{} has been added to the table.", dropBox.getName(), this.context.getName());
                if (!this.isMNode() || (itemsWithTheSameName = this.dropBoxTable.listDropBoxTableItemsSortedDesc(dropBox.getName())).size() != 1 && itemsWithTheSameName.get(0).getJoinTimestamp() != 0L) continue;
                localItem.setJoinTimestamp(this.nextGlobalCount());
                Trace.logInfo(this, "DropBox {}@{} joinTimestamp has been set to {}.", dropBox.getName(), this.context.getName(), localItem.getJoinTimestamp());
            }
            for (DropBoxTable.DropBoxTableItem item : this.dropBoxTable.lookupDropBoxTableItemsForNode(this.context.getName())) {
                DropBox dropBox = this.dropBoxManagerLocal.lookupDropBox(item.getDropBoxName());
                if (dropBox != null && dropBox.isEnabled()) continue;
                this.dropBoxTable.removeDropBoxItem(item.getDropBoxName(), item.getDropBoxNodeName());
            }
            for (DropBoxTable.DropBoxTableItem item : this.dropBoxTable.getItems()) {
                if (item.getState() == DropBoxTable.DropBoxTableItemState.EVICTED) continue;
                if (item.getDropBoxNodeName().equals(this.context.getName())) {
                    item.setState(this.isMNode() ? DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL : DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE);
                    if (!this.isMNode()) continue;
                    item.setMnodeName(this.context.getName());
                    continue;
                }
                item.setState(DropBoxTable.DropBoxTableItemState.OFFLINE);
            }
        }
        this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDropBoxTableFromMNode(DropBoxTable dropBoxTableMNode) {
        boolean tableChanged = false;
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            for (DropBoxTable.DropBoxTableItem dropBoxTableItem : this.dropBoxTable.getItems()) {
                if (dropBoxTableItem.getDropBoxNodeName().equals(this.context.getName()) || this.isMNode() && !this.context.getName().equals(dropBoxTableItem.getMnodeName()) || dropBoxTableMNode.lookupDropBoxTableItem(dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName()) != null) continue;
                tableChanged = true;
                this.dropBoxTable.removeDropBoxItem(dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName());
                Trace.logInfo("DropBox {}@{} removed.", dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName());
            }
            List<DropBoxTable.DropBoxTableItem> itemsLocal = this.dropBoxTable.lookupDropBoxTableItemsForNode(this.context.getName());
            for (DropBoxTable.DropBoxTableItem itemLocal : itemsLocal) {
                if (itemLocal.getState() == DropBoxTable.DropBoxTableItemState.EVICTED || dropBoxTableMNode.lookupDropBoxTableItem(itemLocal.getDropBoxName(), itemLocal.getDropBoxNodeName()) != null) continue;
                tableChanged = true;
                itemLocal.setJoinTimestamp(0L);
                itemLocal.setState(DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE);
                Trace.logInfo("DropBox {}@{} item timestamp set to 0.", itemLocal.getDropBoxName(), itemLocal.getDropBoxNodeName());
            }
            for (DropBoxTable.DropBoxTableItem dropBoxTableItem : dropBoxTableMNode.getItems()) {
                DropBoxTable.DropBoxTableItem itemLocal;
                if (dropBoxTableItem.getDropBoxNodeName().equals(this.context.getName())) continue;
                itemLocal = this.dropBoxTable.lookupDropBoxTableItem(dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName());
                boolean needToTrace = false;
                if (itemLocal != null) {
                    needToTrace = itemLocal.getJoinTimestamp() != dropBoxTableItem.getJoinTimestamp() || itemLocal.getState() != dropBoxTableItem.getState() || !Objects.equals(itemLocal.getMnodeName(), dropBoxTableItem.getMnodeName());
                    itemLocal.setJoinTimestamp(dropBoxTableItem.getJoinTimestamp());
                    itemLocal.setState(dropBoxTableItem.getState());
                    itemLocal.setMnodeName(dropBoxTableItem.getMnodeName());
                } else {
                    itemLocal = this.dropBoxTable.addDropBoxTableItem(dropBoxTableItem.clone());
                    needToTrace = true;
                }
                tableChanged = true;
                if (!needToTrace) continue;
                Trace.logInfo(this, "DropBox {}@{} item synchronized with Management Node [{}]. State: {}, joinTimestamp: {}.", new Object[]{itemLocal.getDropBoxName(), itemLocal.getDropBoxNodeName(), itemLocal.getMnodeName(), itemLocal.getState(), itemLocal.getJoinTimestamp()});
            }
        }
        if (tableChanged) {
            this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
        }
    }

    public void propagateDropBoxTableToSysplex(DropBoxTable dropBoxTableMNode) {
        try {
            this.doPropagateDropBoxTableToSysplexRemoved(dropBoxTableMNode);
            this.doPropagateDropBoxTableToSysplexNotJoined(dropBoxTableMNode);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void doPropagateDropBoxTableToSysplexRemoved(DropBoxTable dropBoxTableMNode) {
        List<DropBoxTable.DropBoxTableItem> itemsToRemove = dropBoxTableMNode.lookupDropBoxTableItemsForNode(this.context.getName());
        if (itemsToRemove.size() > 0) {
            List itemNamesLocal = this.dropBoxTable.lookupDropBoxTableItemsForNode(this.context.getName()).stream().map(DropBoxTable.DropBoxTableItem::getDropBoxName).collect(Collectors.toList());
            itemsToRemove.removeIf(i -> itemNamesLocal.contains(i.getDropBoxName()));
            try {
                if (itemsToRemove.size() > 0) {
                    Trace.logDebug(this, "Node [" + this.context.getName() + "] is synchronizing removal of DropBox items {} with Sysplex...", itemNamesLocal);
                    this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.REMOVE, itemsToRemove);
                    Trace.logInfo(this, "Node [" + this.context.getName() + "] synchronized removal of DropBox items {} with Sysplex...", itemNamesLocal);
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Synchronization of DropBoxes (removal items) failed.");
                Trace.logException(this, exception, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPropagateDropBoxTableToSysplexNotJoined(DropBoxTable dropBoxTableMNode) {
        block11: {
            List<DropBoxTable.DropBoxTableItem> itemsToJoin = null;
            DropBoxTable dropBoxTable = this.dropBoxTable;
            synchronized (dropBoxTable) {
                itemsToJoin = this.dropBoxTable.lookupDropBoxTableItemsForNode(this.context.getName()).stream().filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).filter(i -> i.getJoinTimestamp() == 0L || dropBoxTableMNode.lookupDropBoxTableItem(i.getDropBoxName(), i.getDropBoxNodeName()) == null || dropBoxTableMNode.lookupDropBoxTableItem(i.getDropBoxName(), i.getDropBoxNodeName()).getState() != DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL).map(DropBoxTable.DropBoxTableItem::clone).collect(Collectors.toList());
            }
            if (itemsToJoin.size() > 0) {
                try {
                    Trace.logDebug(this, "Node [" + this.context.getName() + "] is synchronizing DropBox {} items with Management Node...", itemsToJoin.stream().map(DropBoxTable.DropBoxTableItem::getDropBoxName).collect(Collectors.toList()));
                    List<DropBoxTable.DropBoxTableItem> joinedItems = this.sendDropBoxItemJoinTableToMnode(DropBoxTableOperation.JOIN_TO_MNODE, itemsToJoin);
                    if (joinedItems != null) {
                        DropBoxTable dropBoxTable2 = this.dropBoxTable;
                        synchronized (dropBoxTable2) {
                            for (DropBoxTable.DropBoxTableItem joinedItem : joinedItems) {
                                DropBoxTable.DropBoxTableItem item = this.dropBoxTable.lookupDropBoxTableItem(joinedItem.getDropBoxName(), joinedItem.getDropBoxNodeName());
                                item.setJoinTimestamp(joinedItem.getJoinTimestamp());
                                item.setState(joinedItem.getState());
                                item.setMnodeName(joinedItem.getMnodeName());
                                Trace.logInfo(this, "DropBox {}@{} item synchronized with Management Node [{}], response state: {}, timestamp: {}.", new Object[]{item.getDropBoxName(), item.getDropBoxNodeName(), item.getMnodeName(), item.getState(), item.getJoinTimestamp()});
                            }
                        }
                        this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                        Trace.logDebug(this, "Node [" + this.context.getName() + "] is synchronizing DropBox {} items with Sysplex...", itemsToJoin.stream().map(DropBoxTable.DropBoxTableItem::getDropBoxName).collect(Collectors.toList()));
                        this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.JOIN, joinedItems);
                        break block11;
                    }
                    Trace.logInfo(this, "Node [" + this.context.getName() + "] not provisioned. DropBox items not synchronized.");
                }
                catch (Exception exception) {
                    Trace.logError(this, "Synchronization of DropBoxes failed.");
                    Trace.logException(this, exception, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void propagateJoinDropBoxToSysplex(DropBox dropBox) {
        block12: {
            DropBoxTable.DropBoxTableItem item = null;
            DropBoxTable dropBoxTable = this.dropBoxTable;
            synchronized (dropBoxTable) {
                item = this.dropBoxTable.addDropBoxTableItem(dropBox.getName(), this.context.getName(), dropBox.getOwner(), null);
                item.setState(DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE);
            }
            try {
                Trace.logInfo(this, "Node [" + this.context.getName() + "] is synchronizing DropBox {} items with Management Node...", dropBox.getName());
                List joinedItems = null;
                if (this.context.getNodeRole() == FabricNodeRole.MANAGEMENT_NODE) {
                    DropBoxTableSynchronizationData data = new DropBoxTableSynchronizationData();
                    data.operation = DropBoxTableOperation.JOIN_TO_MNODE;
                    data.items = new ArrayList<DropBoxTable.DropBoxTableItem>(Arrays.asList(item));
                    joinedItems = (List)this.invokeDropBoxTableSynchronizationRequest(data);
                } else {
                    joinedItems = this.sendDropBoxItemJoinTableToMnode(DropBoxTableOperation.JOIN_TO_MNODE, new ArrayList<DropBoxTable.DropBoxTableItem>(Arrays.asList(item)));
                }
                if (joinedItems != null && joinedItems.size() > 0) {
                    DropBoxTable dropBoxTable2 = this.dropBoxTable;
                    synchronized (dropBoxTable2) {
                        DropBoxTable.DropBoxTableItem joinedItem = (DropBoxTable.DropBoxTableItem)joinedItems.get(0);
                        item.setJoinTimestamp(joinedItem.getJoinTimestamp());
                        item.setState(joinedItem.getState());
                        item.setMnodeName(joinedItem.getMnodeName());
                        Trace.logInfo(this, "Node [{}] synchronized DropBox {} items with Management Node [{}]. State: {}.", new Object[]{this.context.getName(), dropBox.getName(), item.getMnodeName(), item.getState()});
                    }
                    this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                    Trace.logDebug(this, "Node [" + this.context.getName() + "] is synchronizing DropBox {} items with Sysplex...", dropBox.getName());
                    this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.JOIN, joinedItems);
                    break block12;
                }
                if (joinedItems == null) {
                    Trace.logInfo(this, "Node [" + this.context.getName() + "] not provisioned. DropBox items not synchronized.");
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Synchronization of DropBoxes failed.");
                Trace.logException(this, exception, true);
                throw new DropBoxException(Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        }
    }

    public void propagateRemoveDropBoxToSysplex(String name) {
        DropBoxTable.DropBoxTableItem item = this.dropBoxTable.removeDropBoxItem(name, this.context.getName());
        this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
        try {
            if (item != null) {
                this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.REMOVE, new ArrayList<DropBoxTable.DropBoxTableItem>(Arrays.asList(item)));
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Synchronization of DropBoxes (remove operation) failed.");
            Trace.logException(this, exception, true);
            throw new DropBoxException(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object invokeDropBoxTableSynchronizationRequest(DropBoxTableSynchronizationData data) throws Exception {
        switch (data.operation.ordinal()) {
            case 0: {
                for (DropBoxTable.DropBoxTableItem item : data.items) {
                    this.dropBoxTable.removeDropBoxItem(item.getDropBoxName(), item.getDropBoxNodeName());
                    Trace.logInfo(this, "DropBox item {}@{} removed.", item.getDropBoxName(), item.getDropBoxNodeName());
                }
                this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                return null;
            }
            case 1: {
                ArrayList<DropBoxTable.DropBoxTableItem> joinedItems = new ArrayList<DropBoxTable.DropBoxTableItem>();
                long joinTimestamp = this.nextGlobalCount();
                for (DropBoxTable.DropBoxTableItem item : data.items) {
                    DropBoxTable dropBoxTable = this.dropBoxTable;
                    synchronized (dropBoxTable) {
                        DropBoxTable.DropBoxTableItem localItem = null;
                        List<DropBoxTable.DropBoxTableItem> localItems = this.dropBoxTable.listDropBoxTableItemsSortedDesc(item.getDropBoxName());
                        if (localItems.size() == 0) {
                            localItem = this.dropBoxTable.addDropBoxTableItem(item.getDropBoxName(), item.getDropBoxNodeName(), item.getOwner(), item.getMnodeName());
                        } else if (localItems.get(0).getJoinTimestamp() == 0L) {
                            localItem = this.dropBoxTable.addDropBoxTableItem(item.getDropBoxName(), item.getDropBoxNodeName(), item.getOwner(), item.getMnodeName());
                        } else {
                            localItem = this.dropBoxTable.lookupDropBoxTableItem(item.getDropBoxName(), item.getDropBoxNodeName());
                            if (localItem != localItems.get(0)) {
                                Trace.logInfo(this, "WARNING: Duplicate DropBox names {}@{} and {}@{}.", item.getDropBoxName(), item.getDropBoxNodeName(), localItems.get(0).getDropBoxName(), localItems.get(0).getDropBoxNodeName());
                                localItem = null;
                            }
                        }
                        if (localItem != null) {
                            localItem.setJoinTimestamp(item.getJoinTimestamp() == 0L ? joinTimestamp : item.getJoinTimestamp());
                            localItem.setState(DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL);
                            if (localItem.getMnodeName() == null) {
                                localItem.setMnodeName(this.context.getName());
                            }
                            joinedItems.add(localItem.clone());
                            Trace.logInfo(this, "DropBox item {}@{} joined Management Node [{}].", localItem.getDropBoxName(), localItem.getDropBoxNodeName(), this.context.getName());
                        } else {
                            item.setState(DropBoxTable.DropBoxTableItemState.DUPLICATE);
                            if (item.getMnodeName() == null) {
                                item.setMnodeName(this.context.getName());
                            }
                            this.dropBoxTable.replaceDropBoxTableItem(item);
                            joinedItems.add(item);
                        }
                    }
                }
                this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                return joinedItems;
            }
            case 2: {
                for (DropBoxTable.DropBoxTableItem item : data.items) {
                    DropBoxTable.DropBoxTableItem oldItem = this.dropBoxTable.replaceDropBoxTableItem(item);
                    if (oldItem == null) {
                        Trace.logInfo(this, "DropBox item {}@{} joined node [{}].", item.getDropBoxName(), item.getDropBoxNodeName(), this.context.getName());
                        continue;
                    }
                    if (oldItem.getState() == item.getState()) continue;
                    Trace.logInfo(this, "DropBox item {}@{} state changed from {} to {}.", new Object[]{item.getDropBoxName(), item.getDropBoxNodeName(), oldItem.getState(), item.getState()});
                }
                this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                return null;
            }
            case 3: {
                DropBoxTable dropBoxTable = this.dropBoxTable;
                synchronized (dropBoxTable) {
                    return new DropBoxTable(this.dropBoxTable.lookupDropBoxTableItemsForNode(this.context.getName()).stream().filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).collect(Collectors.toList()));
                }
            }
            case 4: {
                this.mergeDropBoxTableFromMNode(new DropBoxTable(data.items));
                return null;
            }
            case 5: {
                for (DropBoxTable.DropBoxTableItem item : data.items) {
                    this.dropBoxTable.replaceDropBoxTableItem(item);
                }
                this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
                return null;
            }
            case 6: {
                this.evictDropBoxItemsInternal(data.items);
            }
        }
        throw new Exception("Invalid operation " + String.valueOf((Object)data.operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictDropBoxItemsInternal(List<DropBoxTable.DropBoxTableItem> items) {
        for (DropBoxTable.DropBoxTableItem item : items) {
            if (item.getDropBoxNodeName().equals(this.context.getName())) {
                DropBoxTable dropBoxTable = this.dropBoxTable;
                synchronized (dropBoxTable) {
                    DropBoxTable.DropBoxTableItem localItem = this.dropBoxTable.lookupDropBoxTableItem(item.getDropBoxName(), item.getDropBoxNodeName());
                    if (localItem != null) {
                        localItem.setState(DropBoxTable.DropBoxTableItemState.EVICTED);
                        localItem.setJoinTimestamp(0L);
                    }
                    continue;
                }
            }
            this.dropBoxTable.removeDropBoxItem(item.getDropBoxName(), item.getDropBoxNodeName());
        }
        this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
    }

    public void synchronizeDropBoxesTableOverSysplex() {
        if (!this.isMNode()) {
            return;
        }
        boolean tableChanged = false;
        tableChanged |= this.doSynchronizeDropBoxesTableUnderThisMnode();
        if (tableChanged |= this.doSynchronizeDropBoxesTableUnderOtherMnodes()) {
            this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
        }
        try {
            this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.ITEMS_BROADCAST, this.dropBoxTable.getItemsClone());
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSynchronizeDropBoxesTableUnderThisMnode() {
        HashSet<String> nodeNames = new HashSet<String>(this.dropBoxTable.getItemsClone().stream().filter(i -> this.context.getName().equals(i.getMnodeName())).map(DropBoxTable.DropBoxTableItem::getDropBoxNodeName).collect(Collectors.toSet()));
        if (this.context.getContainer() != null) {
            nodeNames.addAll(((MNodeContainer)this.context.getContainer()).getTnodeNames());
        }
        nodeNames.remove(this.context.getName());
        boolean[] tableChanged = new boolean[]{false};
        for (String nodeName : nodeNames) {
            DropBoxTable nodeDropBoxTable = null;
            try {
                nodeDropBoxTable = (DropBoxTable)this.sendDropBoxTableSynchronizationRequestToNode(nodeName, DropBoxTableOperation.GET_DROPBOXES_TABLE, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nodeDropBoxTable == null) {
                DropBoxTable dropBoxTable = this.dropBoxTable;
                synchronized (dropBoxTable) {
                    this.dropBoxTable.getItems().stream().filter(i -> i.getDropBoxNodeName().equals(nodeName) && i.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).forEach(i -> {
                        i.setState(DropBoxTable.DropBoxTableItemState.OFFLINE);
                        tableChanged[0] = true;
                        Trace.logInfo(this, "DropBox {}@{} state set to OFFLINE.", i.getDropBoxName(), i.getDropBoxNodeName());
                    });
                    continue;
                }
            }
            for (DropBoxTable.DropBoxTableItem dropBoxTableItem : this.dropBoxTable.lookupDropBoxTableItemsForNode(nodeName)) {
                if (nodeDropBoxTable.lookupDropBoxTableItem(dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName()) != null) continue;
                this.dropBoxTable.removeDropBoxItem(dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName());
                tableChanged[0] = true;
                Trace.logInfo(this, "DropBox {}@{} has been removed from table.", dropBoxTableItem.getDropBoxName(), dropBoxTableItem.getDropBoxNodeName());
            }
            ArrayList<DropBoxTable.DropBoxTableItem> itemsToJoin = new ArrayList<DropBoxTable.DropBoxTableItem>();
            DropBoxTable dropBoxTable = this.dropBoxTable;
            synchronized (dropBoxTable) {
                for (DropBoxTable.DropBoxTableItem item3 : nodeDropBoxTable.lookupDropBoxTableItemsForNode(nodeName)) {
                    DropBoxTable.DropBoxTableItem localItem = this.dropBoxTable.lookupDropBoxTableItem(item3.getDropBoxName(), item3.getDropBoxNodeName());
                    if (localItem != null && localItem.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE && localItem.getState() == item3.getState() && item3.getJoinTimestamp() != 0L) continue;
                    itemsToJoin.add(item3.clone());
                }
            }
            if (itemsToJoin.size() <= 0) continue;
            DropBoxTableSynchronizationData dropBoxTableSynchronizationData = new DropBoxTableSynchronizationData();
            dropBoxTableSynchronizationData.operation = DropBoxTableOperation.JOIN_TO_MNODE;
            dropBoxTableSynchronizationData.items = itemsToJoin;
            List joinedItems = null;
            try {
                joinedItems = (List)this.invokeDropBoxTableSynchronizationRequest(dropBoxTableSynchronizationData);
            }
            catch (Exception item3) {
                // empty catch block
            }
            try {
                this.sendDropBoxTableSynchronizationRequestToNode(nodeName, DropBoxTableOperation.JOINED_ITEMS_RESPONSE, joinedItems);
            }
            catch (Exception e) {
                Trace.logException(this, e, true);
            }
        }
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            this.dropBoxTable.getItems().stream().filter(i -> i.getDropBoxNodeName().equals(this.context.getName())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL).forEach(i -> {
                i.setState(DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL);
                tableChanged[0] = true;
            });
        }
        return tableChanged[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSynchronizeDropBoxesTableUnderOtherMnodes() {
        boolean[] tableChanged = new boolean[]{false};
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            this.dropBoxTable.getItems().stream().filter(i -> !this.context.getName().equals(i.getMnodeName())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE).map(DropBoxTable.DropBoxTableItem::getMnodeName).distinct().filter(name -> !this.isFabricNodeAttached((String)name)).forEach(name -> this.dropBoxTable.getItems().stream().filter(i -> name.equals(i.getMnodeName())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE).forEach(i -> {
                tableChanged[0] = true;
                i.setState(DropBoxTable.DropBoxTableItemState.OFFLINE);
                Trace.logInfo(this, "DropBox {}@{} state set to OFFLINE.", i.getDropBoxName(), i.getDropBoxNodeName());
            }));
        }
        return tableChanged[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DropBoxTable.DropBoxTableItem> listActiveDropBoxItemsForNode(String nodeName) {
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            List<DropBoxTable.DropBoxTableItem> items = this.dropBoxTable.getItems().stream().filter(i -> i.getState() == DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL).collect(Collectors.toList());
            this.dropBoxTable.getItems().stream().filter(i -> !items.contains(i)).filter(i -> i.getDropBoxNodeName().equals(nodeName) && i.getState() == DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE).forEach(items::add);
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropBoxTable.DropBoxTableItem findActiveDropBoxItem(String dropBoxName) {
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            List<DropBoxTable.DropBoxTableItem> items = this.dropBoxTable.listDropBoxTableItemsSortedDesc(dropBoxName);
            for (DropBoxTable.DropBoxTableItem item : items) {
                if (item.getState() != DropBoxTable.DropBoxTableItemState.ONLINE_GLOBAL) continue;
                return item;
            }
            for (DropBoxTable.DropBoxTableItem item : items) {
                if (item.getState() != DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE) continue;
                return item;
            }
        }
        return null;
    }

    public List<String> listDropBoxNodes() {
        return new ArrayList<String>(this.dropBoxTable.getItemsClone().stream().map(DropBoxTable.DropBoxTableItem::getDropBoxNodeName).collect(Collectors.toSet()));
    }

    public void evictDropBoxItem(String dropBoxName, String dropBoxNodeName, String username) {
        DropBoxTable.DropBoxTableItem item = this.dropBoxTable.lookupDropBoxTableItem(dropBoxName, dropBoxNodeName);
        if (item == null) {
            throw new DropBoxException("Drop Box item for " + dropBoxName + "@" + dropBoxNodeName + " does not exist.");
        }
        if (!username.equals(item.getOwner()) && !DropBoxUtils.isAdmin(this.context, username)) {
            throw new DropBoxException("Only Drop Box owner or admin user can evict DropBox item.");
        }
        ArrayList<DropBoxTable.DropBoxTableItem> items = new ArrayList<DropBoxTable.DropBoxTableItem>(Arrays.asList(new DropBoxTable.DropBoxTableItem(dropBoxName, dropBoxNodeName, "admin", null)));
        this.evictDropBoxItemsInternal(items);
        try {
            this.sendDropBoxTableSynchronizationEventToSysplex(DropBoxTableOperation.EVICT_DROPBOX_ITEMS, items);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onModeratorAdvisory(FabricModeratorAdvisory event) {
        boolean[] changed = new boolean[]{false};
        DropBoxTable dropBoxTable = this.dropBoxTable;
        synchronized (dropBoxTable) {
            if (event.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED || event.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY) {
                this.dropBoxTable.getItems().stream().filter(i -> i.getDropBoxNodeName().equals(event.getEntity())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE).forEach(i -> {
                    Trace.logDebug(this, "DropBox {}@{} state changed to OFFLINE from {}.", new Object[]{i.getDropBoxName(), i.getDropBoxNodeName(), i.getState()});
                    i.setState(DropBoxTable.DropBoxTableItemState.OFFLINE);
                    changed[0] = true;
                });
            } else if (event.getType() == ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX || event.getType() == ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX_FORCIBLY) {
                this.dropBoxTable.getItems().stream().filter(i -> !i.getDropBoxNodeName().equals(this.context.getName())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.OFFLINE).forEach(i -> {
                    Trace.logDebug(this, "DropBox {}@{} state changed to OFFLINE from {}.", new Object[]{i.getDropBoxName(), i.getDropBoxNodeName(), i.getState()});
                    i.setState(DropBoxTable.DropBoxTableItemState.OFFLINE);
                    changed[0] = true;
                });
                if (!this.isMNode()) {
                    this.dropBoxTable.getItems().stream().filter(i -> i.getDropBoxNodeName().equals(this.context.getName())).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.EVICTED).filter(i -> i.getState() != DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE).forEach(i -> {
                        Trace.logDebug(this, "DropBox {}@{} state changed to ONLINE_STANDALONE from {}.", new Object[]{i.getDropBoxName(), i.getDropBoxNodeName(), i.getState()});
                        i.setState(DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE);
                        changed[0] = true;
                    });
                }
            }
        }
        if (changed[0]) {
            this.dropBoxTableFactory.updateObject(this.dropBoxTable.clone());
        }
    }

    private class DropBoxTableSynchronizationMonitor
    implements Runnable {
        private FabricThread executor = FabricThreadManager.getInstance().createDaemonThread("EXC:DropBox.TableSynchronization:Monitor", "Synchronizes DropBoxes table over sysplex.", this);
        private volatile boolean isRunning = false;
        private long checkInterval = 30000L;

        DropBoxTableSynchronizationMonitor() {
        }

        public synchronized void start() {
            this.isRunning = true;
            this.executor.start();
        }

        public synchronized void stop() {
            this.isRunning = false;
            this.executor.interrupt();
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    Thread.sleep(this.checkInterval);
                    if (!this.isRunning) continue;
                    try {
                        DropBoxTableManager.this.synchronizeDropBoxesTableOverSysplex();
                    }
                    catch (Exception exception) {
                        if (exception instanceof InterruptedException) {
                            throw exception;
                        }
                        Trace.logException(this, exception, true);
                    }
                }
                catch (InterruptedException exception) {
                    this.stop();
                }
            }
            this.executor.stop();
        }
    }

    public static enum DropBoxTableOperation {
        REMOVE("remove"),
        JOIN_TO_MNODE("joinToMnode"),
        JOIN("join"),
        GET_DROPBOXES_TABLE("getDropBoxesTable"),
        ITEMS_BROADCAST("itemsBroadcast"),
        JOINED_ITEMS_RESPONSE("itemsBroadcast"),
        EVICT_DROPBOX_ITEMS("evictDropBoxItems");

        private String name;

        private DropBoxTableOperation(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class DropBoxTableSynchronizationData {
        public DropBoxTableOperation operation;
        public List<DropBoxTable.DropBoxTableItem> items;
    }
}

