/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.sdo.CloneableObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DropBoxTable
implements CloneableObject {
    private List<DropBoxTableItem> items = new ArrayList<DropBoxTableItem>();

    public DropBoxTable() {
    }

    public DropBoxTable(List<DropBoxTableItem> items) {
        this.items = items;
    }

    public synchronized List<DropBoxTableItem> getItems() {
        return new ArrayList<DropBoxTableItem>(this.items);
    }

    public synchronized List<DropBoxTableItem> getItemsClone() {
        return new ArrayList<DropBoxTableItem>(this.items.stream().map(i -> i.clone()).collect(Collectors.toList()));
    }

    public synchronized void setItems(List<DropBoxTableItem> items) {
        this.items = items;
    }

    public synchronized List<DropBoxTableItem> listDropBoxTableItemsSortedDesc(String dropBoxName) {
        return this.items.stream().filter(i -> i.getDropBoxName().equals(dropBoxName)).sorted((i1, i2) -> -1 * Long.compare(i1.getJoinTimestamp(), i2.getJoinTimestamp())).collect(Collectors.toList());
    }

    public synchronized List<DropBoxTableItem> lookupDropBoxTableItemsForNode(String dropBoxNodeName) {
        return this.items.stream().filter(i -> i.getDropBoxNodeName().equals(dropBoxNodeName)).collect(Collectors.toList());
    }

    public synchronized DropBoxTableItem lookupDropBoxTableItem(String dropBoxName, String dropBoxNodeName) {
        return this.items.stream().filter(i -> i.getDropBoxName().equals(dropBoxName) && i.getDropBoxNodeName().equals(dropBoxNodeName)).findAny().orElse(null);
    }

    public synchronized DropBoxTableItem addDropBoxTableItem(String dropBoxName, String dropBoxNodeName, String owner, String mnodeName) {
        DropBoxTableItem item = this.items.stream().filter(i -> i.getDropBoxName().equals(dropBoxName) && i.getDropBoxNodeName().equals(dropBoxNodeName)).findAny().orElse(null);
        if (item == null) {
            item = new DropBoxTableItem(dropBoxName, dropBoxNodeName, owner, mnodeName);
            this.items.add(item);
        }
        return item;
    }

    public synchronized DropBoxTableItem removeDropBoxItem(String dropBoxName, String dropBoxNodeName) {
        DropBoxTableItem item;
        while ((item = this.lookupDropBoxTableItem(dropBoxName, dropBoxNodeName)) != null) {
            this.items.remove(item);
        }
        return item;
    }

    public synchronized DropBoxTableItem addDropBoxTableItem(DropBoxTableItem item) {
        DropBoxTableItem localItem = this.lookupDropBoxTableItem(item.getDropBoxName(), item.getDropBoxNodeName());
        if (localItem == null) {
            this.items.add(item);
            return item;
        }
        return localItem;
    }

    public synchronized DropBoxTableItem replaceDropBoxTableItem(DropBoxTableItem item) {
        DropBoxTableItem oldItem = this.removeDropBoxItem(item.getDropBoxName(), item.getDropBoxNodeName());
        this.items.add(item);
        return oldItem;
    }

    synchronized boolean updateOldStates() {
        if (this.items.stream().filter(i -> i.getState() == DropBoxTableItemState.ONLINE_JOINED || i.getState() == DropBoxTableItemState.DUPLICATE_NAME || i.getState() == DropBoxTableItemState.ONLINE_REMOTE).count() == 0L) {
            return false;
        }
        this.items.stream().filter(i -> i.getState() == DropBoxTableItemState.ONLINE_JOINED || i.getState() == DropBoxTableItemState.ONLINE_REMOTE).forEach(i -> i.setState(DropBoxTableItemState.ONLINE_GLOBAL));
        this.items.stream().filter(i -> i.getState() == DropBoxTableItemState.DUPLICATE_NAME).forEach(i -> i.setState(DropBoxTableItemState.DUPLICATE));
        return true;
    }

    @Override
    public synchronized DropBoxTable clone() {
        DropBoxTable result = new DropBoxTable();
        result.items = new ArrayList<DropBoxTableItem>();
        for (DropBoxTableItem item : this.items) {
            result.items.add(item.clone());
        }
        return result;
    }

    public static class DropBoxTableItem
    implements CloneableObject {
        private final String dropBoxName;
        private final String dropBoxNodeName;
        private String mnodeName;
        private final String owner;
        private long joinTimestamp;
        private DropBoxTableItemState state = DropBoxTableItemState.NONE;

        public DropBoxTableItem(String dropBoxName, String dropBoxNodeName, String owner, String mnodeName) {
            this.dropBoxName = dropBoxName;
            this.dropBoxNodeName = dropBoxNodeName;
            this.owner = owner;
            this.mnodeName = mnodeName;
            this.joinTimestamp = 0L;
        }

        public String getDropBoxName() {
            return this.dropBoxName;
        }

        public String getDropBoxNodeName() {
            return this.dropBoxNodeName;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getJoinTimestamp() {
            return this.joinTimestamp;
        }

        public void setJoinTimestamp(long joinTimestamp) {
            this.joinTimestamp = joinTimestamp;
        }

        public DropBoxTableItemState getState() {
            return this.state;
        }

        public void setMnodeName(String mnodeName) {
            this.mnodeName = mnodeName;
        }

        public String getMnodeName() {
            return this.mnodeName;
        }

        public void setState(DropBoxTableItemState state) {
            this.state = state;
        }

        @Override
        public DropBoxTableItem clone() {
            DropBoxTableItem result = new DropBoxTableItem(this.dropBoxName, this.dropBoxNodeName, this.owner, this.mnodeName);
            result.joinTimestamp = this.joinTimestamp;
            result.state = this.state;
            return result;
        }
    }

    public static enum DropBoxTableItemState {
        NONE,
        ONLINE_STANDALONE,
        ONLINE_GLOBAL,
        OFFLINE,
        DUPLICATE,
        EVICTED,
        ONLINE_JOINED,
        ONLINE_REMOTE,
        DUPLICATE_NAME;

    }
}

