/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.enums.EventScope;

public class DropBoxNotificationUtils {
    public static final String DROPBOX_NOTIFICATION_EVENT_ID = "event.dropbox.notification";
    public static final String USER_PROPERTY = "User";
    public static final String COMPONENT_PROPERTY = "Component";
    public static final String OPERATION_PROPERTY = "Operation";
    public static final String ACCEPTOR_PROPERTY = "Acceptor";
    public static final String DROPBOX_PROPERTY = "DropBox";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDropBoxNotification(FabricConnection fabricConnection, DropBox dropBox, String userName, String acceptorName, DropBoxOperationType operationType, FileInfo fileInfo) {
        try {
            FileEvent notification = (FileEvent)EventDatagramFactory.getInstance().createEvent(DROPBOX_NOTIFICATION_EVENT_ID);
            notification.setEventStringProperty(ACCEPTOR_PROPERTY, acceptorName);
            notification.setEventStringProperty(COMPONENT_PROPERTY, fabricConnection.getName());
            notification.setEventStringProperty(USER_PROPERTY, userName);
            notification.setEventStringProperty(OPERATION_PROPERTY, operationType.name());
            notification.setEventStringProperty(DROPBOX_PROPERTY, dropBox.getName());
            if (fileInfo != null) {
                String filepath = fileInfo.getPath() != null && fileInfo.getPath().length() > 0 && !fileInfo.getPath().trim().equals(".") ? fileInfo.getPath() + "/" + fileInfo.getName() : fileInfo.getName();
                fileInfo.setAbsolutePath(DropBoxUtils.getDropBoxURL(dropBox.getName(), filepath));
                FileMetaInfo state = new FileMetaInfo(fileInfo);
                notification.init(state);
            }
            DropBox dropBox2 = dropBox;
            synchronized (dropBox2) {
                if (!fabricConnection.isBoundEventId(DROPBOX_NOTIFICATION_EVENT_ID)) {
                    fabricConnection.bindProducerFor(DROPBOX_NOTIFICATION_EVENT_ID);
                }
                fabricConnection.raiseEvent(notification, EventScope.INHERITED, 0L);
            }
        }
        catch (Exception exception) {
            Trace.logError(DropBoxNotificationUtils.class, "Failed to send DropBox notification for dropbox [" + dropBox.getName() + "].");
            Trace.logException(DropBoxNotificationUtils.class, exception, true);
        }
    }

    public static enum DropBoxOperationType {
        REMOVE,
        UPLOAD,
        DOWNLOAD,
        MKDIR,
        CREATE_TMP_FILE,
        CREATE_NEW_FILE,
        OPEN_FOR_WRITE,
        OPEN_FOR_APPEND,
        OPEN_FOR_READ,
        FILE_CREATED,
        FILE_APPENDED,
        DELETE,
        COPY,
        RENAME,
        MOVE,
        TRUNCATE;

    }
}

