/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dii.AccessibleObjectsCache;
import com.streamscape.sef.dispatcher.AbstractDropBoxManagerRemote;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxAccessorImpl;
import com.streamscape.sef.dropbox.DropBoxAccessorProxy;
import com.streamscape.sef.dropbox.DropBoxFactoryException;
import com.streamscape.sef.dropbox.DropBoxManager;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxTableManager;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DropBoxManagerRemoteImpl
extends AbstractDropBoxManagerRemote
implements DropBoxManager,
AccessibleObject {
    private DropBoxManager dropBoxManagerLocal;
    private DropBoxTableManager dropBoxTableManager;
    private AccessibleObjectsCache cache = new AccessibleObjectsCache();
    private ObjectsChacheMonitor objectsChacheMonitor = null;

    public DropBoxManagerRemoteImpl(RuntimeContext context, DropBoxManager dropBoxManagerLocal) throws FabricException {
        super(context);
        this.dropBoxManagerLocal = dropBoxManagerLocal;
        this.dropBoxTableManager = new DropBoxTableManager(context, dropBoxManagerLocal);
        this.cache.putAccessibleObject(0L, this);
    }

    @Override
    public synchronized void open() {
        super.open();
        this.dropBoxTableManager.open();
        this.objectsChacheMonitor = new ObjectsChacheMonitor();
        this.objectsChacheMonitor.start();
    }

    @Override
    public void destroy() {
        if (this.dropBoxTableManager != null) {
            this.dropBoxTableManager.destroy();
            this.dropBoxTableManager = null;
        }
        if (this.objectsChacheMonitor != null) {
            this.objectsChacheMonitor.stop();
            this.objectsChacheMonitor = null;
        }
        this.cache.clearAndCloseAll();
        super.destroy();
    }

    @Override
    public DropBoxAccessor createDropBoxAccessor(String dropBoxName) {
        String nodeName = this.getDropBoxNodeName(dropBoxName);
        if (nodeName == null) {
            throw new DropBoxException("DropBox '" + dropBoxName + "' not found.");
        }
        if (this.isLocalNode(nodeName)) {
            DropBoxAccessor accessor = this.dropBoxManagerLocal.createDropBoxAccessor(dropBoxName);
            ((DropBoxAccessorImpl)accessor).setDropBoxManagerRemote(this);
            return accessor;
        }
        DropBoxAccessor accessor = (DropBoxAccessor)this.invokeDropBoxManagerRpcUnwrap(nodeName, new AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest().setOperation(6).setDropBoxName(dropBoxName));
        if (accessor instanceof DropBoxAccessorProxy) {
            ((DropBoxAccessorProxy)accessor).setDropBoxName(dropBoxName);
            ((DropBoxAccessorProxy)accessor).setNodeName(nodeName);
            ((DropBoxAccessorProxy)accessor).setDropBoxManagerRemote(this);
            ((DropBoxAccessorProxy)accessor).setAccessor((DropBoxAccessorProxy)accessor);
        }
        return accessor;
    }

    @Override
    public synchronized void addDropBox(DropBox dropBox) throws DropBoxFactoryException {
        List<DropBoxTable.DropBoxTableItem> items = this.dropBoxTableManager.getDropBoxTable().listDropBoxTableItemsSortedDesc(dropBox.getName());
        if (items.size() > 0) {
            List nodes = items.stream().map(i -> i.getDropBoxNodeName()).collect(Collectors.toList());
            throw new DropBoxException("DropBox with specified name already exist on node" + (nodes.size() > 1 ? "s " : " ") + String.valueOf(nodes) + ".");
        }
        this.dropBoxManagerLocal.addDropBox(dropBox);
        if (dropBox.isEnabled()) {
            this.dropBoxTableManager.propagateJoinDropBoxToSysplex(dropBox);
        }
    }

    @Override
    public List<DropBox> getDropBoxes() {
        ArrayList<DropBox> result = new ArrayList<DropBox>();
        result.addAll(this.dropBoxManagerLocal.getDropBoxes());
        this.dropBoxTableManager.listDropBoxNodes().stream().filter(n -> !n.equals(this.context.getName())).forEach(nodeName -> {
            try {
                result.addAll((List)this.invokeDropBoxManagerRpcUnwrap((String)nodeName, new AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest().setOperation(4)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return result;
    }

    public List<DropBox> getDropBoxes(String nodeName) {
        return (List)this.invokeDropBoxManagerRpcUnwrap(nodeName, new AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest().setOperation(4));
    }

    @Override
    public DropBox lookupDropBox(String name) {
        String nodeName = this.getDropBoxNodeName(name);
        if (nodeName == null || this.isLocalNode(nodeName)) {
            return this.dropBoxManagerLocal.lookupDropBox(name);
        }
        return (DropBox)this.invokeDropBoxManagerRpcUnwrap(nodeName, new AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest().setOperation(1).setDropBoxName(name));
    }

    @Override
    public void updateDropBox(String dropBoxName, Consumer<DropBox> updateFunction) {
        this.dropBoxManagerLocal.updateDropBox(dropBoxName, updateFunction);
    }

    @Override
    public synchronized void dropDropBox(String name, boolean withContent) {
        this.dropBoxManagerLocal.dropDropBox(name, withContent);
        this.dropBoxTableManager.propagateRemoveDropBoxToSysplex(name);
    }

    @Override
    public void enable(String name) {
        this.dropBoxManagerLocal.enable(name);
        this.dropBoxTableManager.propagateJoinDropBoxToSysplex(this.dropBoxManagerLocal.lookupDropBox(name));
    }

    @Override
    public void disable(String name) {
        this.dropBoxManagerLocal.disable(name);
        this.dropBoxTableManager.propagateRemoveDropBoxToSysplex(name);
    }

    @Override
    public List<String> listDropBoxes() {
        return this.dropBoxTableManager.getDropBoxTable().getItems().stream().map(i -> i.getDropBoxName()).collect(Collectors.toList());
    }

    @Override
    public List<String> listDropBoxesVisibleBy(String username) {
        return this.dropBoxTableManager.getDropBoxTable().getItems().stream().filter(i -> {
            if (DropBoxUtils.isAdmin(this.context, username) || username.equals(i.getOwner().equals(username))) {
                return true;
            }
            DropBox dropBox = this.lookupDropBox(i.getDropBoxName());
            if (dropBox != null) {
                return DropBoxUtils.hasUserAccessAny(dropBox, username);
            }
            return false;
        }).map(i -> i.getDropBoxName()).collect(Collectors.toList());
    }

    public List<DropBoxTable.DropBoxTableItem> listActiveDropBoxesVisibleByUser(String username) {
        return this.dropBoxTableManager.listActiveDropBoxItemsForNode(this.context.getName()).stream().filter(i -> {
            if (DropBoxUtils.isAdmin(this.context, username) || username.equals(i.getOwner())) {
                return true;
            }
            DropBox dropBox = this.lookupDropBox(i.getDropBoxName());
            if (dropBox != null) {
                return DropBoxUtils.hasUserAccessAny(dropBox, username);
            }
            return false;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isEnabled(String name) {
        String nodeName = this.getDropBoxNodeName(name);
        if (nodeName == null || this.isLocalNode(nodeName)) {
            return this.dropBoxManagerLocal.isEnabled(name);
        }
        return (Boolean)this.invokeDropBoxManagerRpcUnwrap(nodeName, new AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest().setOperation(2).setDropBoxName(name));
    }

    public DropBoxTableManager getDropBoxTableManager() {
        return this.dropBoxTableManager;
    }

    private boolean isLocalNode(String nodeName) {
        return this.context.getName().equals(nodeName);
    }

    private String getDropBoxNodeName(String name) {
        DropBoxTable.DropBoxTableItem item = this.dropBoxTableManager.findActiveDropBoxItem(name);
        if (item == null) {
            return null;
        }
        return item.getDropBoxNodeName();
    }

    @Override
    protected AbstractDropBoxManagerRemote.DropBoxManagerRpcResponse onDropBoxManagerRcpRequest(AbstractDropBoxManagerRemote.DropBoxManagerRpcRequest request) {
        Object data = null;
        switch (request.getOperation()) {
            case 0: {
                this.dropBoxManagerLocal.enable(request.getDropBoxName());
                break;
            }
            case 3: {
                this.dropBoxManagerLocal.enable(request.getDropBoxName());
                break;
            }
            case 1: {
                data = this.dropBoxManagerLocal.lookupDropBox(request.getDropBoxName());
                break;
            }
            case 2: {
                data = this.dropBoxManagerLocal.isEnabled(request.getDropBoxName());
                break;
            }
            case 4: {
                data = this.dropBoxManagerLocal.getDropBoxes();
                break;
            }
            case 6: {
                data = this.dropBoxManagerLocal.createDropBoxAccessor(request.getDropBoxName());
                ((DropBoxAccessorImpl)data).setDropBoxManagerRemote(this);
                data = this.cache.putAndConvertToProxy(data);
                break;
            }
            default: {
                throw new DropBoxException("Invalid operation " + request.getOperation());
            }
        }
        return new AbstractDropBoxManagerRemote.DropBoxManagerRpcResponse(data);
    }

    @Override
    protected Object onSLDataspaceCall(SLDataspaceCall call) {
        AccessibleObject object = this.cache.getAccessibleObject(call.objectId());
        if (object == null) {
            return new SLResponse(new DropBoxException("Specified DropBox is disabled, unavailable or does not exist."));
        }
        try {
            this.cache.resolveArgumentAccessibleObject(call);
            Method method = this.cache.resolveMethod(call, object);
            if (method == null) {
                return new SLResponse(new DropBoxException("Unknown method '" + call.method() + "' specified."));
            }
            SLResponse response = new SLResponse();
            response.setObject(this.cache.invoke(call, method, true));
            if (method.getName().equals("close")) {
                this.cache.removeAndCloseAccessibleObjectWithChilds(object);
            }
            return response;
        }
        catch (Exception exception) {
            return new SLResponse(exception);
        }
    }

    public void eraseFromObjectCache(Long oid) {
        this.cache.removeAndCloseAccessibleObjectWithChilds(oid);
    }

    public AccessibleObjectsCache getCache() {
        return this.cache;
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return null;
    }

    private class ObjectsChacheMonitor
    implements Runnable {
        private FabricThread executor = FabricThreadManager.getInstance().createDaemonThread("EXC:DropBox.CachedObjects:Monitor", "Closes and destroys dropbox chached not active objects.", this);
        private volatile boolean isRunning = false;
        private long objectsInactiveInterval = 30000L;
        private long accessorInactiveInterval = 86400000L;

        ObjectsChacheMonitor() {
        }

        public synchronized void start() {
            this.isRunning = true;
            this.executor.start();
        }

        public synchronized void stop() {
            this.isRunning = false;
            this.executor.interrupt();
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    Thread.sleep(this.objectsInactiveInterval);
                    if (!this.isRunning) continue;
                    DropBoxManagerRemoteImpl.this.cache.iterateOverObjectsNotAccessedForTime(this.objectsInactiveInterval, (oid, inactiveTime) -> {
                        AccessibleObject object = DropBoxManagerRemoteImpl.this.cache.getAccessibleObject((long)oid);
                        if (!(object == null || object instanceof DropBoxManagerRemoteImpl || object instanceof DropBoxAccessorImpl && inactiveTime <= this.accessorInactiveInterval)) {
                            DropBoxManagerRemoteImpl.this.cache.removeAndCloseAccessibleObjectWithChilds((Long)oid);
                        }
                    });
                }
                catch (InterruptedException exception) {
                    this.stop();
                }
            }
            this.executor.stop();
        }
    }
}

