/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxAccessorImpl;
import com.streamscape.sef.dropbox.DropBoxFactory;
import com.streamscape.sef.dropbox.DropBoxFactoryException;
import com.streamscape.sef.dropbox.DropBoxImpl;
import com.streamscape.sef.dropbox.DropBoxManager;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DropBoxManagerImpl
implements DropBoxManager {
    private RuntimeContext context;
    private DropBoxFactory dropBoxFactory = new DropBoxFactory();
    private Map<String, DropBoxAccessorImpl> accessors = new HashMap<String, DropBoxAccessorImpl>();
    private Map<String, DropBoxImpl> impls = new ConcurrentHashMap<String, DropBoxImpl>();
    private DropBoxSharedResourcesCleaner dropBoxSharedResourcesCleaner;

    public DropBoxManagerImpl(RuntimeContext context) throws FabricException {
        this.context = context;
        this.init();
    }

    private synchronized void init() throws FabricException {
        this.dropBoxFactory.init(this.context);
        for (DropBox dropBox : this.dropBoxFactory.getDropBoxes()) {
            this.init(dropBox);
        }
        this.dropBoxSharedResourcesCleaner = new DropBoxSharedResourcesCleaner();
        this.dropBoxSharedResourcesCleaner.start();
    }

    private void init(DropBox dropBox) {
        if (dropBox.isEnabled()) {
            DropBoxImpl impl = this.impls.get(dropBox.getName());
            if (impl == null) {
                impl = new DropBoxImpl(dropBox.clone());
                impl.init(this.context);
                this.impls.put(dropBox.getName(), impl);
            } else {
                impl.update(dropBox);
            }
        }
    }

    public synchronized void validateDropBoxPaths() throws FabricException {
        this.dropBoxFactory.getDropBoxes().stream().map(d -> this.impls.get(d.getName())).filter(Objects::nonNull).forEach(impl -> impl.checkPath(this.context));
    }

    private void destroy(DropBox dropBox) {
        this.destroy(dropBox.getName());
    }

    private void destroy(String name) {
        DropBoxImpl impl = this.impls.remove(name);
        if (impl != null) {
            impl.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        this.dropBoxSharedResourcesCleaner.stop();
        this.impls.values().forEach(a -> a.destroy());
        this.impls.clear();
    }

    @Override
    public synchronized DropBoxAccessor createDropBoxAccessor(String name) {
        DropBoxImpl impl = this.impls.get(name);
        if (impl == null) {
            throw new DataspaceException("Dropbox '" + name + "' doesn't exist or disabled.");
        }
        return new DropBoxAccessorImpl(impl);
    }

    @Override
    public synchronized void addDropBox(DropBox dropBox) throws DropBoxFactoryException {
        dropBox.validate();
        DropBoxUtils.checkDropBoxRootFolderPath(this.context, dropBox);
        this.dropBoxFactory.addDropBox(dropBox.clone());
        this.init(dropBox);
    }

    @Override
    public synchronized List<DropBox> getDropBoxes() {
        return new ArrayList<DropBox>(this.dropBoxFactory.getDropBoxes().stream().map(d -> d.clone()).collect(Collectors.toList()));
    }

    @Override
    public synchronized DropBox lookupDropBox(String name) {
        DropBox dropBox = this.dropBoxFactory.lookupDropBox(name);
        if (dropBox == null) {
            return null;
        }
        return dropBox.clone();
    }

    @Override
    public synchronized void updateDropBox(String dropBoxName, Consumer<DropBox> updateFunction) {
        DropBox dropBoxOld = this.lookupDropBox(dropBoxName);
        if (dropBoxOld == null) {
            throw new DropBoxException("DropBox with name " + dropBoxName + " doesn't exist.");
        }
        DropBox dropBoxNew = dropBoxOld.clone();
        updateFunction.accept(dropBoxNew);
        if (dropBoxNew.getName().equals(dropBoxOld.getName())) {
            try {
                this.dropBoxFactory.updateDropBox(dropBoxNew.clone());
            }
            catch (DropBoxFactoryException exception) {
                throw new DropBoxException("Updating dropbox failed.", exception);
            }
        }
        try {
            this.dropBoxFactory.removeDropBox(dropBoxOld.getName());
        }
        catch (DropBoxFactoryException exception) {
            throw new DropBoxException("Dropping dropbox failed.", exception);
        }
        this.destroy(dropBoxOld.getName());
        dropBoxNew.validate();
        try {
            this.dropBoxFactory.addDropBox(dropBoxNew.clone());
        }
        catch (DropBoxFactoryException exception) {
            throw new DropBoxException("Updating dropbox failed.", exception);
        }
        this.init(dropBoxNew);
    }

    @Override
    public synchronized void dropDropBox(String name, boolean withContent) {
        if (withContent && this.isEnabled(name)) {
            try (DropBoxAccessor accessor = this.createDropBoxAccessor(name);
                 FileSystem fileSystem = accessor.createFileSystem(RuntimeContext.getInstance().getUserName(), DropBoxAccessor.DropBoxPathNotation.OS);){
                fileSystem.delete(".", true);
            }
        }
        try {
            this.dropBoxFactory.removeDropBox(name);
        }
        catch (DropBoxFactoryException exception) {
            throw new DropBoxException("Dropping dropbox failed.", exception);
        }
        this.destroy(name);
    }

    @Override
    public synchronized void enable(String name) {
        DropBox dropBox = this.dropBoxFactory.lookupDropBox(name);
        dropBox.setEnabled(true);
        try {
            this.dropBoxFactory.updateDropBox(dropBox);
        }
        catch (DropBoxFactoryException exception) {
            throw new DropBoxException("Updating dropbox failed.", exception);
        }
        this.init(dropBox);
    }

    @Override
    public synchronized void disable(String name) {
        DropBox dropBox = this.dropBoxFactory.lookupDropBox(name);
        dropBox.setEnabled(false);
        try {
            this.dropBoxFactory.updateDropBox(dropBox);
        }
        catch (DropBoxFactoryException exception) {
            throw new DropBoxException("Updating dropbox failed.", exception);
        }
        this.destroy(dropBox);
    }

    @Override
    public synchronized List<String> listDropBoxes() {
        return this.dropBoxFactory.listDropBoxes();
    }

    @Override
    public synchronized List<String> listDropBoxesVisibleBy(String username) {
        if (username == null) {
            return this.listDropBoxes();
        }
        return new ArrayList<String>(this.dropBoxFactory.getDropBoxes().stream().filter(d -> DropBoxUtils.hasUserAccessAny(d, username) || DropBoxUtils.isAdmin(this.context, username)).map(d -> d.getName()).collect(Collectors.toList()));
    }

    @Override
    public synchronized boolean isEnabled(String name) {
        DropBox dropBox = this.dropBoxFactory.lookupDropBox(name);
        return dropBox != null && dropBox.isEnabled();
    }

    public class DropBoxSharedResourcesCleaner
    extends MonitorDaemonWorker {
        public DropBoxSharedResourcesCleaner() throws FabricException {
            super("DropBoxSharedResourcesCleaner", "Cleans expired dropbox resources.", 60000L);
            Trace.logInfo(this, "DropBox shared resoruces cleaner thread created. Cleanup period {} seconds.", this.getTimeout() / 1000L);
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            List dropBoxes = DropBoxManagerImpl.this.impls.values().stream().map(d -> d.getDropBox()).collect(Collectors.toList());
            for (DropBox dropBox : dropBoxes) {
                if (dropBox.getSharedResources().getResources().stream().filter(r -> r.isExpired()).count() <= 0L) continue;
                DropBoxManagerImpl.this.updateDropBox(dropBox.getName(), d -> {
                    List<String> expiredResources = d.getSharedResources().getResources().stream().filter(r -> r.isExpired()).map(r -> r.getResourceId()).collect(Collectors.toList());
                    Trace.logInfo(this, "Removing drop box " + dropBox.getName() + " expired resources: " + String.valueOf(expiredResources));
                    expiredResources.forEach(id -> d.getSharedResources().removeResource((String)id));
                });
            }
        }
    }
}

