/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemClientConnection;
import com.streamscape.lib.fs.client.local.LocalFileSystem;
import com.streamscape.lib.fs.client.repository.RepositoryAccessorFileSystem;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.cfo.ClientFactoryObject;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.dispatcher.AbstractDropBoxImpl;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxFileSystemImpl;
import com.streamscape.sef.dropbox.DropBoxFileSystemWithNotifications;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.dropbox.DropBoxConfigurator;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DropBoxImpl
extends AbstractDropBoxImpl {
    private DropBox dropBox;
    private String rootFolder;
    private DropBoxConfigurator.FileSystemFactory fileSystemFactory;
    private Exception exception = null;

    public DropBoxImpl(DropBox dropBox) {
        this.dropBox = dropBox;
    }

    @Override
    public synchronized void init(RuntimeContext context) {
        try {
            super.init(context);
            DropBoxUtils.checkDropBoxRootFolderPath(context, this.dropBox);
            this.initFileSystemFactory(context);
            this.checkDirectories();
            this.exception = null;
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    public synchronized void destroy() {
        if (this.fileSystemFactory != null) {
            this.fileSystemFactory.destroy();
            this.fileSystemFactory = null;
        }
    }

    synchronized void checkPath(RuntimeContext context) {
        try {
            DropBoxUtils.checkDropBoxRootFolderPath(context, this.dropBox);
        }
        catch (Exception exception) {
            this.destroy();
            this.exception = exception;
        }
    }

    public synchronized void update(DropBox dropBox) {
        this.dropBox = dropBox.clone();
        if (this.exception != null || this.fileSystemFactory == null) {
            return;
        }
        try {
            this.checkDirectories();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    public DropBox getDropBox() {
        return this.dropBox;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public boolean isError() {
        return this.exception != null;
    }

    public boolean isOpen() {
        return this.fileSystemFactory != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public FileSystem createFileSystem(String username, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        return this.createFileSystemOnPath(".", username, dropBoxPathNotation);
    }

    public FileSystem createFileSystemOnPath(String currentPath, String username, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        DropBoxFileSystemWithNotifications fileSystem = new DropBoxFileSystemWithNotifications(new DropBoxFileSystemImpl(this, currentPath, username, dropBoxPathNotation));
        try {
            fileSystem.open();
        }
        catch (IOException e) {
            throw new DropBoxException("Failed to open dropbox file system.", e);
        }
        return fileSystem;
    }

    private void initFileSystemFactory(final RuntimeContext context) {
        this.log(Trace.Level.DEBUG, "Initializing File System Factory...", new Object[0]);
        if (this.dropBox.getFsClientFactory() == null || this.dropBox.getFsClientFactory().trim().equals("")) {
            this.dropBox.setFsClientFactory(DropBox.LOCAL_FACTORY);
        }
        this.rootFolder = new MacroProcessor().process(this.dropBox.getRootFolder());
        if (this.dropBox.getFsClientFactory().trim().equals(DropBox.STFS_FACTORY)) {
            if (new File(this.rootFolder).isAbsolute()) {
                throw new DropBoxException("Root drop box folder cannot point to absolute directory for " + DropBox.STFS_FACTORY + " factory.");
            }
            this.fileSystemFactory = new DropBoxConfigurator.FileSystemFactory(){

                @Override
                public FileSystem createFileSystem(FabricConnection fabricConnection) {
                    try {
                        return new RepositoryAccessorFileSystem(fabricConnection != null ? fabricConnection.getRepositoryAccessor() : context.getRepositoryAccessor());
                    }
                    catch (FabricConnectionException exception) {
                        throw new DropBoxException("Creating repository accessor failed.", exception);
                    }
                }

                @Override
                public void releaseFileSystem(FileSystem fileSystem) {
                }

                @Override
                public void destroy() {
                }
            };
        } else if (this.dropBox.getFsClientFactory().trim().equals(DropBox.LOCAL_FACTORY) || this.dropBox.getFsClientFactory().trim().equals(DropBox.LOCAL_FACTORY_1)) {
            if (!new File(this.rootFolder).isAbsolute()) {
                String startupDir = (String)context.getEnvironment().get("streamscape.runtime.startup.dir");
                if (startupDir == null || startupDir.equals(".") || startupDir.length() == 0) {
                    startupDir = System.getProperty("user.dir");
                }
                this.rootFolder = startupDir + "/" + this.rootFolder;
                this.rootFolder = new File(this.rootFolder).getAbsolutePath();
            }
            this.fileSystemFactory = new DropBoxConfigurator.FileSystemFactory(this){

                @Override
                public FileSystem createFileSystem(FabricConnection fabricConnection) {
                    return new LocalFileSystem();
                }

                @Override
                public void releaseFileSystem(FileSystem fileSystem) {
                }

                @Override
                public void destroy() {
                }
            };
        } else {
            ClientFactory clientFactory;
            String type = ModeratorUtils.extractComponentNameType(this.dropBox.getFsClientFactory());
            String name = ModeratorUtils.extractComponentNameName(this.dropBox.getFsClientFactory());
            if (type == null || name == null) {
                throw new DropBoxException("Invalid client factory name '" + this.dropBox.getFsClientFactory() + "'.");
            }
            try {
                clientFactory = ClientConfigurationFactory.loadFactoryObject(context, name, type, false);
                clientFactory = new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(clientFactory);
            }
            catch (Exception exception) {
                throw new DropBoxException("Cannot load client factory '" + this.dropBox.getFsClientFactory() + "'.", exception);
            }
            Class<?> clazz = ((ClientFactoryObject)clientFactory).getClientConnectionClass();
            if (clazz == null) {
                throw new DropBoxException("Failed to load connection class for client factory '" + this.dropBox.getFsClientFactory() + "'.");
            }
            if (!FileSystemClientConnection.class.isAssignableFrom(clazz)) {
                throw new DropBoxException("Only file system client connection factories are supported. Not client factory '" + this.dropBox.getFsClientFactory() + "'.");
            }
            final ClientFactory finalClientFactory = clientFactory;
            this.fileSystemFactory = new DropBoxConfigurator.FileSystemFactory(){
                private List<FileSystemClientConnection> connections = new CopyOnWriteArrayList<FileSystemClientConnection>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FileSystem createFileSystem(FabricConnection fabricConnection) {
                    FileSystemClientConnection connection = null;
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(context.getSystemClassLoaderChain());
                        connection = (FileSystemClientConnection)((Object)finalClientFactory.createConnection("DropBoxConnection", finalClientFactory.getDefaultUser(), finalClientFactory.getDefaultPassword()));
                        ((AbstractClientConnection)((Object)connection)).connect();
                        this.connections.add(connection);
                        FileSystem fileSystem = connection.getFileSystem();
                        Thread.currentThread().setContextClassLoader(loader);
                        return fileSystem;
                    }
                    catch (Throwable throwable) {
                        try {
                            Thread.currentThread().setContextClassLoader(loader);
                            throw throwable;
                        }
                        catch (ClientException exception) {
                            try {
                                if (connection != null) {
                                    finalClientFactory.removeConnection(((AbstractClientConnection)((Object)connection)).getName());
                                }
                            }
                            catch (ClientFactoryConfigurationException clientFactoryConfigurationException) {
                                // empty catch block
                            }
                            throw new DropBoxException("Creating File System Connection for factory '" + DropBoxImpl.this.dropBox.getFsClientFactory() + "'.", exception);
                        }
                    }
                }

                @Override
                public void releaseFileSystem(FileSystem fileSystem) {
                    try {
                        for (FileSystemClientConnection connection : this.connections) {
                            if (connection.getFileSystem() != fileSystem) continue;
                            this.connections.remove(connection);
                            finalClientFactory.removeConnection(((AbstractClientConnection)((Object)connection)).getName());
                            break;
                        }
                    }
                    catch (ClientFactoryConfigurationException clientFactoryConfigurationException) {
                        // empty catch block
                    }
                }

                @Override
                public void destroy() {
                    try {
                        finalClientFactory.destroyAll();
                    }
                    catch (ClientFactoryConfigurationException clientFactoryConfigurationException) {
                        // empty catch block
                    }
                }
            };
        }
        this.log(Trace.Level.DEBUG, "File System Factory initialized.", new Object[0]);
    }

    private void checkDirectories() {
        this.log(Trace.Level.DEBUG, "Checking Directories...", new Object[0]);
        FileSystem fileSystem = null;
        try {
            fileSystem = this.fileSystemFactory.createFileSystem(null);
            this.checkDirectories(fileSystem);
        }
        catch (Exception exception) {
            this.log(Trace.Level.ERROR, "WARNING: failed to initialize directories acceptor.", new Object[0]);
            Trace.logException(this, exception, true);
            throw new DropBoxException("Failed to initialize directories.", exception);
        }
        finally {
            if (fileSystem != null) {
                this.fileSystemFactory.releaseFileSystem(fileSystem);
            }
        }
        this.log(Trace.Level.DEBUG, "Directories checked.", new Object[0]);
    }

    private void checkDirectories(FileSystem fileSystem) {
        try {
            if (!fileSystem.exists(this.addTailingSlashForS3(this.rootFolder))) {
                fileSystem.mkdir(this.addTailingSlashForS3(this.rootFolder));
            } else if (!fileSystem.isDirectory(this.addTailingSlashForS3(this.rootFolder))) {
                throw new DropBoxException("Root folder '" + this.rootFolder + "' is not a directory.");
            }
            for (DropBoxFolder folder : this.dropBox.getFolders()) {
                String subfolderPath = DropBoxUtils.buildPath(this.rootFolder, folder.getPath());
                if (!fileSystem.exists(this.addTailingSlashForS3(subfolderPath))) {
                    fileSystem.mkdir(this.addTailingSlashForS3(subfolderPath));
                    continue;
                }
                if (fileSystem.isDirectory(this.addTailingSlashForS3(subfolderPath))) continue;
                throw new DropBoxException("Subfolder '" + subfolderPath + "' is not a directory.");
            }
        }
        catch (Exception exception) {
            if (exception instanceof DropBoxException) {
                throw (DropBoxException)exception;
            }
            throw new DropBoxException("Creation of folders failed.", exception);
        }
    }

    private String addTailingSlashForS3(String path) {
        return path != null && path.trim().length() > 0 && DropBoxUtils.isS3Path(path.toLowerCase().trim()) && !path.trim().endsWith("/") ? path.trim() + "/" : path;
    }

    DropBoxConfigurator.FileSystemFactory getFileSystemFactory() {
        return this.fileSystemFactory;
    }

    protected void log(Trace.Level level, String message, Object ... args) {
        message = "[DropBoxImpl " + this.dropBox.getName() + "] " + (String)message;
        switch (level) {
            case DEBUG: {
                Trace.logDebug(this, (String)message, args);
                break;
            }
            case ERROR: {
                Trace.logError(this, (String)message, args);
                break;
            }
            case INFO: {
                Trace.logInfo(this, (String)message, args);
                break;
            }
            default: {
                Trace.logError(this, (String)message, args);
            }
        }
    }
}

