/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.AbstractFileSystem;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dropbox.DropBoxFileInfo;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxFileSystemImpl;
import com.streamscape.sef.dropbox.DropBoxFileSystemProxy;
import com.streamscape.sef.dropbox.DropBoxNotificationUtils;
import com.streamscape.sef.dropbox.OutputStreamAccessibleObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;

public class DropBoxFileSystemWithNotifications
extends AbstractFileSystem
implements DropBoxFileSystem,
AccessibleObject {
    private DropBoxFileSystemImpl dropBoxFileSystemImpl;
    private boolean notificationsEnabled;

    public DropBoxFileSystemWithNotifications(DropBoxFileSystemImpl fileSystem) {
        this.dropBoxFileSystemImpl = fileSystem;
        this.notificationsEnabled = true;
    }

    @Override
    public void open() throws IOException {
        this.dropBoxFileSystemImpl.open();
    }

    @Override
    public void close() throws IOException {
        this.dropBoxFileSystemImpl.close();
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        return this.dropBoxFileSystemImpl.getPathURI(path);
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        return this.dropBoxFileSystemImpl.getInfo(path);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return this.dropBoxFileSystemImpl.list(path, recursive);
    }

    @Override
    public List<DropBoxFileInfo> listDropBox(String path, boolean recursive) throws IOException {
        return this.dropBoxFileSystemImpl.listDropBox(path, recursive);
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        this.dropBoxFileSystemImpl.mkdir(path, permissions);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.MKDIR, path);
    }

    @Override
    public String createTempFile(String path, String prefix, String suffix) throws IOException {
        String tempFileFullPath = this.dropBoxFileSystemImpl.createTempFile(path, prefix, suffix);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.CREATE_TMP_FILE, tempFileFullPath);
        return tempFileFullPath;
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        this.dropBoxFileSystemImpl.createNewFile(path, permissions);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.CREATE_NEW_FILE, path);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        OutputStream outputStream = this.dropBoxFileSystemImpl.create(path, overwrite, permissions, bufferSize);
        ((OutputStreamAccessibleObject)outputStream).setOnCloseCallback(() -> this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.FILE_CREATED, path));
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.CREATE_NEW_FILE, path);
        return outputStream;
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        OutputStream outputStream = this.dropBoxFileSystemImpl.append(path, bufferSize);
        ((OutputStreamAccessibleObject)outputStream).setOnCloseCallback(() -> this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.FILE_APPENDED, path));
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.OPEN_FOR_APPEND, path);
        return outputStream;
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        FileInfo fileInfo = null;
        try {
            fileInfo = this.dropBoxFileSystemImpl.getInfo(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.dropBoxFileSystemImpl.delete(path, recursive);
        if (fileInfo != null) {
            this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.DELETE, fileInfo);
        }
        return result;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.dropBoxFileSystemImpl.exists(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.dropBoxFileSystemImpl.isFile(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.dropBoxFileSystemImpl.isDirectory(path);
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        InputStream inputStream = this.dropBoxFileSystemImpl.open(path, bufferSize);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.OPEN_FOR_READ, path);
        return inputStream;
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        RandomAccessInputStream inputStream = this.dropBoxFileSystemImpl.openForRandomRead(path, bufferSize);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.OPEN_FOR_READ, path);
        return inputStream;
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        OutputStream outputStream = this.dropBoxFileSystemImpl.openForWrite(path, bufferSize);
        ((OutputStreamAccessibleObject)outputStream).setOnCloseCallback(() -> this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.FILE_APPENDED, path));
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.OPEN_FOR_WRITE, path);
        return outputStream;
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        this.dropBoxFileSystemImpl.writeFileFromInputStream(path, inputStream, bufferSize);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.FILE_CREATED, path);
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        this.dropBoxFileSystemImpl.copy(src, dst);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.COPY, dst);
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        this.dropBoxFileSystemImpl.rename(src, dst);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.RENAME, dst);
    }

    @Override
    public void renameInternal(String src, String dst) throws IOException {
        this.dropBoxFileSystemImpl.renameInternal(src, dst);
    }

    @Override
    public void move(String src, String dst) throws IOException {
        this.dropBoxFileSystemImpl.move(src, dst);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.MOVE, dst);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.dropBoxFileSystemImpl.setOwner(path, username, groupname);
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        this.dropBoxFileSystemImpl.setPermissions(path, permissions);
    }

    @Override
    public boolean isLocal() {
        return this.dropBoxFileSystemImpl.isLocal();
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        long result = this.dropBoxFileSystemImpl.truncate(path, size);
        this.sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType.TRUNCATE, path);
        return result;
    }

    protected void sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType operationType, String path) {
        try {
            FileInfo info = this.dropBoxFileSystemImpl.getInfo(path);
            if (info != null) {
                this.sendDropBoxNotification(operationType, info);
            }
        }
        catch (IOException e) {
            Trace.logError(this, "Failed to get FileInfo for DropBox notification for DropBox " + this.dropBoxFileSystemImpl.getDropBoxImpl().getDropBox().getName() + " and path " + path + ".");
        }
    }

    protected void sendDropBoxNotification(DropBoxNotificationUtils.DropBoxOperationType operationType, FileInfo fileInfo) {
        if (this.notificationsEnabled) {
            DropBoxNotificationUtils.sendDropBoxNotification(this.dropBoxFileSystemImpl.getDropBoxImpl().getFabricConnection(), this.dropBoxFileSystemImpl.getDropBoxImpl().getDropBox(), this.dropBoxFileSystemImpl.getUsername(), "", operationType, fileInfo);
        }
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new DropBoxFileSystemProxy();
    }

    @Override
    public String getFullOsPath(String path) throws IOException {
        return this.dropBoxFileSystemImpl.getFullOsPath(path);
    }

    public static FileSystem withDisabledNotifications(FileSystem fileSystem) {
        if (fileSystem instanceof DropBoxFileSystemWithNotifications) {
            return ((DropBoxFileSystemWithNotifications)fileSystem).dropBoxFileSystemImpl;
        }
        return fileSystem;
    }
}

