/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.sef.dropbox.AbstractAccessibleObjectProxyForDropBox;
import com.streamscape.sef.dropbox.DropBoxAccessorProxy;
import com.streamscape.sef.dropbox.DropBoxFileInfo;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;

public class DropBoxFileSystemProxy
extends AbstractAccessibleObjectProxyForDropBox
implements DropBoxFileSystem {
    private boolean setCloseAccessorOnClose;

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.invokeFileSystemMethod("close", new Object[0]);
        }
        finally {
            if (this.setCloseAccessorOnClose && this.accessor != null) {
                ((DropBoxAccessorProxy)this.accessor).close();
            }
        }
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getPathURI", URI.class, path);
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getInfo", FileInfo.class, path);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return this.invokeFileSystemMethodWithReturn("list", List.class, path, recursive);
    }

    @Override
    public List<DropBoxFileInfo> listDropBox(String path, boolean recursive) throws IOException {
        return this.invokeFileSystemMethodWithReturn("listDropBox", List.class, path, recursive);
    }

    @Override
    public void mkdir(String path) throws IOException {
        this.invokeFileSystemMethod("mkdir", path);
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        this.invokeFileSystemMethod("mkdir", permissions);
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        return this.invokeFileSystemMethodWithReturn("createTempFile", String.class, dir, prefix, suffix);
    }

    @Override
    public void createNewFile(String path) throws IOException {
        this.invokeFileSystemMethod("createNewFile", path);
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        this.invokeFileSystemMethod("createNewFile", path, permissions);
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("create", OutputStream.class, path);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        return this.invokeFileSystemMethodWithReturn("create", OutputStream.class, path, overwrite);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions) throws IOException {
        return this.invokeFileSystemMethodWithReturn("create", OutputStream.class, path, overwrite, permissions);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        return this.invokeFileSystemMethodWithReturn("create", OutputStream.class, path, overwrite, permissions, bufferSize);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize, int replication, long blockSize) throws IOException {
        return this.invokeFileSystemMethodWithReturn("create", OutputStream.class, path, overwrite, permissions, bufferSize, replication, blockSize);
    }

    @Override
    public OutputStream append(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("append", OutputStream.class, path);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        return this.invokeFileSystemMethodWithReturn("append", OutputStream.class, path, bufferSize);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        return this.invokeFileSystemMethodWithReturn("delete", Boolean.class, path, recursive);
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("exists", Boolean.class, path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("isFile", Boolean.class, path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("isDirectory", Boolean.class, path);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("open", InputStream.class, path);
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        return this.invokeFileSystemMethodWithReturn("open", InputStream.class, path, bufferSize);
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path) throws IOException {
        throw new IOException("RandomAccessInputStream is not supported for remote dropboxes.");
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        throw new IOException("RandomAccessInputStream is not supported for remote dropboxes.");
    }

    @Override
    public OutputStream openForWrite(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("openForWrite", OutputStream.class, path);
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        return this.invokeFileSystemMethodWithReturn("openForWrite", OutputStream.class, path, bufferSize);
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        this.invokeFileSystemMethod("writeFileFromInputStream", path, inputStream, bufferSize);
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        this.invokeFileSystemMethod("copy", src, dst);
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        this.invokeFileSystemMethod("rename", src, dst);
    }

    @Override
    public void renameInternal(String src, String dst) throws IOException {
        this.invokeFileSystemMethod("renameInternal", src, dst);
    }

    @Override
    public void move(String src, String dst) throws IOException {
        this.invokeFileSystemMethod("move", src, dst);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.invokeFileSystemMethod("setOwner", path, username, groupname);
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        this.invokeFileSystemMethod("setPermissions", path, permissions);
    }

    @Override
    public int getDefaultReplication(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getDefaultReplication", Integer.class, path);
    }

    @Override
    public long getDefaultBlockSize(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getDefaultBlockSize", Integer.class, path).intValue();
    }

    @Override
    public String separator() throws IOException {
        return this.invokeFileSystemMethodWithReturn("separator", String.class, new Object[0]);
    }

    @Override
    public long getSize(String fileName) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getSize", Long.class, fileName);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        return this.invokeFileSystemMethodWithReturn("truncate", Long.class, path, size);
    }

    public void setCloseAccessorOnClose() {
        this.setCloseAccessorOnClose = true;
    }

    @Override
    public String getFullOsPath(String path) throws IOException {
        return this.invokeFileSystemMethodWithReturn("getFullOsPath", String.class, path);
    }
}

