/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.ds.persist.FlobManager;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.AbstractFileSystem;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.local.Wildcard;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxFileInfo;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxFileSystemProxy;
import com.streamscape.sef.dropbox.DropBoxImpl;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.InputStreamAccessibleObject;
import com.streamscape.sef.dropbox.OutputStreamAccessibleObject;
import com.streamscape.sef.dropbox.dsl.LsDropBoxOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DropBoxFileSystemImpl
extends AbstractFileSystem
implements AccessibleObject,
DropBoxFileSystem {
    private DropBoxImpl dropBoxImpl;
    private DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation;
    private final String currentOsPath;
    private String currentPath;
    private String username;
    private FileSystem fileSystem;

    public DropBoxFileSystemImpl(DropBoxImpl dropBoxImpl, String currentPath, String username, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        String currentOsPathThis;
        this.dropBoxImpl = dropBoxImpl;
        this.dropBoxPathNotation = dropBoxPathNotation;
        this.currentPath = currentPath;
        this.username = username;
        String string = currentOsPathThis = dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS ? this.resolveDropBoxFolderPathToOsPath(currentPath) : DropBoxUtils.resolveFolderShortcutToOsPath(dropBoxImpl.getDropBox(), currentPath);
        if (currentOsPathThis == null || currentOsPathThis.length() == 0) {
            currentOsPathThis = ".";
        }
        this.currentOsPath = currentOsPathThis;
    }

    @Override
    public void open() {
        this.checkAccessorIsOk();
        if (this.fileSystem != null) {
            return;
        }
        this.fileSystem = this.dropBoxImpl.getFileSystemFactory().createFileSystem(null);
    }

    @Override
    public void close() {
        if (this.fileSystem != null) {
            this.dropBoxImpl.getFileSystemFactory().releaseFileSystem(this.fileSystem);
            this.fileSystem = null;
        }
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        return this.fileSystem.getPathURI(this.getFullOsPath(path));
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccessOneOf(this.getFolderPath(path), DropBoxAccessControlOperation.LIST, DropBoxAccessControlOperation.READ, DropBoxAccessControlOperation.WRITE);
        try {
            FileInfo fileInfo = this.fileSystem.getInfo(this.getFullOsPath(path));
            if (fileInfo != null) {
                fileInfo.setPath(DropBoxUtils.replaceFolderShortcutToFolderName(this.getFolderParentPath(path)));
                fileInfo.setAbsolutePath(DropBoxUtils.getDropBoxURL(this.dropBoxImpl.getDropBox().getName(), DropBoxUtils.normalizePath(path)));
            }
            return fileInfo;
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    private String addTailingSlashForS3(String path) {
        return this.isS3FileSystem() && !path.endsWith("/") ? path + "/" : path;
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        Wildcard wildcard = null;
        if (Wildcard.isWildcard(path)) {
            wildcard = Wildcard.extractWildcard(path);
            path = Wildcard.extractWildcardPath(path);
        }
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        if (!DropBoxUtils.isEmptyOrDotPath(this.currentPath) || !DropBoxUtils.isEmptyOrDotPath(path)) {
            this.checkFullAccess(this.getFolderPath(path), DropBoxAccessControlOperation.LIST);
        }
        try {
            String fullPath = this.getFullOsPath(path);
            List<FileInfo> fileInfos = this.fileSystem.list(wildcard != null ? wildcard.format(fullPath) : fullPath, recursive);
            String localPath = path;
            if (DropBoxUtils.isDropBoxURL(localPath)) {
                localPath = DropBoxUtils.normalizePath(DropBoxUtils.getDropBoxPathFromURL(localPath));
            }
            Object absolutePath = DropBoxUtils.getDropBoxURL(this.dropBoxImpl.getDropBox().getName(), localPath);
            if (!DropBoxUtils.isEmptyOrDotPath(this.currentPath)) {
                absolutePath = (String)absolutePath + "/" + DropBoxUtils.replaceFolderShortcutToFolderName(this.currentPath);
            }
            for (FileInfo fileInfo2 : fileInfos) {
                String parent = DropBoxUtils.pathGetParent(fileInfo2.getPath());
                if (parent != null) {
                    fileInfo2.setPath(DropBoxUtils.pathRelativize(fullPath, parent != null ? parent : "."));
                }
                fileInfo2.setAbsolutePath((String)absolutePath);
            }
            fileInfos = fileInfos.stream().filter(fileInfo -> this.hasAccessToSystemOrDisabledFolder(DropBoxUtils.getDropBoxPathFromURL(fileInfo.getAbsolutePath()))).collect(Collectors.toList());
            return fileInfos;
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DropBoxFileInfo> listDropBox(String path, boolean recursive) throws IOException {
        boolean isOwnerOrFull;
        if (path == null) {
            path = ".";
        }
        List<Object> fileInfos = new ArrayList();
        boolean topLs = this.dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS && DropBoxUtils.isEmptyOrDotPath(this.currentPath) && DropBoxUtils.isEmptyOrDotPath(path);
        boolean bl = isOwnerOrFull = DropBoxUtils.isOwner(this.dropBoxImpl.getDropBox(), this.username) || DropBoxUtils.hasUserAccess(this.dropBoxImpl.getDropBox(), this.username, DropBoxAccessControlOperation.FULL);
        if (topLs) {
            for (DropBoxFolder dropBoxFolder : this.dropBoxImpl.getDropBox().getFolders()) {
                void var8_8;
                Object var8_9 = null;
                try {
                    FileInfo fileInfo2 = this.getInfo(dropBoxFolder.getName());
                }
                catch (Exception exception) {
                    FileInfo fileInfo3 = new FileInfo(dropBoxFolder.getName(), this.currentPath);
                    fileInfo3.setDirectory(true);
                }
                var8_8.setName(DropBoxUtils.normalizePath(dropBoxFolder.getPath()));
                fileInfos.add(var8_8);
                if (!recursive || !var8_8.isDirectory() || !this.exists(dropBoxFolder.getName())) continue;
                fileInfos.addAll(this.list(dropBoxFolder.getName(), recursive).stream().map(fileInfo -> {
                    fileInfo.setPath(dropBoxFolder.getName() + (String)(fileInfo.getPath() != null && fileInfo.getPath().length() > 0 ? "/" + fileInfo.getPath() : ""));
                    return fileInfo;
                }).collect(Collectors.toList()));
            }
        } else if (this.isS3FileSystem()) {
            if (Wildcard.isWildcard(path) || this.exists(path) && this.isDirectory(path)) {
                fileInfos = this.list(path, recursive);
            } else if (this.isDirectory(path + "/")) {
                fileInfos = this.list(path + "/", recursive);
            } else {
                FileInfo fileInfo2 = this.getInfo(path);
                if (fileInfo2 != null) {
                    fileInfos.add(fileInfo2);
                }
            }
        } else {
            fileInfos = this.isDirectory(path) || Wildcard.isWildcard(path) ? this.list(path, recursive) : Arrays.asList(this.getInfo(path));
        }
        ArrayList<DropBoxFileInfo> dropBoxFileInfos = new ArrayList<DropBoxFileInfo>();
        for (FileInfo fileInfo4 : fileInfos) {
            DropBoxFolder bestFolder;
            FolderType folderType = null;
            LsDropBoxOperation.DropBoxResourceType resourceType = LsDropBoxOperation.DropBoxResourceType.FILE;
            String managedResourceName = null;
            String directoryPath = DropBoxUtils.pathNormalize(this.currentPath, path, fileInfo4.getPath() != null ? fileInfo4.getPath() : ".", fileInfo4.getName());
            if (directoryPath == null || directoryPath.length() == 0) {
                directoryPath = ".";
            }
            if ((bestFolder = (DropBoxFolder)DropBoxUtils.getDropBoxFolderAndPathOrNull((DropBox)this.dropBoxImpl.getDropBox(), (String)directoryPath, (DropBoxAccessor.DropBoxPathNotation)DropBoxAccessor.DropBoxPathNotation.OS).first) == null) {
                bestFolder = (DropBoxFolder)DropBoxUtils.getDropBoxFolderAndPathOrNull((DropBox)this.dropBoxImpl.getDropBox(), (String)directoryPath, (DropBoxAccessor.DropBoxPathNotation)DropBoxAccessor.DropBoxPathNotation.FOLDERS).first;
            }
            if (bestFolder != null) {
                folderType = bestFolder.getType();
                managedResourceName = bestFolder.getName();
            }
            if (fileInfo4.isDirectory()) {
                resourceType = LsDropBoxOperation.DropBoxResourceType.UNMANAGED_RESOURCE;
                if (this.dropBoxImpl.getDropBox().getFolderByPath(DropBoxUtils.replaceFolderShortcutToFolderName(directoryPath)) != null) {
                    resourceType = LsDropBoxOperation.DropBoxResourceType.MANAGED_RESOURCE;
                    if (topLs && bestFolder != null) {
                        try {
                            boolean exists = this.exists("$" + bestFolder.getName());
                            if (!exists) {
                                resourceType = LsDropBoxOperation.DropBoxResourceType.MISSING_RESOURCE;
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                } else if (bestFolder != null) {
                    resourceType = LsDropBoxOperation.DropBoxResourceType.DIRECTORY;
                }
            }
            String dropBoxPath = null;
            List<Object> sharedResources = new ArrayList();
            if (managedResourceName != null) {
                Object filePath = DropBoxUtils.removeDropBoxPrefixAndName(fileInfo4.getAbsolutePath() + "/" + fileInfo4.getPath() + "/" + fileInfo4.getName());
                if (filePath == null) {
                    filePath = ".";
                }
                if (fileInfo4.isDirectory() && this.isS3FileSystem()) {
                    filePath = (String)filePath + "/";
                }
                Pair<DropBoxFolder, String> folderAndPath = DropBoxUtils.getDropBoxFolderAndPathOrNull(this.dropBoxImpl.getDropBox(), (String)filePath, DropBoxUtils.isEmptyOrDotPath(this.currentPath) ? this.dropBoxPathNotation : DropBoxAccessor.DropBoxPathNotation.FOLDERS);
                if (folderAndPath.first != null) {
                    dropBoxPath = DropBoxUtils.normalizePath(((DropBoxFolder)folderAndPath.first).getName() + "/" + (String)folderAndPath.second);
                    if (resourceType == LsDropBoxOperation.DropBoxResourceType.FILE) {
                        sharedResources = this.dropBoxImpl.getDropBox().getSharedResources().getResourceIdsByPath(dropBoxPath).stream().map(resourceId -> this.dropBoxImpl.getDropBox().getSharedResources().getResourceById((String)resourceId)).collect(Collectors.toList());
                    }
                }
            }
            Object name = fileInfo4.getName();
            if (fileInfo4.getPath() != null && fileInfo4.getPath().length() > 0) {
                name = fileInfo4.getPath() + (fileInfo4.getPath().endsWith("/") ? "" : "/") + fileInfo4.getName();
            }
            if (((String)(name = DropBoxUtils.normalizePath((String)name))).length() == 0) {
                name = ".";
            }
            if (topLs && !isOwnerOrFull) {
                name = resourceType == LsDropBoxOperation.DropBoxResourceType.MANAGED_RESOURCE ? DropBoxUtils.buildFolderShortcut(managedResourceName) : DropBoxUtils.buildFolderShortcut(fileInfo4.getPath()) + "/" + fileInfo4.getName();
            }
            fileInfo4.setName((String)name);
            DropBoxFileInfo dropBoxFileInfo = new DropBoxFileInfo(fileInfo4);
            dropBoxFileInfo.setDropBoxPath(dropBoxPath);
            dropBoxFileInfo.setFolderType(folderType);
            dropBoxFileInfo.setResourceType(resourceType);
            dropBoxFileInfo.setManagedResourceName(managedResourceName);
            dropBoxFileInfo.setSharedResources(new ArrayList<DropBoxSharedResources.DropBoxSharedResource>(sharedResources));
            dropBoxFileInfos.add(dropBoxFileInfo);
        }
        return dropBoxFileInfos;
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.mkdir(this.getFullOsPath(path), permissions);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public String createTempFile(String path, String prefix, String suffix) throws IOException {
        this.checkPath(path);
        this.checkAccessorAndFileSystemIsOk();
        this.checkFullAccess(this.getFolderParentPath(path + "/" + prefix), DropBoxAccessControlOperation.WRITE);
        try {
            String fullPathOS = this.getFullOsPath(path);
            String tempFileFullPath = this.fileSystem.createTempFile(fullPathOS, prefix, suffix);
            return this.getDropBoxPath(path, new File(tempFileFullPath).getName());
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.createNewFile(this.getFullOsPath(path), permissions);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            return new OutputStreamAccessibleObject(this.fileSystem.create(this.getFullOsPath(path), overwrite, permissions, bufferSize));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            return new OutputStreamAccessibleObject(this.fileSystem.append(this.getFullOsPath(path), bufferSize));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        Wildcard wildcard = null;
        if (Wildcard.isWildcard(path)) {
            wildcard = Wildcard.extractWildcard(path);
            path = Wildcard.extractWildcardPath(path);
        }
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        if (path == null || ".".equals(path)) {
            DropBoxUtils.checkUserAccess(this.dropBoxImpl.getDropBox(), this.username, DropBoxAccessControlOperation.FULL);
        } else if (wildcard != null) {
            this.checkFullAccess(FlobManager.unifyPath(path), DropBoxAccessControlOperation.WRITE);
        } else if (this.fileSystem.isFile(this.getFullOsPath(path))) {
            this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        } else {
            this.checkFullAccess(this.getFolderPath(path), DropBoxAccessControlOperation.WRITE);
        }
        try {
            String fullPath = this.getFullOsPath(path);
            return this.fileSystem.delete(wildcard != null ? wildcard.format(fullPath) : fullPath, recursive);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public boolean exists(String path) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        if (!DropBoxUtils.isEmptyOrDotPath(this.currentPath) || !DropBoxUtils.isEmptyOrDotPath(path)) {
            this.checkFullAccess(this.getFolderPath(path), DropBoxAccessControlOperation.LIST);
        }
        try {
            return this.fileSystem.exists(this.getFullOsPath(path));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public boolean isFile(String path) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderPath(path), DropBoxAccessControlOperation.LIST);
        try {
            return this.fileSystem.isFile(this.getFullOsPath(path));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        if (!DropBoxUtils.isEmptyOrDotPath(this.currentPath) || !DropBoxUtils.isEmptyOrDotPath(path)) {
            this.checkFullAccess(this.getFolderPath(path), DropBoxAccessControlOperation.LIST);
        }
        try {
            return this.fileSystem.isDirectory(this.getFullOsPath(path));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.READ);
        try {
            return new InputStreamAccessibleObject(this.fileSystem.open(this.getFullOsPath(path), bufferSize));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.READ);
        try {
            return this.fileSystem.openForRandomRead(this.getFullOsPath(path), bufferSize);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            return new OutputStreamAccessibleObject(this.fileSystem.openForWrite(this.getFullOsPath(path), bufferSize));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.writeFileFromInputStream(this.getFullOsPath(path), inputStream, bufferSize);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(src);
        this.checkPath((String)dst);
        if (this.isDirectory((String)dst)) {
            dst = (String)dst + (((String)dst).endsWith("/") ? "" : "/") + DropBoxUtils.pathGetFilename(src);
        }
        this.checkFullAccess(this.getFolderParentPath(src), DropBoxAccessControlOperation.READ);
        this.checkFullAccess(this.getFolderParentPath((String)dst), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.copy(this.getFullOsPath(src), this.getFullOsPath((String)dst));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, src, (String)dst);
        }
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(src);
        this.checkPath(dst);
        this.checkFullAccess(this.getFolderParentPath(src), DropBoxAccessControlOperation.READ);
        this.checkFullAccess(this.getFolderParentPath(dst), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.rename(this.getFullOsPath(src), this.getFullOsPath(dst));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, src, dst);
        }
    }

    @Override
    public void renameInternal(String src, String dst) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(src);
        this.checkPath(dst);
        try {
            this.fileSystem.rename(this.getFullOsPath(src), this.getFullOsPath(dst));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, src, dst);
        }
    }

    @Override
    public void move(String src, String dst) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(src);
        this.checkPath((String)dst);
        if (this.isDirectory((String)dst)) {
            dst = (String)dst + (((String)dst).endsWith("/") ? "" : "/") + DropBoxUtils.pathGetFilename(src);
        }
        this.checkFullAccess(this.getFolderParentPath(src), DropBoxAccessControlOperation.READ);
        this.checkFullAccess(this.getFolderParentPath((String)dst), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.move(this.getFullOsPath(src), this.getFullOsPath((String)dst));
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, src, (String)dst);
        }
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.setOwner(this.getFullOsPath(path), username, groupname);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            this.fileSystem.setPermissions(this.getFullOsPath(path), permissions);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        this.checkAccessorAndFileSystemIsOk();
        this.checkPath(path);
        this.checkFullAccess(this.getFolderParentPath(path), DropBoxAccessControlOperation.WRITE);
        try {
            return this.fileSystem.truncate(this.getFullOsPath(path), size);
        }
        catch (IOException exception) {
            throw this.convertIOException(exception, path);
        }
    }

    private void checkAccessorIsOk() {
        if (!this.dropBoxImpl.isOpen()) {
            throw new DropBoxException("DropBox accessor is not opened.");
        }
    }

    private void checkAccessorAndFileSystemIsOk() {
        this.checkAccessorIsOk();
        if (this.fileSystem == null) {
            throw new DropBoxException("DropBox accessor file system is not opened.");
        }
    }

    private void checkPath(String path) {
        if (this.dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS && this.currentOsPath != null && this.currentOsPath.length() > 0 && !this.currentOsPath.equals(".") && path.contains("..")) {
            throw new DropBoxException("Path cannot point out of DropBox folder.");
        }
        if (DropBoxUtils.pathNormalize(this.currentOsPath, this.getDropBoxRelativePath(path)).contains("..")) {
            throw new DropBoxException("Path points out of dropbox.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDropBoxRelativePath(String path) {
        String originalPath = path;
        if (!path.startsWith("dropbox:/")) return FlobManager.unifyPath(path);
        path = path.substring("dropbox:/".length());
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.startsWith(this.dropBoxImpl.getDropBox().getName())) throw new DropBoxException("Invalid drop box path '" + originalPath + "'. Points to another dropbox.");
        if ((path = path.substring(this.dropBoxImpl.getDropBox().getName().length())).startsWith("/")) {
            path = path.substring(1);
        }
        if (this.dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS) {
            if (this.currentPath == null || this.currentPath.length() <= 0 || this.currentPath.equals(".")) return FlobManager.unifyPath(path);
            if (!path.startsWith(this.currentPath)) throw new DropBoxException("Invalid drop box path '" + originalPath + "'. Points to out of current DropBox folder.");
            path = path.substring(this.currentPath.length());
            return FlobManager.unifyPath(path);
        } else {
            if (this.currentOsPath == null || this.currentOsPath.equals(".") || this.currentOsPath.equals("/")) return FlobManager.unifyPath(path);
            if (!path.startsWith(this.currentOsPath)) throw new DropBoxException("Invalid drop box path '" + originalPath + "'. Points to another path.");
            path = path.substring(this.currentOsPath.length());
        }
        return FlobManager.unifyPath(path);
    }

    @Override
    public String getFullOsPath(String path) {
        Object fullOsPath = null;
        if (this.dropBoxPathNotation == DropBoxAccessor.DropBoxPathNotation.FOLDERS) {
            String dropBoxRelativePath = this.getDropBoxRelativePath(DropBoxUtils.replaceFolderShortcutToFolderName(path));
            fullOsPath = !DropBoxUtils.isEmptyOrDotPath(this.currentOsPath) ? DropBoxUtils.pathNormalize(this.dropBoxImpl.getRootFolder(), this.currentOsPath, dropBoxRelativePath) : DropBoxUtils.pathNormalize(this.dropBoxImpl.getRootFolder(), this.currentOsPath, this.resolveDropBoxFolderPathToOsPath(dropBoxRelativePath));
        } else {
            String dropBoxRelativePath = this.getDropBoxRelativePath(DropBoxUtils.resolveFolderShortcutToOsPath(this.dropBoxImpl.getDropBox(), path));
            fullOsPath = DropBoxUtils.pathNormalize(this.dropBoxImpl.getRootFolder(), this.currentOsPath, dropBoxRelativePath);
        }
        if (this.isS3FileSystem() && path.endsWith("/")) {
            fullOsPath = (String)fullOsPath + "/";
        }
        return fullOsPath;
    }

    private String resolveDropBoxFolderPathToOsPath(String path) {
        if (DropBoxUtils.isEmptyOrDotPath(path)) {
            return ".";
        }
        Pair<DropBoxFolder, String> pair = DropBoxUtils.getDropBoxFolderAndPath(this.dropBoxImpl.getDropBox(), path);
        return DropBoxUtils.normalizePath(((DropBoxFolder)pair.first).getPath() + "/" + (String)pair.second);
    }

    private String getDropBoxPath(String dropBoxPath, String name) {
        return this.convertPathToDropBoxURL(dropBoxPath + "/" + name);
    }

    private String getFolderPath(String path) {
        return DropBoxUtils.pathNormalize(this.currentPath, this.getDropBoxRelativePath(path));
    }

    private String getFolderParentPath(String path) {
        path = this.getDropBoxRelativePath(path);
        if ((path = DropBoxUtils.pathNormalize(this.currentPath, path)).equals("") || path.equals(".")) {
            return ".";
        }
        if ((path = DropBoxUtils.pathGetParent(path)) == null) {
            return ".";
        }
        if (path.equals("")) {
            return ".";
        }
        return FlobManager.unifyPath(path);
    }

    private void checkFullAccessOneOf(String path, DropBoxAccessControlOperation ... operations) {
        DropBoxUtils.checkFullAccessOneOf(this.dropBoxImpl.getDropBox(), this.username, path, this.dropBoxPathNotation, operations);
    }

    private void checkFullAccess(String path, DropBoxAccessControlOperation operation) {
        if (path == null) {
            throw new DropBoxException("Operations in the root dropbox folder are not allowed.");
        }
        String dropBoxRelativePath = this.getFolderPath(path);
        DropBoxUtils.checkFullAccess(this.dropBoxImpl.getDropBox(), this.username, operation, dropBoxRelativePath, this.dropBoxPathNotation);
    }

    private IOException convertIOException(IOException exception, String path) {
        String fullPath = this.getFullOsPath(path);
        if (exception.getMessage().contains(fullPath)) {
            exception = new IOException(exception.getMessage().replaceAll(Pattern.quote(fullPath), this.convertPathToDropBoxURL(path)), exception.getCause() == exception ? null : exception.getCause());
        }
        return exception;
    }

    private IOException convertIOException(IOException exception, String path1, String path2) {
        return this.convertIOException(this.convertIOException(exception, path1), path2);
    }

    private String convertPathToDropBoxURL(String path) {
        return DropBoxUtils.getDropBoxURL(this.dropBoxImpl.getDropBox().getName(), this.getFolderPath(path).replaceAll(Pattern.quote("\\\\"), "/"));
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new DropBoxFileSystemProxy();
    }

    public DropBoxImpl getDropBoxImpl() {
        return this.dropBoxImpl;
    }

    public String getUsername() {
        return this.username;
    }

    private boolean hasAccessToSystemOrDisabledFolder(String path) {
        DropBoxFolder folder = (DropBoxFolder)DropBoxUtils.getDropBoxFolderAndPathOrNull((DropBox)this.dropBoxImpl.getDropBox(), (String)path, (DropBoxAccessor.DropBoxPathNotation)this.dropBoxPathNotation).first;
        if (folder == null || folder.getType() == FolderType.DISABLED) {
            return DropBoxUtils.getUserAclMerged(this.getDropBoxImpl().getDropBox(), this.username, path, this.dropBoxPathNotation, DropBoxAccessControlOperation.FULL).contains((Object)DropBoxAccessControlOperation.FULL);
        }
        return true;
    }

    private boolean isS3FileSystem() {
        return DropBoxUtils.isS3Path(this.dropBoxImpl.getRootFolder());
    }
}

