/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.Trace;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dropbox.DropBoxFactoryException;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.utils.Configurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropBoxFactory
extends AbstractRuntimeFactory {
    public static final String DROPBOXES_NAMESPACE = "/sys/dropboxes/";
    protected String namespace;
    protected List<String> supportedModels;
    protected transient SemanticType semanticType;
    protected transient List<SemanticType> supportedTypes;
    protected transient Map<String, DropBox> objects;
    protected transient Configurator<DropBox> configurator;

    public DropBoxFactory() {
        DropBoxFactory.checkContext();
        this.namespace = DROPBOXES_NAMESPACE;
        this.listSupportedModels();
    }

    public void init(RuntimeContext context) throws FabricException {
        AbstractRuntimeFactory.checkContext();
        try {
            this.objects = new HashMap<String, DropBox>();
            this.configurator = new Configurator(this.namespace);
            this.loadObjects();
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of " + this.getName() + " failed.", exception);
        }
        Trace.logInfo(this, this.getName() + " initialized.");
    }

    public void destroy() {
    }

    public String getName() {
        return "DropBoxFactory";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<SemanticType> getSupportedTypes() {
        if (this.supportedTypes == null) {
            this.supportedTypes = new ArrayList<SemanticType>();
            this.addSupportedTypes();
        }
        return this.supportedTypes;
    }

    public List<String> listSupportedModels() {
        if (this.supportedModels == null) {
            this.supportedModels = new ArrayList<String>();
            for (SemanticType semanticType : this.getSupportedTypes()) {
                this.supportedModels.add(semanticType.getTypeName());
            }
            Collections.sort(this.supportedModels);
        }
        return this.supportedModels;
    }

    public List<DropBox> getDropBoxes() {
        if (this.objects != null) {
            return new ArrayList<DropBox>(this.objects.values());
        }
        return null;
    }

    public DropBox lookupDropBox(String name) {
        return this.objects.get(name);
    }

    public List<String> listDropBoxes() {
        return new ArrayList<String>(this.objects.keySet());
    }

    public boolean isDropBoxExists(String name) {
        return this.objects.containsKey(name);
    }

    public DropBox addDropBox(DropBox dropbox) throws DropBoxFactoryException {
        try {
            DropBoxFactory.validateDropBox(dropbox);
            if (this.isDropBoxExists(dropbox.getName())) {
                throw new DropBoxFactoryException(6002, "DropBox '" + dropbox.getName() + "' already exist.");
            }
            this.configurator.bindObject(dropbox.getName(), dropbox);
            this.putDropBox(dropbox.getName(), dropbox);
            return dropbox;
        }
        catch (Exception exception) {
            throw new DropBoxFactoryException(6002, "Adding dropbox " + dropbox.getName() + " failed.", exception);
        }
    }

    public DropBox updateDropBox(DropBox dropbox) throws DropBoxFactoryException {
        try {
            DropBoxFactory.validateDropBox(dropbox);
            if (!this.isDropBoxExists(dropbox.getName())) {
                throw new DropBoxFactoryException(6002, "DropBox '" + dropbox.getName() + "' doesn't exist.");
            }
            this.configurator.unbindObject(dropbox.getName());
            this.objects.remove(dropbox.getName());
            this.configurator.bindObject(dropbox.getName(), dropbox);
            this.putDropBox(dropbox.getName(), dropbox);
            return dropbox;
        }
        catch (Exception exception) {
            throw new DropBoxFactoryException(6002, "Updating dropbox " + dropbox.getName() + " failed.", exception);
        }
    }

    public void removeDropBox(String name) throws DropBoxFactoryException {
        try {
            this.configurator.unbindObject(name);
            DropBox removedObject = this.objects.remove(name);
            if (removedObject == null) {
                throw new DropBoxFactoryException(6002, "DropBox '" + name + "' doesn't exist.");
            }
        }
        catch (ObjectConfigurationException exception) {
            throw new DropBoxFactoryException(6002, "Removing dropbox '" + name + "' failed.", exception);
        }
    }

    private void loadObjects() throws Exception {
        for (String objectName : this.configurator.listBoundNames()) {
            DropBox object;
            if (this.isDropBoxExists(objectName) || DropBoxTable.class.getSimpleName().equals(objectName)) continue;
            try {
                object = this.configurator.loadObject(objectName);
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Object '" + objectName + "' is invalid. Skipping.");
                String artifact = null;
                for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof TFCacheException)) continue;
                    artifact = ((TFCacheException)cause).getArtifact();
                    break;
                }
                if (artifact == null) continue;
                this.configurator.moveObjectToJunk(artifact);
                continue;
            }
            try {
                this.putDropBox(objectName, object);
            }
            catch (Exception exception) {
                this.processException(exception, object);
            }
            this.updateDropBoxFolderNames(object);
        }
    }

    private DropBox updateDropBoxFolderNames(DropBox object) throws DropBoxFactoryException {
        boolean changed = false;
        List<DropBoxFolder> foldersCopy = object.getFolders();
        for (DropBoxFolder folderCopy : foldersCopy) {
            DropBoxFolder folder = object.getFolderByPath(folderCopy.getPath());
            if ((folder == null || folder.getName() != null) && folder.getName().length() != 0) continue;
            folder.setName(DropBoxUtils.buildFolderNameFromPath(folder.getPath()));
            changed = true;
        }
        if (changed) {
            this.updateDropBox(object);
        }
        return object;
    }

    private void putDropBox(String objectName, DropBox object) throws DropBoxFactoryException {
        if (object != null) {
            object.setNodeName(((RuntimeContext)context).getName());
        }
        this.objects.put(objectName, object);
    }

    private void processException(Exception exception, DropBox object) throws Exception {
        Trace.logException(this, exception, true);
    }

    private static void validateDropBox(DropBox dropbox) throws DropBoxFactoryException {
        if (dropbox.getName() == null || dropbox.getName().isEmpty()) {
            throw new DropBoxFactoryException(6007, "DropBox must have a name.");
        }
    }

    private void addSupportedTypes() {
        this.addSupportedType("DropBox", DropBox.class, "Core DropBox object.");
    }

    private void addSupportedType(String typeName, Class objectClass, String description) {
        SemanticType type = DropBoxFactory.createSemanticType(typeName, objectClass, true);
        type.setDescription(description);
        this.supportedTypes.add(type);
    }
}

