/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractFactoryConnectionService;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxFactoryException;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.DropBoxConnectionLexiconProcessor;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.factory.connection.external.ExternalParser;
import com.streamscape.slex.SemanticLexiconProcessor;

public class DropBoxConnectionService
extends AbstractFactoryConnectionService {
    public static final String DROPBOX_TYPE_NAME = "DropBox";
    private DropBoxConnectionLexiconProcessor lexiconProcessor;
    private RuntimeContext context;
    private String dropBoxName;
    private String userName;
    private DropBoxAccessor accessor;
    private String currentPath = ".";
    private DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation = DropBoxAccessor.DropBoxPathNotation.FOLDERS;

    public DropBoxConnectionService(RuntimeContext context, String dropBoxName, String userName) {
        this.context = context;
        this.dropBoxName = dropBoxName;
        this.userName = userName;
    }

    public RuntimeContext getContext() {
        return this.context;
    }

    @Override
    protected void onInit() throws Exception {
        this.lexiconProcessor = new DropBoxConnectionLexiconProcessor(RuntimeContext.getInstance(), this.getDSLComponent(this));
        this.initDropBoxAccessor();
    }

    @Override
    public void destroy() {
        this.destroyDropBoxAccessor();
    }

    @Override
    public SemanticLexiconProcessor getLexiconProcessor() {
        return this.lexiconProcessor;
    }

    public DropBoxAccessor getDropBoxAccessor() {
        return this.accessor;
    }

    private void initDropBoxAccessor() throws Exception {
        DropBox dropBox = RuntimeContext.getInstance().getDropBoxManagerRemote().lookupDropBox(this.dropBoxName);
        if (dropBox == null) {
            throw new DropBoxFactoryException("Dropbox '" + this.dropBoxName + "' does not exist.");
        }
        DropBoxUtils.checkAccessAny(dropBox, this.userName);
        this.accessor = RuntimeContext.getInstance().getDropBoxManagerRemote().createDropBoxAccessor(this.dropBoxName);
        this.dropBoxPathNotation = DropBoxUtils.isOwner(dropBox, this.userName) || DropBoxUtils.hasUserAccess(dropBox, this.userName, DropBoxAccessControlOperation.FULL) ? DropBoxAccessor.DropBoxPathNotation.OS : DropBoxAccessor.DropBoxPathNotation.FOLDERS;
    }

    private void destroyDropBoxAccessor() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }

    @Override
    public ExternalParser getExternalParser() {
        return null;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    public String getDropBoxName() {
        return this.dropBoxName;
    }

    public void setDropBoxPathNotation(DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        this.dropBoxPathNotation = dropBoxPathNotation;
    }

    public DropBoxAccessor.DropBoxPathNotation getDropBoxPathNotation() {
        return this.dropBoxPathNotation;
    }
}

