/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.List;

public class DropBoxAutoConnectFileSystem
implements FileSystem {
    private FileSystem dropBoxFileSystem;
    private Session session;

    public DropBoxAutoConnectFileSystem(Session session) {
        this.session = session;
    }

    private void initDropBoxFileSystem(String path) throws IOException {
        if (this.dropBoxFileSystem == null) {
            this.dropBoxFileSystem = new FileSystemProvider(DataspaceStore.getContext()).createFileSystem(this.session, path);
            this.dropBoxFileSystem.open();
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.dropBoxFileSystem != null) {
            this.dropBoxFileSystem.close();
            this.dropBoxFileSystem = null;
        }
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.getPathURI(path);
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.getInfo(path);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.list(path, recursive);
    }

    @Override
    public void mkdir(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.mkdir(path);
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.mkdir(path, permissions);
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        this.initDropBoxFileSystem(dir);
        return this.dropBoxFileSystem.createTempFile(dir, prefix, suffix);
    }

    @Override
    public void createNewFile(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.createNewFile(path);
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.createNewFile(path, permissions);
    }

    @Override
    public OutputStream create(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.create(path);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.create(path, overwrite);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.create(path, overwrite, permissions);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.create(path, overwrite, permissions, bufferSize);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize, int replication, long blockSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.create(path, overwrite, permissions, bufferSize, replication, blockSize);
    }

    @Override
    public OutputStream append(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.append(path);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.append(path, bufferSize);
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.delete(path, recursive);
    }

    @Override
    public boolean exists(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.exists(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.isFile(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.isDirectory(path);
    }

    @Override
    public InputStream open(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.open(path);
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.open(path, bufferSize);
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.openForRandomRead(path);
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.openForRandomRead(path, bufferSize);
    }

    @Override
    public OutputStream openForWrite(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.openForWrite(path);
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.openForWrite(path, bufferSize);
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.writeFileFromInputStream(path, inputStream, bufferSize);
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        this.initDropBoxFileSystem(src);
        this.dropBoxFileSystem.copy(src, dst);
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        this.initDropBoxFileSystem(src);
        this.dropBoxFileSystem.rename(src, dst);
    }

    @Override
    public void move(String src, String dst) throws IOException {
        this.initDropBoxFileSystem(src);
        this.dropBoxFileSystem.move(src, dst);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.setOwner(path, username, groupname);
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        this.initDropBoxFileSystem(path);
        this.dropBoxFileSystem.setPermissions(path, permissions);
    }

    @Override
    public int getDefaultReplication(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.getDefaultReplication(path);
    }

    @Override
    public long getDefaultBlockSize(String path) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.getDefaultBlockSize(path);
    }

    @Override
    public String separator() throws IOException {
        return FileSystems.getDefault().getSeparator();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        this.initDropBoxFileSystem(path);
        return this.dropBoxFileSystem.truncate(path, size);
    }
}

