/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dropbox;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxAccessorProxy;
import com.streamscape.sef.dropbox.DropBoxImpl;
import com.streamscape.sef.dropbox.DropBoxManagerRemoteImpl;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import java.util.function.Consumer;

class DropBoxAccessorImpl
implements DropBoxAccessor,
AccessibleObject {
    private DropBoxImpl impl;
    private long requestTimeout;
    private DropBoxManagerRemoteImpl dropBoxManagerRemote;

    public DropBoxAccessorImpl(DropBoxImpl impl) {
        this.impl = impl;
    }

    @Override
    public void close() {
    }

    @Override
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public DropBox getDropBox() {
        return this.impl.getDropBox();
    }

    @Override
    public String getRootFolder() {
        return this.impl.getRootFolder();
    }

    @Override
    public boolean isError() {
        return this.impl.isError();
    }

    @Override
    public boolean isOpen() {
        return this.impl.isOpen();
    }

    @Override
    public Exception getException() {
        return this.impl.getException();
    }

    @Override
    public FileSystem createFileSystem(String username, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        return this.impl.createFileSystem(username, dropBoxPathNotation);
    }

    @Override
    public FileSystem createFileSystemOnPath(String path, String username, DropBoxAccessor.DropBoxPathNotation dropBoxPathNotation) {
        return this.impl.createFileSystemOnPath(path, username, dropBoxPathNotation);
    }

    @Override
    public DropBoxSharedResources.DropBoxSharedResource createSharedResource(String fullPath, String resourceId, Long expiresAt, String ownerName, DropBoxSharedResources.DropBoxSharedResource.ShareMethod shareMethod) {
        DropBoxSharedResources.DropBoxSharedResource[] resource = new DropBoxSharedResources.DropBoxSharedResource[]{null};
        Consumer<DropBox> updateFunction = dropBox -> {
            DropBoxUtils.checkFullAccessAny(dropBox, ownerName, fullPath, DropBoxAccessor.DropBoxPathNotation.FOLDERS);
            if (resourceId != null && dropBox.getSharedResources().getResourceById(resourceId) != null) {
                throw new DropBoxException("Resource with ID " + resourceId + " already exists.");
            }
            resource[0] = dropBox.getSharedResources().createResource(fullPath, resourceId, expiresAt, ownerName, shareMethod);
        };
        this.dropBoxManagerRemote.updateDropBox(this.impl.getDropBox().getName(), updateFunction);
        return resource[0];
    }

    @Override
    public void removeSharedResource(String resourceId) {
        Consumer<DropBox> updateFunction = dropBox -> dropBox.getSharedResources().removeResource(resourceId);
        this.dropBoxManagerRemote.updateDropBox(this.impl.getDropBox().getName(), updateFunction);
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return new DropBoxAccessorProxy();
    }

    public void setDropBoxManagerRemote(DropBoxManagerRemoteImpl dropBoxManagerRemote) {
        this.dropBoxManagerRemote = dropBoxManagerRemote;
    }
}

