/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDetachUnlinkNodeOperation;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;
import java.util.stream.Collectors;

public class UnlinkNodeOperation
extends AbstractDetachUnlinkNodeOperation {
    public static final String NAME = "unlink node";

    public UnlinkNodeOperation() {
        super(NAME);
        this.syntax.setDescription("Closes an existing connection (i.e. a direct link) between the specified nodes.\nIf the parameter <SourceNode> is not specified, the current node is used as a source node.\n");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  force                  - Tries to forcibly close a corresponding network connection.\n                           This operation is potentially unsafe, so use it only if a normal way does not work.\n  with timeout <Timeout> - Wait time (in seconds) for normal closing a link.\n                           If the timeout expires before closing completion, the link will be closed forcibly.\n                           Non-positive value means that forced closing will not be used. Default is 10 seconds.\n  stop scavenger         - Stops the Scavenger thread in the source node.");
        this.syntax.setExamples("unlink node from TestNode2\nunlink node TestNode1 from TestNode2\nunlink node from TestNode2 stop scavenger\nunlink node TestNode1 from TestNode2 with timeout 30\nunlink node from TestNode2 with timeout 30 stop scavengerunlink node from TestNode2 force");
    }

    @Override
    void addNodeModifiers() {
        this.syntax.addActionParameter((SyntaxParameter)((IdentifierParameter)((IdentifierParameter)new IdentifierParameter("SourceNode").addExclusionValue("FROM")).setCompletionAdviser(new SourceNodeCompletionAdviser())).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM").addParameter((SyntaxParameter)new IdentifierParameter("TargetNode").setCompletionAdviser(new TargetNodeCompletionAdviser()))).setSyntaxHintSpace());
    }

    @Override
    void addOptionalModifiers() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(this.makeForceModifier(true))).addModifier(this.makeWithTimeoutModifier(true)));
        this.syntax.addModifier(this.makeStopScavengerModifier());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("SourceNode") ? statement.getParameter("SourceNode").getValue() : null, statement.getParameter("TargetNode").getValue(), UnlinkNodeOperation.getForceParameter(statement), UnlinkNodeOperation.getTimeoutParameter(statement), UnlinkNodeOperation.getStopScavengerParameter(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.sourceNode != null && ((RuntimeContext)this.callable).moderator.lookupFabricNode(definition.sourceNode) == null) {
            throw new Exception("Source node not found.");
        }
        return this.invoke(definition.sourceNode, definition, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        FabricNode targetNode = ((RuntimeContext)this.callable).exchange.getFabricNode(definition.targetNode);
        if (targetNode == null) {
            throw new Exception("Target node not found.");
        }
        if (!((RuntimeContext)this.callable).exchange.existsNodeConnection(targetNode)) {
            throw new Exception("Link not found.");
        }
        FabricThreadManager.getInstance().createThread("EXCH:Unlink.Node", "Closes a direct link between '" + node.getName() + "' and '" + definition.targetNode + "' nodes.", () -> {
            Utils.sleep(500L);
            this.unlink(targetNode, definition);
        }).start();
        return new SLResponse();
    }

    private void unlink(FabricNodeReference targetNode, Definition definition) {
        ((RuntimeContext)this.callable).exchange.unlinkNode((FabricNode)targetNode, definition.force, UnlinkNodeOperation.getTimeout(definition), !definition.stopScavenger);
    }

    private class SourceNodeCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        private SourceNodeCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return ((RuntimeContext)UnlinkNodeOperation.this.callable).getModerator().listFabricNodes().stream().sorted().collect(Collectors.toList());
        }
    }

    private class TargetNodeCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        private TargetNodeCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                return ((RuntimeContext)((UnlinkNodeOperation)UnlinkNodeOperation.this).callable).exchange.getNodeConnectionAddresses().stream().map(address -> ((RuntimeContext)((UnlinkNodeOperation)UnlinkNodeOperation.this).callable).exchange.getFabricNode((FabricAddress)address).getName()).sorted().collect(Collectors.toList());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static class Definition
    extends AbstractDetachUnlinkNodeOperation.Definition {
        private String sourceNode;
        private String targetNode;

        public Definition(String sourceNode, String targetNode, boolean force, Long timeout, boolean stopScavenger) {
            super(UnlinkNodeOperation.NAME, force, timeout, stopScavenger);
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
        }
    }
}

