/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.omf.mapper.mf.ConverterPluginManager;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.slang.SLSession;
import java.util.HashMap;
import java.util.Map;

public class TriggerFunctionContextImpl
extends TriggerFunctionParserContextImpl
implements TriggerFunctionContext {
    private Map<String, Object> systemVariableValues = new HashMap<String, Object>();
    private EventTriggerDefinition eventTriggerDefinition;
    private ImmutableEventDatagram incomingEvent;
    private ImmutableEventDatagram sourceEvent;
    private AbstractFabricComponent component;
    private SLSession slSession;
    private long executionWindowMs;
    private DataspaceAccessorProvider dataspaceAccessorProvider;

    public TriggerFunctionContextImpl(FabricContext context) {
        super(context);
    }

    public void setComponent(FabricComponent component) throws Exception {
        if (!(component instanceof AbstractFabricComponent)) {
            throw new Exception("Component should be instance of AbstractFabricComponent.");
        }
        this.component = (AbstractFabricComponent)component;
    }

    @Override
    public FabricComponent getComponent() {
        return this.component;
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws Exception {
        if (this.component == null) {
            throw new Exception("Failed to raise event, component not set.");
        }
        if (eventScope == EventScope.LOCAL) {
            this.component.dispatcher.raiseActionableEvent(event, 0L);
        } else if (event instanceof AcknowledgementEvent) {
            this.component.dispatcher.raiseAcknowledgement((AcknowledgementEvent)event, eventScope, 0L);
            Trace.logDebug(this, "Acknowledgement [" + event.getEventId() + "] raised.");
        } else if (event instanceof EventDatagram) {
            this.component.dispatcher.raiseEvent(event, eventScope, 0L);
            Trace.logDebug(this, "Event [" + event.getEventId() + "] raised.");
        } else if (event instanceof ExceptionEventDatagram) {
            this.component.dispatcher.raiseException((ExceptionEventDatagram)event, eventScope);
            Trace.logDebug(this, "Exception [" + event.getEventId() + "] raised.");
        } else if (event instanceof AdvisoryEventDatagram) {
            this.component.dispatcher.raiseSystemAdvisory((AdvisoryEventDatagram)event, eventScope);
            Trace.logDebug(this, "Advisory [" + event.getEventId() + "] raised.");
        } else {
            Trace.logError(this, "Raising is impossible: Unsupported event type.");
        }
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event) throws Exception {
        this.raiseEvent(event, EventScope.INHERITED);
    }

    @Override
    public Object getSystemVariableValue(String name) {
        return this.systemVariableValues.get(name);
    }

    @Override
    public boolean existsSystemVariableValue(String name) {
        return this.systemVariableValues.containsKey(name);
    }

    public void setSystemVariableValue(String name, Object value) throws TriggerFunctionException {
        if (!super.existsSystemVariableType(name)) {
            throw new TriggerFunctionException("System variable '" + name + "' type not defined.");
        }
        Type<?> variableType = super.getSystemVariableType(name);
        Type<?> valueType = TypeFactory.resolveObjectType(value, this);
        try {
            variableType.canConvert(valueType);
        }
        catch (TypeConversionException exception) {
            throw new TriggerFunctionException("System variable '" + name + "' types mismatch, should be '" + String.valueOf(variableType) + "', but passed '" + String.valueOf(valueType) + "'.", exception);
        }
        this.systemVariableValues.put(name, value);
    }

    public void setEventTriggerDefinition(EventTriggerDefinition eventTriggerDefinition) {
        this.eventTriggerDefinition = eventTriggerDefinition;
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition() {
        return this.eventTriggerDefinition;
    }

    public void setActionableEvent(ImmutableEventDatagram actionableEvent) throws TriggerFunctionException {
        this.incomingEvent = actionableEvent;
        this.setSystemVariableValue(this.actionableEventAlias, actionableEvent);
    }

    @Override
    public ImmutableEventDatagram getActionableEvent() {
        return this.incomingEvent;
    }

    public void setSourceEvent(ImmutableEventDatagram sourceEvent) {
        this.sourceEvent = sourceEvent;
        if (this.sourceEventAlias != null) {
            this.systemVariableValues.put(this.sourceEventAlias, sourceEvent);
        }
    }

    public ImmutableEventDatagram getSourceEvent() {
        return this.sourceEvent;
    }

    @Override
    public AcknowledgementEvent createAcknowledgement(ImmutableEventDatagram event, boolean withSourceData) throws Exception {
        if (event instanceof EventDatagram) {
            return this.fabricContext.getEventDatagramFactory().createAcknowledgement((EventDatagram)event, withSourceData);
        }
        if (event instanceof ExceptionEventDatagram) {
            return this.fabricContext.getEventDatagramFactory().createAcknowledgement((ExceptionEventDatagram)event);
        }
        throw new Exception("Failed to create ack event for event [" + event.getClass().getSimpleName() + "], EventDatagram and ExceptionEventDatagram are allowed only.");
    }

    @Override
    public AcknowledgementEvent createAcknowledgement(String eventId) throws Exception {
        return this.fabricContext.getEventDatagramFactory().createAcknowledgement(eventId);
    }

    @Override
    public ConverterPluginManager getConverterPluginManager() {
        if (this.fabricContext instanceof RuntimeContext) {
            return ((RuntimeContext)this.fabricContext).getConverterPluginManager();
        }
        return null;
    }

    @Override
    public EventDatagramFactory getEventDatagramFactory() {
        return this.eventDatagramFactory;
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(String componentName) throws Exception {
        if (this.dataspaceAccessorProvider != null) {
            return this.dataspaceAccessorProvider.getDataspaceAccessor();
        }
        if (this.fabricContext instanceof RuntimeContext) {
            String nodeName = ModeratorUtils.extractNodeName(componentName);
            DataspaceType dataspaceType = this.getDataspaceType(componentName);
            String dataspaceName = ModeratorUtils.extractComponentNameName(componentName);
            if (dataspaceType == null && nodeName != null) {
                throw new Exception("Invalid component name specified.");
            }
            if (dataspaceType == null) {
                DataspaceComponent dataspaceComponent = ((RuntimeContext)this.fabricContext).getDataspaceManager().lookup(dataspaceName);
                if (dataspaceComponent == null) {
                    throw new Exception("Dataspace with name '" + dataspaceName + "' not found.");
                }
                dataspaceType = dataspaceComponent.getDataspaceType();
            }
            if (this.component != null && this.component.getAccessorsPool() != null) {
                return this.component.getAccessorsPool().createDataspaceAccessor(nodeName, dataspaceType, dataspaceName, this.slSession != null ? this.slSession.getUserName() : null);
            }
            return ((AbstractRuntimeContext)this.fabricContext).getSystemConnection().createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
        }
        throw new Exception("FabricContext is not RuntimeContext.");
    }

    @Override
    public ServiceAccessor createServiceAccessor(String componentName) throws Exception {
        if (this.fabricContext instanceof RuntimeContext) {
            String nodeName = ModeratorUtils.extractNodeName(componentName);
            String serviceType = ModeratorUtils.extractComponentNameType(componentName);
            String serviceName = ModeratorUtils.extractComponentNameName(componentName);
            if (serviceType == null && serviceName != null) {
                throw new Exception("Invalid component name specified.");
            }
            if (this.component != null && this.component.getAccessorsPool() != null) {
                return this.component.getAccessorsPool().createServiceAccessor(nodeName, serviceType, serviceName);
            }
            return ((AbstractRuntimeContext)this.fabricContext).getSystemConnection().createServiceAccessor(nodeName, serviceType, serviceName);
        }
        throw new Exception("FabricContext is not RuntimeContext.");
    }

    @Override
    public SLSession createSLSession(String nodeName) throws Exception {
        if (this.component != null && this.component.getAccessorsPool() != null) {
            return this.component.getAccessorsPool().createSLSession(((AbstractRuntimeContext)this.fabricContext).getSystemConnection(), nodeName);
        }
        if (this.fabricContext instanceof RuntimeContext) {
            return ((AbstractRuntimeContext)this.fabricContext).getSystemConnection().createSLSession(nodeName);
        }
        throw new Exception("FabricContext is not RuntimeContext.");
    }

    private DataspaceType getDataspaceType(String componentName) throws Exception {
        String dataspaceType = ModeratorUtils.extractComponentNameType(componentName);
        if (dataspaceType != null) {
            return DataspaceType.valueOf(dataspaceType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLSession getSLSession() throws Exception {
        if (this.slSession == null) {
            TriggerFunctionContextImpl triggerFunctionContextImpl = this;
            synchronized (triggerFunctionContextImpl) {
                if (this.slSession == null) {
                    if (this.fabricContext instanceof RuntimeContext) {
                        this.slSession = ((AbstractRuntimeContext)this.fabricContext).getSystemConnection().createSLSession();
                    } else {
                        throw new Exception("FabricContext is not RuntimeContext.");
                    }
                }
            }
        }
        return this.slSession;
    }

    public synchronized void closeSLSession() {
        if (this.slSession != null) {
            this.slSession.close();
        }
    }

    public void setExecutionWindowMs(long executionWindowMs) {
        this.executionWindowMs = executionWindowMs;
    }

    @Override
    public long getExecutionWindowMs() {
        return this.executionWindowMs;
    }

    public TriggerFunctionContextImpl setDataspaceAccessorProvider(DataspaceAccessorProvider dataspaceAccessorProvider) {
        this.dataspaceAccessorProvider = dataspaceAccessorProvider;
        return this;
    }

    public static interface DataspaceAccessorProvider {
        public DataspaceAccessor getDataspaceAccessor() throws FabricComponentAccessorException, FabricConnectionException;
    }
}

