/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.globals.GlobalVariable;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.globals.UnresolvedVariableException;
import com.streamscape.sdo.CloneableDataObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

class SysGlobals
extends CloneableDataObject
implements GlobalVariableCollection {
    private Hashtable<String, Hashtable<String, GlobalVariable>> globalVariables = new Hashtable();

    SysGlobals() {
        this.globalVariables.put("SYS", new Hashtable());
    }

    void addLiteralPool(String poolName) throws UnresolvedVariableException {
        if (this.globalVariables.containsKey(poolName)) {
            throw new UnresolvedVariableException("Pool '" + poolName + "' already exists.");
        }
        this.globalVariables.put(poolName, new Hashtable());
    }

    void removeLiteralPool(String poolName) {
        this.globalVariables.remove(poolName);
    }

    @Override
    public boolean existsLiteralPool(String poolName) {
        return this.globalVariables.containsKey(poolName);
    }

    Hashtable<String, GlobalVariable> getLiteralPool(String poolName) throws UnresolvedVariableException {
        Hashtable<String, GlobalVariable> result = this.globalVariables.get(poolName);
        if (result != null) {
            return result;
        }
        throw new UnresolvedVariableException("Pool '" + poolName + "' does not exist.");
    }

    @Override
    public List<String> listLiteralPools() {
        ArrayList<String> result = new ArrayList<String>(this.globalVariables.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> listLiteralPoolVariables(String poolName) throws UnresolvedVariableException {
        ArrayList<String> result = new ArrayList<String>(this.getLiteralPool(poolName).keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public List<GlobalVariable> getLiteralPoolVariables(String poolName) throws UnresolvedVariableException {
        ArrayList<GlobalVariable> result = new ArrayList<GlobalVariable>(this.getLiteralPool(poolName).values());
        Collections.sort(result);
        return result;
    }

    void addVariable(String poolName, String variableName) throws UnresolvedVariableException {
        Hashtable<String, GlobalVariable> pool = this.getLiteralPool(poolName);
        if (pool.containsKey(variableName)) {
            throw new UnresolvedVariableException("Variable '" + variableName + "' already exists in pool '" + poolName + "'.");
        }
        pool.put(variableName, new GlobalVariable(variableName));
    }

    void removeVariable(String poolName, String variableName) throws UnresolvedVariableException {
        this.getLiteralPool(poolName).remove(variableName);
    }

    @Override
    public String getVariable(String qualifiedName) throws UnresolvedVariableException {
        String[] nameTokens = SysGlobals.getVariableNameTokens(qualifiedName);
        return this.getVariable(nameTokens[0], nameTokens[1]);
    }

    @Override
    public String getVariable(String poolName, String variableName) throws UnresolvedVariableException {
        GlobalVariable result = this.getLiteralPool(poolName).get(variableName);
        if (result == null) {
            throw new UnresolvedVariableException("Variable '" + variableName + "' does not exist in pool '" + poolName + "'.");
        }
        return result.getValue();
    }

    void setVariable(String poolName, String variableName, String value) throws UnresolvedVariableException {
        this.getLiteralPool(poolName).put(variableName, new GlobalVariable(variableName, value));
    }

    @Override
    public boolean existsVariable(String qualifiedName) throws UnresolvedVariableException {
        String[] nameTokens = SysGlobals.getVariableNameTokens(qualifiedName);
        return this.existsVariable(nameTokens[0], nameTokens[1]);
    }

    @Override
    public boolean existsVariable(String poolName, String variableName) throws UnresolvedVariableException {
        return this.getLiteralPool(poolName).containsKey(variableName);
    }

    static String[] getVariableNameTokens(String qualifiedName) throws UnresolvedVariableException {
        String[] result = qualifiedName.split("\\.");
        if (result.length == 2) {
            return result;
        }
        throw new UnresolvedVariableException("Variable name '" + qualifiedName + "' has invalid format. Must be <poolName>.<variableName>.");
    }

    @Override
    public synchronized SysGlobals clone() {
        if (this.globalVariables != null) {
            SysGlobals result = new SysGlobals();
            for (Map.Entry<String, Hashtable<String, GlobalVariable>> poolEntry : this.globalVariables.entrySet()) {
                result.globalVariables.put(poolEntry.getKey(), new Hashtable(poolEntry.getValue()));
            }
            return result;
        }
        return (SysGlobals)super.clone();
    }

    synchronized void replace(SysGlobals other) {
        if (other != null) {
            this.globalVariables = other.globalVariables;
        }
    }

    synchronized boolean merge(SysGlobals other) {
        boolean needSave = false;
        for (Map.Entry<String, Hashtable<String, GlobalVariable>> otherPoolEntry : other.globalVariables.entrySet()) {
            String poolName = otherPoolEntry.getKey();
            if (!this.globalVariables.containsKey(poolName)) {
                this.globalVariables.put(poolName, otherPoolEntry.getValue());
                needSave = true;
                continue;
            }
            Hashtable<String, GlobalVariable> pool = this.globalVariables.get(poolName);
            for (Map.Entry<String, GlobalVariable> otherVariableEntry : otherPoolEntry.getValue().entrySet()) {
                if (pool.containsKey(otherVariableEntry.getKey())) continue;
                pool.put(otherVariableEntry.getKey(), otherVariableEntry.getValue());
                needSave = true;
            }
        }
        return needSave;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SysGlobals && Utils.equalsNullSafe(this.globalVariables, ((SysGlobals)other).globalVariables);
    }
}

