/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSerialOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ShowSerialStatsOperation
extends AbstractSerialOperation {
    public static final String NAME = "show serial stats";

    public ShowSerialStatsOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW SERIAL STATS");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR CLASS", false).addParameter(new IdentifierParameter("ClassName"))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Shows information about old class loaders and Serial Schemas that are used by the Java Serializer.");
        this.syntax.setSyntaxDescription("show serial stats                       - Shows the serial statistics for all classes in the current node.\nshow serial stats for class <ClassName> - Shows the serial statistics for the specified class in the current node.\n\nOptional parameters:\n\n   at node <NodeName> - Executes the command at the specified node.");
        this.syntax.setExamples("show serial stats\nshow serial stats for class example.Example\nshow serial stats at node Node1\nshow serial stats for class example.Example at node Node1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.getParameter("ClassName").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ShowSerialStatsOperation.createResultDescriptor(definition.className != null));
        if (definition.className != null) {
            List<Long> loaders = this.getFactory().getOldLoaderVersions(definition.className);
            List<Long> supports = this.getFactory().getOldSerialSupportVersions(definition.className);
            List<Long> schemas = this.getManager().getSerialSchemaVersions(definition.className);
            for (Long version : this.mergeValues(loaders, supports, schemas)) {
                result.addToRowSet(new Object[]{version, loaders.remove(version), supports.remove(version), schemas.remove(version)});
            }
        } else {
            Map<String, Integer> loaders = this.getFactory().getOldLoaderCount();
            Map<String, Integer> supports = this.getFactory().getOldSerialSupportCount();
            Map<String, Integer> schemas = this.getManager().getSerialSchemaCount();
            for (String className : this.mergeValues(loaders.keySet(), supports.keySet(), schemas.keySet())) {
                result.addToRowSet(new Object[]{className, this.formatSemanticType(className), this.getCount(loaders, className), this.getCount(supports, className), this.getCount(schemas, className)});
            }
        }
        return new SLResponse(result);
    }

    private <T> Set<T> mergeValues(Collection<T> ... values) {
        TreeSet result = new TreeSet();
        Arrays.asList(values).forEach(result::addAll);
        return result;
    }

    private String formatSemanticType(String className) {
        String result = ((RuntimeContext)this.callable).getSemanticTypeCache().resolveSemanticClass(className);
        return result != null ? result : "n/a";
    }

    private int getCount(Map<String, Integer> map, String className) {
        Integer result = map.remove(className);
        return result != null ? result : 0;
    }

    private boolean exists(List<Long> list, long version) {
        return list.remove(version);
    }

    private static RowMetaData createResultDescriptor(boolean forClass) {
        RowMetaData result = new RowMetaData();
        if (forClass) {
            ShowSerialStatsOperation.addColumn(result, "Serial Version");
            ShowSerialStatsOperation.addColumn(result, "Class Loader");
            ShowSerialStatsOperation.addColumn(result, "Serial Support");
            ShowSerialStatsOperation.addColumn(result, "Serial Schema");
        } else {
            ShowSerialStatsOperation.addColumn(result, "Class");
            ShowSerialStatsOperation.addColumn(result, "Semantic Type");
            ShowSerialStatsOperation.addColumn(result, "Class Loader Count");
            ShowSerialStatsOperation.addColumn(result, "Serial Support Count");
            ShowSerialStatsOperation.addColumn(result, "Serial Schema Count");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String className;

        public Definition(String nodeName, String className) {
            super(ShowSerialStatsOperation.NAME);
            this.nodeName = nodeName;
            this.className = className;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

