/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractExchangeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class ShowExchangeTokenGraphOperation
extends AbstractExchangeOperation {
    public static final String NAME = "show exchange token graph";

    public ShowExchangeTokenGraphOperation() {
        super(false, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW EXCHANGE TOKEN GRAPH");
        this.syntax.addModifier((AbstractModifier)new Modifier("SHORT", false).setSyntaxHintSpace());
        this.syntax.setDescription("Shows a graph (closed) of the synchronization token movement in the sysplex.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   short - Shows result in the short format.");
        this.syntax.addTag(OperationTag.sysplex);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("SHORT"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ShowExchangeTokenGraphOperation.createResultDescriptor(definition.isShort));
        List<Pair<String, String>> tokenRing = ((RuntimeContext)this.callable).exchange.getTokenRing();
        if (!tokenRing.isEmpty()) {
            if (definition.isShort) {
                StringBuilder str = new StringBuilder();
                for (Pair<String, String> pair : tokenRing) {
                    str.append((String)pair.first).append(" -> ");
                }
                str.append((String)tokenRing.get((int)0).first);
                result.addToRowSet(new Object[]{str.toString()});
            } else {
                int order = 0;
                for (Pair<String, String> pair : tokenRing) {
                    result.addToRowSet(new Object[]{++order, pair.first, pair.second});
                }
            }
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(boolean isShort) {
        RowMetaData result = new RowMetaData();
        if (isShort) {
            ShowExchangeTokenGraphOperation.addColumn(result, "Nodes");
        } else {
            ShowExchangeTokenGraphOperation.addColumn(result, "Order");
            ShowExchangeTokenGraphOperation.addColumn(result, "Source Node");
            ShowExchangeTokenGraphOperation.addColumn(result, "Destination Node");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean isShort;

        public Definition(boolean isShort) {
            super(ShowExchangeTokenGraphOperation.NAME);
            this.isShort = isShort;
        }

        public boolean isShort() {
            return this.isShort;
        }
    }
}

