/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.stream.Collectors;

public class SetupRoutedSessionOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "setup routed session";

    public SetupRoutedSessionOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SETUP ROUTED SESSION").addActionParameter((SyntaxParameter)new ExpressionParameter("ComponentName").setRequired(false));
        this.syntax.setDescription("Returns data for setup of routed SLANG session.");
        this.syntax.addTag(OperationTag.session);
        this.syntax.addTag("system");
        this.syntax.addTag("internal");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return false;
    }

    @Override
    public boolean isVisible(MFSession session, SLStatement statement) {
        return super.isVisible(session) && statement instanceof Definition && ((Definition)statement).isVisible;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("ComponentName") ? statement.getParameter("ComponentName").getValue() : null, false);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SLResponse result = new SLResponse();
        if (definition.componentName != null) {
            ComponentReference component2 = ((RuntimeContext)this.callable).getModerator().getFabricNode().lookupComponent(((Definition)statement).componentName);
            if (component2 != null) {
                result.setObject(new Pair<ComponentReference, RequestConsumerReference>(component2, component2.lookupRequestConsumer("sys$SessionManager")));
            }
        } else {
            result.setObject(((RuntimeContext)this.callable).getModerator().getFabricNode().getComponents(EventScope.OBSERVABLE).stream().filter(component -> component.getModel() == ComponentModel.DATASPACE || component.getModel() == ComponentModel.SERVICE).collect(Collectors.toList()));
        }
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String componentName;
        private boolean isVisible;

        Definition(String componentName, boolean isVisible) {
            super(SetupRoutedSessionOperation.NAME);
            this.componentName = componentName;
            this.isVisible = isVisible;
        }
    }
}

