/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.enums.SessionState;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.SLSessionDataImpl;

public final class SessionRequest
extends CloneableDataObject {
    static final String EVENT_ID = "e.sys.SessionRequest";
    private String clientName;
    private String accessorName;
    private String ownerName;
    private boolean isRouted;
    private String sessionName;
    private SessionState sessionState;
    private boolean isInstant;
    private String slSessionName;
    private SLSessionData slSessionData;

    public static SessionRequest createOpenRequest(String clientName, String accessorName, String ownerName, boolean isRouted, boolean isInstant, String slSessionName, SLSessionData slSessionData) {
        return new SessionRequest(clientName, accessorName, ownerName, isRouted, null, SessionState.OPEN, isInstant, slSessionName, slSessionData);
    }

    public static SessionRequest createCloseRequest(String clientName, String sessionName, boolean isInstant, String slSessionName) {
        return new SessionRequest(clientName, null, null, false, sessionName, SessionState.CLOSE, isInstant, slSessionName, null);
    }

    SessionRequest() {
    }

    SessionRequest(String clientName, String accessorName, String ownerName, boolean isRouted, String sessionName, SessionState sessionState, boolean isInstant, String slSessionName, SLSessionData slSessionData) {
        this.clientName = clientName;
        this.accessorName = accessorName;
        this.ownerName = ownerName;
        this.isRouted = isRouted;
        this.sessionName = sessionName;
        this.sessionState = sessionState;
        this.isInstant = isInstant;
        this.slSessionName = slSessionName;
        this.slSessionData = slSessionData;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getAccessorName() {
        return this.accessorName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isRouted() {
        return this.isRouted;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public boolean isInstant() {
        return this.isInstant;
    }

    public String getSLSessionName() {
        return this.slSessionName;
    }

    public SLSessionData getSLSessionData() {
        return this.slSessionData != null ? this.slSessionData : new SLSessionDataImpl();
    }

    public String toString() {
        return "clientName: " + this.clientName + ", accessorName: " + this.accessorName + ", ownerName: " + this.ownerName + ", isRouted: " + this.isRouted + ", sessionName: " + this.sessionName + ", sessionState: " + String.valueOf((Object)this.sessionState) + ", isInstant: " + this.isInstant + ", slSessionName: " + this.slSessionName + ", slSessionData: " + String.valueOf(this.slSessionData);
    }
}

