/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.DaemonServiceBlockedException;
import com.streamscape.sef.service.ServiceContextException;
import com.streamscape.sef.service.dsl.DSLProcessor;
import com.streamscape.service.osf.CancellableService;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.eim.EventIdentityPlugin;
import com.streamscape.slex.lang.DSLStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class ServicePool {
    protected int size = 0;
    protected List<Service> freeServices = null;
    protected List<Service> busyServices = null;
    protected EventIdentityPlugin defaultEIMPlugin;
    protected ThreadLocal<EventIdentityPlugin> threadLocalEventIdentityPlugin;
    protected ThreadLocal<MacroProcessor> threadLocalMacroProcessor;
    protected ThreadLocal<ImmutableEventDatagram> threadLocalEvent;
    private Service serviceForDsl = null;
    private int serviceForDslCount = 0;

    ServicePool(int size, Class<?> serviceClass, EventIdentityPlugin eimPlugin) throws ServiceContextException {
        this.size = size;
        this.freeServices = new ArrayList<Service>();
        this.busyServices = new ArrayList<Service>();
        this.defaultEIMPlugin = eimPlugin;
        this.threadLocalEventIdentityPlugin = new ThreadLocal();
        this.threadLocalMacroProcessor = new ThreadLocal();
        this.threadLocalEvent = new ThreadLocal();
        try {
            for (int i = 0; i < size; ++i) {
                Service service = (Service)serviceClass.newInstance();
                this.freeServices.add(service);
                if (!(service instanceof AbstractDaemonService)) continue;
                ((AbstractDaemonService)service).setThreadLocalEventIdentityPlugin(this.threadLocalEventIdentityPlugin, this.defaultEIMPlugin);
            }
        }
        catch (Exception exception) {
            throw new ServiceContextException(6065, "Initialization of Service class instance failed.", exception);
        }
    }

    public synchronized boolean isInPool(Service srv) {
        return this.freeServices.stream().anyMatch(service -> service == srv) || this.busyServices.stream().anyMatch(service -> service == srv);
    }

    public Service borrowService() {
        return this.borrowService(null);
    }

    public synchronized Service borrowService(Long timeout) {
        Service result = null;
        while (result == null) {
            if (this.freeServices.size() > 0) {
                result = this.freeServices.remove(0);
            }
            if (result != null) continue;
            if (timeout == null || timeout > 0L) {
                Trace.logDebug(ServiceContextImpl.class, "Waiting for service to complete previous request(s)...");
                try {
                    if (timeout == null) {
                        this.wait();
                    } else {
                        this.wait(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (timeout == null) continue;
        }
        if (result != null) {
            this.busyServices.add(result);
            if (this.defaultEIMPlugin != null) {
                this.threadLocalEventIdentityPlugin.set(this.defaultEIMPlugin.clone());
            }
            this.threadLocalMacroProcessor.set(new MacroProcessor());
        }
        return result;
    }

    public synchronized void releaseService(Service service) {
        this.busyServices.remove(service);
        this.freeServices.add(service);
        this.notifyAll();
        this.threadLocalEventIdentityPlugin.remove();
        this.threadLocalMacroProcessor.remove();
        this.releaseEvent();
    }

    public EventIdentityPlugin getCurrentEIM() {
        return this.threadLocalEventIdentityPlugin.get();
    }

    public EventIdentityPlugin getDefaultEIM() {
        if (this.defaultEIMPlugin == null) {
            return null;
        }
        return this.defaultEIMPlugin.clone();
    }

    public MacroProcessor getMacroProcessor() {
        MacroProcessor result = this.threadLocalMacroProcessor.get();
        if (result == null) {
            result = new MacroProcessor();
        }
        return result;
    }

    public void setEvent(ImmutableEventDatagram event) {
        this.threadLocalEvent.set(event);
    }

    ImmutableEventDatagram getEvent() {
        return this.threadLocalEvent.get();
    }

    void releaseEvent() {
        this.threadLocalEvent.remove();
    }

    void doOperation(ServicePoolOperation operation) throws ServiceContextException {
        this.doOperation(operation, null);
    }

    synchronized void doOperation(ServicePoolOperation operation, Long timeout) throws ServiceContextException {
        Service[] services = new Service[this.size];
        try {
            block15: for (int i = 0; i < this.size; ++i) {
                Service service = this.borrowService(timeout);
                if (service == null) continue;
                services[i] = service;
                switch (operation.ordinal()) {
                    case 0: {
                        service.init();
                        continue block15;
                    }
                    case 1: {
                        service.destroy();
                        continue block15;
                    }
                    case 2: {
                        service.start();
                        continue block15;
                    }
                    case 3: {
                        service.stop();
                        continue block15;
                    }
                    case 4: {
                        service.suspend();
                        continue block15;
                    }
                    case 5: {
                        service.resume();
                    }
                }
            }
        }
        catch (ServiceFrameworkException exception) {
            throw new ServiceContextException(exception.getErrorCode(), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ServiceContextException(6002, String.valueOf((Object)operation) + " of service failed.", exception);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            throw new ServiceContextException(6002, String.valueOf((Object)operation) + " of service failed.", exception);
        }
        finally {
            for (int i = 0; i < this.size; ++i) {
                if (services[i] == null) continue;
                this.releaseService(services[i]);
            }
        }
    }

    synchronized void cancelOperation() throws ServiceContextException {
        try {
            int counter = 0;
            for (Service service : this.busyServices) {
                if (!(service instanceof CancellableService)) continue;
                Trace.logDebug(this, "Cancelling service instance " + ++counter + "...");
                ((CancellableService)service).cancel();
                Trace.logDebug(this, "Cancel request is sent to service instance " + counter + ".");
            }
        }
        catch (Exception exception) {
            throw new ServiceContextException(6002, "Canceling of service failed.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SLResponse onStatement(DSLStatement statement) throws Exception {
        int i;
        Service[] services = new Service[this.size];
        SLResponse response = null;
        try {
            for (i = 0; i < this.size; ++i) {
                Service service;
                services[i] = service = this.borrowService(null);
                if (!(services[i] instanceof DSLProcessor)) {
                    throw new Exception("Service does not implement interface DSLProcessor.");
                }
                response = ((DSLProcessor)((Object)services[i])).onStatement(statement);
            }
        }
        finally {
            for (i = 0; i < this.size; ++i) {
                if (services[i] == null) continue;
                this.releaseService(services[i]);
            }
        }
        return response;
    }

    public void setCurrentEIM(EventIdentityPlugin eim) {
        this.threadLocalEventIdentityPlugin.set(eim);
    }

    public void releaseCurrentEIM() {
        this.threadLocalEventIdentityPlugin.remove();
    }

    public synchronized void checkServiceIsNotBlocked() throws DaemonServiceBlockedException {
        for (Service service : this.freeServices) {
            if (!(service instanceof AbstractDaemonService)) continue;
            ((AbstractDaemonService)service).checkServiceIsNotBlocked();
        }
        for (Service service : this.busyServices) {
            if (!(service instanceof AbstractDaemonService)) continue;
            ((AbstractDaemonService)service).checkServiceIsNotBlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLResponse invokeForDsl(Function<Service, SLResponse> callback) throws Exception {
        if (this.size == 0) {
            throw new Exception("Service pool is not initialized.");
        }
        Service service = this.borrowServiceFroDsl();
        try {
            SLResponse sLResponse = callback.apply(service);
            return sLResponse;
        }
        finally {
            this.releaseServiceForDsl(service);
        }
    }

    private synchronized Service borrowServiceFroDsl() {
        if (this.serviceForDsl != null) {
            ++this.serviceForDslCount;
            return this.serviceForDsl;
        }
        this.serviceForDsl = this.borrowService();
        ++this.serviceForDslCount;
        return this.serviceForDsl;
    }

    private synchronized void releaseServiceForDsl(Service service) {
        --this.serviceForDslCount;
        if (this.serviceForDslCount == 0) {
            this.serviceForDsl = null;
            this.releaseService(service);
        }
    }

    public synchronized String getVersion() {
        if (this.freeServices.size() > 0) {
            return this.freeServices.get(0).getVersion();
        }
        if (this.busyServices.size() > 0) {
            return this.busyServices.get(0).getVersion();
        }
        return null;
    }

    static enum ServicePoolOperation {
        INIT,
        DESTROY,
        START,
        STOP,
        SUSPEND,
        RESUME;

    }
}

