/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.ds.replication.MessagesExpirationCache;
import com.streamscape.lib.concurrent.ExecutedTask;
import com.streamscape.lib.concurrent.TaskExecutor;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.advisory.DaemonServiceBlockedAdvisory;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.IllegalComponentStateException;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.service.DaemonServiceBlockedException;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceLogger;
import com.streamscape.sef.service.ServiceLoggerImpl;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceManagerException;
import com.streamscape.sef.service.ServiceManifest;
import com.streamscape.sef.service.ServiceManifestFactory;
import com.streamscape.sef.service.dsl.DSLSyntaxFactoryManager;
import com.streamscape.sef.utils.Utils;
import com.streamscape.service.osf.config.EventTriggerData;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class ServiceManagerImpl
implements ServiceManager {
    protected RuntimeContext context;
    protected ServiceManifestFactory manifestFactory;
    protected ServiceManifest manifest;
    protected boolean persistent = false;
    protected Map<String, ServiceContextImpl> services;
    protected DSLSyntaxFactoryManager syntaxFactoryManager;
    private Map<String, Logger> loggers = Collections.synchronizedMap(new HashMap());
    private Logger defaultLogger;
    private ServiceMonitor serviceMonitor;
    private static final String CREDENTIALS_SEP = ":";
    private static final byte[] KEY = new byte[]{47, 21, -39, -122, 4, -39, 126, -74, 68, -25, -98, -115, 2, 90, -82, -75};

    protected ServiceManagerImpl(RuntimeContext context, Logger defaultLogger) {
        this.context = context;
        this.defaultLogger = defaultLogger;
    }

    protected void init() {
        Trace.logInfo(ServiceManagerImpl.class, "Initializing Service Manager...");
        this.initServiceManifest();
        this.initDSLSyntaxFactoryManager();
        this.services = new ConcurrentHashMap<String, ServiceContextImpl>();
        this.persistent = this.manifest.isManifestUsed();
        if (!this.persistent) {
            this.manifest.clear();
            this.manifestFactory.destroy();
        }
        this.initServiceContexts();
        Trace.logInfo(ServiceManagerImpl.class, "Service Manager initialized.");
    }

    protected void destroy() {
        Trace.logInfo(ServiceManagerImpl.class, "Destroying Service Manager...");
        this.destroyServiceContexts();
        if (this.manifest != null) {
            this.manifest = null;
            this.manifestFactory.destroy();
        }
        Trace.logInfo(ServiceManagerImpl.class, "Service Manager destroyed.");
    }

    protected void initServiceManifest() {
        try {
            Trace.logDebug(ServiceManagerImpl.class, "Loading Service Manager configuration...");
            this.manifestFactory = new ServiceManifestFactory();
            this.manifest = (ServiceManifest)this.manifestFactory.create();
            Trace.logDebug(ServiceManagerImpl.class, "Service Manager configuration loaded.");
        }
        catch (Exception exception) {
            Trace.logException(ServiceManagerImpl.class, exception, true);
            throw new RuntimeException("Initialization of Service Manifest failed.", exception);
        }
    }

    protected void initDSLSyntaxFactoryManager() {
        try {
            Trace.logDebug(ServiceManagerImpl.class, "Loading DSL Syntax Factory Manager configuration...");
            this.syntaxFactoryManager = new DSLSyntaxFactoryManager();
            Trace.logDebug(ServiceManagerImpl.class, "Loading DSL Syntax Factory Manager configuration loaded.");
        }
        catch (Exception exception) {
            Trace.logException(ServiceManagerImpl.class, exception, true);
            throw new RuntimeException("Initialization of DSL Syntax Factory Manager failed.", exception);
        }
    }

    @Override
    public DSLSyntaxFactoryManager getDSLSyntaxFactoryManager() {
        return this.syntaxFactoryManager;
    }

    private void initServiceContexts() {
        if (this.manifest != null) {
            for (ServiceDescriptor service : this.manifest.services()) {
                try {
                    this.loadServiceContext(service.getFullName());
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Loading service context '" + service.getFullName() + "' failed.");
                }
            }
        }
    }

    private void destroyServiceContexts() {
        if (this.manifest != null) {
            for (ServiceDescriptor service : this.manifest.services()) {
                try {
                    this.unloadServiceContext(service.getFullName());
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    Trace.logError(this, "Destroying service context '" + service.getFullName() + "' failed.");
                }
            }
        }
    }

    protected synchronized void start() throws ServiceManagerException {
        if (this.persistent) {
            int numberOfServices;
            Trace.logInfo(ServiceManagerImpl.class, "Starting Service Manager...");
            if (this.serviceMonitor == null) {
                try {
                    this.serviceMonitor = new ServiceMonitor();
                    this.serviceMonitor.start();
                }
                catch (FabricException exception) {
                    this.logError("Service monitor start failed.");
                    this.logException(exception);
                    if (this.serviceMonitor != null) {
                        this.serviceMonitor.stop();
                    }
                    this.serviceMonitor = null;
                }
            }
            try {
                if (this.context.isDataspaceBound() && !this.manifest.isStartOnSuspectDataspace() && this.context.getDataspaceManager().getStoreState() == DataspaceStoreState.RECOVERY_FAILED) {
                    this.logError("Dataspace store recovery failed. Service Manager start cancelled.");
                    return;
                }
            }
            catch (Exception exception) {
                throw new ServiceManagerException(6076, (Throwable)exception);
            }
            List<ServiceDescriptor> servicesToStart = new ArrayList<ServiceDescriptor>();
            for (ServiceDescriptor service : this.manifest.services()) {
                if (!service.isAutostart()) continue;
                servicesToStart.add(service);
            }
            do {
                numberOfServices = servicesToStart.size();
            } while (!(servicesToStart = this.startServices(servicesToStart)).isEmpty() && numberOfServices != servicesToStart.size());
            if (!servicesToStart.isEmpty()) {
                for (ServiceDescriptor service : servicesToStart) {
                    this.logError("Service '" + service.getFullName() + "' was not started due to unresolved dependencies.");
                }
            }
            Trace.logInfo(ServiceManagerImpl.class, "Service Manager started.");
        }
    }

    protected List<ServiceDescriptor> startServices(List<ServiceDescriptor> serviceList) throws ServiceManagerException {
        ArrayList<ServiceDescriptor> unresolvedServices = new ArrayList<ServiceDescriptor>();
        for (ServiceDescriptor service : serviceList) {
            if (this.checkServiceDependencies(service)) {
                this.doStartService(service, true);
                continue;
            }
            unresolvedServices.add(service);
        }
        return unresolvedServices;
    }

    protected synchronized void stop() {
        Trace.logInfo(ServiceManagerImpl.class, "Stopping Service Manager...");
        if (this.serviceMonitor != null) {
            try {
                this.serviceMonitor.stop(1000L);
            }
            catch (Exception exception) {
                this.logError("Service monitor stop failed.");
                this.logException(exception);
            }
            this.serviceMonitor = null;
        }
        List<ServiceDescriptor> allServices = this.manifest.services();
        for (int i = allServices.size() - 1; i >= 0; --i) {
            ServiceDescriptor service = allServices.get(i);
            try {
                ServiceContextImpl serviceContext = this.getServiceContext(service);
                if (serviceContext == null || !serviceContext.isRunning()) continue;
                this.stopService(service.getFullName());
                continue;
            }
            catch (Exception exception) {
                this.logException(exception);
                this.logError("Stopping service '" + service.getFullName() + "' failed.");
            }
        }
        Trace.logInfo(ServiceManagerImpl.class, "Service Manager stopped.");
    }

    protected boolean checkServiceDependencies(ServiceDescriptor service) {
        return service.getDependencies() == null || service.getDependencies().isEmpty() || service.getDependencies().stream().map(dependency -> this.services.get(dependency)).noneMatch(serviceContext -> serviceContext == null || serviceContext.getState() != ComponentState.STARTED);
    }

    @Override
    public synchronized void registerService(ServiceDescriptor service) throws ServiceManagerException {
        this.registerService(this.manifest.services().size() + 1, service);
    }

    @Override
    public synchronized void registerService(int position, ServiceDescriptor service) throws ServiceManagerException {
        if (this.isServiceRegistered(service.getFullName())) {
            throw new ServiceManagerException(6071, "Service '" + service.getFullName() + "' is already registered.");
        }
        RepositoryAccessor accessor = this.context.getRepositoryAccessor();
        try {
            if (!accessor.existsServiceConfiguration(service.getName(), service.getType())) {
                throw new ServiceManagerException(6064, "SCO does not exist for specified '" + service.getFullName() + "' service.");
            }
        }
        catch (Exception exception) {
            throw new ServiceManagerException(6025, "Registering service '" + service.getFullName() + "' failed.", exception);
        }
        if (service.getDependencies() != null) {
            for (String dependency : service.getDependencies()) {
                if (this.manifest.existsService(dependency)) continue;
                throw new ServiceManagerException(6067, "Dependency '" + dependency + "' does not exist.");
            }
        }
        this.manifest.addServiceAt(position, service);
        this.updateManifest();
        try {
            this.createServiceContext(service);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            service.setLastError(Utils.formatException(exception, "\n"));
            throw new ServiceManagerException(6065, "Creating Service Context for '" + service.getFullName() + "' service failed.", exception);
        }
    }

    @Override
    public synchronized void runServiceAs(String serviceName, String userName, String password) throws ServiceManagerException {
        ServiceDescriptor service = this.getServiceDescriptor(serviceName);
        try {
            if (!this.context.securityManager.existsUser(userName)) {
                throw new ServiceManagerException(6098, "User '" + userName + "' does not exist.");
            }
            this.context.securityManagerImpl.authenticate(userName, password);
            String credentialsString = serviceName + CREDENTIALS_SEP + userName;
            byte[] credentials = CryptoUtils.encrypt(credentialsString.getBytes(), KEY);
            service.setCredentials(credentials);
            this.updateManifest();
        }
        catch (SecurityManagerException exception) {
            throw new ServiceManagerException(exception.getErrorCode(), exception.getErrorMessage());
        }
        catch (GeneralSecurityException exception) {
            throw new ServiceManagerException(6072, "Encryption of user credentials failed.", exception);
        }
    }

    @Override
    public synchronized void setServiceSequence(String serviceName, int sequence) throws ServiceManagerException {
        this.manifest.setServiceSequence(serviceName, sequence);
        this.updateManifest();
    }

    @Override
    public synchronized void setServiceStartTimeout(int timeout) {
        this.manifest.setStartTimeout(timeout);
        this.updateManifest();
    }

    @Override
    public int getServiceStartTimeout() {
        return this.manifest.getStartTimeout();
    }

    @Override
    public synchronized void setAbortOnFailure(boolean value) {
        this.manifest.setAbortOnFailure(value);
        this.updateManifest();
    }

    @Override
    public boolean isAbortOnFailure() {
        return this.manifest.isAbortOnFailure();
    }

    @Override
    public synchronized int getServiceSequence(String serviceName) throws ServiceManagerException {
        int sequence = this.manifest.getServiceSequence(serviceName);
        if (sequence == -1) {
            this.throwServiceNotExists(serviceName);
        }
        return sequence;
    }

    @Override
    public boolean isServiceRegistered(String name) {
        return this.manifest.existsService(name);
    }

    @Override
    public synchronized void enableManifest(boolean enable) throws ServiceManagerException {
        try {
            if (!this.persistent && enable) {
                ServiceManifest repositoryManifest = (ServiceManifest)this.manifestFactory.create();
                this.manifest.services().stream().filter(service -> !repositoryManifest.existsService(service.getFullName())).forEach(repositoryManifest::addService);
                this.manifest = repositoryManifest;
                this.manifest.useManifest(true);
                this.persistent = true;
                this.updateManifest();
            } else if (this.persistent && !enable) {
                this.manifest.useManifest(false);
                this.updateManifest();
                this.manifestFactory.destroy();
                this.persistent = false;
            }
        }
        catch (FabricException exception) {
            throw new ServiceManagerException(6011, (Throwable)exception);
        }
    }

    @Override
    public synchronized ServiceDescriptor getService(String fullName) {
        ServiceDescriptor descriptor = this.manifest.getService(fullName);
        if (descriptor != null) {
            return descriptor.clone();
        }
        return null;
    }

    @Override
    public List<String> listRunningServices() {
        return this.services.entrySet().stream().filter(entry -> ((ServiceContextImpl)entry.getValue()).isRunning()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<String> listLoadedServices() {
        return new ArrayList<String>(this.services.keySet());
    }

    @Override
    public boolean isServiceLoaded(String fullName) {
        return this.services.containsKey(fullName);
    }

    @Override
    public synchronized void setServiceLogLevel(String serviceName, Trace.Level level) throws ServiceManagerException {
        Logger logger;
        ServiceDescriptor service = this.getServiceDescriptor(serviceName);
        service.setLogLevel(level);
        this.updateManifest();
        ServiceContextImpl serviceContext = this.getServiceContext(service);
        if (serviceContext != null && (logger = serviceContext.getLogger()) instanceof ServiceLogger) {
            ((ServiceLogger)logger).setLogLevel(level);
        }
    }

    @Override
    public synchronized void setServiceLogBroadcast(String serviceName, boolean broadcast) throws ServiceManagerException {
        Logger logger;
        ServiceDescriptor service = this.getServiceDescriptor(serviceName);
        service.setLogBroadcast(broadcast);
        this.updateManifest();
        ServiceContextImpl serviceContext = this.getServiceContext(service);
        if (serviceContext != null && (logger = serviceContext.getLogger()) instanceof ServiceLogger) {
            ((ServiceLogger)logger).setBroadcast(broadcast);
        }
    }

    @Override
    public synchronized List<String> listRegisteredServices() {
        return this.manifest.services().stream().map(ServiceDescriptor::getFullName).collect(Collectors.toList());
    }

    @Override
    public synchronized void unregisterService(String fullName) throws ServiceManagerException {
        ServiceDescriptor service = this.manifest.getService(fullName);
        if (service != null) {
            try {
                Pair<String, String> name = ServiceManagerImpl.getServiceTypeAndName(fullName);
                try {
                    RepositoryAccessor accessor = this.context.getRepositoryAccessor();
                    if (accessor.existsServiceConfiguration((String)name.second, (String)name.first)) {
                        ServiceConfigurationObject sco = accessor.loadServiceConfiguration((String)name.second, (String)name.first);
                        for (String triggerName : sco.listEventTriggers()) {
                            EventTriggerData triggerData = sco.getEventTriggerData(triggerName);
                            if (triggerData == null) continue;
                            throw new ServiceManagerException(6075, "Service '" + fullName + "' is actual dependent on event trigger '" + triggerName + "' and cannot be unregistered.");
                        }
                    }
                    this.unloadServiceContext(fullName);
                    for (ServiceDescriptor otherService : this.manifest.services()) {
                        if (otherService.getDependencies() == null || !otherService.getDependencies().contains(fullName)) continue;
                        throw new ServiceManagerException(6075, "Service '" + fullName + "' is actual dependency of " + otherService.getFullName() + "' service and cannot be unregistered.");
                    }
                }
                catch (Exception exception) {
                    throw this.processException(6025, "Unegistering service '" + fullName + "' failed.", exception, service);
                }
                this.manifest.removeService((String)name.first, (String)name.second);
                this.updateManifest();
                this.clearLastError(null, service);
            }
            catch (FabricException exception) {
                throw new ServiceManagerException(6006, exception.getMessage());
            }
        }
    }

    @Override
    public synchronized void startService(String fullName) throws ServiceManagerException {
        ServiceDescriptor service = this.getServiceDescriptor(fullName);
        if (!this.checkServiceDependencies(service)) {
            throw this.processException("Starting service '" + service.getFullName() + "' failed.", new ServiceManagerException(6076, "Service dependencies are not started."), service);
        }
        this.doStartService(service, false);
    }

    @Override
    public synchronized void startService(String fullName, boolean force) throws ServiceManagerException {
        ServiceDescriptor service = this.getServiceDescriptor(fullName);
        if (this.checkServiceDependencies(service)) {
            this.doStartService(service, false);
        } else if (force) {
            this.doStartService(service, false);
        } else {
            throw this.processException("Starting service '" + service.getFullName() + "' failed.", new ServiceManagerException(6076, "Service dependencies are not started."), service);
        }
    }

    protected void doStartService(final ServiceDescriptor service, boolean atNodeStartup) throws ServiceManagerException {
        ServiceContextImpl serviceContext = this.getServiceContext(service);
        if (serviceContext != null) {
            if (serviceContext.getState() == ComponentState.SUSPECT) {
                throw new ServiceManagerException(6131, "Service '" + service.getFullName() + "' is in suspect state. Stop it first.");
            }
            if (serviceContext.isRunning()) {
                throw new ServiceManagerException(6079, "Service '" + service.getFullName() + "' is already started.");
            }
        }
        final boolean isOutsync = serviceContext != null && serviceContext.getState() == ComponentState.OUTSYNC;
        try {
            class ServiceStartTask
            implements ExecutedTask<Boolean, ServiceDescriptor> {
                ServiceStartTask() {
                }

                @Override
                public Boolean execute(ServiceDescriptor service2) throws Exception {
                    ServiceContextImpl serviceContext = ServiceManagerImpl.this.getServiceContext(service2);
                    if (serviceContext == null) {
                        serviceContext = ServiceManagerImpl.this.createServiceContext(service2);
                    } else if (isOutsync) {
                        ServiceManagerImpl.this.reloadServiceContext(service2.getFullName());
                        serviceContext = ServiceManagerImpl.this.getServiceContext(service2);
                    }
                    ServiceManagerImpl.this.authenticate(service2, serviceContext);
                    serviceContext.start();
                    ServiceManagerImpl.this.clearLastError(serviceContext, service2);
                    return true;
                }

                @Override
                public String getType() {
                    return "SVC";
                }

                @Override
                public String getName() {
                    return "Service.Manager:Bootstrap";
                }

                @Override
                public String getDescription() {
                    return "Initializes and starts '" + service.getFullName() + "' service.";
                }
            }
            new TaskExecutor<Boolean, ServiceDescriptor>().execute(new ServiceStartTask(), service, this.manifest.getStartTimeout());
        }
        catch (Throwable exception) {
            if (!atNodeStartup || this.manifest.isAbortOnFailure()) {
                throw this.processException("Starting service '" + service.getFullName() + "' failed.", exception, service);
            }
            this.logException(exception);
            this.logError("Starting service '" + service.getFullName() + "' failed. Skipping...");
            this.processException("Starting service '" + service.getFullName() + "' failed.", exception, service);
        }
    }

    @Override
    public void stopService(String fullName) throws ServiceManagerException {
        this.doStopService(fullName, false);
    }

    synchronized void doStopService(String fullName, boolean ignoreOutsync) throws ServiceManagerException {
        ServiceContextImpl service = this.services.get(fullName);
        if (service != null) {
            if (!service.isRunning()) {
                throw new ServiceManagerException(6078, "Service '" + fullName + "' is not started.");
            }
            boolean isOutsync = service.getState() == ComponentState.OUTSYNC;
            try {
                service.stop();
                if (!ignoreOutsync && isOutsync) {
                    this.reloadServiceContext(fullName);
                }
                this.clearLastError(service, service.descriptor);
            }
            catch (Throwable exception) {
                throw this.processException("Stopping service '" + fullName + "' failed.", exception, service.descriptor);
            }
        } else {
            this.throwServiceNotExists(fullName);
        }
    }

    private void reloadServiceContext(String fullName) throws ServiceManagerException {
        this.unloadServiceContext(fullName);
        this.loadServiceContext(fullName);
    }

    @Override
    public synchronized void loadServiceContext(String fullName) throws ServiceManagerException {
        ServiceDescriptor service = this.getServiceDescriptor(fullName);
        if (this.getServiceContext(service) == null) {
            try {
                this.clearLastError(this.createServiceContext(service), service);
            }
            catch (Throwable exception) {
                throw this.processException("Loading service '" + fullName + "' failed.", exception, service);
            }
        } else {
            throw new ServiceManagerException(6002, "Service '" + fullName + "' already loaded.");
        }
    }

    @Override
    public synchronized void unloadServiceContext(String fullName) throws ServiceManagerException {
        ServiceDescriptor service = this.getServiceDescriptor(fullName);
        if (service != null) {
            try {
                ServiceContextImpl serviceContext = this.services.get(fullName);
                if (serviceContext != null) {
                    if (serviceContext.isRunning()) {
                        this.doStopService(fullName, true);
                    }
                    serviceContext.destroy();
                    this.services.remove(fullName);
                    this.clearLastError(serviceContext, service);
                }
            }
            catch (Throwable exception) {
                throw this.processException("Unloading service '" + fullName + "' failed.", exception, service);
            }
        }
    }

    private ServiceManagerException processException(int errorCode, String errorMessage, Throwable cause, ServiceDescriptor service) {
        ServiceManagerException result = new ServiceManagerException(errorCode, errorMessage, cause);
        if (service != null) {
            service.setLastError(Utils.formatException(result, "\n"));
        }
        return result;
    }

    private ServiceManagerException processException(String errorMessage, Throwable cause, ServiceDescriptor service) {
        return this.processException(6002, errorMessage, cause, service);
    }

    private void clearLastError(ServiceContextImpl serviceContext, ServiceDescriptor service) {
        if (serviceContext == null || serviceContext.getState() != ComponentState.PENDING && serviceContext.getState() != ComponentState.SUSPECT) {
            service.setLastError(null);
        }
    }

    @Override
    public boolean isServiceRunning(String fullName) {
        ServiceContextImpl serviceContext = this.services.get(fullName);
        return serviceContext != null && serviceContext.isRunning();
    }

    @Override
    public synchronized void resumeService(String fullName) throws ServiceManagerException {
        ServiceContextImpl serviceContext = this.services.get(fullName);
        try {
            if (serviceContext == null || serviceContext.getState() != ComponentState.SUSPENDED) {
                throw new ServiceManagerException(6077, "Service '" + fullName + "' is not suspended.");
            }
            serviceContext.resume();
        }
        catch (IllegalComponentStateException exception) {
            throw this.processException("Resuming service '" + fullName + "' failed.", exception, serviceContext.descriptor);
        }
    }

    @Override
    public synchronized void suspendService(String fullName) throws ServiceManagerException {
        ServiceContextImpl serviceContext = this.services.get(fullName);
        try {
            if (serviceContext == null || !serviceContext.isRunning()) {
                throw new ServiceManagerException(6078, "Service '" + fullName + "' is not started.");
            }
            serviceContext.suspend();
        }
        catch (IllegalComponentStateException exception) {
            throw this.processException("Suspending service '" + fullName + "' failed.", exception, serviceContext.descriptor);
        }
    }

    @Override
    public synchronized void updateService(ServiceDescriptor descriptor) throws ServiceManagerException {
        if (!this.manifest.removeService(descriptor.getType(), descriptor.getName())) {
            this.throwServiceNotExists(descriptor.getType() + "." + descriptor.getName());
        }
        this.manifest.addService(descriptor);
        this.updateManifest();
    }

    @Override
    public ComponentState getServiceState(String serviceName) {
        ServiceContextImpl serviceContext = this.services.get(serviceName);
        if (serviceContext != null) {
            return serviceContext.getState();
        }
        return null;
    }

    @Override
    public synchronized void setServiceLogger(String serviceName, Logger logger) {
        ServiceContextImpl serviceContext = this.services.get(serviceName);
        this.loggers.put(serviceName, logger);
        if (serviceContext != null) {
            serviceContext.setLogger(logger);
        }
    }

    private static Pair<String, String> getServiceTypeAndName(String fullServiceName) throws FabricException {
        StringTokenizer tokenizer = new StringTokenizer(fullServiceName, ".", false);
        Utils.check(tokenizer.countTokens() == 2, "Full service name has wrong format.");
        return new Pair<String, String>(tokenizer.nextToken(), tokenizer.nextToken());
    }

    private Pair<String, String> resolveUserFromCredentials(byte[] data) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(new String(CryptoUtils.decrypt(data, KEY)), CREDENTIALS_SEP);
        if (tokenizer.countTokens() != 2) {
            throw new ServiceManagerException(6074, "User credentials corrupted.");
        }
        return new Pair<String, String>(tokenizer.nextToken(), tokenizer.nextToken());
    }

    protected void updateManifest() {
        if (this.persistent) {
            this.manifest.touch();
            this.manifestFactory.updateObject(this.manifest);
        }
    }

    protected ServiceContextImpl createServiceContext(ServiceDescriptor service) throws Exception {
        ServiceContextImpl serviceContext = new ServiceContextImpl(service, this);
        Logger logger = this.loggers.get(service.getFullName());
        if (logger == null) {
            if (this.defaultLogger != null) {
                logger = this.defaultLogger;
            } else {
                logger = new ServiceLoggerImpl(service.getFullName(), service.getLogLevel(), this.context.getNodeTimezone());
                ((ServiceLogger)logger).setBroadcast(service.getLogBroadcast());
            }
        }
        serviceContext.setLogger(logger);
        try {
            serviceContext.init();
        }
        catch (Exception exception) {
            serviceContext.destroy();
            throw exception;
        }
        this.services.put(service.getFullName(), serviceContext);
        return serviceContext;
    }

    protected ServiceContextImpl getServiceContext(ServiceDescriptor service) {
        return this.services.get(service.getFullName());
    }

    private ServiceDescriptor getServiceDescriptor(String serviceName) throws ServiceManagerException {
        ServiceDescriptor service = this.manifest.getService(serviceName);
        if (service == null) {
            this.throwServiceNotExists(serviceName);
        }
        return service;
    }

    void authenticate(ServiceDescriptor service, ServiceContextImpl serviceContext) throws Exception {
        User user = this.getUser(service, serviceContext);
        if (user != null) {
            serviceContext.authenticate(user);
        }
    }

    private User getUser(ServiceDescriptor service, ServiceContextImpl serviceContext) throws Exception {
        if (this.context.isSecurityEnabled()) {
            SecurityManagerImpl securityManager = this.context.securityManagerImpl;
            if (service.getCredentials() != null) {
                try {
                    Pair<String, String> credentials = this.resolveUserFromCredentials(service.getCredentials());
                    if (!service.getFullName().equals(credentials.first) || !securityManager.existsUser((String)credentials.second)) {
                        throw new ServiceManagerException(6074, "User credentials corrupted.");
                    }
                    return securityManager.lookupUser((String)credentials.second);
                }
                catch (GeneralSecurityException exception) {
                    throw new ServiceManagerException(6073, "Decryption of user credentials failed.", exception);
                }
            }
            return securityManager.getRuntimeUser();
        }
        return null;
    }

    private void throwServiceNotExists(String serviceName) throws ServiceManagerException {
        throw new ServiceManagerException(6070, "Service '" + serviceName + "' is not registered.");
    }

    void logException(Throwable exception) {
        Trace.logException(this, exception, false);
    }

    void logError(String message) {
        Trace.logError(this, message);
    }

    void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    private class ServiceMonitor
    extends MonitorWorker {
        static final long CHECK_INTERVAL = 30000L;
        static final long REPORT_INTERVAL = 300000L;
        private MessagesExpirationCache advisoriesExpirationCache;

        protected ServiceMonitor() throws FabricException {
            super("SVC:ServiceMonitor", "Monitors locking state of daemon services.", 30000L);
            this.advisoriesExpirationCache = new MessagesExpirationCache(300000L, 600000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            ArrayList<DaemonServiceBlockedAdvisory> advisories = new ArrayList<DaemonServiceBlockedAdvisory>();
            ServiceManagerImpl serviceManagerImpl = ServiceManagerImpl.this;
            synchronized (serviceManagerImpl) {
                for (ServiceContextImpl serviceContext : ServiceManagerImpl.this.services.values()) {
                    try {
                        serviceContext.checkServiceIsNotBlocked();
                    }
                    catch (DaemonServiceBlockedException exception) {
                        advisories.add(new DaemonServiceBlockedAdvisory(serviceContext.getRuntimeContextName(), serviceContext.getType(), serviceContext.getName(), exception.getIterationStartTime(), exception.getPassiveIterationInterval(), exception.getMaxIterationWorkTime(), exception.getCurrentTime()));
                    }
                }
            }
            for (DaemonServiceBlockedAdvisory advisory : advisories) {
                try {
                    if (this.advisoriesExpirationCache.addMessage(new DaemonServiceBlockedAdvisoryMessage(this, advisory)) == null) continue;
                    ServiceManagerImpl.this.context.getSystemConnection().raiseSystemAdvisory(advisory, EventScope.GLOBAL);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Sending Daemon Service Blocked Advisory failed.");
                    Trace.logException(this, exception, true);
                }
            }
            this.advisoriesExpirationCache.cleanup();
        }

        class DaemonServiceBlockedAdvisoryMessage
        implements MessagesExpirationCache.Message {
            private final String message;

            public DaemonServiceBlockedAdvisoryMessage(ServiceMonitor this$1, DaemonServiceBlockedAdvisory advisory) {
                this.message = advisory.getServiceType() + "." + advisory.getServiceName();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DaemonServiceBlockedAdvisoryMessage)) {
                    return false;
                }
                DaemonServiceBlockedAdvisoryMessage that = (DaemonServiceBlockedAdvisoryMessage)o;
                return Objects.equals(this.message, that.message);
            }

            public int hashCode() {
                return Objects.hash(this.message);
            }
        }
    }
}

