/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.dispatcher.AbstractEventTrigger;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.EventTriggerSyntaxStore;
import com.streamscape.sef.dispatcher.ServiceEventTriggerManager;
import com.streamscape.sef.dispatcher.SourceEventFlowImpl;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.evtrigger.function.TriggerScript;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.service.mf.impl.CreateEventTriggerOperationImpl;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.tools.parser.AbstractParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class ServiceEventTriggersCache {
    private ServiceEventTriggerManager manager;
    private Map<String, EventTriggerDefinition> definitions = new HashMap<String, EventTriggerDefinition>();
    private Map<String, AbstractEventTrigger> triggers = new HashMap<String, AbstractEventTrigger>();
    private CreateEventTriggerOperationImpl createEventTriggerOperation = new CreateEventTriggerOperationImpl();

    ServiceEventTriggersCache(ServiceEventTriggerManager manager) {
        this.manager = manager;
    }

    public synchronized void initializeEventTriggers() {
        for (String triggerName : this.manager.sco.listEventTriggers()) {
            try {
                this.getOrCreateEventTriggerOrThrowException(triggerName);
            }
            catch (Exception exception) {
                this.manager.serviceContext.logDebug("Initialization of event trigger '" + triggerName + "' failed. Cause: " + exception.getMessage());
            }
        }
    }

    public synchronized List<EventTriggerDefinition> getOrCreateEventTriggerDefinitions() {
        return this.manager.sco.listEventTriggers().stream().map(this::getOrCreateEventTriggerDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public synchronized EventTriggerDefinition getOrCreateEventTriggerDefinition(String triggerName) {
        EventTriggerDefinition definition = null;
        AbstractEventTrigger trigger = this.triggers.get(triggerName);
        if (trigger != null) {
            definition = trigger.triggerScript.getDefinition();
        }
        if (definition == null) {
            definition = this.definitions.get(triggerName);
        }
        if (definition == null) {
            try {
                trigger = this.getOrCreateEventTriggerOrThrowException(triggerName);
                definition = trigger.triggerScript.getDefinition();
            }
            catch (ServiceConfigurationException e) {
                definition = this.definitions.get(triggerName);
            }
        }
        return definition;
    }

    public synchronized List<AbstractEventTrigger> getEventTriggers() {
        return new ArrayList<AbstractEventTrigger>(this.triggers.values());
    }

    public synchronized AbstractEventTrigger getEventTrigger(String triggerName) {
        return this.triggers.get(triggerName);
    }

    public synchronized AbstractEventTrigger getOrCreateEventTriggerOrThrowException(String triggerName) throws ServiceConfigurationException {
        AbstractEventTrigger eventTrigger = this.triggers.get(triggerName);
        if (eventTrigger != null) {
            return eventTrigger;
        }
        EventTriggerData triggerData = this.manager.sco.getEventTriggerData(triggerName);
        if (triggerData == null) {
            throw new ServiceConfigurationException("Event trigger '" + triggerName + "' does not exist in SCO.");
        }
        String syntax = EventTriggerSyntaxStore.loadSyntax(this.manager.serviceContext, triggerName);
        if (syntax == null) {
            String error = "Event trigger does not exist in SYSLDEF.";
            this.definitions.remove(triggerName);
            this.manager.invalidateEventTriggerData(triggerName, error);
            throw new ServiceConfigurationException("Event trigger '" + triggerName + "' does not exist in SYSLDEF.");
        }
        EventTriggerDefinition definition = this.tryParseEventTriggerDefinition(triggerName, syntax, false);
        this.definitions.put(triggerName, definition);
        TriggerScript triggerScript = this.tryParseAndCompileTriggerScript(definition);
        this.definitions.put(triggerName, triggerScript.getDefinition());
        eventTrigger = this.tryParseCompileAndValidateEventTrigger(triggerScript);
        eventTrigger.triggerScript.getDefinition().setAutoEnable(triggerData.isAutoEnable());
        this.triggers.put(triggerName, eventTrigger);
        this.definitions.remove(triggerName);
        return eventTrigger;
    }

    public synchronized EventTriggerDefinition tryParseEventTriggerDefinition(String triggerName, String syntax, boolean alter) throws ServiceConfigurationException {
        try {
            DSLStatement statement = this.createEventTriggerOperation.parseDsl(syntax);
            EventTriggerDefinition definition = CreateEventTriggerOperationImpl.parseEventTriggerSlangDefinition(statement);
            if (triggerName != null && !definition.getName().equals(triggerName)) {
                String error = "Trigger '" + triggerName + "' name mismatch, name in syntax '" + definition.getName() + "'.";
                this.manager.invalidateEventTriggerData(triggerName, error);
                throw new ServiceConfigurationException(error);
            }
            if (alter) {
                AbstractEventTrigger oldTrigger = this.triggers.get(definition.getName());
                EventTriggerDefinition oldDefinition = null;
                if (oldTrigger != null) {
                    oldDefinition = oldTrigger.triggerScript.getDefinition();
                }
                if (oldDefinition == null) {
                    oldDefinition = this.definitions.get(triggerName);
                }
                if (oldDefinition != null) {
                    CreateEventTriggerOperationImpl.mergeParametersForAlter(statement, oldDefinition, definition);
                }
            }
            return definition;
        }
        catch (ParsingException exception) {
            String error = "Failed to parse trigger syntax '" + syntax + "'. Cause: " + exception.getMessage();
            if (triggerName != null) {
                this.manager.invalidateEventTriggerData(triggerName, error);
            }
            throw new ServiceConfigurationException(error);
        }
    }

    public synchronized AbstractEventTrigger tryParseCompileAndValidateEventTrigger(EventTriggerDefinition definition) throws ServiceConfigurationException {
        AbstractEventTrigger eventTrigger = this.createEventTrigger(this.manager.serviceContext);
        eventTrigger.init(definition, this.manager.serviceContext.context);
        if (eventTrigger.getState() == EventTriggerState.INVALID) {
            this.manager.serviceContext.logDebug("Initialization of event trigger '" + definition.getName() + "' failed.");
            this.manager.invalidateEventTriggerData(definition.getName(), eventTrigger.getLastError());
            if (eventTrigger.getLastErrorException() instanceof AbstractParserException) {
                throw new ServiceConfigurationException(eventTrigger.getLastError(), eventTrigger.getLastErrorException());
            }
            throw new ServiceConfigurationException(eventTrigger.getLastError());
        }
        return eventTrigger;
    }

    private synchronized AbstractEventTrigger tryParseCompileAndValidateEventTrigger(TriggerScript triggerScript) throws ServiceConfigurationException {
        AbstractEventTrigger eventTrigger = this.createEventTrigger(this.manager.serviceContext);
        eventTrigger.init(triggerScript, this.manager.serviceContext.context);
        if (eventTrigger.getState() == EventTriggerState.INVALID) {
            this.manager.serviceContext.logDebug("Initialization of event trigger '" + triggerScript.getDefinition().getName() + "' failed.");
            this.manager.invalidateEventTriggerData(triggerScript.getDefinition().getName(), eventTrigger.getLastError());
            if (eventTrigger.getLastErrorException() instanceof AbstractParserException) {
                throw new ServiceConfigurationException(eventTrigger.getLastError(), eventTrigger.getLastErrorException());
            }
            throw new ServiceConfigurationException(eventTrigger.getLastError());
        }
        return eventTrigger;
    }

    private synchronized TriggerScript tryParseAndCompileTriggerScript(EventTriggerDefinition definition) throws ServiceConfigurationException {
        try {
            return TriggerScript.parseAndCompile(definition, this.manager.serviceContext, this.manager.serviceContext.context);
        }
        catch (Exception exception) {
            this.manager.serviceContext.logDebug("Initialization of event trigger '" + definition.getName() + "' failed.");
            this.manager.invalidateEventTriggerData(definition.getName(), exception.getMessage());
            throw new ServiceConfigurationException(exception.getMessage());
        }
    }

    private AbstractEventTrigger createEventTrigger(AbstractFabricComponent component) {
        return new ServiceEventTrigger(component);
    }

    public synchronized void removeEventTrigger(String triggerName) {
        this.triggers.remove(triggerName);
        this.definitions.remove(triggerName);
    }

    public synchronized void removeAllEventTriggers() {
        this.triggers.clear();
        this.definitions.clear();
    }

    class ServiceEventTrigger
    extends AbstractEventTrigger {
        protected ServiceEventTrigger(AbstractFabricComponent component) {
            super(component);
        }

        @Override
        void onBindEvent(String eventId) {
            SourceEventFlowImpl eventFlow = this.component.addSourceEventFlow(eventId, this.getEventFlowEntity(), this.getName(), this.getEventScope(), false);
            if (this.getEventHandlerName() != null) {
                eventFlow.addEntityParameter("eventHandler", this.getEventHandlerName());
            }
        }

        @Override
        void onUnbindEvent(String eventId) {
            this.component.removeSourceEventFlow(eventId, this.getEventFlowEntity(), this.getName());
        }

        private EventFlowEntity getEventFlowEntity() {
            return this.getTriggerActionTime() == TriggerActionTime.BEFORE ? EventFlowEntity.SERVICE_EVENT_TRIGGER_BEFORE : EventFlowEntity.SERVICE_EVENT_TRIGGER_AFTER;
        }

        @Override
        protected void onDisableException() {
            try {
                this.logInfo("Disable event trigger '" + this.getName() + "' function called.");
                ServiceEventTriggersCache.this.manager.disableEventTrigger(this.getName());
            }
            catch (ServiceConfigurationException exception) {
                this.logError("Disable trigger operation failed for trigger '" + this.getName() + "'. Cause: " + exception.getMessage());
            }
        }

        @Override
        protected void onInvalidateException(String error) {
            this.logInfo("Invalidate event trigger '" + this.getName() + "' function called.");
            ServiceEventTriggersCache.this.manager.unloadEventTrigger(this.getName(), false);
            ServiceEventTriggersCache.this.manager.invalidateEventTriggerData(this, error);
        }

        @Override
        protected String getOnEventErrorMessage() {
            return "Event Trigger Script '" + this.getName() + "' in Service [" + ServiceEventTriggersCache.this.manager.serviceContext.getFullNameInLocalNode() + "] execution failed.";
        }

        @Override
        protected void logDebug(String message) {
            ServiceEventTriggersCache.this.manager.serviceContext.logDebug(this.getTracePrefix() + message);
        }

        @Override
        protected void logInfo(String message) {
            ServiceEventTriggersCache.this.manager.serviceContext.logInfo(this.getTracePrefix() + message);
        }

        @Override
        protected void logError(String message) {
            ServiceEventTriggersCache.this.manager.serviceContext.logError(this.getTracePrefix() + message);
        }
    }
}

