/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.dispatcher.AbstractEventTrigger;
import com.streamscape.sef.dispatcher.EventTriggerSyntaxStore;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.InvokeDelegate;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.dispatcher.ServiceEventTriggersCache;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.sef.service.mf.impl.AlterEventTriggerOperationImpl;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class ServiceEventTriggerManager
implements EventTriggerManagerDelegate {
    protected ServiceContextImpl serviceContext;
    protected ServiceConfigurationObject sco;
    private ServiceEventTriggersCache cache;
    private Map<String, String> lastErrors = new HashMap<String, String>();

    ServiceEventTriggerManager(ServiceContextImpl serviceContext) {
        this.serviceContext = serviceContext;
        this.sco = serviceContext.getServiceConfiguration();
        this.cache = new ServiceEventTriggersCache(this);
    }

    @Override
    public synchronized List<String> listEventTriggers() {
        TreeSet<String> result = new TreeSet<String>();
        try {
            result.addAll(EventTriggerSyntaxStore.listTriggers(this.serviceContext));
        }
        catch (ServiceConfigurationException exception) {
            this.serviceContext.logError("Failed to list event triggers from SYSLDEF. Cause: " + exception.getMessage());
        }
        result.addAll(this.sco.listEventTriggers());
        return new ArrayList<String>(result);
    }

    @Override
    public synchronized EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        return this.sco.getEventTriggerData(triggerName);
    }

    @Override
    public synchronized boolean hasEventTriggers() {
        return this.sco.hasEventTriggers();
    }

    @Override
    public synchronized boolean existsEventTrigger(String triggerName) {
        return this.sco.existsEventTrigger(triggerName);
    }

    @Override
    public synchronized EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        return this.cache.getOrCreateEventTriggerDefinition(triggerName);
    }

    @Override
    public synchronized List<EventTriggerDefinition> getEventTriggerDefinitions() {
        return this.cache.getOrCreateEventTriggerDefinitions();
    }

    @Override
    public synchronized void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        EventTriggerDefinition definition = this.cache.tryParseEventTriggerDefinition(null, triggerSyntax, false);
        String triggerName = definition.getName();
        boolean existsInSysldef = EventTriggerSyntaxStore.isSyntaxExists(this.serviceContext, triggerName);
        boolean existsInSco = this.sco.existsEventTrigger(triggerName);
        if (existsInSysldef && existsInSco) {
            throw new ServiceConfigurationException("Trigger with name '" + triggerName + "' already exists. Remove it before adding.");
        }
        if (existsInSysldef) {
            throw new ServiceConfigurationException("Trigger with name '" + triggerName + "' already exists in SYSLDEF. Remove it before adding.");
        }
        if (existsInSco) {
            throw new ServiceConfigurationException("Trigger with name '" + triggerName + "' already exists in SCO. Remove it before adding.");
        }
        AbstractEventTrigger trigger = this.cache.tryParseCompileAndValidateEventTrigger(definition);
        this.validateEventTrigger(trigger);
        this.alterAddEventTriggerInternal(trigger, definition.getFullSyntax());
        this.serviceContext.logInfo("Trigger '" + triggerName + "' added.");
        if (definition.isAutoEnable()) {
            this.enableEventTrigger(trigger.getName());
        }
    }

    @Override
    public synchronized void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        triggerSyntax = AlterEventTriggerOperationImpl.replaceAlterWithCreate(triggerSyntax);
        EventTriggerDefinition definition = this.cache.tryParseEventTriggerDefinition(null, triggerSyntax, true);
        AbstractEventTrigger trigger = this.cache.tryParseCompileAndValidateEventTrigger(definition);
        this.validateEventTrigger(trigger);
        this.removeEventTrigger(definition.getName());
        this.alterAddEventTriggerInternal(trigger, definition.getFullSyntax());
        this.serviceContext.logInfo("Trigger '" + definition.getName() + "' altered.");
        if (definition.isAutoEnable()) {
            this.enableEventTrigger(trigger.getName());
        }
    }

    private void alterAddEventTriggerInternal(AbstractEventTrigger trigger, String triggerSyntax) throws ServiceConfigurationException {
        EventTriggerCompiledDefinition definition = trigger.triggerScript.getDefinition();
        String triggerName = definition.getName();
        EventTriggerSyntaxStore.saveSyntax(this.serviceContext, triggerName, AlterEventTriggerOperationImpl.removeEnableDisableFlag(triggerSyntax));
        try {
            this.sco.addEventTrigger(triggerName);
            this.sco.getEventTriggerData(triggerName).setAutoEnable(definition.isAutoEnable());
            if (trigger.triggerScript.getDefinition().getEventScope() == EventScope.LOCAL) {
                for (String eventId : trigger.triggerScript.getDefinition().getRaisedEventIds()) {
                    if (this.sco.existsActionableEvent(eventId)) continue;
                    this.sco.addActionableEvent(eventId);
                }
            }
            this.saveSco();
        }
        catch (ServiceConfigurationException exception) {
            this.serviceContext.logError("Failed to save SCO with added trigger '" + triggerName + "'. Cause: " + exception.getMessage());
            try {
                this.sco.removeEventTrigger(triggerName);
            }
            catch (Exception e) {
                this.serviceContext.logError("Failed to remove trigger '" + triggerName + "'. Cause: " + e.getMessage());
            }
            try {
                EventTriggerSyntaxStore.removeSyntax(this.serviceContext, triggerName);
            }
            catch (ServiceConfigurationException e) {
                this.serviceContext.logError("Failed to remove syntax for trigger '" + triggerName + "'. Cause: " + e.getMessage());
            }
            throw exception;
        }
    }

    @Override
    public synchronized void enableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.enableEventTriggerData(triggerName, true);
        AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
        if (trigger != null && trigger.getState() == EventTriggerState.ENABLED) {
            throw new ServiceConfigurationException("Event trigger already in ENABLED state.");
        }
        this.unloadEventTrigger(triggerName, true);
        this.lastErrors.remove(triggerName);
        trigger = this.cache.getOrCreateEventTriggerOrThrowException(triggerName);
        this.validateEventTrigger(trigger);
        if (!this.serviceContext.isRunning()) {
            Trace.logInfo(this, "Service is not running. Doesn't enable trigger '" + triggerName + "'.");
            return;
        }
        if (trigger.getState() == EventTriggerState.INVALID) {
            throw new ServiceConfigurationException("Event trigger cannot be enabled when state is INVALID.");
        }
        trigger.enable();
        if (trigger.getState() == EventTriggerState.INVALID) {
            this.invalidateEventTriggerData(triggerName, trigger.getLastError());
            throw new ServiceConfigurationException(trigger.getLastError());
        }
        try {
            if (trigger.getTriggerActionTime() == TriggerActionTime.AFTER) {
                FabricEventDirectConsumerImpl consumer = this.serviceContext.dispatcher.createActionableConsumer(triggerName, trigger, this.getActionableEventId(trigger), null);
                SinkEventFlowImpl eventFlow = this.serviceContext.addSinkEventFlow(EventFlowEntity.SERVICE_EVENT_TRIGGER_AFTER, triggerName, trigger.getActionableEventId(), consumer, false);
                eventFlow.setEntityScope(trigger.getEventScope() != null ? trigger.getEventScope() : this.serviceContext.getEventScope());
                trigger.setEventFlow(eventFlow);
            } else {
                InvokeDelegate delegate = this.serviceContext.getInvokeDelegates().get(trigger.triggerScript.getDefinition().getEventHandlerName());
                if (delegate == null) {
                    throw new EventTriggerCompileException("Unable to get event handler '" + trigger.triggerScript.getDefinition().getEventHandlerName() + "' invoke delegate. Event Trigger '" + triggerName + "' cannot be created.");
                }
                delegate.addBeforeEventTrigger(trigger);
                SinkEventFlowImpl eventFlow = this.serviceContext.addSinkEventFlow(EventFlowEntity.SERVICE_EVENT_TRIGGER_BEFORE, triggerName, trigger.getEventScope(), null, null, delegate.getEventHandler().getRequestEventId(), trigger.getEventSelector(), false);
                eventFlow.addEntityParameter("eventHandler", delegate.getEventHandler().getHandlerName());
                trigger.setEventFlow(eventFlow);
            }
        }
        catch (Exception exception) {
            trigger.disable();
            String error = "Trigger initialization failed. Cause: " + exception.getMessage();
            this.invalidateEventTriggerData(trigger, error);
            throw new ServiceConfigurationException(error);
        }
        this.serviceContext.logInfo("Trigger '" + triggerName + "' enabled.");
    }

    @Override
    public synchronized void disableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.enableEventTriggerData(triggerName, false);
        this.unloadEventTrigger(triggerName, false);
        this.resetSuspectState(triggerName);
        this.serviceContext.logInfo("Trigger '" + triggerName + "' disabled.");
    }

    @Override
    public synchronized void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        try {
            AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
            if (trigger != null && trigger.getState() == EventTriggerState.ENABLED) {
                throw new IllegalTriggerStateException("Event trigger cannot be compiled in ENABLED state.");
            }
            this.unloadEventTrigger(triggerName, true);
            trigger = this.cache.getOrCreateEventTriggerOrThrowException(triggerName);
            this.validateEventTrigger(trigger);
            this.serviceContext.logInfo("Trigger '" + triggerName + "' initialized (and now in state " + String.valueOf((Object)this.getTriggerState(triggerName)) + ").");
        }
        catch (ServiceConfigurationException error) {
            throw new EventTriggerCompileException(error.getMessage());
        }
    }

    @Override
    public synchronized void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.unloadEventTrigger(triggerName, false);
        AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
        if (trigger != null && trigger.getEventScope() == EventScope.LOCAL) {
            EventTriggerCompiledDefinition definition = trigger.triggerScript.getDefinition();
            for (String eventId : definition.getRaisedEventIds()) {
                if (this.sco.existsActionableEvent(eventId)) {
                    boolean lastUse = true;
                    for (EventTriggerDefinition def : this.getEventTriggerDefinitions()) {
                        if (def.getName().equals(definition.getName()) || def.getEventScope() != EventScope.LOCAL || !(def instanceof EventTriggerCompiledDefinition)) continue;
                        for (String defEventId : ((EventTriggerCompiledDefinition)def).getRaisedEventIds()) {
                            if (!defEventId.equals(eventId)) continue;
                            lastUse = false;
                        }
                    }
                    if (lastUse) {
                        this.sco.removeActionableEvent(eventId);
                    }
                }
                this.saveSco();
            }
        }
        this.cache.removeEventTrigger(triggerName);
        this.lastErrors.remove(triggerName);
        this.resetSuspectState(triggerName);
        if (!this.sco.existsEventTrigger(triggerName) && !EventTriggerSyntaxStore.isSyntaxExists(this.serviceContext, triggerName)) {
            throw new ServiceConfigurationException("Trigger '" + triggerName + "' doesn't exist.");
        }
        if (this.sco.existsEventTrigger(triggerName)) {
            this.sco.removeEventTrigger(triggerName);
            this.saveSco();
        }
        EventTriggerSyntaxStore.removeSyntax(this.serviceContext, triggerName);
        this.serviceContext.logInfo("Trigger '" + triggerName + "' removed.");
    }

    @Override
    public synchronized void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        for (AbstractEventTrigger eventTrigger : this.cache.getEventTriggers()) {
            this.unloadEventTrigger(eventTrigger.getName(), false);
            this.resetSuspectState(eventTrigger.getName());
            if (eventTrigger.triggerScript.getDefinition().getEventScope() != EventScope.LOCAL) continue;
            for (String eventId : eventTrigger.triggerScript.getDefinition().getRaisedEventIds()) {
                if (!this.sco.existsActionableEvent(eventId)) continue;
                this.sco.removeActionableEvent(eventId);
            }
        }
        this.saveSco();
        this.cache.removeAllEventTriggers();
        this.lastErrors.clear();
        this.sco.removeAllEventTriggers();
        this.saveSco();
        EventTriggerSyntaxStore.removeSyntaxes(this.serviceContext);
        this.serviceContext.logInfo("All triggers removed.");
    }

    @Override
    public synchronized String getLastError(String triggerName) {
        AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
        if (trigger != null) {
            return trigger.getLastError();
        }
        if (this.lastErrors.get(triggerName) != null) {
            return this.lastErrors.get(triggerName);
        }
        if (this.sco.getEventTriggerData(triggerName) != null) {
            return null;
        }
        try {
            if (EventTriggerSyntaxStore.isSyntaxExists(this.serviceContext, triggerName)) {
                return "Trigger exists in SYSLDEF but doesn't exist in SCO. Try to remove it...";
            }
        }
        catch (ServiceConfigurationException exception) {
            this.serviceContext.logError("Failed to get syntax from SYSLDEF. Cause: " + exception.getMessage());
        }
        return null;
    }

    @Override
    public synchronized EventTriggerState getTriggerState(String triggerName) {
        AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
        if (trigger != null) {
            switch (trigger.getState()) {
                case INVALID: {
                    return trigger.getState();
                }
                case DISABLED: 
                case ENABLED: {
                    if (this.serviceContext.isRunning()) {
                        return trigger.getState();
                    }
                    return trigger.triggerScript.getDefinition().isAutoEnable() ? EventTriggerState.ENABLED : EventTriggerState.DISABLED;
                }
                case INITIALIZED: 
                case NOT_INITIALIZED: {
                    return trigger.triggerScript.getDefinition().isAutoEnable() ? EventTriggerState.ENABLED : EventTriggerState.DISABLED;
                }
            }
        }
        if (this.lastErrors.get(triggerName) != null) {
            return EventTriggerState.INVALID;
        }
        if (this.sco.getEventTriggerData(triggerName) != null) {
            return this.sco.getEventTriggerData(triggerName).isAutoEnable() ? EventTriggerState.ENABLED : EventTriggerState.DISABLED;
        }
        try {
            if (EventTriggerSyntaxStore.isSyntaxExists(this.serviceContext, triggerName)) {
                return EventTriggerState.INVALID;
            }
        }
        catch (ServiceConfigurationException exception) {
            this.serviceContext.logError("Failed to get syntax from SYSLDEF. Cause: " + exception.getMessage());
        }
        return null;
    }

    @Override
    public synchronized TriggerActionTime getTriggerActionTime(String triggerName) {
        try {
            EventTriggerDefinition definition = this.cache.getOrCreateEventTriggerDefinition(triggerName);
            if (definition != null) {
                return definition.getTriggerActionTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        String syntax = EventTriggerSyntaxStore.loadSyntax(this.serviceContext, triggerName);
        if (syntax != null) {
            return syntax;
        }
        return null;
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        EventTriggerData data = this.sco.getEventTriggerData(triggerName);
        if (data == null) {
            throw new IllegalTriggerStateException("Event trigger doesn't exist.");
        }
        return data.isAutoEnable();
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        EventTriggerData data = this.sco.getEventTriggerData(triggerName);
        if (data == null) {
            throw new IllegalTriggerStateException("Event trigger doesn't exist.");
        }
        this.enableEventTriggerData(triggerName, autoEnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveSco() throws ServiceConfigurationException {
        ServiceConfigurationObject scoForSave = ServiceConfigurationFactory.loadConfigurationObject(this.serviceContext, this.serviceContext.getName(), this.serviceContext.getType(), false);
        if (!scoForSave.existsException("exception.service.Framework")) {
            scoForSave.addException("exception.service.Framework");
        }
        scoForSave.removeAllEventTriggers();
        for (String triggerName : this.sco.listEventTriggers()) {
            EventTriggerData eventTriggerData = this.sco.getEventTriggerData(triggerName);
            if (eventTriggerData == null) continue;
            scoForSave.addEventTriggerData(eventTriggerData);
        }
        try {
            this.serviceContext.scoUpdate = true;
            ServiceConfigurationFactory.saveConfigurationObject(scoForSave);
        }
        catch (ServiceConfigurationException exception) {
            this.serviceContext.logError("Failed to save SCO. Destroying the service context....");
            Trace.logException(this, exception, true);
            try {
                if (this.serviceContext.isRunning()) {
                    this.serviceContext.stop();
                }
                this.serviceContext.destroy();
            }
            catch (Exception e) {
                this.serviceContext.logError("Failed to stop and destroy service context... ");
                Trace.logException(this, exception, true);
            }
            throw exception;
        }
        finally {
            this.serviceContext.scoUpdate = false;
        }
    }

    protected void enableEventTriggerData(String triggerName, boolean enabled) throws ServiceConfigurationException {
        EventTriggerDefinition definition;
        EventTriggerData triggerData = this.sco.getEventTriggerData(triggerName);
        if (triggerData != null && triggerData.isAutoEnable() ^ enabled) {
            triggerData.setAutoEnable(enabled);
            this.saveSco();
        }
        if ((definition = this.cache.getOrCreateEventTriggerDefinition(triggerName)) != null) {
            definition.setAutoEnable(enabled);
        }
    }

    protected void validateEventTriggerData(String triggerName) {
        this.lastErrors.remove(triggerName);
        this.resetSuspectState(triggerName);
    }

    protected void invalidateEventTriggerData(String triggerName, String error) {
        if (this.sco.existsEventTrigger(triggerName)) {
            this.lastErrors.put(triggerName, error);
            if (this.sco.getEventTriggerData(triggerName).isAutoEnable()) {
                this.setSuspectState(triggerName, error);
            }
        }
    }

    void invalidateEventTriggerData(AbstractEventTrigger trigger, String error) {
        this.invalidateEventTriggerData(trigger.getName(), error);
        trigger.invalidate(error);
    }

    protected void syncEventTriggers(boolean withCreate) throws ServiceConfigurationException {
        boolean scoChanged = false;
        try {
            for (AbstractEventTrigger trigger : this.cache.getEventTriggers()) {
                if (trigger.getState() != EventTriggerState.ENABLED) continue;
                this.serviceContext.logError("Failed to sync event triggers when triggers are loaded.");
                return;
            }
            this.cache.removeAllEventTriggers();
            List<String> sysldefTriggers = EventTriggerSyntaxStore.listTriggers(this.serviceContext);
            for (String sysldefTrigger : sysldefTriggers) {
                if (this.sco.existsEventTrigger(sysldefTrigger)) continue;
                this.serviceContext.logError("Trigger '" + sysldefTrigger + "' exists in SYSLDEF and does not exist in SCO. Adding it to SCO...");
                this.sco.addEventTrigger(sysldefTrigger);
                scoChanged = true;
            }
            for (String scoTrigger : this.sco.listEventTriggers()) {
                if (sysldefTriggers.contains(scoTrigger)) continue;
                this.serviceContext.logError("Trigger '" + scoTrigger + "' exists in SCO and does not exist in SYSLDEF. Removing it from SCO...");
                this.sco.removeEventTrigger(scoTrigger);
                scoChanged = true;
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Synchronization of event triggers failed. Cause: " + exception.getMessage());
        }
        if (scoChanged) {
            this.saveSco();
        }
        if (withCreate) {
            this.cache.initializeEventTriggers();
        }
    }

    protected void initializeAndEnableEventTriggers() throws ServiceConfigurationException {
        this.syncEventTriggers(false);
        List<String> triggers = this.sco.listEventTriggers();
        for (String trigger : triggers) {
            if (this.sco.getEventTriggerData(trigger).isAutoEnable()) {
                try {
                    this.enableEventTrigger(trigger);
                }
                catch (Exception exception) {
                    this.serviceContext.logError("Enabling of event trigger '" + trigger + "' failed. Cause: " + exception.getMessage());
                }
                continue;
            }
            try {
                this.compileEventTrigger(trigger);
            }
            catch (Exception exception) {
                this.serviceContext.logDebug("Initialization of event trigger '" + trigger + "' failed. Cause: " + exception.getMessage());
            }
        }
    }

    protected synchronized void unloadEventTriggers() {
        for (AbstractEventTrigger trigger : this.cache.getEventTriggers()) {
            this.unloadEventTrigger(trigger.getName(), false);
        }
    }

    synchronized void unloadEventTrigger(String triggerName, boolean withRemove) {
        AbstractEventTrigger trigger = this.cache.getEventTrigger(triggerName);
        if (trigger == null) {
            return;
        }
        if (withRemove) {
            this.cache.removeEventTrigger(triggerName);
        }
        boolean wasUnloaded = false;
        if (trigger.getState() == EventTriggerState.ENABLED) {
            wasUnloaded = true;
            trigger.disable();
        }
        if (trigger.getTriggerActionTime() == TriggerActionTime.AFTER) {
            try {
                if (this.serviceContext.dispatcher.existsConsumer(trigger.getName())) {
                    this.serviceContext.dispatcher.dropConsumer(trigger.getName());
                    wasUnloaded = true;
                }
            }
            catch (FabricEventDispatcherException fabricEventDispatcherException) {}
        } else {
            InvokeDelegate delegate = this.serviceContext.getInvokeDelegates().get(trigger.triggerScript.getDefinition().getEventHandlerName());
            if (delegate != null) {
                delegate.removeBeforeEventTrigger(triggerName);
                wasUnloaded = true;
            }
        }
        if (wasUnloaded) {
            this.serviceContext.logInfo("Trigger '" + triggerName + "' unloaded.");
        }
    }

    private String getActionableEventId(AbstractEventTrigger trigger) {
        return "e.action." + trigger.getActionableEventId();
    }

    private void validateEventTrigger(AbstractEventTrigger trigger) throws ServiceConfigurationException {
        try {
            String eventId;
            EventTriggerCompiledDefinition definition = trigger.triggerScript.getDefinition();
            if (!(definition.getActionableEventId() == null || definition.getActionableEventId().isEmpty() || this.sco.existsActionableEvent(eventId = definition.getActionableEventId()) || this.sco.existsException(eventId) || this.sco.existsAdvisory(eventId))) {
                throw new ServiceConfigurationException("Trigger actionable event [" + eventId + "] is undefined.");
            }
            if (definition.getEventHandlerName() != null && definition.getEventHandlerName().length() > 0 && this.sco.getEventHandler(definition.getEventHandlerName()) == null) {
                throw new ServiceConfigurationException("Unknown event handler name '" + definition.getEventHandlerName() + "'.  Event Trigger '" + definition.getName() + "' cannot be created.");
            }
            for (String eventId2 : definition.getRaisedEventIds()) {
                if (trigger.triggerScript.isEventIdForReply(eventId2)) continue;
                for (EventHandler eventHandler : this.sco.getEventHandlers()) {
                    if (eventHandler.getRequestEventId() == null || !eventHandler.getRequestEventId().equals(eventId2)) continue;
                    throw new ServiceConfigurationException("Trigger event [" + eventId2 + "] cannot be request event of handler '" + eventHandler.getHandlerName() + "' because it is raised from event trigger '" + trigger.getName() + "'.");
                }
            }
        }
        catch (ServiceConfigurationException exception) {
            this.invalidateEventTriggerData(trigger, exception.getMessage());
            throw exception;
        }
        this.validateEventTriggerData(trigger.getName());
    }

    private void setSuspectState(String triggerName, String lastError) {
        this.serviceContext.setSuspectState(SuspectState.SuspectStateOriginator.trigger(triggerName), lastError);
    }

    private void resetSuspectState(String triggerName) {
        this.serviceContext.resetSuspectState(SuspectState.SuspectStateOriginator.trigger(triggerName));
    }
}

