/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.lib.filter.FilterMap;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.admin.pkg.PackageStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.Version;
import com.streamscape.sdo.advisory.ComponentStateChangeAdvisory;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.advisory.MetricAdvisory;
import com.streamscape.sdo.advisory.RepositoryArtifactStateChangeAdvisory;
import com.streamscape.sdo.advisory.RuntimeAdvisory;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.utils.EventPrototypeComparator;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSinkException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricManagedComponentException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.IllegalComponentStateException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.advisories.StateAdvisoryFactory;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.FabricEventSinkFactoryImpl;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.InvokeDelegate;
import com.streamscape.sef.dispatcher.LocalFabricComponent;
import com.streamscape.sef.dispatcher.ServiceEventTriggerManager;
import com.streamscape.sef.dispatcher.ServiceLexiconProcessor;
import com.streamscape.sef.dispatcher.ServiceMFSession;
import com.streamscape.sef.dispatcher.ServiceManagerImpl;
import com.streamscape.sef.dispatcher.ServicePool;
import com.streamscape.sef.dispatcher.ServiceSessionManager;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.sef.metrics.MetricsFactory;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pool.AccessorsPool;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.service.DaemonServiceBlockedException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.ServiceContextException;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceLogger;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.sef.service.advisories.ServiceStateAdvisoriesFactory;
import com.streamscape.sef.service.dsl.CustomServiceDSLOperation;
import com.streamscape.sef.service.dsl.CustomServiceDSLProvider;
import com.streamscape.sef.service.dsl.DSLProcessor;
import com.streamscape.sef.service.dsl.DSLSyntaxFactory;
import com.streamscape.sef.service.dsl.UserDefinedOfflineServiceDSLProviderAnnotation;
import com.streamscape.sef.service.dsl.UserDefinedServiceDSLProvider;
import com.streamscape.sef.service.dsl.UserDefinedServiceDSLProviderAnnotation;
import com.streamscape.sef.service.metrics.ServiceMetricsFactory;
import com.streamscape.service.osf.CancellableService;
import com.streamscape.service.osf.DaemonService;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.AbstractFactoryPropertyValue;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.eim.EventIdentityPlugin;
import com.streamscape.service.osf.eim.mf.EventIdentityPluginManagerException;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.evh.EventHandlerException;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconProcessorHolder;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

class ServiceContextImpl
extends LocalFabricComponent
implements ServiceContext,
Logger,
EventTriggerManagerDelegate,
DSLComponent<ServiceContext>,
DSLProcessor {
    private ServiceManagerImpl manager = null;
    ServiceDescriptor descriptor = null;
    private ServiceConfigurationObject sco = null;
    boolean scoUpdate = false;
    private ComponentState originalState = null;
    private Object stateChangeMutex = new Object();
    private SuspectState suspectState = new SuspectState();
    private ServiceMetricsFactory metricsFactory = null;
    private ServiceStateAdvisoriesFactory notificationsFactory = null;
    private boolean useEIM = false;
    private ServiceSessionManager sessionManager = null;
    private final SemanticLexiconProcessorHolder<ServiceLexiconProcessor> lexiconProcessorHolder;
    private Class<?> serviceClass = null;
    private ServicePool servicePool = null;
    private int servicePoolSize = 1;
    private SemanticTypeCache typeCache = null;
    private GlobalVariableCollection globalVariables = null;
    private Map<String, InvokeDelegate> invokeDelegates = new HashMap<String, InvokeDelegate>();
    private FilterMap<InvokeDelegate> invokeDelegatesByEventId = new FilterMap();
    private ServiceEventTriggerManager eventTriggerManager;
    static final String EVENT_HANDLER_CONSUMER_SUFFIX = "HandlerInput";

    ServiceContextImpl(ServiceDescriptor descriptor, ServiceManagerImpl manager) throws ServiceContextException {
        this.logDebug("Creating Service Context...");
        this.context = RuntimeContext.getInstance();
        this.manager = manager;
        this.descriptor = descriptor;
        this.lexiconProcessorHolder = new SemanticLexiconProcessorHolder<ServiceLexiconProcessor>(new ServiceLexiconProcessor(this.context, this));
        try {
            this.setState(ComponentState.NOT_INITIALIZED);
            this.setModel(ComponentModel.CTX_SERVICE);
            this.setName(descriptor.getName());
            this.setType(descriptor.getType());
            this.typeCache = this.context.getSemanticTypeCache();
            this.globalVariables = VariableFactory.getGlobalVariables();
            this.logPrefix = "[" + this.getType() + "/" + this.getName() + "] ";
            this.accessorsPool = new AccessorsPool(this, this.context);
            this.accessorsPool.init();
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            throw new ServiceContextException(6065, "Initialization of Service Context failed.", exception);
        }
        this.logDebug("Service Context Created.");
    }

    @Override
    public void init() throws IllegalComponentStateException, FabricManagedComponentException {
        if (this.state != ComponentState.NOT_INITIALIZED && this.state != ComponentState.DESTROYED) {
            throw new IllegalComponentStateException("Unable initialize service in state '" + String.valueOf((Object)this.state) + "'.");
        }
        try {
            this.logInfo("Initializing Service Context...");
            this.setState(ComponentState.INITIALIZING);
            this.sco = this.loadSco();
            this.manager.authenticate(this.descriptor, this);
            this.initPackageManifestManager();
            this.loadPackageManifest();
            this.loadServiceClass();
            this.initInternal(this.context.getDatagramPrototypeCache());
            this.boundEventIds.bindEventId("exception.service.Framework", false, false);
            this.context.bind(this);
            if (this.eventScope != EventScope.LOCAL) {
                this.sessionManager = new ServiceSessionManager(this.context, this);
                this.sessionManager.init();
            }
            this.lexiconProcessorHolder.setSemanticLexiconProcessor(new ServiceLexiconProcessor(this.context, this));
            this.initUserDefinedOfflineDSLProvider();
            this.eventTriggerManager = new ServiceEventTriggerManager(this);
            this.eventTriggerManager.syncEventTriggers(true);
            this.registerOutsyncHandler();
            this.sendRuntimeAdvisory("Service Context. Service ID: " + this.getFullName() + " initialized.");
            this.setState(ComponentState.INITIALIZED);
            this.logInfo("Service Context initialized.");
        }
        catch (Exception error) {
            this.logError("Unable to initialize service context. " + error.toString());
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setState(ComponentState.NOT_INITIALIZED);
            throw new FabricManagedComponentException("Initializing Service Context failed.", error);
        }
        this.validatePrototypesTriggersAndHandlers();
    }

    @Override
    public void destroy() throws IllegalComponentStateException, FabricManagedComponentException {
        if (this.state == ComponentState.DESTROYED || this.state == ComponentState.NOT_INITIALIZED) {
            return;
        }
        if (this.state != ComponentState.STOPPED && this.state != ComponentState.INITIALIZING && this.state != ComponentState.INITIALIZED && this.state != ComponentState.PENDING && this.state != ComponentState.OUTSYNC) {
            throw new IllegalComponentStateException("Unable to destroy service in state '" + String.valueOf((Object)this.state) + "'.");
        }
        try {
            this.logDebug("Destroying Service Context...");
            this.lexiconProcessorHolder.setSemanticLexiconProcessor(new ServiceLexiconProcessor(this.context, this));
            this.setState(ComponentState.DESTROYING);
            this.unregisterOutsyncHandler();
            if (this.sessionManager != null) {
                this.sessionManager.destroy();
                this.sessionManager = null;
            }
            this.destroyInternal();
            this.context.unbind(this.contextId);
            this.unloadPackageManifest();
            this.sendRuntimeAdvisory("Service Context. Service ID: " + this.getFullName() + " destroyed.");
            this.setState(ComponentState.DESTROYED);
            this.logInfo("Service Context destroyed.");
        }
        catch (Exception error) {
            this.setState(ComponentState.DESTROYED);
            Trace.logError(this, "Destroying Service Context '" + this.getFullNameInLocalNode() + "' failed.");
            this.logError("Destroying Service Context failed.");
            throw new FabricManagedComponentException("Destroying of Service Context '" + this.getFullNameInLocalNode() + "' failed.", error);
        }
    }

    ServiceSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void start() throws IllegalComponentStateException, FabricManagedComponentException {
        if (this.state != ComponentState.STOPPED && this.state != ComponentState.INITIALIZED) {
            throw new IllegalComponentStateException("Unable to start service in state '" + String.valueOf((Object)this.state) + "'.");
        }
        try {
            this.logDebug("Starting Service Context...");
            this.setState(ComponentState.STARTING);
            this.createServicePool();
            this.printServiceInfo();
            this.bindAdvisoryEvents();
            if (this.sco.getMetrics().size() > 0 && !this.dispatcher.isBoundEventId("advisory.service.metric")) {
                this.dispatcher.bindProducerForSystem("advisory.service.metric");
                this.addSourceEventFlow("advisory.service.metric", EventFlowEntity.SERVICE_EVENT_ADVISORY, null, null, false);
            }
            this.lexiconProcessorHolder.setSemanticLexiconProcessor(new ServiceLexiconProcessor(this.context, this));
            this.initCustomDSLProvider();
            this.initUserDefinedDSLProvider();
            this.logDebug("Initializing Service...");
            this.servicePool.doOperation(ServicePool.ServicePoolOperation.INIT);
            this.logInfo("Service initialized.");
            this.initNotifications();
            this.initMetrics();
            this.initEventHandlers();
            this.initEventTriggers();
            this.logDebug("Starting Service...");
            this.servicePool.doOperation(ServicePool.ServicePoolOperation.START);
            this.logInfo("Service started.");
            this.sendRuntimeAdvisory("Service Context. Service ID: " + this.getFullName() + " started.");
            this.setState(ComponentState.STARTED);
            this.logInfo("Service Context started.");
        }
        catch (Throwable exception) {
            String error = "Unable to start service context. " + exception.getMessage();
            this.logError(error);
            Trace.logException(this, exception, true);
            this.setSuspectState(SuspectState.SuspectStateOriginator.serviceContext(), error);
            this.unloadEventTriggers();
            this.unloadEventHandlers(this.getServiceStopTimeout());
            throw new FabricManagedComponentException("Starting Service Context '" + this.getFullName() + "' failed.", exception);
        }
    }

    @Override
    public void stop() throws IllegalComponentStateException, FabricManagedComponentException {
        if (!this.isRunning()) {
            throw new IllegalComponentStateException("Unable to stop service in state '" + String.valueOf((Object)this.state) + "'.");
        }
        try {
            this.logInfo("Stopping Service Context...");
            this.setState(ComponentState.STOPPING);
            long timeout = this.getServiceStopTimeout() / 3L;
            this.logInfo("Stopping Service...");
            if (this.servicePool != null) {
                this.servicePool.doOperation(ServicePool.ServicePoolOperation.STOP, timeout);
            }
            this.logInfo("Service stopped.");
            this.unloadEventHandlers(timeout);
            this.unloadEventTriggers();
            this.logInfo("Destroying Service...");
            if (this.servicePool != null) {
                this.servicePool.doOperation(ServicePool.ServicePoolOperation.DESTROY, timeout);
            }
            this.logInfo("Service destroyed.");
            this.destroyMetrics();
            this.sendRuntimeAdvisory("Service Context. Service ID: " + this.getFullName() + " stopped.");
            this.resetSuspectState();
            this.setState(ComponentState.STOPPED);
            this.lexiconProcessorHolder.setSemanticLexiconProcessor(new ServiceLexiconProcessor(this.context, this));
            this.initUserDefinedOfflineDSLProvider();
            this.logInfo("Service Context Stopped.");
        }
        catch (Exception exception) {
            this.logError("Unable to stop service context. " + exception.getMessage());
            Trace.logException(this, exception, true);
            this.logError("Stopping service failed. Set to PENDING state. Reload the service to recover from PENDING state.");
            this.setState(ComponentState.PENDING);
            throw new FabricManagedComponentException("Stopping Service Context '" + this.getFullName() + "' failed.", exception);
        }
    }

    private long getServiceStopTimeout() {
        Object value;
        long result = 15L;
        ConfigurationProperty property = this.sco.getAdvancedProperty("serviceStopTimeout");
        if (property != null && (value = property.getValue()) instanceof Long) {
            result = (Long)value;
        }
        return result * 1000L;
    }

    @Override
    public void resume() throws IllegalComponentStateException {
        try {
            this.logInfo("Resuming Service Context...");
            this.setState(ComponentState.RESUMING);
            this.servicePool.doOperation(ServicePool.ServicePoolOperation.RESUME);
            this.setState(ComponentState.STARTED);
            this.logInfo("Service Context Resumed.");
        }
        catch (ServiceContextException exception) {
            String error = "Unable to resume service context. " + exception.getMessage();
            this.logError(error);
            Trace.logException(this, exception, true);
            this.setSuspectState(SuspectState.SuspectStateOriginator.serviceContext(), error);
            throw new IllegalComponentStateException(exception.getMessage());
        }
    }

    @Override
    public void suspend() throws IllegalComponentStateException {
        try {
            this.logInfo("Suspending Service Context...");
            this.setState(ComponentState.SUSPENDING);
            this.servicePool.doOperation(ServicePool.ServicePoolOperation.SUSPEND);
            this.setState(ComponentState.SUSPENDED);
            this.logInfo("Service Context Suspended.");
        }
        catch (ServiceContextException exception) {
            String error = "Unable to suspend service context. " + exception.getMessage();
            this.logError(error);
            Trace.logException(this, exception, true);
            this.setSuspectState(SuspectState.SuspectStateOriginator.serviceContext(), error);
            throw new IllegalComponentStateException(exception.getMessage());
        }
    }

    @Override
    public String getVersion() {
        return this.servicePool != null ? this.servicePool.getVersion() : null;
    }

    private void printServiceInfo() {
        Service service = null;
        try {
            service = this.servicePool.borrowService();
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n\n\t\t");
            buffer.append(this.getType()).append(" / ").append(this.getName()).append("\n");
            buffer.append("\t\t");
            buffer.append("Release: ").append(service.getMajorVersion()).append(".").append(service.getMinorVersion()).append(" b").append(Version.formatBuild(service.getMajorBuild(), service.getMinorBuild()));
            buffer.append("\n\n");
            this.logInfo(buffer.toString());
        }
        finally {
            if (service != null) {
                this.servicePool.releaseService(service);
            }
        }
    }

    public void checkServiceIsNotBlocked() throws DaemonServiceBlockedException {
        if (this.servicePool != null) {
            this.servicePool.checkServiceIsNotBlocked();
        }
    }

    @Override
    protected void initInternal(DatagramPrototypeCache prototypeCache) {
        this.dispatcher = new FabricEventDispatcherImpl(this, prototypeCache);
        this.eventScope = this.sco.getEventScope();
    }

    private void initCustomDSLProvider() {
        DSLSyntaxFactory dslSyntaxFactory = this.context.getServiceManager().getDSLSyntaxFactoryManager().lookupDSLSyntaxFactory(this.type);
        if (dslSyntaxFactory != null && !dslSyntaxFactory.listDSLSyntaxes().isEmpty()) {
            CustomServiceDSLProvider customDSLProvider = new CustomServiceDSLProvider(this.getFullName(), this);
            for (DSLStatementSyntax syntax : dslSyntaxFactory.getDSLSyntaxes()) {
                customDSLProvider.registerOperation(new CustomServiceDSLOperation(syntax));
            }
            customDSLProvider.activate(this);
            this.lexiconProcessorHolder.getSemanticLexiconProcessor().registerCustomProvider(customDSLProvider);
        }
    }

    private void initUserDefinedDSLProvider() {
        try {
            UserDefinedServiceDSLProviderAnnotation annotation = this.serviceClass.getDeclaredAnnotation(UserDefinedServiceDSLProviderAnnotation.class);
            if (annotation == null) {
                return;
            }
            Class<?> providerClass = annotation.clazz();
            Constructor<?> providerClassConstructor = providerClass.getConstructor(String.class, ServiceContext.class);
            providerClassConstructor.setAccessible(true);
            UserDefinedServiceDSLProvider provider = (UserDefinedServiceDSLProvider)providerClassConstructor.newInstance("UserDefinedProvider#" + this.getFullName(), this);
            provider.activate(this);
            this.lexiconProcessorHolder.getSemanticLexiconProcessor().registerCustomProvider(provider);
        }
        catch (Exception exception) {
            this.logError("Failed to initialize user defined DSL provider.");
            Trace.logException(this, exception, true);
        }
    }

    private void initUserDefinedOfflineDSLProvider() {
        try {
            UserDefinedOfflineServiceDSLProviderAnnotation annotation = this.serviceClass.getDeclaredAnnotation(UserDefinedOfflineServiceDSLProviderAnnotation.class);
            if (annotation == null) {
                return;
            }
            Class<?> providerClass = annotation.clazz();
            Constructor<?> providerClassConstructor = providerClass.getConstructor(String.class, ServiceContext.class);
            providerClassConstructor.setAccessible(true);
            UserDefinedServiceDSLProvider provider = (UserDefinedServiceDSLProvider)providerClassConstructor.newInstance("UserDefinedProvider#" + this.getFullName(), this);
            provider.activate(this);
            this.lexiconProcessorHolder.getSemanticLexiconProcessor().registerCustomProvider(provider);
        }
        catch (Exception exception) {
            this.logError("Failed to initialize user defined DSL provider.");
            Trace.logException(this, exception, true);
        }
    }

    protected void initNotifications() throws ServiceContextException {
        this.notificationsFactory = new ServiceStateAdvisoriesFactory(this);
        Trace.logDebug(ServiceContextImpl.class, "Notifications Factory initialized.");
    }

    protected void initMetrics() throws ServiceContextException {
        this.metricsFactory = new ServiceMetricsFactory(this);
        Trace.logDebug(ServiceContextImpl.class, "Metrics Factory initialized.");
    }

    protected void destroyMetrics() {
        if (this.metricsFactory != null) {
            this.metricsFactory.destroy();
        }
    }

    protected EventIdentityPlugin initEventIdentityManager() throws ServiceContextException {
        try {
            EventIdentityPlugin eimPlugin = this.context.getEventIdentityPluginManager().createEventIdentityPlugin(this.sco.getEIMPluginName(), this.manifestManager.getManifestClassLoader());
            eimPlugin.init(this);
            this.useEIM = true;
            this.logDebug("Event Identity Plugin initialized.");
            return eimPlugin;
        }
        catch (EventIdentityPluginManagerException error) {
            throw new ServiceContextException(6065, "Initialization of Event Identity Plugin failed.", error);
        }
    }

    private void initEventHandlers() throws Exception {
        for (EventHandler handler : this.sco.getEventHandlers()) {
            try {
                this.checkEventHandlerRequestEventId(handler.getRequestEventId());
                InvokeDelegate delegate = new InvokeDelegate();
                delegate.init(this.serviceClass, this.servicePool, handler, this, this.context);
                InvokeMode invokeMode = handler.getInvokeMode();
                if (invokeMode == null) {
                    invokeMode = this.sco.getInvokeMode();
                }
                if (!StringUtils.isEmpty(handler.getRequestEventId())) {
                    String consumerName = handler.getHandlerName() + EVENT_HANDLER_CONSUMER_SUFFIX;
                    if (invokeMode == InvokeMode.DIRECT) {
                        consumer = this.dispatcher.createEventConsumer(consumerName, delegate, handler.getRequestEventId(), handler.getRequestSelector(), EventScope.INHERITED, false, null);
                        this.addSinkEventFlow(handler, consumer);
                    } else {
                        consumer = this.dispatcher.createEventAsyncConsumer(consumerName, delegate, handler.getRequestEventId(), handler.getRequestSelector(), EventScope.INHERITED, false, null);
                        ((FabricEventAsyncConsumerImpl)consumer).start();
                        this.addSinkEventFlow(handler, consumer);
                    }
                    this.invokeDelegatesByEventId.put(handler.getRequestEventId(), delegate);
                }
                if (!StringUtils.isEmpty(handler.getResponseEventId()) && this.sco.existsActionableEvent(handler.getResponseEventId())) {
                    this.addSourceEventFlow(handler);
                }
                this.invokeDelegates.put(handler.getHandlerName(), delegate);
                this.logInfo("Event handler '" + handler.getHandlerName() + "' initialized.");
            }
            catch (Exception exception) {
                handler.setValid(false);
                Trace.logError(this, "Initialization of event handler '" + handler.getHandlerName() + "' failed.");
                this.logError("Initialization of event handler '" + handler.getHandlerName() + "' failed. Cause: " + exception.getMessage());
                throw exception;
            }
        }
    }

    private void addSourceEventFlow(EventHandler handler) {
        this.addSourceEventFlow(handler.getResponseEventId(), EventFlowEntity.SERVICE_EVENT_HANDLER, handler.getHandlerName(), this.getEventScope(), false);
    }

    private void addSinkEventFlow(EventHandler handler, AbstractFabricConsumer consumer) {
        this.addSinkEventFlow(EventFlowEntity.SERVICE_EVENT_HANDLER, handler.getHandlerName(), consumer, false);
    }

    private void checkEventHandlerRequestEventId(String eventId) throws EventHandlerException {
        if (eventId.trim().length() == 0) {
            return;
        }
        for (InvokeDelegate delegate : this.invokeDelegates.values()) {
            if (!delegate.getEventHandler().getRequestEventId().equals(eventId)) continue;
            throw new EventHandlerException("Another event handler '" + delegate.getEventHandler().getHandlerName() + "' already has requestEventId [" + eventId + "].");
        }
    }

    private void unloadEventHandlers(long timeout) {
        for (Map.Entry<String, InvokeDelegate> entry : this.invokeDelegates.entrySet()) {
            InvokeDelegate delegate = entry.getValue();
            if (delegate != null) {
                InvokeMode invokeMode = delegate.getEventHandler().getInvokeMode();
                if (invokeMode == null) {
                    invokeMode = this.sco.getInvokeMode();
                }
                if (invokeMode == InvokeMode.ASYNC) {
                    consumer = this.dispatcher.getEventAsyncConsumer(entry.getKey() + EVENT_HANDLER_CONSUMER_SUFFIX);
                    if (consumer != null) {
                        consumer.close(timeout);
                    }
                } else {
                    consumer = this.dispatcher.getEventConsumer(entry.getKey() + EVENT_HANDLER_CONSUMER_SUFFIX);
                    if (consumer != null) {
                        consumer.close();
                    }
                }
            }
            this.logInfo("Event handler '" + entry.getKey() + "' unloaded.");
        }
        this.invokeDelegates.clear();
        this.invokeDelegatesByEventId.clear();
    }

    protected void bindAdvisoryEvents() throws FabricEventDispatcherException {
        for (String advisory : this.sco.listAdvisories()) {
            if (this.isBoundEventId(advisory)) continue;
            this.bindProducerFor(advisory);
            this.addSourceEventFlow(advisory, EventFlowEntity.SERVICE_EVENT_ADVISORY, null, null, false);
        }
        if (this.sco.getStateAdvisoryDefinitions().size() > 0 && !this.isBoundEventId("advisory.service.notif")) {
            this.bindProducerForSystem("advisory.service.notif");
            this.addSourceEventFlow("advisory.service.notif", EventFlowEntity.SERVICE_EVENT_ADVISORY, null, null, false);
        }
        if (this.sco.getMetrics().size() > 0 && !this.isBoundEventId("advisory.service.metric")) {
            this.bindProducerForSystem("advisory.service.metric");
            this.addSourceEventFlow("advisory.service.metric", EventFlowEntity.SERVICE_EVENT_ADVISORY, null, null, false);
        }
    }

    protected ServiceConfigurationObject loadSco() throws ServiceContextException {
        try {
            ServiceConfigurationObject configuration = ServiceConfigurationFactory.loadConfigurationObject(this, this.getName(), this.getType(), false);
            if (!configuration.existsException("exception.service.Framework")) {
                configuration.addException("exception.service.Framework");
            }
            for (EventHandler handler : configuration.getEventHandlers()) {
                MetricDefinition metric = new MetricDefinition(InvokeDelegate.getMethodCallCounterMetric(handler));
                metric.setIncrementUnits(1L);
                configuration.addMetric(metric);
            }
            return (ServiceConfigurationObject)new GlobalVariablesResolverImpl(this.globalVariables).resolveVariables(configuration);
        }
        catch (Exception exception) {
            throw new ServiceContextException(6065, "Loading SCO failed.", exception);
        }
    }

    public void sendRuntimeAdvisory(String message) {
        try {
            this.context.raiseRuntimeAdvisory(new RuntimeAdvisory(message));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    public void sendStateChangeAdvisory() {
        if (this.dispatcher != null) {
            try {
                ComponentStateChangeAdvisory advisory = new ComponentStateChangeAdvisory();
                advisory.setState(this.state);
                advisory.setMessage("Service '" + this.getType() + "." + this.getName() + "' state changed to " + this.state.name() + ".");
                this.dispatcher.raiseSystemAdvisory(advisory, EventScope.INHERITED);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    protected SemanticTypeCache getSemanticTypeCache() {
        return this.typeCache;
    }

    @Override
    public EventIdentityPlugin getIdentityPlugin() {
        return this.servicePool.getCurrentEIM();
    }

    @Override
    public MacroProcessor getMacroProcessor() {
        return this.servicePool.getMacroProcessor();
    }

    public ServicePool getServicePool() {
        return this.servicePool;
    }

    protected boolean hasIdentityManager() {
        return this.useEIM;
    }

    protected SemanticLexiconProcessorHolder<ServiceLexiconProcessor> getLexiconProcessorHolder() {
        return this.lexiconProcessorHolder;
    }

    @Override
    public ServiceContext getCallable() {
        return this;
    }

    @Override
    public ServiceConfigurationObject getServiceConfiguration() {
        return this.sco;
    }

    @Override
    public MetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public StateAdvisoryFactory getNotificationsFactory() {
        return this.notificationsFactory;
    }

    @Override
    public void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    @Override
    public boolean isContainerFor(Service compareService) {
        return this.servicePool != null && this.servicePool.isInPool(compareService);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger instanceof ServiceLogger ? logger : new LoggerDelegate(logger);
    }

    @Override
    public void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.logDebug(msg);
        }
    }

    @Override
    public void logInfo(String msg) {
        if (this.logger != null) {
            this.logger.logInfo(msg);
        }
    }

    @Override
    public void logError(String msg) {
        if (this.logger != null) {
            this.logger.logError(msg);
        }
    }

    protected void createServicePool() throws ServiceContextException {
        Object value;
        this.logDebug("Creating Service pool...");
        String className = this.sco.getServiceClassName();
        this.logDebug("Service bean class name: " + className + ".");
        try {
            this.serviceClass = ClassUtils.loadClass(className, this.manifestManager.getManifestClassLoader());
        }
        catch (ClassNotFoundException error) {
            throw new ServiceContextException(6065, "Loading service class '" + className + "' failed.");
        }
        if (this.sco.isInterruptableService() && !CancellableService.class.isAssignableFrom(this.serviceClass)) {
            throw new ServiceContextException(6065, "Service is interruptable but does not implement CancellableService interface.");
        }
        if (this.sco.isDaemonService() && !DaemonService.class.isAssignableFrom(this.serviceClass)) {
            throw new ServiceContextException(6065, "Service is a daemon but does not implement DaemonService interface.");
        }
        ConfigurationProperty property = this.sco.getAdvancedProperty("servicePoolSize");
        if (property != null && (value = property.getValue()) instanceof Long) {
            this.servicePoolSize = ((Long)value).intValue();
        }
        if (this.servicePoolSize <= 0) {
            throw new ServiceContextException(6065, "Service pool size must be positive.");
        }
        EventIdentityPlugin eimPlugin = null;
        if (this.sco.hasEIMPlugin()) {
            eimPlugin = this.initEventIdentityManager();
        }
        this.servicePool = new ServicePool(this.servicePoolSize, this.serviceClass, eimPlugin);
        this.logDebug("Service pool created.");
    }

    @Override
    public List<String> listSinkEvents() {
        return this.sco.listSinkEvents();
    }

    @Override
    public boolean hasSinkEvents() {
        return this.sco.hasSinkEvents();
    }

    @Override
    public boolean existsEventHandler(String handlerName) {
        return this.sco.existsEventHandler(handlerName);
    }

    private void setEventIdToActionable(ImmutableEventDatagram event) throws FabricEventSourceException {
        try {
            FabricEventSourceFactoryImpl.setEventId(event, "e.action." + event.getEventId());
        }
        catch (SDOFormatException error) {
            Trace.logException(this, error, true);
        }
    }

    @Override
    public void raiseAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        if (event instanceof StateAdvisory) {
            this.raiseNotification((StateAdvisory)event);
        } else if (event instanceof MetricAdvisory) {
            this.raiseMetricAdvisory((MetricAdvisory)event);
        } else {
            Trace.logDebug(ServiceContextImpl.class, "raiseAdvisory(" + event.getEventId() + ")");
            if (!this.sco.listAdvisories().contains(event.getEventId())) {
                throw new FabricEventSourceException(6051, "Event prototype [" + event.getEventId() + "] does not exist in the advisories registry.");
            }
            if (event instanceof ConnectionStateChangeAdvisory) {
                this.dispatcher.raiseSystemAdvisory(event, EventScope.INHERITED);
            } else {
                this.dispatcher.raiseAdvisory(event, EventScope.INHERITED);
            }
            try {
                FabricEventSinkFactoryImpl.reset(event);
                this.setEventIdToActionable(event);
                this.dispatcher.raiseActionableEvent(event, 0L);
            }
            catch (FabricEventSinkException error) {
                Trace.logException(this, error, true);
            }
        }
    }

    public void raiseNotification(StateAdvisory event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "raiseNotification(" + String.valueOf((Object)event.getType()) + ")");
        this.dispatcher.raiseSystemAdvisory(event, EventScope.INHERITED);
        FabricEventSinkFactoryImpl.reset(event);
        this.setEventIdToActionable(event);
        this.dispatcher.raiseActionableEvent(event, 0L);
    }

    public void raiseMetricAdvisory(MetricAdvisory event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "raiseMetricAdvisory(" + event.getName() + ")");
        this.dispatcher.raiseSystemAdvisory(event, EventScope.INHERITED);
        FabricEventSinkFactoryImpl.reset(event);
        this.setEventIdToActionable(event);
        this.dispatcher.raiseActionableEvent(event, 0L);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, long timeToLive) throws FabricEventSourceException, FabricEventException {
        if (!this.sco.existsActionableEvent(event.getEventId())) {
            throw new FabricEventSourceException(6051, "Event prototype [" + event.getEventId() + "] does not exist in the actionable events registry.");
        }
        if (event instanceof EventDatagram) {
            if (this.useEIM) {
                EventIdentityPlugin currentEIM = this.servicePool.getCurrentEIM();
                if (currentEIM == null) {
                    currentEIM = this.servicePool.getDefaultEIM();
                }
                if (currentEIM != null) {
                    currentEIM.setDatagramIdentity((EventDatagram)event);
                } else {
                    this.logDebug("EIM is not available. Event Identity information is not set to outgoing event [" + event.getEventId() + "].");
                }
            }
            this.setEventIdToActionable(event);
        }
        this.dispatcher.raiseActionableEvent(event, timeToLive);
    }

    @Override
    public void raiseAcknowledgement(AcknowledgementEvent event, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "raiseAcknowledgement(" + event.getEventId() + ")");
        this.dispatcher.raiseAcknowledgement(event, EventScope.INHERITED, timeToLive);
    }

    @Override
    public void acknowledgeEvent(EventDatagram sourceEvent, boolean withSourceData, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "acknowledgeEvent(" + sourceEvent.getEventId() + "):WithSourceData=" + withSourceData + "; AcknowledgeAction=" + String.valueOf((Object)action) + "; RecipientId=" + recipientId);
        this.dispatcher.acknowledgeEvent(sourceEvent, withSourceData, action, recipientId, EventScope.LOCAL, timeToLive);
    }

    @Override
    public void acknowledgeException(ExceptionEventDatagram event, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "acknowledgeException(" + event.getEventId() + "):AcknowledgeAction=" + String.valueOf((Object)action) + "; RecipientId=" + recipientId);
        this.dispatcher.acknowledgeException(event, action, recipientId, EventScope.LOCAL, timeToLive);
    }

    @Override
    public void acknowledgeAndForward(EventDatagram sourceEvent, boolean withSourceData, AcknowledgeAction action, String recipientId, long timeToLive) throws FabricEventSourceException {
        Trace.logDebug(ServiceContextImpl.class, "acknowledgeAndForward(" + sourceEvent.getEventId() + "):WithSourceData=" + withSourceData + "; AcknowledgeAction=" + String.valueOf((Object)action) + "; RecipientId=" + recipientId);
        this.dispatcher.acknowledgeAndForward(sourceEvent, withSourceData, action, recipientId, timeToLive);
    }

    @Override
    public AcknowledgementEvent raiseRequest(EventDatagram requestEvent, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Trace.logDebug(ServiceContextImpl.class, "raiseRequest(" + requestEvent.getEventId() + "): DistributionStrategy= " + distributionStrategy.toString() + "; MatchStrategy=" + matchStrategy.toString());
        if (!this.sco.existsActionableEvent(requestEvent.getEventId())) {
            throw new FabricEventSourceException(6051, "Event prototype [" + requestEvent.getEventId() + "] does not exist in the actionable events registry.");
        }
        if (requestEvent instanceof EventDatagram) {
            if (this.useEIM) {
                EventIdentityPlugin currentEIM = this.servicePool.getCurrentEIM();
                if (currentEIM != null) {
                    currentEIM.setDatagramIdentity(requestEvent);
                } else {
                    this.logDebug("EIM is not available. Event Identity information is not set to outgoing event [" + requestEvent.getEventId() + "].");
                }
            }
            this.setEventIdToActionable(requestEvent);
        }
        return this.dispatcher.raiseActionableRequest(requestEvent, distributionStrategy, matchStrategy, timeout);
    }

    @Override
    void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        if ("advisory.connection.StateChange".equals(eventId)) {
            this.boundEventIds.bindEventId(eventId, true, false);
        } else if ("advisory.component.StateChange".equals(eventId)) {
            this.boundEventIds.bindEventId(eventId, true, false);
        } else {
            this.boundEventIds.bindEventId(eventId, false, false);
        }
    }

    @Override
    void unbindProducerFor(String eventId) {
        this.boundEventIds.unbindEventId(eventId, false);
    }

    @Override
    public AccessorsPool getAccessorsPool() {
        return super.getAccessorsPool();
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return super.createDataspaceAccessor(dataspaceType, dataspaceName);
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return super.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String serviceType, String serviceName) throws FabricComponentAccessorException {
        return super.createServiceAccessor(serviceType, serviceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws FabricComponentAccessorException {
        return super.createServiceAccessor(nodeName, serviceType, serviceName);
    }

    @Override
    public List<String> listActionableEvents() {
        return this.sco.listActionableEvents();
    }

    @Override
    public boolean hasActionableEvents() {
        return this.sco.hasActionableEvents();
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        return this.sco.existsActionableEvent(eventId);
    }

    @Override
    public List<String> listEventHandlers() {
        return this.sco.listEventHandlers();
    }

    @Override
    public EventHandler getEventHandler(String name) throws ServiceConfigurationException {
        return this.sco.getEventHandler(name);
    }

    @Override
    public List<EventHandler> getEventHandlers() {
        return this.sco.getEventHandlers();
    }

    @Override
    public List<String> listAdvisories() {
        return this.sco.listAdvisories();
    }

    @Override
    public boolean hasAdvisories() {
        return this.sco.hasAdvisories();
    }

    @Override
    public boolean existsAdvisory(String eventId) {
        return this.sco.existsAdvisory(eventId);
    }

    @Override
    public void raiseException(ExceptionEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        if (!this.sco.listExceptions().contains(event.getEventId())) {
            throw new FabricEventSourceException(6051, "Event prototype [" + event.getEventId() + "] does not exist in the exception events registry.");
        }
        if (this.useEIM) {
            EventIdentityPlugin currentEIM = this.servicePool.getCurrentEIM();
            if (currentEIM != null) {
                currentEIM.setExceptionIdentity(event);
            } else {
                this.logDebug("EIM is not available. Event Identity information is not set on outgoing event [" + event.getEventId() + "].");
            }
        }
        this.setEventIdToActionable(event);
        this.dispatcher.raiseActionableEvent(event, 0L);
    }

    @Override
    public String getRuntimeContextName() {
        return this.context.getName();
    }

    @Override
    public ServiceStateAdvisoriesFactory getAdvisoriesFactory() {
        return this.notificationsFactory;
    }

    @Override
    public EventConsumer createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        return this.dispatcher.createActionableConsumer(consumerName, listener, eventFilter, eventSelector);
    }

    @Override
    public EventAsyncConsumer createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricEventDispatcherException {
        return this.dispatcher.createActionableAsyncConsumer(consumerName, listener, eventFilter, eventSelector);
    }

    @Override
    public void dropConsumer(String consumerName) throws FabricEventDispatcherException {
        this.dispatcher.dropConsumer(consumerName);
    }

    @Override
    public Moderator getModerator() {
        return this.moderator;
    }

    @Override
    void initSecurityManager() throws Exception {
    }

    @Override
    public SecurityManager getSecurityManager() throws SecurityManagerException {
        try {
            return super.getSecurityManager();
        }
        catch (Exception exception) {
            if (exception instanceof SecurityManagerException) {
                throw (SecurityManagerException)exception;
            }
            throw new SecurityManagerException(6011, (Throwable)exception);
        }
    }

    Map<String, InvokeDelegate> getInvokeDelegates() {
        return this.invokeDelegates;
    }

    FilterMap<InvokeDelegate> getInvokeDelegatesByEventId() {
        return this.invokeDelegatesByEventId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setState(ComponentState state) {
        Object object = this.stateChangeMutex;
        synchronized (object) {
            if (this.state != ComponentState.SUSPECT) {
                this.state = state;
            } else {
                this.originalState = state;
            }
            this.sendStateChangeAdvisory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuspectState(SuspectState.SuspectStateOriginator originator, String lastError) {
        Object object = this.stateChangeMutex;
        synchronized (object) {
            if (!this.state.isRunning()) {
                return;
            }
            if (this.state == ComponentState.OUTSYNC) {
                return;
            }
            if (this.suspectState.setSuspectState(originator, lastError)) {
                this.logInfo("Set state to SUSPECT, originator: " + String.valueOf(originator) + ", state before : " + String.valueOf((Object)this.state));
            }
            if (this.state != ComponentState.SUSPECT) {
                this.originalState = this.state;
                this.state = ComponentState.SUSPECT;
                this.sendStateChangeAdvisory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSuspectState(SuspectState.SuspectStateOriginator originator) {
        Object object = this.stateChangeMutex;
        synchronized (object) {
            if (this.suspectState.resetSuspectState(originator)) {
                this.logInfo("Reset SUSPECT state, originator: " + String.valueOf(originator));
            }
            if (!this.suspectState.isSuspect() && this.state == ComponentState.SUSPECT) {
                this.logInfo("Reset SUSPECT state to " + String.valueOf((Object)this.originalState));
                this.state = this.originalState;
                this.sendStateChangeAdvisory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSuspectState() {
        Object object = this.stateChangeMutex;
        synchronized (object) {
            this.suspectState.reset();
            if (this.state == ComponentState.SUSPECT) {
                this.state = this.originalState;
                this.sendStateChangeAdvisory();
            }
        }
    }

    protected ServiceConfigurationProperty assertPropertyExistenceAndType(String propertyName, ServicePropertyType type) throws ServiceConfigurationException {
        ServiceConfigurationProperty property = this.sco.getProperty(propertyName);
        if (property.getType() != type) {
            throw new ServiceConfigurationException("Invalid property '" + propertyName + "' type. Expected '" + String.valueOf((Object)type) + "', but actual '" + String.valueOf((Object)property.getType()) + "'.");
        }
        return property;
    }

    protected ConfigurationProperty assertAdvancedPropertyExistenceAndType(String propertyName, Class<?> type) throws ServiceConfigurationException {
        ConfigurationProperty propertyValue = this.sco.getAdvancedProperty(propertyName);
        if (propertyValue == null) {
            throw new ServiceConfigurationException("Advanced service property '" + propertyName + "' does not exist.");
        }
        if (!propertyValue.getValueClass().equals(type)) {
            throw new ServiceConfigurationException("Invalid advanced property '" + propertyName + "' type. Expected '" + type.getSimpleName() + "', but actual '" + propertyValue.getValueClass().getSimpleName() + "'.");
        }
        return propertyValue;
    }

    @Override
    public boolean existsAdvancedProperty(String property) {
        return this.sco.existsAdvancedProperty(property);
    }

    @Override
    public String lookupAdvancedTextProperty(String property) throws ServiceConfigurationException {
        return (String)this.assertAdvancedPropertyExistenceAndType(property, String.class).getValue();
    }

    @Override
    public Long lookupAdvancedNumericProperty(String property) throws ServiceConfigurationException {
        return (Long)this.assertAdvancedPropertyExistenceAndType(property, Long.class).getValue();
    }

    @Override
    public Boolean lookupAdvancedBooleanProperty(String property) throws ServiceConfigurationException {
        return (Boolean)this.assertAdvancedPropertyExistenceAndType(property, Boolean.class).getValue();
    }

    @Override
    public Boolean lookupBooleanProperty(String property) throws ServiceConfigurationException {
        return (Boolean)this.assertPropertyExistenceAndType(property, ServicePropertyType.BOOLEAN).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public Long lookupNumericProperty(String property) throws ServiceConfigurationException {
        return (Long)this.assertPropertyExistenceAndType(property, ServicePropertyType.NUMERIC).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public Double lookupDecimalProperty(String property) throws ServiceConfigurationException {
        return (Double)this.assertPropertyExistenceAndType(property, ServicePropertyType.DECIMAL).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public String lookupPasswordProperty(String property) throws ServiceConfigurationException {
        ServiceConfigurationProperty propertyValue = this.sco.getProperty(property);
        if (propertyValue.getType() == ServicePropertyType.PASSWORD) {
            Object value = propertyValue.getValue();
            if (value == null) {
                throw new ServiceConfigurationException("Property '" + property + "' value is not set. Unable to retrieve password value.");
            }
            String password = ((PasswordPropertyValue)value).getPassword();
            if (MacroProcessor.isGlobalVariable(password)) {
                password = this.servicePool.getMacroProcessor().process(password);
                password = new String(Base64.decode(password));
            }
            return password;
        }
        if (propertyValue.getType() == ServicePropertyType.STRING) {
            Object value = propertyValue.getValue();
            if (value == null) {
                throw new ServiceConfigurationException("Property '" + property + "' value is not set. Unable to retrieve password value.");
            }
            if (MacroProcessor.isGlobalVariable((String)value)) {
                value = this.servicePool.getMacroProcessor().process((String)value);
            }
            return new String(Base64.decode((String)value));
        }
        throw new ServiceConfigurationException("Invalid property '" + property + "' type. Expected 'PASSWORD' or 'STRING', but actual '" + String.valueOf((Object)propertyValue.getType()) + "'.");
    }

    @Override
    public boolean existsProperty(String property) {
        return this.sco.hasProperty(property);
    }

    @Override
    public String lookupStringProperty(String property) throws ServiceConfigurationException {
        return (String)this.assertPropertyExistenceAndType(property, ServicePropertyType.STRING).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public String lookupEnumProperty(String property) throws ServiceConfigurationException {
        return (String)this.assertPropertyExistenceAndType(property, ServicePropertyType.ENUMERATION).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public ObjectPropertyValue lookupObjectProperty(String property) throws ServiceConfigurationException {
        return (ObjectPropertyValue)this.assertPropertyExistenceAndType(property, ServicePropertyType.OBJECT).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public Hashtable<String, ServiceConfigurationProperty> lookupTableProperty(String property) throws ServiceConfigurationException {
        return (Hashtable)this.assertPropertyExistenceAndType(property, ServicePropertyType.TABLE).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public List<ServiceConfigurationProperty> lookupListProperty(String property) throws ServiceConfigurationException {
        return (List)this.assertPropertyExistenceAndType(property, ServicePropertyType.LIST).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public TransportFactory lookupTransportFactoryProperty(String property) throws ServiceConfigurationException {
        try {
            TransportFactoryPropertyValue factory = (TransportFactoryPropertyValue)this.assertPropertyExistenceAndType(property, ServicePropertyType.TRANSPORT_FACTORY).getValue();
            if (factory != null) {
                this.loadFactoryPackage(PackageType.transport, factory);
                TransportFactory transportFactory = TransportConfigurationFactory.loadFactoryObject(this, factory.getFactoryName(), factory.getFactoryType(), false);
                return new GlobalVariablesResolverImpl(this.globalVariables).resolveVariables(transportFactory);
            }
            return null;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new ServiceConfigurationException("Unable to initialize TRANSPORT Factory property '" + property + "'. " + error.getMessage());
        }
    }

    @Override
    public ClientFactory lookupClientFactoryProperty(String property) throws ServiceConfigurationException {
        try {
            ClientFactoryPropertyValue factory = (ClientFactoryPropertyValue)this.assertPropertyExistenceAndType(property, ServicePropertyType.CLIENT_FACTORY).getValue();
            if (factory != null) {
                this.loadFactoryPackage(PackageType.client, factory);
                ClientFactory clientFactory = ClientConfigurationFactory.loadFactoryObject(this, factory.getFactoryName(), factory.getFactoryType(), false);
                return new GlobalVariablesResolverImpl(this.globalVariables).resolveVariables(clientFactory);
            }
            return null;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new ServiceConfigurationException("Unable to initialize CLIENT Factory property '" + property + "'. " + error.getMessage());
        }
    }

    private void loadFactoryPackage(PackageType type, AbstractFactoryPropertyValue factory) throws Exception {
        if (PackageStore.existsPackage(type, factory.getFactoryType())) {
            this.logInfo("Package '" + String.valueOf((Object)type) + "." + factory.getFactoryType() + "' found for " + StringUtils.toCapitalized(type.name()) + " Factory '" + String.valueOf(factory) + "'.");
            PackageStore.beginXact(this);
            Package pkg = PackageStore.loadPackage(type, factory.getFactoryType());
            if (!this.manifestManager.getLoaderRegistry().isPackageRegistered(pkg.getFullName())) {
                this.manifestManager.getLoaderRegistry().registerClassLoader(pkg, PackageStore.loadPackageURLs(pkg), true, true);
            }
            PackageStore.commitXact();
        } else {
            this.logInfo("Specific package for " + StringUtils.toCapitalized(type.name()) + " Factory '" + String.valueOf(factory) + "' not found.");
        }
    }

    @Override
    public JDBCFactory lookupJdbcFactoryProperty(String property) throws ServiceConfigurationException {
        try {
            JDBCFactoryPropertyValue factory = (JDBCFactoryPropertyValue)this.assertPropertyExistenceAndType(property, ServicePropertyType.JDBC_FACTORY).getValue();
            return factory != null ? JDBCConfigurationFactory.getJDBCFactory(this, factory.getFactoryName(), factory.getFactoryType()) : null;
        }
        catch (Exception error) {
            Trace.logException(this, error, true);
            throw new ServiceConfigurationException("Unable to initialize JDBC Factory property '" + property + "'. " + error.getMessage());
        }
    }

    @Override
    public boolean hasEventProperty(String property) throws ServiceConfigurationException {
        ImmutableEventDatagram event = this.servicePool.getEvent();
        if (event instanceof IAbstractDataEvent) {
            try {
                return ((IAbstractDataEvent)event).existsEventProperty(property);
            }
            catch (SDOException error) {
                throw new ServiceConfigurationException(error);
            }
        }
        return false;
    }

    @Override
    public String lookupEventProperty(String property) throws ServiceConfigurationException {
        ImmutableEventDatagram event = this.servicePool.getEvent();
        if (event instanceof IAbstractDataEvent) {
            try {
                return ((IAbstractDataEvent)event).getEventStringProperty(property);
            }
            catch (SDOException error) {
                throw new ServiceConfigurationException(error);
            }
        }
        return null;
    }

    @Override
    public String lookupEventCorrelationId() {
        ImmutableEventDatagram event = this.servicePool.getEvent();
        if (event instanceof IAbstractDataEvent) {
            return ((IAbstractDataEvent)event).getCorrelationId();
        }
        return null;
    }

    @Override
    public String lookupEventKey() {
        ImmutableEventDatagram event = this.servicePool.getEvent();
        if (event instanceof IAbstractDataEvent) {
            return ((IAbstractDataEvent)event).getEventKey();
        }
        return null;
    }

    @Override
    public String lookupEventGroupId() {
        ImmutableEventDatagram event = this.servicePool.getEvent();
        if (event instanceof IAbstractDataEvent) {
            return ((IAbstractDataEvent)event).getEventGroupId();
        }
        return null;
    }

    private void loadPackageManifest() throws ServiceContextException {
        try {
            this.manifestManager.doLoadManifest();
            String pkgName = this.getPackageName();
            if (!this.manifestManager.existsPackage(pkgName)) {
                RepositoryAccessor accessor = this.context.getRepositoryAccessor();
                if (!accessor.existsPackage(PackageType.service, this.getType())) {
                    Trace.logInfo(ServiceContextImpl.class, "WARNING: Service package '" + this.getPackageName() + "' does not exist. Creating empty package...");
                    accessor.addPackage(Package.create(PackageType.service, this.getType()));
                }
                PackageDescriptor descriptor = PackageDescriptor.create(accessor.getPackage(PackageType.service, this.getType()), true);
                this.manifestManager.manifest.add(descriptor);
                this.manifestManager.doSaveManifest();
            }
            this.manifestManager.doInit();
        }
        catch (Exception exception) {
            throw new ServiceContextException(6065, "Loading Service Package Manifest failed.", exception);
        }
    }

    private void loadServiceClass() throws ServiceContextException {
        this.logDebug("Service bean class name: " + this.sco.getServiceClassName() + ".");
        try {
            this.serviceClass = ClassUtils.loadClass(this.sco.getServiceClassName(), this.manifestManager.getManifestClassLoader());
        }
        catch (ClassNotFoundException exception) {
            throw new ServiceContextException(6065, "Loading service class '" + this.sco.getServiceClassName() + "' failed.");
        }
    }

    private void unloadPackageManifest() throws ServiceContextException {
        if (this.manifestManager != null) {
            this.manifestManager.destroy();
        }
    }

    private String getPackageName() {
        return Package.getFullName(PackageType.service, this.getType());
    }

    @Override
    public ServicePropertyType getPropertyType(String propertyName) throws ServiceConfigurationException {
        return this.sco.getProperty(propertyName).getType();
    }

    @Override
    public Object lookupProperty(String propertyName) throws ServiceConfigurationException {
        return this.sco.getProperty(propertyName).resolveValue(this.servicePool.getMacroProcessor());
    }

    @Override
    public ImmutableEventDatagram createResponseEvent(String methodName) throws ServiceConfigurationException {
        for (EventHandler handler : this.sco.getEventHandlers()) {
            if (!handler.getMethodName().equals(methodName)) continue;
            String eventId = handler.getResponseEventId();
            Prototype eventPrototype = RuntimeContext.getInstance().getDatagramPrototypeCache().lookupPrototype(eventId);
            if (eventPrototype == null) {
                throw new ServiceConfigurationException("Specified prototype '" + eventId + "' does not exist.");
            }
            DatagramFactory factory = RuntimeContext.getInstance().getDatagramFactoryManager().lookupDatagramFactoryByModel(eventPrototype.getModelName());
            if (factory == null) {
                throw new ServiceConfigurationException("Unable to resolve Datagram Factory for specified prototype '" + String.valueOf(eventPrototype) + "'.");
            }
            try {
                return factory.createEvent(eventId);
            }
            catch (Exception error) {
                Trace.logError(EventPrototypeComparator.class, error.getMessage());
                throw new ServiceConfigurationException(error);
            }
        }
        return null;
    }

    @Override
    public void cancel() throws ServiceContextException {
        if (!this.sco.isInterruptableService()) {
            throw new ServiceContextException(6002, "Non interruptable service cannot be canceled.");
        }
        if (!this.isRunning()) {
            throw new ServiceContextException(6002, "Not running service cannot be canceled.");
        }
        if (this.servicePool != null) {
            this.servicePool.cancelOperation();
            this.sendCancelNotification(false);
        }
    }

    void cancel(Service service) throws ServiceFrameworkException {
        if (!this.sco.isInterruptableService()) {
            this.logError("Non interruptable service cannot be canceled.");
            return;
        }
        ((CancellableService)service).cancel();
        this.sendCancelNotification(true);
    }

    private void sendCancelNotification(boolean isSingleService) {
        try {
            StateAdvisory cancelNotif = this.notificationsFactory.createAdvisory("Cancel");
            cancelNotif.setMessage("Service '" + this.getType() + "." + this.getName() + "' received cancel request.");
            this.raiseAdvisory(cancelNotif);
        }
        catch (Exception error) {
            this.logError("Service Context cancelled all current requests upon 'cancel' request. But unable to send out 'Cancel' notification. " + error.getMessage());
        }
    }

    void authenticate(User user) {
        if (this.securityContext == null) {
            this.bindUser(this.context.securityManagerImpl, user);
        } else if (!this.securityContext.getUser().getName().equals(user.getName())) {
            this.rebindUser(this.context.securityManagerImpl, user);
        }
    }

    @Override
    public Connection getJDBCConnection(String dataspaceName) throws SQLException {
        return this.context.getDataspaceManager().getJDBCConnection(dataspaceName, this.securityContext);
    }

    @Override
    void initIsSecurityEnabled() {
        this.isSecurityEnabled = this.context.isSecurityEnabled();
    }

    @Override
    public SLResponse onStatement(DSLStatement statement) throws Exception {
        return this.servicePool.onStatement(statement);
    }

    public boolean isRunning() {
        return this.state == ComponentState.OUTSYNC ? this.originalState.isRunning() : this.getState().isRunning();
    }

    private void initEventTriggers() throws ServiceConfigurationException {
        this.eventTriggerManager.initializeAndEnableEventTriggers();
    }

    private void unloadEventTriggers() {
        this.eventTriggerManager.unloadEventTriggers();
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        return this.eventTriggerManager.getEventTriggerData(triggerName);
    }

    @Override
    public List<String> listEventTriggers() {
        return this.eventTriggerManager.listEventTriggers();
    }

    @Override
    public boolean hasEventTriggers() {
        return this.eventTriggerManager.hasEventTriggers();
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        return this.eventTriggerManager.existsEventTrigger(triggerName);
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        return this.eventTriggerManager.getEventTriggerDefinition(triggerName);
    }

    @Override
    public synchronized void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.eventTriggerManager.addEventTrigger(triggerSyntax);
    }

    @Override
    public synchronized void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.eventTriggerManager.alterEventTrigger(triggerSyntax);
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        return this.eventTriggerManager.getEventTriggerDefinitions();
    }

    @Override
    public synchronized void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.eventTriggerManager.removeEventTrigger(triggerName);
    }

    @Override
    public synchronized void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        this.eventTriggerManager.removeAllEventTriggers();
    }

    @Override
    public synchronized void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        this.eventTriggerManager.compileEventTrigger(triggerName);
    }

    @Override
    public synchronized void enableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.eventTriggerManager.enableEventTrigger(triggerName);
    }

    @Override
    public synchronized void disableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.eventTriggerManager.disableEventTrigger(triggerName);
    }

    @Override
    public String getLastError(String triggerName) {
        return this.eventTriggerManager.getLastError(triggerName);
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        return this.eventTriggerManager.getTriggerActionTime(triggerName);
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        return this.eventTriggerManager.getTriggerState(triggerName);
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        return this.eventTriggerManager.getEventTriggerSyntax(triggerName);
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        return this.eventTriggerManager.isEventTriggerAutoEnable(triggerName);
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        this.eventTriggerManager.setEventTriggerAutoEnable(triggerName, autoEnable);
    }

    @Override
    public List<ActiveEvent> listActiveEvents() {
        ActiveEvent activeEvent;
        ArrayList<ActiveEvent> result = new ArrayList<ActiveEvent>();
        for (EventHandler eventHandler : this.getEventHandlers()) {
            if (eventHandler.getRequestEventId() == null || eventHandler.getRequestEventId().length() <= 0) continue;
            activeEvent = new ActiveEvent(eventHandler.getRequestEventId());
            activeEvent.setType(ActiveEvent.ActiveEventType.Sink);
            activeEvent.setEventScope(null);
            if (eventHandler.getRequestSelector() != null && eventHandler.getRequestSelector().length() > 0) {
                activeEvent.setSelector(eventHandler.getRequestSelector());
            }
            this.resolveActiveEventModel(activeEvent);
            result.add(activeEvent);
        }
        this.listActionableActiveEventsFor(this.listActionableEvents(), result);
        this.listActionableActiveEventsFor(this.sco.listExceptions(), result);
        this.listActionableActiveEventsFor(this.sco.listAdvisories(), result);
        for (EventTriggerDefinition definition : this.eventTriggerManager.getEventTriggerDefinitions()) {
            if (!(definition instanceof EventTriggerCompiledDefinition)) continue;
            EventTriggerCompiledDefinition compiledDefinition = (EventTriggerCompiledDefinition)definition;
            for (String eventId : compiledDefinition.getRaisedEventIds()) {
                ActiveEvent activeEvent2 = new ActiveEvent(eventId);
                if (this.sco.listExceptions().contains(eventId)) {
                    activeEvent2.setType(ActiveEvent.ActiveEventType.Exception);
                } else {
                    activeEvent2.setType(ActiveEvent.ActiveEventType.Source);
                }
                activeEvent2.setEventScope(definition.getEventScope());
                this.resolveActiveEventModel(activeEvent2);
                result.add(activeEvent2);
            }
            List<String> usedEventIds = compiledDefinition.getUsedEventIds();
            usedEventIds.removeAll(compiledDefinition.getRaisedEventIds());
            if (compiledDefinition.getActionableEventId() != null) {
                usedEventIds.remove(compiledDefinition.getActionableEventId());
            }
            for (ActiveEvent activeEvent2 : result) {
                usedEventIds.remove(activeEvent2.getEventId());
            }
            for (String eventId : usedEventIds) {
                ActiveEvent activeEvent3 = new ActiveEvent(eventId);
                activeEvent3.setType(ActiveEvent.ActiveEventType.None);
                this.resolveActiveEventModel(activeEvent3);
                result.add(activeEvent3);
            }
        }
        for (String advisory : this.sco.listAdvisories()) {
            activeEvent = new ActiveEvent(advisory);
            activeEvent.setType(ActiveEvent.ActiveEventType.Advisory);
            activeEvent.setEventScope(EventScope.INHERITED);
            this.resolveActiveEventModel(activeEvent);
            result.add(activeEvent);
        }
        return result;
    }

    private void listActionableActiveEventsFor(List<String> events, List<ActiveEvent> result) {
        Function<String, ActiveEvent> newActionableLocalActiveEvent = actionableEvent -> {
            ActiveEvent activeEvent = new ActiveEvent((String)actionableEvent);
            activeEvent.setType(ActiveEvent.ActiveEventType.Actionable);
            activeEvent.setEventScope(EventScope.LOCAL);
            return activeEvent;
        };
        for (String actionableEvent2 : events) {
            ActiveEvent activeEvent = null;
            for (EventTriggerDefinition definition : this.eventTriggerManager.getEventTriggerDefinitions()) {
                if (definition.getActionableEventId() == null || !definition.getActionableEventId().equals(actionableEvent2)) continue;
                activeEvent = newActionableLocalActiveEvent.apply(actionableEvent2);
                activeEvent.setTrigger(definition.getName());
                if (definition.getEventSelector() != null && definition.getEventSelector().length() > 0) {
                    activeEvent.setSelector(definition.getEventSelector());
                }
                this.resolveActiveEventModel(activeEvent);
                result.add(activeEvent);
            }
            if (activeEvent != null) continue;
            activeEvent = newActionableLocalActiveEvent.apply(actionableEvent2);
            this.resolveActiveEventModel(activeEvent);
            result.add(activeEvent);
        }
    }

    private void resolveActiveEventModel(ActiveEvent activeEvent) {
        String eventModel = "Unknown";
        try {
            eventModel = this.context.getDatagramPrototypeCache().getModel(activeEvent.getEventId());
        }
        catch (DatagramFactoryException e) {
            this.logError("Event model not found for event [" + activeEvent.getEventId() + "]. Cause: " + e.getMessage());
        }
        activeEvent.setEventModel(eventModel);
    }

    private void validatePrototypesTriggersAndHandlers() {
        this.logInfo("Validating event prototypes...");
        LinkedList<String> errors = new LinkedList<String>();
        boolean serviceStatus = true;
        try {
            this.serviceClass.newInstance();
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, false);
            this.logError("Creating Service class instance failed.", errors);
            serviceStatus = false;
        }
        boolean status = true;
        for (String eventId : this.sco.listActionableEvents()) {
            status &= this.validateEventPrototype("Actionable", eventId, errors);
        }
        for (String eventId : this.sco.listExceptions()) {
            status &= this.validateEventPrototype("Exception", eventId, errors);
        }
        for (String eventId : this.sco.listAdvisories()) {
            status &= this.validateEventPrototype("Advisory", eventId, errors);
        }
        for (EventHandler handler : this.getEventHandlers()) {
            status &= this.validateEventPrototype("Handler '" + handler.getHandlerName() + "' request event id ", handler.getRequestEventId(), errors);
            status &= this.validateEventPrototype("Handler '" + handler.getHandlerName() + "' response event id ", handler.getResponseEventId(), errors);
        }
        if (!serviceStatus || !status) {
            if (!status) {
                this.logError("Validation of service event prototypes failed.", errors);
            }
            this.descriptor.setLastError(String.join((CharSequence)"\n", errors));
            this.logError("Set to PENDING state. Reload the service to recover from PENDING state.");
            this.setState(ComponentState.PENDING);
        } else {
            this.logInfo("Event prototypes validated.");
        }
    }

    private void setToPendingState() {
        this.logError("Set to PENDING state. Reload the service to recover from PENDING state.");
        this.setState(ComponentState.PENDING);
    }

    private boolean validateEventPrototype(String name, String eventId, List<String> errors) {
        if (eventId == null || eventId.isEmpty()) {
            return true;
        }
        Prototype prototype = this.context.getDatagramPrototypeCache().lookupPrototype(eventId);
        if (prototype == null) {
            this.logError(name + " event [" + eventId + "] prototype does not exist.", errors);
            return false;
        }
        if (!prototype.isValid()) {
            this.logError(name + " event [" + eventId + "] prototype is invalid.", errors);
            return false;
        }
        return true;
    }

    private void logError(String error, List<String> errors) {
        this.logError(error);
        errors.add(error);
    }

    private void registerOutsyncHandler() throws FabricEventDispatcherException {
        this.dispatcher.createHiddenEventConsumer("ServiceOutsyncHandler", new OutsyncHandler(), "advisory.repository.ArtifactChange", null);
    }

    private void unregisterOutsyncHandler() throws FabricEventDispatcherException {
        if (this.dispatcher != null) {
            this.dispatcher.dropSystemConsumer("ServiceOutsyncHandler");
        }
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof ServiceMFSession;
    }

    @Override
    public String getStartupDir() {
        return this.context.getStartupDir();
    }

    public void updateSco(Consumer<ServiceConfigurationObject> updater) throws ServiceConfigurationException {
        ServiceConfigurationObject scoForSave = ServiceConfigurationFactory.loadConfigurationObject(this, this.getName(), this.getType(), false);
        updater.accept(scoForSave);
        try {
            this.scoUpdate = true;
            ServiceConfigurationFactory.saveConfigurationObject(scoForSave);
            updater.accept(this.sco);
        }
        finally {
            this.scoUpdate = false;
        }
    }

    Class<?> getServiceClass() {
        Class result = this.serviceClass;
        if (result == null) {
            try {
                result = ClassUtils.loadClass(this.sco.getServiceClassName(), this.manifestManager.getManifestClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    String getFullNameInLocalNode() {
        return ModeratorUtils.makeComponentFullName(this.type, this.name);
    }

    private class LoggerDelegate
    implements Logger {
        private Logger logger;

        LoggerDelegate(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void logDebug(String message) {
            this.logger.logDebug(ServiceContextImpl.this.logPrefix + message);
        }

        @Override
        public void logInfo(String message) {
            this.logger.logInfo(ServiceContextImpl.this.logPrefix + message);
        }

        @Override
        public void logError(String message) {
            this.logger.logError(ServiceContextImpl.this.logPrefix + message);
        }
    }

    private class OutsyncHandler
    implements FabricEventListener {
        private OutsyncHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            RepositoryArtifactStateChangeAdvisory advisory = (RepositoryArtifactStateChangeAdvisory)event;
            if (!ServiceContextImpl.this.scoUpdate && advisory.getEntityType() == CachedEntity.SERVICE && advisory.getArtifactPath().endsWith(ServiceContextImpl.this.getType() + "." + ServiceContextImpl.this.getName() + ".sco")) {
                Object object = ServiceContextImpl.this.stateChangeMutex;
                synchronized (object) {
                    if (ServiceContextImpl.this.state != ComponentState.OUTSYNC) {
                        ServiceContextImpl.this.originalState = ServiceContextImpl.this.state;
                        ServiceContextImpl.this.setState(ComponentState.OUTSYNC);
                    }
                }
            }
        }
    }
}

