/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCacheImpl;
import com.streamscape.lib.filter.FilterMap;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.sys.Text;
import com.streamscape.sdo.utils.EIMObject;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.dispatcher.DirectServiceAccessor;
import com.streamscape.sef.dispatcher.InvokeDelegate;
import com.streamscape.sef.dispatcher.ParentAccessorHolder;
import com.streamscape.sef.dispatcher.SLServiceCall;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.dispatcher.ServiceMFSession;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class ServiceAccessorProxy
extends AbstractAccessorProxy {
    private ServiceContextImpl context;
    private ServiceMFSession session;
    private Map<String, InvokeDelegate> invokeDelegates;
    private FilterMap<InvokeDelegate> invokeDelegatesByEventId;

    ServiceAccessorProxy(String sessionName, String componentName, ComponentOwner owner, boolean isRouted, ServiceContextImpl context, String slSessionName, SLSessionData slSessionData) {
        super(context.getLexiconProcessorHolder());
        String defaultDataspaceName = null;
        ConfigurationProperty property = context.getServiceConfiguration().getAdvancedProperty("sessionDataspace");
        if (property != null && property.getValue() != null) {
            defaultDataspaceName = String.valueOf(property.getValue()).trim();
        }
        if (defaultDataspaceName == null || defaultDataspaceName.trim().isEmpty()) {
            defaultDataspaceName = "SDS";
        }
        this.context = context;
        this.session = new ServiceMFSession(sessionName, componentName, owner, isRouted, context.context, slSessionName, context.getFullName(), defaultDataspaceName);
        this.session.setSLSessionData(slSessionData);
        this.invokeDelegates = context.getInvokeDelegates();
        this.invokeDelegatesByEventId = context.getInvokeDelegatesByEventId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram request) throws FabricRequestException {
        DirectServiceAccessor direct = new DirectServiceAccessor(this);
        ParentAccessorHolder.setServiceAccessorIfNotSet(direct);
        try {
            ImmutableEventDatagram immutableEventDatagram = super.onRequest(request);
            return immutableEventDatagram;
        }
        finally {
            ParentAccessorHolder.resetServiceAccessor(direct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImmutableEventDatagram invokeDSLCompletionRequest(String command, MFSession session) throws Exception {
        DirectServiceAccessor direct = new DirectServiceAccessor(this);
        ParentAccessorHolder.setServiceAccessorIfNotSet(direct);
        try {
            ImmutableEventDatagram immutableEventDatagram = super.invokeDSLCompletionRequest(command, session);
            return immutableEventDatagram;
        }
        finally {
            ParentAccessorHolder.resetServiceAccessor(direct);
        }
    }

    @Override
    protected ImmutableEventDatagram invokeOtherRequest(ImmutableEventDatagram request) throws FabricRequestException {
        if (request.getEventId().equals("e.sys.sl.ServiceCall")) {
            return this.invokeOperation((OpaqueEvent)request);
        }
        try {
            List<InvokeDelegate> delegates = this.invokeDelegatesByEventId.get(request.getEventId());
            if (delegates == null) {
                throw new FabricComponentAccessorException(6106, "Event handler not found for event [" + request.getEventId() + "].");
            }
            if (delegates.size() != 1) {
                throw new FabricComponentAccessorException(6107, "Too many suitable event handlers found for event [" + request.getEventId() + "].");
            }
            return (ImmutableEventDatagram)delegates.get(0).onRequest(request, true);
        }
        catch (Throwable exception) {
            if (exception instanceof FabricRequestException) {
                throw (FabricRequestException)exception;
            }
            throw new FabricRequestException(exception);
        }
    }

    private OpaqueEvent invokeOperation(OpaqueEvent request) throws FabricRequestException {
        try {
            SLResponse response = new SLResponse();
            SLServiceCall call = (SLServiceCall)request.getData();
            switch (call.getOperation()) {
                case INVOKE_BY_EVENT_HANDLER: {
                    Object requestData;
                    String handlerName;
                    EventHandler eventHandler;
                    if (this.context.getState() != ComponentState.STARTED && this.context.getState() != ComponentState.SUSPECT) {
                        ServiceAccessorProxy.throwException(6078, "Service " + this.context.getFullName() + " is unavailable. State=" + String.valueOf((Object)this.context.getState()) + ".");
                    }
                    if (!(eventHandler = this.getEventHandler(handlerName = (String)call.getParameters()[0])).isValid()) {
                        ServiceAccessorProxy.throwException(6104, "Event handler '" + handlerName + "'" + this.inService() + " is invalid.");
                    }
                    if ((requestData = call.getParameters()[1]) == null) {
                        if (!eventHandler.getRequestSemanticType().equals("Void")) {
                            ServiceAccessorProxy.throwException(6004, "Request data for event handler '" + handlerName + "'" + this.inService() + " is null, but should be of type '" + eventHandler.getRequestSemanticType() + "'.");
                        }
                    } else {
                        SemanticType dataType = this.context.getSemanticTypeCache().lookupSemanticClass(requestData.getClass());
                        if (dataType == null) {
                            ServiceAccessorProxy.throwException(6024, "Semantic type not found for request data class '" + requestData.getClass().getName() + "' when invoking event handler '" + handlerName + "'" + this.inService() + ".");
                        }
                        if (!dataType.getTypeName().equals(eventHandler.getRequestSemanticType())) {
                            if (requestData.getClass() == Text.class) {
                                requestData = ((Text)requestData).getText();
                                dataType = this.context.getSemanticTypeCache().lookupSemanticClass(requestData.getClass());
                            }
                            if (!dataType.getTypeName().equals(eventHandler.getRequestSemanticType())) {
                                ServiceAccessorProxy.throwException(6024, "Request data type '" + dataType.getTypeName() + "' does not match with event handler '" + handlerName + "' request type '" + eventHandler.getRequestSemanticType() + "'" + this.inService() + ".");
                            }
                        }
                    }
                    boolean isEvent = requestData instanceof ImmutableEventDatagram;
                    if (!(requestData instanceof ImmutableEventDatagram) && eventHandler.getRequestEventId() != null && requestData != null && !eventHandler.getRequestSemanticType().equals("Void")) {
                        Map properties = null;
                        if (call.getParameters().length > 2 && call.getParameters()[2] instanceof Map) {
                            properties = (Map)call.getParameters()[2];
                        }
                        requestData = this.createRequestEvent(eventHandler.getRequestEventId(), requestData, properties);
                    }
                    if (call.getParameters().length > 2 && requestData instanceof ImmutableEventDatagram && call.getParameters()[2] instanceof EIMObject) {
                        this.setEIMData((ImmutableEventDatagram)requestData, (EIMObject)call.getParameters()[2]);
                    }
                    InvokeDelegate delegate = this.getInvokeDelegate(handlerName);
                    if (requestData instanceof ImmutableEventDatagram) {
                        response.setObject(delegate.onRequest((ImmutableEventDatagram)requestData, isEvent));
                        break;
                    }
                    response.setObject(this.invokeRequest(delegate, requestData));
                    break;
                }
                case LOOKUP_EVENT_HANDLER: {
                    String handlerName = (String)call.getParameters()[0];
                    if (!this.context.existsEventHandler(handlerName)) break;
                    response.setObject(this.context.getEventHandler(handlerName));
                    break;
                }
                case LOOKUP_EVENT_HANDLER_BY_METHOD: {
                    String methodName = (String)call.getParameters()[0];
                    this.context.getEventHandlers().stream().filter(handler -> handler.getMethodName().equals(methodName)).forEach(response::setObject);
                    break;
                }
                case IS_EVENT_HANDLER_VALID: {
                    response.setObject(this.getEventHandler((String)((String)call.getParameters()[0])).isValid);
                    break;
                }
                case GET_EVENT_HANDLERS: {
                    response.setObject(this.context.getEventHandlers());
                    break;
                }
                case LIST_EVENT_HANDLERS: {
                    response.setObject(this.context.listEventHandlers());
                    break;
                }
                case LIST_ACTIVE_EVENTS: {
                    response.setObject(this.context.listActiveEvents());
                    break;
                }
                case GET_EVENT_HANDLER_PARAMETER_NAME: {
                    Class<?> serviceClass;
                    String parameterName = null;
                    EventHandler handler2 = this.context.getEventHandler((String)call.getParameters()[0]);
                    if (handler2 != null && (serviceClass = this.context.getServiceClass()) != null) {
                        parameterName = Arrays.stream(serviceClass.getMethods()).filter(m -> m.getName().equals(handler2.getMethodName()) && m.getParameterCount() == 1).map(m -> m.getParameters()[0].getName()).findAny().orElse(null);
                    }
                    response.setObject(parameterName);
                    break;
                }
                case GET_EVENT_HANDLER_METHOD_INFO: {
                    Method method;
                    Class<?> serviceClass;
                    RPLMethodsCache.RPLMethodInfo methodInfo = null;
                    EventHandler handler3 = this.context.getEventHandler((String)call.getParameters()[0]);
                    if (handler3 != null && (serviceClass = this.context.getServiceClass()) != null && (method = (Method)Arrays.stream(serviceClass.getMethods()).filter(m -> m.getName().equals(handler3.getMethodName()) && m.getParameterCount() == 1).findAny().orElse(null)) != null) {
                        methodInfo = RPLMethodsCacheImpl.getRPLMethodInfo(method);
                    }
                    response.setObject(methodInfo);
                    break;
                }
                case GET_EVENT_TRIGGER_DEFINITION: {
                    response.setObject(this.context.getEventTriggerDefinition((String)call.getParameters()[0]));
                    break;
                }
                case GET_EVENT_TRIGGER_SYNTAX: {
                    response.setObject(this.context.getEventTriggerSyntax((String)call.getParameters()[0]));
                    break;
                }
                case ADD_EVENT_TRIGGER: {
                    this.context.addEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case ALTER_EVENT_TRIGGER: {
                    this.context.alterEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case ENABLE_EVENT_TRIGGER: {
                    this.context.enableEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case DISABLE_EVENT_TRIGGER: {
                    this.context.disableEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case REMOVE_EVENT_TRIGGER: {
                    this.context.removeEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case GET_EVENT_TRIGGER_DEFINITIONS: {
                    response.setObject(this.context.getEventTriggerDefinitions());
                    break;
                }
                case REMOVE_ALL_EVENT_TRIGGERS: {
                    this.context.removeAllEventTriggers();
                    break;
                }
                case GET_LAST_ERROR: {
                    response.setObject(this.context.getLastError((String)call.getParameters()[0]));
                    break;
                }
                case GET_TRIGGER_STATE: {
                    response.setObject((Object)this.context.getTriggerState((String)call.getParameters()[0]));
                    break;
                }
                case GET_TRIGGER_ACTION_TIME: {
                    response.setObject((Object)this.context.getTriggerActionTime((String)call.getParameters()[0]));
                    break;
                }
                case COMPILE_EVENT_TRIGGER: {
                    this.context.compileEventTrigger((String)call.getParameters()[0]);
                    break;
                }
                case GET_TRIGGER_AUTO_ENABLE: {
                    response.setObject(this.context.isEventTriggerAutoEnable((String)call.getParameters()[0]));
                    break;
                }
                case SET_TRIGGER_AUTO_ENABLE: {
                    this.context.setEventTriggerAutoEnable((String)call.getParameters()[0], (Boolean)call.getParameters()[1]);
                    break;
                }
                case GET_EVENT_TRIGGER_DATA: {
                    response.setObject(this.context.getEventTriggerData((String)call.getParameters()[0]));
                    break;
                }
                case LIST_EVENT_TRIGGERS: {
                    response.setObject(this.context.listEventTriggers());
                    break;
                }
                case HAS_EVENT_TRIGGERS: {
                    response.setObject(this.context.hasEventTriggers());
                    break;
                }
                case EXIST_EVENT_TRIGGER: {
                    response.setObject(this.context.existsEventTrigger((String)call.getParameters()[0]));
                    break;
                }
                case HAS_SINK_EVENTS: {
                    response.setObject(this.context.hasSinkEvents());
                    break;
                }
                case LIST_SINK_EVENTS: {
                    response.setObject(this.context.listSinkEvents());
                    break;
                }
                case LIST_ACTIONABLE_EVENTS: {
                    response.setObject(this.context.listActionableEvents());
                    break;
                }
                case HAS_ACTIONABLE_EVENTS: {
                    response.setObject(this.context.hasActionableEvents());
                    break;
                }
                case EXISTS_ACTIONABLE_EVENTS: {
                    response.setObject(this.context.existsActionableEvent((String)call.getParameters()[0]));
                }
            }
            return ServiceAccessorProxy.createResponseEvent(response);
        }
        catch (Throwable exception) {
            if (exception instanceof FabricRequestException) {
                throw (FabricRequestException)exception;
            }
            throw new FabricRequestException(exception);
        }
    }

    private ImmutableEventDatagram createRequestEvent(String eventId, Object requestData, Map<String, Object> properties) throws Exception {
        EventDatagram result = this.context.context.getEventDatagramFactory().createEvent(eventId);
        InvokeDelegate.fillEvent(result, requestData, properties);
        return result;
    }

    private void setEIMData(ImmutableEventDatagram event, EIMObject eimData) throws Exception {
        if (event instanceof EventDatagram) {
            EventDatagram eventDatagram = (EventDatagram)event;
            if (eimData.getCorrelationId() != null) {
                eventDatagram.setCorrelationIdAsBytes(eimData.getCorrelationId());
            }
            if (eimData.getEventGroupId() != null) {
                eventDatagram.setEventGroupId(eimData.getEventGroupId());
            }
            if (eimData.getEventKey() != null) {
                eventDatagram.setEventKey(eimData.getEventKey());
            }
            if (eimData.getReplyTo() != null) {
                eventDatagram.setReplyTo(eimData.getReplyTo());
            }
        } else if (event instanceof ExceptionEventDatagram) {
            ExceptionEventDatagram eventDatagram = (ExceptionEventDatagram)event;
            if (eimData.getCorrelationId() != null) {
                eventDatagram.setCorrelationIdAsBytes(eimData.getCorrelationId());
            }
            if (eimData.getEventGroupId() != null) {
                eventDatagram.setEventGroupId(eimData.getEventGroupId());
            }
            if (eimData.getEventKey() != null) {
                eventDatagram.setEventKey(eimData.getEventKey());
            }
            if (eimData.getReplyTo() != null) {
                eventDatagram.setReplyTo(eimData.getReplyTo());
            }
        }
    }

    private Object invokeRequest(InvokeDelegate delegate, Object requestData) throws FabricRequestException {
        try {
            return delegate.invokeRequest(requestData);
        }
        catch (Throwable error) {
            throw delegate.createFabricRequestException(error);
        }
    }

    private EventHandler getEventHandler(String handlerName) throws Exception {
        if (!this.context.existsEventHandler(handlerName)) {
            throw new FabricComponentAccessorException(6103, "Event handler '" + handlerName + "' not found in service " + this.context.getFullName() + ".");
        }
        return this.context.getEventHandler(handlerName);
    }

    private InvokeDelegate getInvokeDelegate(String handlerName) throws FabricRequestException {
        InvokeDelegate delegate = this.invokeDelegates.get(handlerName);
        if (delegate != null) {
            return delegate;
        }
        throw new FabricRequestException("Invoke Delegate not found for event handler '" + handlerName + "'.");
    }

    private static void throwException(int errorCode, String errorMessage) throws FabricComponentAccessorException {
        throw new FabricComponentAccessorException(errorCode, errorMessage);
    }

    private String inService() {
        return " in service " + this.context.getFullName();
    }

    @Override
    protected void logError(Throwable exception) {
        Trace.logException(this, exception, true);
        this.context.logError("Processing DSL statement failed. " + exception.getMessage());
    }

    @Override
    protected MFSession getMFSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.session.close();
        super.close();
    }

    @Override
    protected void doInvokeInterruptRequest(String command, MFSession session) throws Exception {
        Runnable interruptListener = ((AbstractMFSession)session).getInterruptListener();
        if (interruptListener == null) {
            throw new Exception("This command cannot be interrupted.");
        }
        interruptListener.run();
        ((AbstractMFSession)session).setInterruptListener(null);
    }
}

