/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.utils.EIMObject;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AccessorParentSessionLink;
import com.streamscape.sef.dispatcher.RemoteClientComponent;
import com.streamscape.sef.dispatcher.SLServiceCall;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SessionResponse;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ServiceAccessorImpl
extends AbstractComponentAccessor
implements ServiceAccessor,
AccessorParentSessionLink {
    private Set<String> boundEventIds;
    private transient Session parentSession;

    ServiceAccessorImpl(AbstractFabricComponent owningComponent, String nodeName, String componentType, String componentName, boolean checkComponent, SLSessionImpl slSession, boolean isInstant) throws FabricComponentAccessorException {
        super(owningComponent, nodeName, componentType, componentName, checkComponent ? ComponentModel.SERVICE : null, slSession, isInstant, null);
    }

    ServiceAccessorImpl(AbstractFabricComponent owningComponent, FabricNodeReference node, ComponentReference component, RequestConsumerReference sessionManager, SLSessionImpl slSession) throws FabricComponentAccessorException {
        super(owningComponent, node, component, sessionManager, slSession);
    }

    @Override
    public List<String> listBoundEventIds() {
        return this.boundEventIds != null ? new ArrayList<String>(this.boundEventIds) : new ArrayList();
    }

    @Override
    void onSessionOpen(SessionResponse response) {
        this.initBoundEventIds();
        HashSet<String> eventIds = new HashSet<String>();
        if (this.nodeName != null) {
            this.getEventIdsForBinding(this.component, eventIds);
        } else {
            this.getEventIdsForBinding(eventIds);
        }
        this.bindEventIds(eventIds);
    }

    private synchronized void initBoundEventIds() {
        this.boundEventIds = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindEventIds(Set<String> eventIds) {
        AbstractFabricComponent abstractFabricComponent = this.owningComponent;
        synchronized (abstractFabricComponent) {
            for (String eventId : eventIds) {
                if (this.boundEventIds.contains(eventId)) continue;
                if (this.owningComponent instanceof RemoteClientComponent && !this.owningComponent.isBoundEventId(eventId) && !PrototypeFactory.existsPrototype(eventId)) {
                    try {
                        ((RemoteClientComponent)this.owningComponent).connection.importEventPrototype(eventId);
                    }
                    catch (Exception exception) {
                        this.logException(exception, "Importing event prototype [" + eventId + "] failed.");
                    }
                }
                try {
                    if (SDOUtils.isSystemEventId(eventId)) continue;
                    this.owningComponent.bindProducerFor(eventId, false);
                    this.boundEventIds.add(eventId);
                }
                catch (Exception exception) {
                    this.logException(exception, "Binding producer for [" + eventId + "] event failed.");
                }
            }
        }
    }

    private void getEventIdsForBinding(Set<String> result) {
        String componentFullName = this.getComponentFullName();
        for (FabricNodeReference fabricNode : this.owningComponent.moderator.getFabricNodes()) {
            this.getEventIdsForBinding(fabricNode, componentFullName, result);
        }
    }

    private void getEventIdsForBinding(FabricNodeReference fabricNode, String componentFullName, Set<String> result) {
        this.getEventIdsForBinding(fabricNode.lookupComponent(componentFullName), result);
    }

    private void getEventIdsForBinding(ComponentReference component, Set<String> result) {
        if (component != null && component.getModel() == this.componentModel) {
            HashSet<String> eventIds = new HashSet<String>();
            ServiceAccessorImpl.getEventIds(component.getDirectConsumers(EventScope.INHERITED), eventIds);
            ServiceAccessorImpl.getEventIds(component.getAsyncConsumers(EventScope.INHERITED), eventIds);
            result.addAll(eventIds);
        }
    }

    private static <T extends EventConsumerReference> void getEventIds(List<T> consumers, Set<String> result) {
        for (EventConsumerReference consumer : consumers) {
            if (!consumer.getName().endsWith("HandlerInput")) continue;
            result.add(consumer.getEventFilter());
        }
    }

    @Override
    void onSessionClose() {
        this.unbindEventIds(this.boundEventIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindEventIds(Set<String> eventIds) {
        if (eventIds != null && eventIds.size() > 0) {
            AbstractFabricComponent abstractFabricComponent = this.owningComponent;
            synchronized (abstractFabricComponent) {
                for (String eventId : eventIds) {
                    this.owningComponent.unbindProducerFor(eventId, false);
                }
                this.boundEventIds.removeAll(eventIds);
            }
        }
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        return this.invokeServiceRequest(request, this.requestTimeout);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(ImmutableEventDatagram request, long timeout) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        this.check(request.getEventId());
        try {
            return this.owningComponent.dispatcher.raiseRequest(this.session, request, timeout);
        }
        catch (FabricRequestException exception) {
            if (exception.getCause() instanceof FabricComponentAccessorException) {
                throw (FabricComponentAccessorException)exception.getCause();
            }
            if (exception.getCause() instanceof ServiceFrameworkException) {
                throw (ServiceFrameworkException)exception.getCause();
            }
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
        catch (FabricUnboundEventException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, Object data) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeServiceRequest(eventHandler, data, this.requestTimeout);
    }

    @Override
    public Object invokeServiceRequest(String handlerName, Object data, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{handlerName, data}, 6108);
    }

    @Override
    public Object invokeServiceRequest(String handlerName, Object data, Map<String, Object> properties, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{handlerName, data, properties}, 6108);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeServiceRequest(eventHandler, eimData, data, this.requestTimeout);
    }

    @Override
    public Object invokeServiceRequest(String eventHandler, EIMObject eimData, Object data, long timeout) throws FabricComponentAccessorException, ServiceFrameworkException {
        return this.invokeOperation(SLServiceCall.Operation.INVOKE_BY_EVENT_HANDLER, new Object[]{eventHandler, data, eimData}, 6108);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        return this.invokeServiceRequest(request, strategy, this.requestTimeout);
    }

    @Override
    public ImmutableEventDatagram invokeServiceRequest(EventDatagram request, RequestDistributionStrategy strategy, long timeout) throws FabricComponentAccessorException, FabricEventSourceException, ServiceFrameworkException {
        ImmutableEventDatagram data;
        AcknowledgementEvent ack;
        this.check(request.getEventId());
        try {
            ack = this.owningComponent.dispatcher.raiseRequest(request, EventScope.INHERITED, strategy, ReplyMatchStrategy.REPLY_TO, timeout);
        }
        catch (FabricUnboundEventException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
        catch (FabricEventException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
        try {
            data = (ImmutableEventDatagram)ack.getData();
        }
        catch (Exception exception) {
            throw new FabricComponentAccessorException(6011, "Obtaining response for event [" + request.getEventId() + "] failed.", exception);
        }
        if (data instanceof ServiceFrameworkException) {
            throw (ServiceFrameworkException)data;
        }
        return data;
    }

    @Override
    public void invokeAsyncServiceRequest(ImmutableEventDatagram request) throws FabricComponentAccessorException, FabricEventSourceException {
        this.check(request.getEventId());
        try {
            this.owningComponent.dispatcher.raiseEvent(request, EventScope.INHERITED, -1L);
        }
        catch (FabricUnboundEventException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
        catch (FabricEventException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
    }

    private void check(String eventId) throws FabricComponentAccessorException {
        this.checkOpened();
        this.checkAvailable();
        this.checkEventId(eventId);
    }

    private synchronized void checkEventId(String eventId) throws FabricComponentAccessorException {
        if (!this.boundEventIds.contains(eventId)) {
            HashSet<String> eventIds = new HashSet<String>();
            this.getEventIdsForBinding(eventIds);
            this.bindEventIds(eventIds);
            if (!this.boundEventIds.contains(eventId)) {
                throw new FabricComponentAccessorException(6129, "Event [" + eventId + "] does not correspond to any event handler or service is not started.");
            }
        }
    }

    @Override
    public EventHandler lookupEventHandler(String handlerName) throws FabricComponentAccessorException {
        return (EventHandler)this.invokeOperation(SLServiceCall.Operation.LOOKUP_EVENT_HANDLER, new Object[]{handlerName});
    }

    @Override
    public EventHandler lookupEventHandlerByMethod(String methodName) throws FabricComponentAccessorException {
        return (EventHandler)this.invokeOperation(SLServiceCall.Operation.LOOKUP_EVENT_HANDLER_BY_METHOD, new Object[]{methodName});
    }

    @Override
    public boolean isEventHandlerValid(String handlerName) throws FabricComponentAccessorException {
        return (Boolean)this.invokeOperation(SLServiceCall.Operation.IS_EVENT_HANDLER_VALID, new Object[]{handlerName});
    }

    @Override
    public List<EventHandler> getEventHandlers() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLERS, null);
    }

    @Override
    public List<String> listEventHandlers() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.LIST_EVENT_HANDLERS, null);
    }

    @Override
    public List<ActiveEvent> listActiveEvents() throws FabricComponentAccessorException {
        return (List)this.invokeOperation(SLServiceCall.Operation.LIST_ACTIVE_EVENTS, null);
    }

    @Override
    public String getEventHandlerParameterName(String handlerName) throws FabricComponentAccessorException {
        return (String)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLER_PARAMETER_NAME, new Object[]{handlerName});
    }

    @Override
    public RPLMethodsCache.RPLMethodInfo getEventHandlerRPLMethodInfo(String handlerName) throws FabricComponentAccessorException {
        return (RPLMethodsCache.RPLMethodInfo)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_HANDLER_METHOD_INFO, new Object[]{handlerName});
    }

    @Override
    public List<String> listSinkEvents() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_SINK_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean hasSinkEvents() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_SINK_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public List<String> listActionableEvents() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_ACTIONABLE_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public boolean hasActionableEvents() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_ACTIONABLE_EVENTS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.EXISTS_ACTIONABLE_EVENTS, new Object[]{eventId});
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public List<String> listEventTriggers() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.LIST_EVENT_TRIGGERS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<String>();
        }
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) throws ServiceConfigurationException {
        return (EventTriggerData)this.invokeOperationServiceWithException(SLServiceCall.Operation.GET_EVENT_TRIGGER_DATA, new Object[]{triggerName});
    }

    @Override
    public boolean hasEventTriggers() {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.HAS_EVENT_TRIGGERS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.EXIST_EVENT_TRIGGER, new Object[]{triggerName});
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return false;
        }
    }

    @Override
    public void addEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.ADD_EVENT_TRIGGER, new Object[]{triggerSyntax});
    }

    @Override
    public void alterEventTrigger(String triggerSyntax) throws ServiceConfigurationException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.ALTER_EVENT_TRIGGER, new Object[]{triggerSyntax});
    }

    @Override
    public void enableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.ENABLE_EVENT_TRIGGER, new Object[]{triggerName});
    }

    @Override
    public void disableEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.DISABLE_EVENT_TRIGGER, new Object[]{triggerName});
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.REMOVE_EVENT_TRIGGER, new Object[]{triggerName});
    }

    @Override
    public EventTriggerDefinition getEventTriggerDefinition(String triggerName) throws ServiceConfigurationException {
        return (EventTriggerDefinition)this.invokeOperationServiceWithException(SLServiceCall.Operation.GET_EVENT_TRIGGER_DEFINITION, new Object[]{triggerName});
    }

    @Override
    public String getEventTriggerSyntax(String triggerName) throws ServiceConfigurationException {
        return (String)this.invokeOperationServiceWithException(SLServiceCall.Operation.GET_EVENT_TRIGGER_SYNTAX, new Object[]{triggerName});
    }

    @Override
    public List<EventTriggerDefinition> getEventTriggerDefinitions() {
        try {
            return (List)this.invokeOperation(SLServiceCall.Operation.GET_EVENT_TRIGGER_DEFINITIONS, null);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return new ArrayList<EventTriggerDefinition>();
        }
    }

    @Override
    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
        this.invokeOperationServiceWithException(SLServiceCall.Operation.REMOVE_ALL_EVENT_TRIGGERS, null);
    }

    @Override
    public void compileEventTrigger(String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
        try {
            this.invokeOperation(SLServiceCall.Operation.COMPILE_EVENT_TRIGGER, new Object[]{triggerName});
        }
        catch (Exception exception) {
            throw new EventTriggerCompileException(exception);
        }
    }

    @Override
    public String getLastError(String triggerName) {
        try {
            return (String)this.invokeOperation(SLServiceCall.Operation.GET_LAST_ERROR, new Object[]{triggerName});
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return null;
        }
    }

    @Override
    public EventTriggerState getTriggerState(String triggerName) {
        try {
            return (EventTriggerState)((Object)this.invokeOperation(SLServiceCall.Operation.GET_TRIGGER_STATE, new Object[]{triggerName}));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return null;
        }
    }

    @Override
    public TriggerActionTime getTriggerActionTime(String triggerName) {
        try {
            return (TriggerActionTime)((Object)this.invokeOperation(SLServiceCall.Operation.GET_TRIGGER_ACTION_TIME, new Object[]{triggerName}));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            return null;
        }
    }

    @Override
    public boolean isEventTriggerAutoEnable(String triggerName) throws IllegalTriggerStateException {
        try {
            return (Boolean)this.invokeOperation(SLServiceCall.Operation.GET_TRIGGER_AUTO_ENABLE, new Object[]{triggerName});
        }
        catch (Exception exception) {
            throw new IllegalTriggerStateException(exception);
        }
    }

    @Override
    public void setEventTriggerAutoEnable(String triggerName, boolean autoEnable) throws IllegalTriggerStateException, ServiceConfigurationException {
        try {
            this.invokeOperation(SLServiceCall.Operation.SET_TRIGGER_AUTO_ENABLE, new Object[]{triggerName, autoEnable});
        }
        catch (Exception exception) {
            throw new ServiceConfigurationException(exception);
        }
    }

    protected Object invokeOperationServiceWithException(SLServiceCall.Operation operation, Object[] parameters) throws ServiceConfigurationException {
        try {
            return this.invokeOperation(operation, parameters);
        }
        catch (FabricComponentAccessorException e) {
            throw new ServiceConfigurationException(e.getMessage());
        }
    }

    protected Object invokeOperation(SLServiceCall.Operation operation, Object[] parameters) throws FabricComponentAccessorException {
        try {
            return this.invokeOperation(operation, parameters, 6011);
        }
        catch (ServiceFrameworkException exception) {
            throw new FabricComponentAccessorException(6011, (Throwable)exception);
        }
    }

    protected Object invokeOperation(SLServiceCall.Operation operation, Object[] parameters, int errorCode) throws FabricComponentAccessorException, ServiceFrameworkException {
        SLResponse response = this.invokeRequest("e.sys.sl.ServiceCall", new SLServiceCall(operation, parameters), this.requestTimeout);
        if (!response.isOK()) {
            if (response.getException() != null) {
                if (response.getException() instanceof FabricComponentAccessorException) {
                    throw (FabricComponentAccessorException)response.getException();
                }
                if (response.getException().getCause() instanceof FabricComponentAccessorException) {
                    throw (FabricComponentAccessorException)response.getException().getCause();
                }
                if (response.getException() instanceof ServiceFrameworkException) {
                    throw (ServiceFrameworkException)response.getException();
                }
                if (response.getException().getCause() instanceof ServiceFrameworkException) {
                    throw (ServiceFrameworkException)response.getException().getCause();
                }
                throw new FabricComponentAccessorException(errorCode, response.getException());
            }
            throw new FabricComponentAccessorException(errorCode, response.getText());
        }
        return response.getObject();
    }

    @Override
    public void setParentSession(Session parentSession) {
        this.parentSession = parentSession;
    }

    @Override
    public Session getParentSession() {
        return this.parentSession;
    }
}

