/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.tlp.ClientId;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.ListComponentsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractClientOperation;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class SelectClientIdOperation
extends AbstractClientOperation {
    public static final String NAME = "select clientid";

    public SelectClientIdOperation() {
        super(NAME, false);
        this.syntax.addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON")));
        this.syntax.setDescription("Returns ClientId object of the specified external client.");
        this.syntax.addCompletionCommand("list clients at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(NAME, statement.getParameter("ClientId").getValue(), statement);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ComponentReference component = node.lookupComponent(definition.clientId);
        if (!ListComponentsOperation.checkSysadmin((MFSession)session, component)) {
            component = null;
        }
        return component != null ? this.createResult(definition, session, component) : new SLResponse("Client not found.", false);
    }

    private SLResponse createResult(Definition definition, MFSession session, ComponentReference component) throws Exception {
        RuntimeExchange.ClientInfo client = ((RuntimeContext)this.callable).exchange.getClientInfo(component);
        if (client == null) {
            throw new Exception("Client not found.");
        }
        List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
        ClientId clientId = new ClientId(nameTokens.get(2));
        if (definition.statement.existsModifier("XML")) {
            return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(clientId));
        }
        if (definition.statement.existsModifier("JSON")) {
            return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(clientId));
        }
        RowSet rowSet = new RowSet(SelectClientIdOperation.createResultDescriptor());
        SelectClientIdOperation.addValues(rowSet, clientId);
        return new SLResponse(rowSet);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        SelectClientIdOperation.addGenericColumn(result, "ClientId");
        return result;
    }

    static class Definition
    extends AbstractClientOperation.Definition {
        DSLStatement statement;

        Definition(String operationName, String clientName, DSLStatement statement) {
            super(operationName, clientName);
            this.statement = statement;
        }
    }
}

