/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.CIString;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AcceptorHelper;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.SecurityContextImpl;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.security.AbstractSecurityManagerImpl;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import com.streamscape.sef.security.AuthenticationModule;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Groups;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.Organizations;
import com.streamscape.sef.security.SecurityAdvisory;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.security.UserState;
import com.streamscape.sef.security.Users;
import com.streamscape.tools.mnode.ManagementNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class SecurityManagerImpl
extends AbstractSecurityManagerImpl {
    SecurityManagerImpl(RuntimeContext context) {
        super(context);
    }

    @Override
    protected void init() throws Exception {
        super.init();
    }

    @Override
    protected boolean isSysadmin(User user) {
        return super.isSysadmin(user);
    }

    protected static boolean isSysadmin(String userName) {
        return AbstractSecurityManagerImpl.isSysadmin(userName);
    }

    static String getSysadminPassword() {
        return "]D}W;k!oX~!:{E7O";
    }

    AuthenticationModule getAuthenticationModule() {
        return this.authenticationModule;
    }

    void setAuthenticationModule(AuthenticationModule authenticationModule) {
        this.authenticationModule = authenticationModule;
    }

    RuntimeExchange getExchange() {
        return this.context.exchange;
    }

    Users getUsersStore() {
        return this.users;
    }

    Groups getGroupsStore() {
        return this.groups;
    }

    Organizations getOrganizationsStore() {
        return this.organizations;
    }

    @Override
    protected void copyStore(String toPath) throws Exception {
        super.copyStore(toPath);
    }

    @Override
    protected RowSet getVCardTable() {
        return super.getVCardTable();
    }

    @Override
    protected RowSet getVCardPhotoTable() {
        return super.getVCardPhotoTable();
    }

    @Override
    protected void completeInitialization() throws Exception {
        super.completeInitialization();
    }

    @Override
    protected void synchronize(Users users, Groups groups, Organizations organizations) {
        super.synchronize(users, groups, organizations);
    }

    @Override
    protected synchronized void synchronize(RowSet vCardTable, RowSet vCardPhotoTable) {
        super.synchronize(vCardTable, vCardPhotoTable);
    }

    @Override
    protected User getAnonymousUser() {
        return super.getAnonymousUser();
    }

    @Override
    protected User getRuntimeUser() {
        return super.getRuntimeUser();
    }

    @Override
    protected String getRuntimeUserPassword() {
        return this.context.getPassword();
    }

    protected static String normalizePassword(String password) {
        return AbstractSecurityManagerImpl.normalizePassword(password);
    }

    protected User doGetUser(String name) throws SecurityManagerException {
        return super.getUser(new CIString(name));
    }

    @Override
    protected String createRuntimeUserDigest(String key) throws SecurityManagerException {
        return super.createRuntimeUserDigest(key);
    }

    protected static User createAnonymousUser() {
        return AbstractSecurityManagerImpl.createAnonymousUser();
    }

    @Override
    protected void doSetDefaultMnode(User user) {
        String mnode = null;
        if (this.context.getNodeRole() == FabricNodeRole.MANAGEMENT_NODE) {
            mnode = this.context.getName();
        } else {
            try {
                ManagementNode mfObject = (ManagementNode)this.context.getRepositoryAccessor().lookupObject("sys/mf", "ManagementNode");
                if (mfObject != null && mfObject.getName() != null) {
                    mnode = mfObject.getName();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mnode != null) {
            this.doSetAttribute(user, "defaultMnode", mnode);
        }
    }

    protected void setLastAccessTimestamp(String userName, long timestamp) {
        this.doSetTimestamp(userName, "lastAccessTimestamp", timestamp);
    }

    protected void setLastFailedAttemptTimestamp(String userName, long timestamp) {
        this.doSetTimestamp(userName, "lastFailedAttemptTimestamp", timestamp);
    }

    User authenticate(String userName, String credentials, String key) throws SecurityManagerException {
        return this.authenticate(AuthenticationType.DIGEST, userName, credentials, Collections.singletonMap("key", key), null);
    }

    synchronized User authenticate(AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator, AbstractFabricComponent component) throws SecurityManagerException {
        User user = userName != null ? this.authenticate(type, userName, credentials, parameters, calculator) : this.authenticate(credentials);
        this.bindSecurityContext(user, component);
        return user;
    }

    @Override
    protected User authenticate(String userName, String credentials) throws SecurityManagerException {
        return super.authenticate(userName, credentials);
    }

    @Override
    protected User authenticate(AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws SecurityManagerException {
        return super.authenticate(type, userName, credentials, parameters, calculator);
    }

    User authenticate(String securityToken) throws SecurityManagerException {
        if (!this.context.exchange.webAppTokenAuthentication) {
            throw new SecurityManagerException(6084, "Authentication with Web App Token is not allowed.");
        }
        HTTPAuthenticationManager manager = this.context.getHTTPAuthenticationManager();
        manager.authorize(this.getRuntimeUser());
        ApiKeyToken token = manager.getApiKeyServiceFactory().getApiKeyTokenService().get(securityToken);
        if (token == null) {
            throw new SecurityManagerException(6084, "Authentication failed: invalid security token.");
        }
        if (!token.isGlobal()) {
            throw new SecurityManagerException(6084, "Authentication failed: security token is not global.", token.getOwner());
        }
        if (token.getExpiresIn() > 0 && System.currentTimeMillis() - token.getLastAccessedAt() > (long)(token.getExpiresIn() * 1000)) {
            throw new SecurityManagerException(6084, "Authentication failed: security token expired.", token.getOwner());
        }
        return this.authenticate(AuthenticationType.DIGEST, token.getOwner(), token.getSecurityTokenId(), null, new ApiKeyTokenDigestCalculator());
    }

    void bindSecurityContext(User user, AbstractFabricComponent component) {
        SecurityContextImpl securityContext = (SecurityContextImpl)this.getSecurityContext(user);
        if (securityContext == null) {
            securityContext = new SecurityContextImpl(user, (Object)this);
            this.putSecurityContext(user, securityContext);
        }
        component.securityContext = securityContext;
    }

    void bindSecurityContext(Group group, AbstractFabricComponent component) {
        SecurityContextImpl securityContext = (SecurityContextImpl)this.getSecurityContext(group);
        if (securityContext == null) {
            securityContext = new SecurityContextImpl(group, (Object)this);
            this.putSecurityContext(group, securityContext);
        }
        component.securityContext = securityContext;
    }

    SecurityContext getSecurityContext(String ownerName) {
        return (SecurityContext)this.securityContexts.get(new CIString(ownerName));
    }

    boolean hasSecurityContext(String ownerName) {
        return this.securityContexts.containsKey(new CIString(ownerName));
    }

    @Override
    protected void onUpdate(SecurityAdvisory advisory) {
        this.context.exchange.onSecurityUpdate(advisory);
    }

    @Override
    protected User createUser(User currentUser, String name, String password, String description, vCard vcard, UserState state) throws SecurityManagerException {
        return super.createUser(state != null ? null : currentUser, name, password, description, vcard, state);
    }

    protected static User makeUser(String name, String password, boolean isAdmin) {
        return AbstractSecurityManagerImpl.makeUser(name, password, isAdmin);
    }

    @Override
    protected void dropUser(User currentUser, String name, boolean checkActive) throws SecurityManagerException {
        super.dropUser(currentUser, name, checkActive);
    }

    @Override
    protected void updateUser(User currentUser, User user) throws SecurityManagerException {
        super.updateUser(currentUser, user);
    }

    @Override
    protected void doUpdateUser(User user) throws SecurityManagerException {
        super.doUpdateUser(user);
    }

    @Override
    protected User lookupUser(String name) {
        return super.lookupUser(name);
    }

    @Override
    protected boolean existsUser(String name) {
        return super.existsUser(name);
    }

    @Override
    protected List<User> getUsers() {
        return super.getUsers();
    }

    @Override
    protected List<String> listUsers() {
        return super.listUsers();
    }

    @Override
    protected void addUserPermission(User currentUser, String userName, AccessControlOperation operation) throws SecurityManagerException {
        super.addUserPermission(currentUser, userName, operation);
    }

    @Override
    protected void removeUserPermission(User currentUser, String userName, AccessControlOperation operation) throws SecurityManagerException {
        super.removeUserPermission(currentUser, userName, operation);
    }

    @Override
    protected void resetUserPermissions(User currentUser, String userName) throws SecurityManagerException {
        super.resetUserPermissions(currentUser, userName);
    }

    @Override
    protected AccessControlList getUserPermissions(User currentUser, String userName) throws SecurityManagerException {
        return super.getUserPermissions(currentUser, userName);
    }

    @Override
    protected void enableUser(User currentUser, String name) throws SecurityManagerException {
        super.enableUser(currentUser, name);
    }

    @Override
    protected void disableUser(User currentUser, String name) throws SecurityManagerException {
        super.disableUser(currentUser, name);
    }

    @Override
    protected vCard getVCard(User currentUser, String userName) throws SecurityManagerException {
        return super.getVCard(currentUser, userName);
    }

    @Override
    protected void setVCard(User currentUser, String userName, vCard vCard2) throws SecurityManagerException {
        super.setVCard(currentUser, userName, vCard2);
    }

    @Override
    protected boolean existsVCard(String userName) {
        return super.existsVCard(userName);
    }

    @Override
    protected Group createGroup(User currentUser, String name, String description) throws SecurityManagerException {
        return super.createGroup(currentUser, name, description);
    }

    @Override
    protected void dropGroup(User currentUser, String name, boolean checkActive) throws SecurityManagerException {
        super.dropGroup(currentUser, name, checkActive);
    }

    @Override
    protected void updateGroup(User currentUser, Group group) throws SecurityManagerException {
        super.updateGroup(currentUser, group);
    }

    @Override
    protected void doUpdateGroup(Group group) throws SecurityManagerException {
        super.doUpdateGroup(group);
    }

    @Override
    protected Group lookupGroup(String name) {
        return super.lookupGroup(name);
    }

    @Override
    protected boolean existsGroup(String name) {
        return super.existsGroup(name);
    }

    @Override
    protected List<Group> getGroups() {
        return super.getGroups();
    }

    @Override
    protected List<String> listGroups() {
        return super.listGroups();
    }

    @Override
    protected void addGroupPermission(User currentUser, String groupName, AccessControlOperation operation) throws SecurityManagerException {
        super.addGroupPermission(currentUser, groupName, operation);
    }

    @Override
    protected void removeGroupPermission(User currentUser, String groupName, AccessControlOperation operation) throws SecurityManagerException {
        super.removeGroupPermission(currentUser, groupName, operation);
    }

    @Override
    protected AccessControlList getGroupPermissions(User currentUser, String groupName) throws SecurityManagerException {
        return super.getGroupPermissions(currentUser, groupName);
    }

    @Override
    protected void addUserToGroup(User currentUser, String userName, String groupName) throws SecurityManagerException {
        super.addUserToGroup(currentUser, userName, groupName);
    }

    @Override
    protected void removeUserFromGroup(User currentUser, String userName, String groupName) throws SecurityManagerException {
        super.removeUserFromGroup(currentUser, userName, groupName);
    }

    @Override
    protected void onRemoveUserFromGroup(User user, Group group) {
        if (group.getName().equals("XMPP")) {
            this.logInfo("User '" + String.valueOf(user.getName()) + "' is no longer in 'XMPP' group. Closing all XMPP sessions...");
            this.closeUserSessions(user.getName().toString());
        }
    }

    private void closeUserSessions(String userName) {
        AcceptorFactory factory = this.context.getAcceptorManager().lookupFactory("XMPPAcceptorFactory");
        if (factory != null) {
            factory.getAcceptors().stream().filter(Acceptor::isStarted).forEach(acceptor -> ((AcceptorHelper)((Object)acceptor)).closeSession(userName));
        }
    }

    @Override
    protected Organization createOrganization(User currentUser, String name, String description) throws SecurityManagerException {
        return super.createOrganization(currentUser, name, description);
    }

    @Override
    protected void dropOrganization(User currentUser, String name) throws SecurityManagerException {
        super.dropOrganization(currentUser, name);
    }

    @Override
    protected void updateOrganization(User currentUser, Organization organization) throws SecurityManagerException {
        super.updateOrganization(currentUser, organization);
    }

    @Override
    protected void doUpdateOrganization(Organization organization) throws SecurityManagerException {
        super.doUpdateOrganization(organization);
    }

    @Override
    protected boolean existsOrganization(String name) {
        return super.existsOrganization(name);
    }

    @Override
    protected Organization lookupOrganization(String name) {
        return super.lookupOrganization(name);
    }

    @Override
    protected List<String> listOrganizations() {
        return super.listOrganizations();
    }

    @Override
    protected List<Organization> getOrganizations() {
        return super.getOrganizations();
    }

    @Override
    protected void setOrganizationDomain(User currentUser, String organizationName, String domain) throws SecurityManagerException {
        super.setOrganizationDomain(currentUser, organizationName, domain);
    }

    @Override
    protected void setUserOrganization(User currentUser, String userName, String organizationName) throws SecurityManagerException {
        super.setUserOrganization(currentUser, userName, organizationName);
    }

    @Override
    protected void setGroupOrganization(User currentUser, String groupName, String organizationName) throws SecurityManagerException {
        super.setGroupOrganization(currentUser, groupName, organizationName);
    }

    @Override
    protected String resetPassword(User currentUser, String userName) throws SecurityManagerException {
        return super.resetPassword(currentUser, userName);
    }

    @Override
    protected void changePassword(User currentUser, String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        super.changePassword(currentUser, userName, oldPassword, newPassword);
    }

    @Override
    protected void setPassword(String userName, String password) throws SecurityManagerException {
        super.setPassword(userName, password);
    }

    @Override
    protected List<ComponentReference> listBoundComponents(String ownerName, boolean inSysplex) throws SecurityManagerException {
        return super.listBoundComponents(ownerName, inSysplex);
    }

    @Override
    protected boolean isUserActive(String userName) {
        return this.context.exchange.isOwnerActive(userName);
    }

    @Override
    protected boolean isGroupActive(String groupName) {
        return this.context.exchange.isOwnerActive(groupName);
    }

    @Override
    protected List<ComponentReference> listRemoteBoundComponents(String ownerName) {
        return this.context.exchange.getOwnerComponents(ownerName);
    }

    @Override
    protected ComponentOwner getComponentOwner(String name, boolean withoutSysadmin) throws SecurityManagerException {
        return super.getComponentOwner(name, withoutSysadmin);
    }
}

