/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.User;

class SecurityContextImpl
extends SecurityContext {
    SecurityContextImpl(User user, Object securityManager) {
        super(user, securityManager);
    }

    SecurityContextImpl(Group group, Object securityManager) {
        super(group, securityManager);
    }

    synchronized void bind(AbstractFabricComponent component) {
        component.securityContext = this;
        if (component.reference != null) {
            this.boundComponents.add(component.reference);
            component.reference.setSecurityContext(this);
        }
    }

    synchronized void unbind(AbstractFabricComponent component) {
        if (component.reference != null) {
            component.reference.setSecurityContext(null);
            this.boundComponents.remove(component.reference);
        }
        if (this.boundComponents.isEmpty()) {
            this.destroy();
        }
    }

    void setUser(User user) {
        this.owner = user;
    }

    boolean isAnonymous() {
        return this.owner instanceof User && ((User)this.owner).isAnonymous();
    }
}

