/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.utils.Base64;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.keys.SSSecurityKeyAlgorithm;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyException;
import com.streamscape.sef.keys.SSSecurityKeyGenerator;
import com.streamscape.sef.keys.SSSecurityKeyStore;
import java.security.Key;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class SSSecurityKeyStoreDataspace
implements SSSecurityKeyStore {
    private final RuntimeContext context;
    private DataspaceAccessor accessor;

    SSSecurityKeyStoreDataspace(RuntimeContext context) {
        this.context = context;
    }

    public synchronized void init() {
        try {
            this.accessor = this.context.getSystemConnection().createDataspaceAccessor(DataspaceType.TSPACE, "SDS");
        }
        catch (Exception exception) {
            throw new SSSecurityKeyException("Initialization of accessor failed.", exception);
        }
        RowSet rowSet = null;
        try {
            rowSet = this.executeQuery("select ALIAS,UUID,ALGORITHM,CREATED_AT,OWNERNAME,IS_PUBLIC,PARAMETERS,SECRET_KEY,PRIVATE_KEY,PUBLIC_KEY from SS_SECURITY_KEYS", "failed to select from SS_SECURITY_KEYS", new Object[0]);
            this.executeQuery("drop collection SS_SECURITY_KEYS", "failed to drop SS_SECURITY_KEYS", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeQuery("create persistent table SS_SECURITY_KEYS if not exists (  NAME string,  UUID string,  ALGORITHM string,  CREATED_AT long,  OWNERNAME string,  IS_PUBLIC boolean,  PARAMETERS string,  SECRET_KEY string,  PRIVATE_KEY string,  PUBLIC_KEY string,  PRIMARY KEY (UUID),  UNIQUE (NAME))", "Initialization of SS_SECURITY_KEYS table failed.", new Object[0]);
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    this.executeQuery("insert into SS_SECURITY_KEYS (NAME,UUID,ALGORITHM,CREATED_AT,OWNERNAME,IS_PUBLIC,PARAMETERS,SECRET_KEY,PRIVATE_KEY,PUBLIC_KEY) values (?,?,?,?,?,?,?,?,?,?)", "Failed to insert into SS_SECURITY_KEYS.", rowSet.getString(1), rowSet.getString(2), rowSet.getString(3), rowSet.getLong(4), rowSet.getString(5), rowSet.getBoolean(6), rowSet.getString(7), rowSet.getString(8), rowSet.getString(9), rowSet.getString(10));
                }
            }
            catch (Exception excepiton) {
                Trace.logException(this, excepiton, true);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }

    @Override
    public List<SSSecurityKeyAlgorithm> listAlgorithms() {
        RowSet rowSet = this.executeQuery("select distinct ALGORITHM from SS_SECURITY_KEYS", "Failed to select ALGORITHM from SS_SECURITY_KEYS.", new Object[0]);
        ArrayList<SSSecurityKeyAlgorithm> result = new ArrayList<SSSecurityKeyAlgorithm>();
        try {
            while (rowSet.next()) {
                result.add(SSSecurityKeyAlgorithm.valueOf(rowSet.getString(1)));
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return result;
    }

    @Override
    public List<SSSecurityKeyEntry> listEntries() {
        return this.listEntriesInternal("", new Object[0]);
    }

    @Override
    public List<SSSecurityKeyEntry> listEntriesForAlgorithm(SSSecurityKeyAlgorithm algorithm) {
        return this.listEntriesInternal(" WHERE ALGORITHM = ?", algorithm.toString());
    }

    @Override
    public SSSecurityKeyEntry getEntryByUUID(String uuid) {
        List<SSSecurityKeyEntry> result = this.listEntriesInternal(" WHERE UUID = ?", uuid);
        return result.size() > 0 ? result.get(0) : null;
    }

    @Override
    public SSSecurityKeyEntry getEntryByName(String name) {
        List<SSSecurityKeyEntry> result = this.listEntriesInternal(" WHERE NAME = ?", name);
        return result.size() > 0 ? result.get(0) : null;
    }

    @Override
    public int deleteAll() {
        return this.deleteEntryInternal("", new Object[0]);
    }

    @Override
    public int deleteEntryByUUID(String uuid) {
        return this.deleteEntryInternal(" WHERE UUID=?", uuid);
    }

    @Override
    public int deleteEntryByName(String name) {
        return this.deleteEntryInternal(" WHERE NAME=?", name);
    }

    @Override
    public void saveEntry(SSSecurityKeyEntry entry) {
        this.executeQuery("insert into SS_SECURITY_KEYS values (?, ?, ?, ?, ?, ?, null, ?, ?, ?)", "Failed to insert into SS_SECURITY_KEYS.", entry.getName(), entry.getUUID(), entry.getAlgorithm().toString(), entry.getCreatedAt(), entry.getOwnerName(), entry.isPublic(), this.getBase64Key(entry.getSecretKey()), this.getBase64Key(entry.getPrivateKey()), this.getBase64Key(entry.getPublicKey()));
    }

    private String getBase64Key(Key key) {
        if (key == null) {
            return null;
        }
        return Base64.encodeBytes(key.getEncoded());
    }

    private List<SSSecurityKeyEntry> listEntriesInternal(String whereClause, Object ... args) {
        RowSet rowSet = this.executeQuery("select NAME, UUID, ALGORITHM, CREATED_AT, OWNERNAME, IS_PUBLIC, SECRET_KEY, PRIVATE_KEY, PUBLIC_KEY from SS_SECURITY_KEYS " + whereClause, "Failed to select from SS_SECURITY_KEYS.", args);
        ArrayList<SSSecurityKeyEntry> result = new ArrayList<SSSecurityKeyEntry>();
        try {
            while (rowSet.next()) {
                try {
                    SSSecurityKeyAlgorithm algorithm = SSSecurityKeyAlgorithm.valueOf(rowSet.getString(3));
                    byte[] secretKey = rowSet.getString(7) != null ? Base64.decode(rowSet.getString(7)) : null;
                    byte[] privateKey = rowSet.getString(8) != null ? Base64.decode(rowSet.getString(8)) : null;
                    byte[] publicKey = rowSet.getString(9) != null ? Base64.decode(rowSet.getString(9)) : null;
                    SSSecurityKeyEntry entry = SSSecurityKeyGenerator.algorithm(algorithm).setName(rowSet.getString(1)).setUuid(rowSet.getString(2)).setCreatedAt(rowSet.getLong(4)).setOwnerName(rowSet.getString(5)).setPublic(rowSet.getBoolean(6)).createFrom(secretKey, privateKey, publicKey);
                    result.add(entry);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        catch (SQLException exception) {
            throw new SSSecurityKeyException("Failed to read from SS_SECURITY_KEYS table.", exception);
        }
        return result;
    }

    private int deleteEntryInternal(String whereClause, Object ... args) {
        RowSet rowSet = this.executeQuery("delete from SS_SECURITY_KEYS " + whereClause, "Failed to delete from SS_SECURITY_KEYS.", args);
        try {
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return 0;
    }

    private synchronized RowSet executeQuery(String query, String error, Object ... args) {
        this.checkOpened();
        try {
            return this.accessor.executeQuery(query, args);
        }
        catch (DataspaceComponentException exception) {
            throw new SSSecurityKeyException(error, exception);
        }
    }

    private void checkOpened() {
        if (this.accessor == null) {
            throw new SSSecurityKeyException("Accessor is not created.");
        }
        if (!this.accessor.isOpened()) {
            throw new SSSecurityKeyException("Accessor is not opened.");
        }
    }
}

