/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.NameManager;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLClientFactoriesMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.GenericSLSession;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SLSessionMFContext;
import com.streamscape.sef.dispatcher.SLSessionMFSession;
import com.streamscape.sef.dispatcher.SetupRoutedSessionOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SLSessionUseOperation
extends AbstractDSLOperation<GenericSLSession> {
    public static final String NAME = "use";

    SLSessionUseOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("USE");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().setSyntaxHint(SyntaxHint.SPACE)).addParameter((AbstractParameter)((ExpressionParameter)new ExpressionParameter("ComponentName").setEndDelimiterToCommandEnd()).setCompactSyntax("<NodeName> | [<NodeName>://]<ComponentType>.<ComponentName> | <FactoryType>.<FactoryName> | activator"))).addModifier((AbstractModifier)new Modifier("connection factory").addParameter(new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter()))).addModifier((AbstractModifier)new Modifier("dropbox").addParameter((SyntaxParameter)new IdentifierParameter("name").setName("dropBoxName")))).addModifier((AbstractModifier)new Modifier("server").addParameter(new IdentifierParameter("serverName")))).addModifier(new Modifier("..", "Rollback")));
        this.syntax.setDescription("Changes the current session context.");
        this.syntax.setSyntaxDescription("use <NodeName>                                   - Changes the current session context to a context of the specified Fabric node.\nuse [NodeName://]<ComponentType>.<ComponentName> - Changes the current session context to a context of the specified Fabric component.\nuse <FactoryType>.<FactoryName>                  - Changes the current session context to a context of the specified JDBC or Client connection factory.\nuse connection factory <Type>.<Name>             - Changes the current session context to a context of the specified JDBC or Client connection factory.\nuse dropbox <name>                               - Changes the current session context to a context of the specified DropBox.\nuse activator                                    - Changes the current session context to a context of the Activator.\nuse server <server name>                         - Changes the current dataspace context to a context of the specified virtual server.\nuse ..                                           - Changes the current session context to the previous node context.");
        this.syntax.setExamples("use Node1\nuse TestService.Service1\nuse Node1://TestService.Service1\nuse tspace.Dataspace1\nuse Node1://tspace.Dataspace1\nuse MySQL.MyServer\nuse connection factory MySQL.MyServer\nuse dropbox Release\nuse activator\nuse server OpenCart\nuse ..");
        this.syntax.addCompletionCommand("list nodes");
        this.syntax.addCompletionCommand("list components");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        SLSessionImpl slSession = (SLSessionImpl)this.callable;
        boolean isConnectionFactorySet = comp.scriptToComplete != null && BufferUtils.normalizeCommand(comp.scriptToComplete).toLowerCase().startsWith("connection factory ");
        boolean isVirtualServerSet = comp.scriptToComplete != null && BufferUtils.normalizeCommand(comp.scriptToComplete).toLowerCase().startsWith("server ");
        boolean isDropBoxSet = comp.scriptToComplete != null && BufferUtils.normalizeCommand(comp.scriptToComplete).toLowerCase().startsWith("dropbox ");
        try {
            SLResponse response;
            AbstractComponentAccessor accessor;
            if (!(isConnectionFactorySet || isVirtualServerSet || isDropBoxSet)) {
                SLResponse response2;
                Moderator moderator = slSession.owningConnection.getModerator();
                FabricNodeReference localNode = moderator.lookupFabricNode(((GenericSLSession)this.callable).getNodeName());
                completions.addAll(moderator.getFabricNodes().stream().filter(node -> !node.getFabricAddress().belongsToSameNode(localNode.getFabricAddress())).map(FabricNodeReference::getName).collect(Collectors.toList()));
                Collections.sort(completions);
                ArrayList<String> localComponentNames = new ArrayList<String>();
                ArrayList<String> remoteComponentNames = new ArrayList<String>();
                for (ComponentReference component2 : moderator.getComponents(EventScope.INHERITED)) {
                    if (component2.getModel() != ComponentModel.DATASPACE && component2.getModel() != ComponentModel.SERVICE || SLSessionUseOperation.isSystemComponent(component2.getName())) continue;
                    if (component2.getAddress().belongsToSameNode(localNode.getFabricAddress())) {
                        localComponentNames.add(SLSessionUseOperation.buildDataspaceComponentName(component2, comp.scriptToComplete));
                        continue;
                    }
                    Object componentFullName = component2.getName();
                    if (component2.getModel() == ComponentModel.DATASPACE && comp.scriptToComplete != null && comp.scriptToComplete.trim().length() > 0) {
                        String nodeName = ModeratorUtils.extractNodeName(component2.getName()) + "://";
                        String prefix = comp.scriptToComplete.trim();
                        if (prefix.length() > nodeName.length() && prefix.startsWith(nodeName)) {
                            componentFullName = nodeName + SLSessionUseOperation.buildDataspaceComponentName(component2, prefix.substring(nodeName.length()));
                        }
                    }
                    remoteComponentNames.add((String)componentFullName);
                }
                if (slSession.isRouted() && (response2 = slSession.invokeRoutedRequest(new SetupRoutedSessionOperation.Definition(null, true))).getObject() != null && response2.getObject() instanceof List) {
                    localComponentNames.addAll(((List)response2.getObject()).stream().map(component -> SLSessionUseOperation.buildDataspaceComponentName(component, comp.scriptToComplete)).collect(Collectors.toList()));
                }
                Collections.sort(localComponentNames);
                Collections.sort(remoteComponentNames);
                completions.addAll(localComponentNames);
                completions.addAll(remoteComponentNames);
                if (moderator.getFabricNode().getRole() == FabricNodeRole.MANAGEMENT_NODE) {
                    completions.add("activator");
                }
            }
            if (!isDropBoxSet && !isVirtualServerSet) {
                try {
                    accessor = slSession.mfSession.isRouted() && slSession.mfSession.context != null ? slSession.mfSession.context.accessor : slSession.mfSession.initialNodeContext.accessor;
                    response = accessor.invokeRequest("e.sys.sl.ClientFactoriesMessage", new SLClientFactoriesMessage(), accessor.requestTimeout);
                    if (!response.isOK()) {
                        throw response.getException() != null ? response.getException() : new Exception(response.getText());
                    }
                    if (response.getObject() == null) {
                        throw new Exception("Response object is null.");
                    }
                    if (!(response.getObject() instanceof List)) {
                        throw new Exception("Response object is not a list.");
                    }
                    List factories = (List)response.getObject();
                    if (!factories.isEmpty() && !isConnectionFactorySet) {
                        completions.add("connection factory");
                    }
                    completions.addAll(factories.stream().map(factory -> (isConnectionFactorySet ? "connection factory " : "") + (String)factory.second).collect(Collectors.toList()));
                }
                catch (Throwable exception) {
                    Trace.logError(this, "Obtaining a list of usable client factories failed. Cause: " + exception.getMessage());
                }
            }
            if (!isConnectionFactorySet && !isVirtualServerSet) {
                try {
                    accessor = slSession.mfSession.isRouted() && slSession.mfSession.context != null ? slSession.mfSession.context.accessor : slSession.mfSession.initialNodeContext.accessor;
                    response = accessor.invokeRequest("e.sys.sl.ClientFactoriesMessage", new SLClientFactoriesMessage(slSession.mfSession.getOwnerName(), false), accessor.requestTimeout);
                    if (!response.isOK()) {
                        throw response.getException() != null ? response.getException() : new Exception(response.getText());
                    }
                    if (response.getObject() == null) {
                        throw new Exception("Response object is null.");
                    }
                    if (!(response.getObject() instanceof List)) {
                        throw new Exception("Response object is not a list.");
                    }
                    List dropBoxes = (List)response.getObject();
                    completions.addAll(dropBoxes.stream().map(factory -> "dropbox " + factory).collect(Collectors.toList()));
                }
                catch (Throwable exception) {
                    Trace.logError(this, "Obtaining a list of DropBoxes failed. Cause: " + exception.getMessage());
                }
            }
            if (!isConnectionFactorySet && !isVirtualServerSet && !isDropBoxSet && this.callable instanceof SLSessionImpl && ((SLSessionImpl)this.callable).mfSession != null && ((SLSessionImpl)this.callable).mfSession.context instanceof SLSessionMFContext && ((SLSessionImpl)this.callable).mfSession.context.accessor instanceof DataspaceAccessor) {
                completions.add("server");
            }
            if (!(isConnectionFactorySet || isVirtualServerSet || isDropBoxSet)) {
                completions.add("..");
            }
            this.setPreserveCompletionOrder();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String buildDataspaceComponentName(ComponentReference component, String prefix) {
        String dataspaceTypeToComplete;
        Object componentName = ModeratorUtils.extractComponentName(component.getName());
        if (component.getModel() != ComponentModel.DATASPACE || prefix == null || prefix.trim().length() == 0) {
            return componentName;
        }
        prefix = prefix.trim();
        String dataspaceType = ((String)componentName).substring(0, ((String)componentName).indexOf(46));
        String dataspaceName = ((String)componentName).substring(((String)componentName).indexOf(46) + 1);
        int pos = prefix.indexOf(46);
        String string = dataspaceTypeToComplete = pos > 0 ? prefix.substring(0, pos) : prefix;
        if (dataspaceTypeToComplete.length() > 0 && dataspaceType.trim().toLowerCase().startsWith(dataspaceTypeToComplete.toLowerCase())) {
            componentName = dataspaceTypeToComplete;
            if (dataspaceTypeToComplete.length() < dataspaceType.length()) {
                String suffix = dataspaceType.substring(dataspaceTypeToComplete.length());
                suffix = Character.isLowerCase(dataspaceTypeToComplete.charAt(0)) ? suffix.toLowerCase() : suffix.toUpperCase();
                componentName = (String)componentName + suffix;
            }
            componentName = (String)componentName + "." + dataspaceName;
        }
        return componentName;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.existsParameter("ComponentName")) {
            String componentName = statement.getParameter("ComponentName").getValue();
            if (componentName.contains(".")) {
                try {
                    List<String> tokens = ModeratorUtils.splitComponentFullName(componentName, true);
                    return tokens.size() == 2 ? new Definition(null, tokens.get(0), NameManager.unquoteString(tokens.get(1))) : new Definition(tokens.get(0), tokens.get(1), NameManager.unquoteString(tokens.get(2)));
                }
                catch (FabricException exception) {
                    throw new ParsingException(this.getSyntaxErrorMessage(exception.getMessage()));
                }
            }
            return new Definition(componentName);
        }
        if (statement.existsParameter("FactoryType")) {
            return new Definition(statement.getParameter("FactoryType").getValue(), statement.getParameter("FactoryName").getValue(), Definition.ContextType.FACTORY);
        }
        if (statement.existsParameter("serverName")) {
            return new Definition("Server", statement.getParameter("serverName").getValue(), Definition.ContextType.SERVER);
        }
        if (statement.existsParameter("dropBoxName")) {
            return new Definition("DropBox", statement.getParameter("dropBoxName").getValue(), Definition.ContextType.DROPBOX);
        }
        if (statement.existsModifier("Rollback")) {
            return new Definition(true);
        }
        throw new ParsingException(this.getSyntaxErrorMessage("Undefined error."));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String initialNodeName;
        Definition definition = (Definition)statement;
        SLSessionImpl callable = (SLSessionImpl)this.callable;
        SLSessionMFSession mfSession = (SLSessionMFSession)session;
        String string = initialNodeName = mfSession.initialNodeContext != null ? mfSession.initialNodeContext.componentName : callable.owningConnection.getModerator().getFabricNode().getName();
        if (this.isDataspaceType(definition.componentType)) {
            definition.componentType = definition.componentType.toUpperCase();
        }
        if (definition.rollback && mfSession.context.contextType == Definition.ContextType.SERVER) {
            try {
                mfSession.context.switchFromVirtualServerContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return callable.getPrompt(mfSession.context.nodeName, mfSession.context.componentType, mfSession.context.componentName);
        }
        if (definition.componentType.equalsIgnoreCase("Runtime") || definition.componentType.equalsIgnoreCase("RuntimeContext")) {
            definition.componentType = "RuntimeContext";
            if (definition.rollback) {
                if (callable.hasActivatorSession()) {
                    callable.unsetActivatorSession();
                } else if (!SLSessionUseOperation.inNodeContext(mfSession.context)) {
                    mfSession.setContext(mfSession.nodeContext);
                } else if (mfSession.isSwitched) {
                    mfSession.setNodeContext(mfSession.initialNodeContext, false);
                }
                return callable.getPrompt(mfSession.nodeContext.componentName);
            }
            if (definition.componentName == null || definition.componentName.equals(initialNodeName)) {
                if (mfSession.context == null) {
                    mfSession.setInitialContext(new SLSessionMFContext(callable, initialNodeName, definition.componentType, initialNodeName));
                } else if (!SLSessionUseOperation.inNodeContext(mfSession.context) || mfSession.isSwitched) {
                    mfSession.setNodeContext(mfSession.initialNodeContext, false);
                }
                return callable.getPrompt(initialNodeName);
            }
            if (definition.componentName.equalsIgnoreCase("activator")) {
                return callable.setActivatorSession();
            }
            if (mfSession.context == null) {
                mfSession.setInitialContext(new SLSessionMFContext(callable, definition.componentName, definition.componentType, definition.componentName));
            } else if (SLSessionUseOperation.inNodeContext(mfSession.context)) {
                if (!mfSession.context.componentName.equals(definition.componentName)) {
                    this.switchToNodeContext(definition, mfSession);
                }
            } else if (mfSession.nodeContext.componentName.equals(definition.componentName)) {
                mfSession.setContext(mfSession.nodeContext);
            } else {
                this.switchToNodeContext(definition, mfSession);
            }
            return callable.getPrompt(definition.componentName);
        }
        if (definition.nodeName == null) {
            definition.nodeName = callable.nodeName;
        }
        if (definition.contextType == Definition.ContextType.SERVER) {
            mfSession.context.switchToVirtualServerContext(definition.componentName);
            Object prompt = mfSession.isRouted() ? ModeratorUtils.makeComponentFullName(mfSession.context.nodeName, mfSession.context.componentType, mfSession.context.componentName) : ModeratorUtils.makeComponentFullName(mfSession.context.componentType, mfSession.context.componentName);
            prompt = (String)prompt + ":" + mfSession.context.subComponentName;
            PromptSLResponse response = callable.getPrompt(mfSession.context.nodeName, mfSession.context.componentType, mfSession.context.componentName + ":" + mfSession.context.subComponentName);
            response.setPrompt((String)prompt);
            return response;
        }
        if (definition.nodeName.equals(callable.nodeName)) {
            if (!mfSession.context.componentType.equals(definition.componentType) || !mfSession.context.componentName.equals(definition.componentName)) {
                mfSession.setContext(this.createContext(definition));
            }
        } else {
            SLSessionMFContext newContext = this.createContext(definition);
            mfSession.setNodeContext(mfSession.initialNodeContext, !definition.nodeName.equals(initialNodeName));
            mfSession.setContext(newContext);
        }
        return callable.getPrompt(definition.nodeName, definition.componentType, definition.componentName);
    }

    private void switchToNodeContext(Definition definition, SLSessionMFSession mfSession) throws Exception {
        mfSession.setNodeContext(new SLSessionMFContext((SLSessionImpl)this.callable, definition.componentName, definition.componentType, definition.componentName), true);
    }

    private SLSessionMFContext createContext(Definition definition) throws Exception {
        return new SLSessionMFContext((SLSessionImpl)this.callable, definition.nodeName, definition.componentType, definition.componentName, definition.contextType);
    }

    private boolean isDataspaceType(String componentType) {
        try {
            return DataspaceType.valueOf(componentType.toUpperCase()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean inNodeContext(SLSessionMFContext mfContext) {
        return mfContext != null && mfContext.componentType.equalsIgnoreCase("RuntimeContext");
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String componentType;
        private String componentName;
        private ContextType contextType = ContextType.NONE;
        private boolean rollback = false;

        Definition() {
            this("RuntimeContext", null);
        }

        Definition(String nodeName) {
            this(nodeName, "RuntimeContext", nodeName);
        }

        Definition(String nodeName, String componentType, String componentName) {
            this(componentType, componentName);
            this.nodeName = nodeName;
        }

        Definition(String componentType, String componentName, ContextType contextType) {
            this(componentType, componentName);
            this.contextType = contextType;
        }

        private Definition(String componentType, String componentName) {
            super(SLSessionUseOperation.NAME);
            this.componentType = componentType;
            this.componentName = componentName;
            this.contextType = ContextType.NONE;
        }

        Definition(boolean rollback) {
            this();
            this.rollback = rollback;
        }

        public static enum ContextType {
            NONE,
            FACTORY,
            DROPBOX,
            SERVER;

        }
    }
}

