/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.SLSessionMFContext;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFContext;
import com.streamscape.slex.slang.SLSessionException;

class SLSessionMFSession
extends AbstractMFSession {
    SLSessionMFContext context;
    SLSessionMFContext nodeContext;
    SLSessionMFContext initialNodeContext;
    boolean isSwitched = false;
    long timeout;

    SLSessionMFSession(String name, String componentName, User user) {
        super(name, componentName, user, false, name, null);
    }

    @Override
    public SLSessionMFContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(MFContext context) {
        if (context instanceof SLSessionMFContext) {
            if (this.context != null && this.context != this.nodeContext) {
                this.context.close();
            }
            this.context = (SLSessionMFContext)context;
        }
    }

    void setNodeContext(SLSessionMFContext context, boolean isSwitched) {
        if (this.context != null && this.context != this.initialNodeContext) {
            this.context.close();
        }
        if (this.nodeContext != null && this.nodeContext != this.initialNodeContext) {
            this.nodeContext.close();
        }
        this.context = context;
        this.nodeContext = context;
        this.setSwitched(isSwitched);
    }

    void setInitialContext(SLSessionMFContext context) {
        this.context = context;
        this.nodeContext = context;
        this.initialNodeContext = context;
    }

    SLSessionUseOperation.Definition reset() {
        if (this.context != null && this.nodeContext != null && this.initialNodeContext != null) {
            if (!this.context.isAvailable()) {
                if (this.nodeContext.isAvailable()) {
                    this.context.close();
                    this.context = this.nodeContext;
                } else if (this.initialNodeContext.isAvailable()) {
                    this.context.close();
                    this.context = this.initialNodeContext;
                    this.nodeContext.close();
                    this.nodeContext = this.initialNodeContext;
                } else {
                    return null;
                }
            }
            return new SLSessionUseOperation.Definition(this.context.getNodeName(), this.context.getComponentType(), this.context.getComponentName());
        }
        return null;
    }

    void setRouted(boolean isRouted) {
        this.isRouted = isRouted;
    }

    void setSwitched(boolean isSwitched) {
        this.isSwitched = isSwitched;
    }

    void close() {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }

    void forcedClose(boolean clear) {
        if (this.context != null) {
            this.context.forcedClose();
            if (clear) {
                this.context = null;
            }
        }
    }

    void routedClose() {
        if (this.context != null) {
            this.context.routedClose();
        }
    }

    boolean isNodeContext() {
        return this.context == this.nodeContext;
    }

    boolean isAvailable() {
        return this.context != null && this.context.isAvailable();
    }

    SLResponse[] invokeCommand(String command, long timeout) throws SLSessionException {
        SLResponse[] responses = new SLResponse[3];
        if (this.context != null) {
            responses[0] = this.doInvokeCommand(this.context, command, timeout);
        }
        if (this.context != this.initialNodeContext) {
            responses[1] = this.doInvokeCommand(this.initialNodeContext, command, timeout);
        }
        if (this.context != this.nodeContext) {
            responses[2] = this.doInvokeCommand(this.nodeContext, command, timeout);
        }
        return responses;
    }

    private SLResponse doInvokeCommand(SLSessionMFContext context, String command, long timeout) throws SLSessionException {
        try {
            return context != null && context.accessor != null ? context.accessor.invokeLanguageRequest(command, timeout) : null;
        }
        catch (FabricComponentAccessorException exception) {
            throw new SLSessionException(7002, (Throwable)exception);
        }
    }
}

