/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.sef.dispatcher.SetupRoutedSessionOperation;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.MFContext;

class SLSessionMFContext
implements MFContext {
    String nodeName;
    String componentType;
    String componentName;
    AbstractComponentAccessor accessor;
    SLSessionUseOperation.Definition.ContextType contextType;
    String subComponentType;
    String subComponentName;

    SLSessionMFContext(SLSessionImpl session, String nodeName, String componentType, String componentName) throws Exception {
        this(session, nodeName, componentType, componentName, SLSessionUseOperation.Definition.ContextType.NONE);
    }

    SLSessionMFContext(SLSessionImpl session, String nodeName, String componentType, String componentName, SLSessionUseOperation.Definition.ContextType contextType) throws Exception {
        FabricNodeReference node;
        this.nodeName = nodeName;
        this.componentType = componentType;
        this.componentName = componentName;
        this.contextType = contextType;
        AbstractFabricConnection connection = session.getUnderlyingConnection();
        if (contextType == SLSessionUseOperation.Definition.ContextType.NONE && !componentType.equals("RuntimeContext")) {
            RepositoryAccessor repositoryAccessor = session.isRouted() ? connection.getRemoteRepositoryAccessor(nodeName) : connection.getRepositoryAccessor();
            try {
                contextType = repositoryAccessor.existsJDBCFactory(componentName, componentType) || repositoryAccessor.existsClientFactory(componentName, componentType) ? SLSessionUseOperation.Definition.ContextType.FACTORY : SLSessionUseOperation.Definition.ContextType.NONE;
            }
            catch (Exception exception) {
                contextType = SLSessionUseOperation.Definition.ContextType.NONE;
            }
        }
        if (contextType == SLSessionUseOperation.Definition.ContextType.FACTORY || contextType == SLSessionUseOperation.Definition.ContextType.DROPBOX) {
            try {
                this.accessor = (AbstractComponentAccessor)connection.createFactoryConnectionAccessor(nodeName, componentType, componentName, session);
                this.componentName = this.accessor.componentName;
                return;
            }
            catch (Throwable exception) {
                while (exception.getCause() != null && !(exception instanceof ClientException)) {
                    exception = exception.getCause();
                }
                if (exception instanceof FabricConnectionException || exception instanceof FabricComponentAccessorException) {
                    throw (Exception)exception;
                }
                if (exception instanceof ClientException) {
                    throw (ClientException)exception;
                }
                throw new FabricException(exception);
            }
        }
        FabricNodeReference fabricNodeReference = node = nodeName == null ? connection.getModerator().getFabricNode() : connection.getModerator().lookupFabricNode(nodeName);
        if (node == null) {
            throw new FabricException("Node '" + nodeName + "' not found.");
        }
        if (componentType.equals("RuntimeContext")) {
            this.accessor = session.isInstant ? connection.component.createInstantServiceAccessor(nodeName, componentType, componentName, session) : connection.component.createServiceAccessor(nodeName, componentType, componentName, false, session);
        } else {
            Pair specialData = null;
            ComponentReference component = node.lookupComponent(this.getComponentFullName());
            if (component == null) {
                SLResponse response;
                if (session.isRouted() && (response = session.invokeRoutedRequest(new SetupRoutedSessionOperation.Definition(this.getComponentFullName(), true))).getObject() != null && response.getObject() instanceof Pair) {
                    specialData = (Pair)response.getObject();
                    component = (ComponentReference)specialData.first;
                    if (specialData.second instanceof RequestConsumerReferenceImpl) {
                        ((RequestConsumerReferenceImpl)specialData.second).isSpecial = true;
                    }
                }
                if (component == null) {
                    throw new FabricException("Component '" + ModeratorUtils.makeComponentFullName(nodeName, componentType, componentName) + "' not found or not accessible.");
                }
            }
            switch (component.getModel()) {
                case DATASPACE: {
                    DataspaceType dataspaceType;
                    try {
                        dataspaceType = DataspaceType.valueOf(componentType);
                    }
                    catch (IllegalArgumentException exception) {
                        throw new FabricException("Invalid dataspace type '" + componentType + "'.");
                    }
                    this.accessor = specialData != null ? connection.createDataspaceAccessor(node, (ComponentReference)specialData.first, (RequestConsumerReference)specialData.second, session) : connection.createDataspaceAccessor(nodeName, dataspaceType, componentName, false, session);
                    break;
                }
                case SERVICE: {
                    this.accessor = specialData != null ? connection.createServiceAccessor(node, (ComponentReference)specialData.first, (RequestConsumerReference)specialData.second, session) : connection.createServiceAccessor(nodeName, componentType, componentName, false, session);
                    break;
                }
                default: {
                    throw new FabricException("Component '" + this.getComponentFullName() + "' neither Dataspace nor Service.");
                }
            }
        }
        this.accessor.setInterruptUnderlyingRequestOnTimeout(true);
    }

    public void switchToVirtualServerContext(String componentName) throws FabricException {
        if (!(this.accessor instanceof DataspaceAccessor)) {
            throw new FabricException("Switch to virtual server is allowed in dataspace context only.");
        }
        try {
            ((DataspaceAccessor)((Object)this.accessor)).executeQuery("use server " + componentName);
        }
        catch (Exception exception) {
            throw new FabricException("Switch context to virtual server failed.", exception);
        }
        this.contextType = SLSessionUseOperation.Definition.ContextType.SERVER;
        this.subComponentType = "Server";
        this.subComponentName = componentName;
    }

    public void switchFromVirtualServerContext() throws FabricException {
        if (!(this.accessor instanceof DataspaceAccessor)) {
            throw new FabricException("Switch from virtual server is allowed in dataspace context only.");
        }
        try {
            ((DataspaceAccessor)((Object)this.accessor)).executeQuery("use ..");
        }
        catch (Exception exception) {
            throw new FabricException("Switch context from virtual server failed.", exception);
        }
        this.contextType = SLSessionUseOperation.Definition.ContextType.NONE;
        this.subComponentType = null;
        this.subComponentName = null;
    }

    @Override
    public Object getEntity() {
        return null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void close() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }

    void forcedClose() {
        this.accessor.forcedClose();
    }

    void routedClose() {
    }

    String getComponentFullName() {
        return ModeratorUtils.makeComponentFullName(this.componentType, this.componentName);
    }

    boolean isAvailable() {
        return this.accessor != null && this.accessor.isAvailable();
    }
}

