/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractSLSession;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.SLRequestRaiser;
import com.streamscape.sef.dispatcher.SLSessionDSLProvider;
import com.streamscape.sef.dispatcher.SLSessionMFSession;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.security.User;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.mnode.activator.ActivatorSLSessionImpl;
import java.util.concurrent.locks.ReentrantLock;

class SLSessionImpl
extends AbstractSLSession
implements SLRequestRaiser {
    boolean isRouted = false;
    boolean isInstant = false;
    boolean isSystem = false;
    transient AbstractFabricConnection owningConnection;
    transient RoutedCloseListener routedCloseListener;
    transient ReopenListener reopenListener;
    transient SLMessageListener slMessageListener;
    transient EventAsyncConsumer slMessageConsumer;
    transient RequestConsumerReference activatorSession;
    transient boolean restoreActivatorSession = false;
    transient boolean restoreReconnectAttempts = false;
    private AbstractComponentAccessor currentCommandAccessor;
    private String currentCommand;
    private final ReentrantLock currentCommandLock = new ReentrantLock();
    private static final LongNumberAllocatorSimple SESSION_NAME_ALLOCATOR = new LongNumberAllocatorSimple();

    SLSessionImpl(AbstractFabricConnection owningConnection, String nodeName, User user, boolean isSystem) throws SLSessionException {
        this.owningConnection = owningConnection;
        this.sessionName = "SLSession" + SESSION_NAME_ALLOCATOR.getNumber();
        this.isInstant = user != null;
        this.isSystem = isSystem;
        this.initMFSession(nodeName, user);
        this.open(true, nodeName);
    }

    void open(boolean first, String nodeName) throws SLSessionException {
        if (!(first || this.mfSession != null && Utils.equalsNullSafe(this.nodeName, nodeName))) {
            this.initMFSession(nodeName, null);
        }
        this.doOpen(first, new SLSessionUseOperation.Definition(nodeName), false);
    }

    void reopen() throws SLSessionException {
        if (this.mfSession == null) {
            this.open(false, this.owningConnection.getExchange().getNodeName());
        } else {
            SLSessionUseOperation.Definition useDefinition = this.mfSession.reset();
            if (useDefinition != null) {
                this.doOpen(false, useDefinition, true);
            }
        }
    }

    private void doOpen(boolean first, SLSessionUseOperation.Definition useDefinition, boolean fullReopen) throws SLSessionException {
        PromptSLResponse response = (PromptSLResponse)this.doSlangRequest(useDefinition, 30000L);
        this.isOpened = true;
        if (!this.isInstant) {
            Trace.logInfo(this, "SLANG session '" + this.sessionName + "' " + (first ? "" : "re-") + "opened.");
            this.initCompleter();
            if (!first) {
                if (this.slMessageListener != null) {
                    this.setSLMessageListener(this.slMessageListener);
                }
                if (this.reopenListener != null) {
                    this.reopenListener.onReopen(response, fullReopen ? ReopenSessionType.STANDARD : ReopenSessionType.RESTORING_PARENT);
                }
                if (this.restoreActivatorSession) {
                    this.restoreActivatorSession = false;
                    try {
                        response = this.setActivatorSession();
                        if (this.reopenListener != null) {
                            this.reopenListener.onReopen(response, ReopenSessionType.RESTORING_ACTIVATOR);
                        }
                    }
                    catch (Exception exception) {
                        this.restoreUnreliableSession();
                    }
                }
            }
        }
    }

    private void initMFSession(String nodeName, User user) {
        this.nodeName = nodeName;
        if (this.mfSession != null) {
            this.mfSession.close();
        }
        this.mfSession = new SLSessionMFSession(this.sessionName, this.owningConnection.component.getFullName(), user != null ? user : this.owningConnection.getCurrentUser());
    }

    @Override
    public String getUserName() {
        return this.owningConnection.getCurrentUserName();
    }

    @Override
    protected SLResponse invokeUse(SLSessionUseOperation.Definition definition) {
        SLResponse response = this.dslProvider.invoke(definition, this.mfSession, this.mfSession.timeout);
        if (response instanceof PromptSLResponse) {
            PromptSLResponse prompt = (PromptSLResponse)response;
            if (StringUtils.equalsNullSafe(prompt.getComponentType(), "Activator")) {
                prompt.setPrompt(this.nodeName + "[Activator]");
            } else {
                this.nodeName = prompt.getNodeName() != null ? prompt.getNodeName() : prompt.getText();
                this.isRouted = !this.owningConnection.component.moderator.getFabricNode().getName().equals(this.nodeName);
                this.mfSession.setRouted(this.isRouted);
                if (this.isOpened && this.routedCloseListener == null) {
                    this.setRoutedCloseListener(new RoutedCloseListenerImpl());
                }
                if (prompt.getText() == null) {
                    prompt.setPrompt(this.isRouted ? ModeratorUtils.makeComponentFullName(this.nodeName, prompt.getComponentType(), prompt.getComponentName()) : ModeratorUtils.makeComponentFullName(prompt.getComponentType(), prompt.getComponentName()));
                }
            }
        }
        return response;
    }

    @Override
    public boolean interruptCommand(String command) throws SLSessionException {
        this.currentCommandLock.lock();
        try {
            if (this.currentCommandAccessor == null || this.currentCommand != command) {
                boolean bl = false;
                return bl;
            }
            SLResponse response = this.currentCommandAccessor.invokeInterruptRequest(this.currentCommand);
            if (response.getException() != null) {
                throw new SLSessionException(7012, response.getException());
            }
            if (!response.isOK()) {
                throw new SLSessionException(7012, response.getText());
            }
        }
        catch (FabricComponentAccessorException exception) {
            throw new SLSessionException(7012, "Underlying accessor closed.");
        }
        finally {
            this.currentCommandLock.unlock();
        }
        return true;
    }

    @Override
    public SLResponse invokeRequest(SLStatement request, long timeout) throws SLSessionException {
        try {
            return this.activatorSession != null ? SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)this, request, timeout) : this.mfSession.context.accessor.invokeLanguageRequest(request, timeout);
        }
        catch (FabricComponentAccessorException exception) {
            throw new SLSessionException(7010, "Underlying accessor closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invokeRequest(String request, long timeout) throws SLSessionException {
        if (this.activatorSession != null) {
            return SLRequestRaiser.invokeLanguageRequest((SLRequestRaiser)this, request, timeout);
        }
        this.currentCommandAccessor = this.mfSession.context.accessor;
        this.currentCommand = request;
        try {
            SLResponse sLResponse = this.mfSession.context.accessor.invokeLanguageRequest(request, timeout);
            this.currentCommandLock.lock();
            this.currentCommandAccessor = null;
            this.currentCommand = null;
            this.currentCommandLock.unlock();
            return sLResponse;
        }
        catch (Throwable throwable) {
            try {
                this.currentCommandLock.lock();
                this.currentCommandAccessor = null;
                this.currentCommand = null;
                this.currentCommandLock.unlock();
                throw throwable;
            }
            catch (FabricComponentAccessorException exception) {
                throw new SLSessionException(7010, "Underlying accessor closed.");
            }
        }
    }

    @Override
    public SLResponse invokeCompleteRequest(String request, long timeout) throws SLSessionException {
        try {
            return this.activatorSession != null ? SLRequestRaiser.invokeCompleteRequest(this, request, timeout) : this.mfSession.context.accessor.invokeCompleteRequest(request, timeout);
        }
        catch (FabricComponentAccessorException exception) {
            throw new SLSessionException(7010, "Underlying accessor closed.", exception);
        }
    }

    SLResponse invokeRoutedRequest(SLStatement request) throws SLSessionException {
        try {
            return this.mfSession.nodeContext.accessor.invokeLanguageRequest(request, 30000L);
        }
        catch (FabricComponentAccessorException exception) {
            throw new SLSessionException(7010, "Underlying accessor closed.");
        }
    }

    @Override
    SLResponse processResponse(SLResponse response) throws SLSessionException {
        if (response == null) {
            return new SLResponse(new UnsupportedRequestException());
        }
        if (!response.isOK() && response.getException() == null && response.getText() == null) {
            return this.createErrorResponse("Operation failed.");
        }
        if (!response.isOK() && response.getText() != null && response.getException() == null && !(response instanceof HelpSLResponse)) {
            return this.createErrorResponse(response.getText());
        }
        if (response.getException() != null) {
            if (!this.owningConnection.isOpened()) {
                throw new SLSessionException(7010, "Underlying connection is closed.", response.getException());
            }
            if (this.mfSession.getContext() == null) {
                throw new SLSessionException(7010, "Creation of underlying accessor failed.", response.getException());
            }
            if (response.getException() instanceof FabricEventSourceException) {
                if (((FabricEventSourceException)response.getException()).getErrorCode() == 6042) {
                    throw new SLSessionException(6042, response.getException().getMessage());
                }
                throw new SLSessionException(7010, "SLANG request failed.", response.getException());
            }
            if (response.getException() instanceof FabricRequestException && response.getException().getCause() instanceof ExchangeException && ((ExchangeException)response.getException().getCause()).getErrorCode() == 6015) {
                this.nodeName = this.owningConnection.component.moderator.getFabricNode().getName();
                SLResponse useResponse = this.invokeUse(new SLSessionUseOperation.Definition());
                if (useResponse.isOK()) {
                    return new PromptSLResponse(this.getUserName(), this.nodeName, new Exception("Session to Fabric node was forcibly closed."));
                }
                return useResponse;
            }
        }
        return response;
    }

    SLResponse createErrorResponse(String text) {
        return new SLResponse(text, false);
    }

    @Override
    public synchronized void close() {
        if (this.isOpened && this.mfSession != null) {
            this.mfSession.close();
            this.mfSession = null;
            if (!this.isInstant) {
                this.owningConnection.removeSLSession(this);
                this.removeSLMessageConsumer();
                this.closeSLFileMessageProcessor();
                this.closeSLAudioMessageProcessor();
                Trace.logInfo(this, "SLANG session '" + this.sessionName + "' closed.");
            }
            this.isOpened = false;
        }
    }

    synchronized void forcedClose(boolean clear) {
        if (this.activatorSession != null) {
            try {
                this.unsetActivatorSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restoreActivatorSession = true;
        }
        if (this.mfSession != null) {
            this.mfSession.forcedClose(clear);
        }
        this.closeSLFileMessageProcessor();
        this.closeSLAudioMessageProcessor();
        this.removeSLMessageConsumer();
        this.isOpened = false;
    }

    private void closeSLFileMessageProcessor() {
        if (this.owningConnection.slFileMessageProcessor != null) {
            this.owningConnection.slFileMessageProcessor.close(this.getName());
        }
    }

    private void closeSLAudioMessageProcessor() {
        if (this.owningConnection.slAudioMessageProcessor != null) {
            this.owningConnection.slAudioMessageProcessor.close(this.getName());
        }
    }

    synchronized void routedClose() {
        if (this.isOpened) {
            this.mfSession.routedClose();
            if (this.routedCloseListener != null) {
                this.routedCloseListener.onClose();
            } else {
                this.isRouted = false;
            }
        }
    }

    void setRoutedCloseListener(RoutedCloseListener routedCloseListener) {
        this.routedCloseListener = routedCloseListener;
    }

    boolean isRouted() {
        return this.isRouted;
    }

    void rollback() throws Exception {
        Trace.logDebug(SLSessionImpl.class, "Rollback session '" + this.sessionName + "'...");
        try {
            this.nodeName = this.mfSession.initialNodeContext.getNodeName();
            SLResponse useResponse = this.invokeUse(new SLSessionUseOperation.Definition());
            if (!useResponse.isOK()) {
                throw new FabricException("Session rollback failed.", useResponse.getException());
            }
        }
        catch (Exception exception) {
            this.isRouted = false;
            throw exception;
        }
        Trace.logDebug(SLSessionImpl.class, "Session '" + this.sessionName + "' rolled back.");
    }

    void setReopenListener(ReopenListener reopenListener) {
        this.reopenListener = reopenListener;
    }

    boolean isAdministrative() {
        return this.mfSession != null && this.mfSession.getOwner() != null && this.mfSession.getOwner().isAdministrator();
    }

    AbstractFabricConnection getUnderlyingConnection() {
        return this.owningConnection;
    }

    SLSessionDSLProvider getDSLProvider() {
        return this.dslProvider;
    }

    @Override
    public void setSLMessageListener(SLMessageListener listener) throws SLSessionException {
        this.checkOpened();
        if (this.slMessageConsumer == null) {
            String consumerName = "SLMessageListener_" + this.getName();
            try {
                String eventKey = this.owningConnection.component.getFullName() + ":" + this.getName();
                this.slMessageConsumer = this.owningConnection.createSystemEventAsyncConsumer(consumerName, new SLMessageEventListener(listener), "e.sys.sl.Message", "eventKey = '" + eventKey + "'", EventScope.INHERITED, true);
            }
            catch (FabricConnectionException | FabricEventDispatcherException exception) {
                throw new SLSessionException(7011, "Creating SL Message listener failed.", exception);
            }
            this.slMessageConsumer.start();
        } else {
            this.slMessageConsumer.setEventListener(new SLMessageEventListener(listener));
        }
        if (this.owningConnection.slFileMessageProcessor != null) {
            this.owningConnection.slFileMessageProcessor.addSLMessageListener(this.getName(), listener);
        }
        if (this.owningConnection.slAudioMessageProcessor != null) {
            this.owningConnection.slAudioMessageProcessor.addSLMessageListener(this.getName(), listener);
        }
        this.slMessageListener = listener;
    }

    private void removeSLMessageConsumer() {
        if (this.slMessageConsumer != null) {
            this.slMessageConsumer.stop();
            try {
                this.owningConnection.dropSystemConsumer(this.slMessageConsumer.getName());
            }
            catch (FabricConnectionException exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Removing SL Message listener failed.");
            }
            this.slMessageConsumer = null;
        }
        if (this.owningConnection.slFileMessageProcessor != null) {
            this.owningConnection.slFileMessageProcessor.removeSLMessageListener(this.getName());
        }
        if (this.owningConnection.slAudioMessageProcessor != null) {
            this.owningConnection.slAudioMessageProcessor.removeSLMessageListener(this.getName());
        }
    }

    PromptSLResponse setActivatorSession() throws Exception {
        FabricNodeReference node = this.mfSession.nodeContext.accessor.node;
        if (node.getRole() != FabricNodeRole.MANAGEMENT_NODE) {
            throw new SLSessionException(7002, "Node [" + node.getName() + "] is not Management Node.");
        }
        this.activatorSession = this.mfSession.nodeContext.accessor.raiseOpenRequestForActivator().getSession();
        if (this.activatorSession == null) {
            throw new FabricException("Session with Activator is not established. Probably Activator is stopped.");
        }
        if (this.owningConnection.getReconnectAttempts() == 0) {
            this.owningConnection.setReconnectAttempts(-1);
            this.restoreReconnectAttempts = true;
        }
        return ActivatorSLSessionImpl.getPrompt(this.mfSession.getOwnerName(), this.mfSession.nodeContext.nodeName);
    }

    void unsetActivatorSession() throws Exception {
        try {
            this.mfSession.nodeContext.accessor.raiseCloseRequestForActivator(InternalUtils.extractSystemName(ModeratorUtils.extractConsumerName(this.activatorSession.getName())));
            this.restoreUnreliableSession();
        }
        finally {
            this.activatorSession = null;
        }
    }

    boolean hasActivatorSession() {
        return this.activatorSession != null;
    }

    private void restoreUnreliableSession() {
        try {
            if (this.restoreReconnectAttempts && this.owningConnection.getReconnectAttempts() == -1) {
                this.owningConnection.setReconnectAttempts(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram request, long timeout) throws Exception {
        return this.owningConnection.raiseSystemRequest(this.activatorSession, request, timeout);
    }

    @Override
    public SLResponse[] invokeSessionCommand(String command, long timeout) throws SLSessionException {
        SLResponse[] sLResponseArray;
        SLResponse[] result;
        SLResponse[] sLResponseArray2 = result = this.mfSession != null ? this.mfSession.invokeCommand(command, timeout) : null;
        if (this.activatorSession != null) {
            SLResponse[] sLResponseArray3 = new SLResponse[1];
            sLResponseArray = sLResponseArray3;
            sLResponseArray3[0] = this.invokeRequest(command, timeout);
        } else {
            sLResponseArray = result;
        }
        return sLResponseArray;
    }

    static interface ReopenListener {
        public void onReopen(PromptSLResponse var1, ReopenSessionType var2);
    }

    static enum ReopenSessionType {
        STANDARD,
        RESTORING_PARENT,
        RESTORING_ACTIVATOR;

    }

    static interface RoutedCloseListener {
        public void onClose();
    }

    class RoutedCloseListenerImpl
    implements RoutedCloseListener {
        RoutedCloseListenerImpl() {
        }

        @Override
        public void onClose() {
            new SessionRollbackWorker().start();
        }
    }

    private static class SLMessageEventListener
    implements FabricEventListener {
        private SLMessageListener listener;

        SLMessageEventListener(SLMessageListener listener) {
            this.listener = listener;
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) {
            if (event instanceof OpaqueDatagram) {
                try {
                    SLMessage message = (SLMessage)((OpaqueDatagram)event).getData();
                    this.listener.onMessage(message);
                }
                catch (SDOException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
    }

    class SessionRollbackWorker
    extends SingleTaskWorker {
        protected SessionRollbackWorker() {
            super("FSYS:SLANG:SessionRollback", "Performs a rollback of the opened SLANG session.");
        }

        @Override
        protected void doExecute() throws FabricException {
            Utils.sleep(200L);
            try {
                SLSessionImpl.this.rollback();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
    }
}

