/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSLSession;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.GenericSLSession;
import com.streamscape.sef.dispatcher.SLSessionDescribeSearchTagOperation;
import com.streamscape.sef.dispatcher.SLSessionHelpOperation;
import com.streamscape.sef.dispatcher.SLSessionListSearchTagsOperation;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.sef.factory.connection.AbstractGetFetchSizeOperation;
import com.streamscape.sef.factory.connection.AbstractSetFetchSizeOperation;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.GetDataObjectNotationOperation;
import com.streamscape.slex.GetTransferBufferSizeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SetDataObjectNotationOperation;
import com.streamscape.slex.SetSessionContextOperation;
import com.streamscape.slex.SetTransferBufferSizeOperation;
import com.streamscape.slex.ShowSessionContextOperation;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.slang.SLSessionException;
import java.util.Arrays;

class SLSessionDSLProvider
extends AbstractDSLProvider<GenericSLSession> {
    SLSessionDSLProvider(GenericSLSession session) {
        super("SLSessionDSLProvider", session, SuggestionGroup.SESSION_OPERATIONS);
        this.registerOperation(new SLSessionListSearchTagsOperation());
        this.registerOperation(new SLSessionDescribeSearchTagOperation());
        this.registerOperation(new SLSessionHelpOperation());
        if (session instanceof AbstractSLSession) {
            this.registerOperation(new SLSessionSetTransferBufferSizeOperation());
            this.registerOperation(new SLSessionGetTransferBufferSizeOperation());
            this.registerOperation(new SLSessionSetSessionContextOperation());
            this.registerOperation(new SLSessionShowSessionContextOperation());
            if (!(session instanceof AbstractSpecialSLSession)) {
                this.registerOperation(new SLSessionUseOperation());
                this.registerOperation(new SLSessionSetFetchSizeOperation());
                this.registerOperation(new SLSessionGetFetchSizeOperation());
                this.registerOperation(new SLSessionSetDataObjectNotationOperation());
                this.registerOperation(new SLSessionGetDataObjectNotationOperation());
            }
        }
        this.activate(session);
    }

    private static SLResponse invokeSetCommand(SLResponse response, GenericSLSession callable, AbstractDSLOperation<GenericSLSession> operation, long timeout, String parameter) throws Exception {
        SLSessionDSLProvider.invokeInAllContexts(callable, operation.getName() + " " + parameter, timeout);
        return response;
    }

    private static SLResponse invokeGetCommand(SLResponse response, GenericSLSession callable, AbstractDSLOperation<GenericSLSession> operation, long timeout) throws Exception {
        SLResponse response1 = callable.invokeRequest(operation.getName(), timeout);
        if (response1.getRowSet() != null) {
            return response1;
        }
        return response;
    }

    private static SLResponse[] invokeInAllContexts(GenericSLSession callable, String command, long timeout) throws SLSessionException {
        return callable.invokeSessionCommand(command, timeout);
    }

    static class SLSessionSetTransferBufferSizeOperation
    extends SetTransferBufferSizeOperation<GenericSLSession> {
        SLSessionSetTransferBufferSizeOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeSetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout, session.getSLSessionData().getTransferBufferSize() + " bytes");
        }
    }

    static class SLSessionGetTransferBufferSizeOperation
    extends GetTransferBufferSizeOperation<GenericSLSession> {
        SLSessionGetTransferBufferSizeOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeGetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout);
        }
    }

    static class SLSessionSetSessionContextOperation
    extends SetSessionContextOperation<GenericSLSession> {
        SLSessionSetSessionContextOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeSetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout, session.getSLSessionData().getSLFileSessionContext().toString());
        }
    }

    static class SLSessionShowSessionContextOperation
    extends ShowSessionContextOperation<GenericSLSession> {
        SLSessionShowSessionContextOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeGetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout);
        }
    }

    static class SLSessionSetFetchSizeOperation
    extends AbstractSetFetchSizeOperation<GenericSLSession> {
        SLSessionSetFetchSizeOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            SLResponse response = super.invoke(statement, session, timeout);
            SLResponse[] responses = SLSessionDSLProvider.invokeInAllContexts((GenericSLSession)this.callable, this.getName() + " " + session.getSLSessionData().getFetchSize(), timeout);
            return Arrays.stream(responses).filter(rsp -> rsp != null && rsp.isOK() && rsp.getRowSet() != null).findFirst().orElse(response);
        }
    }

    static class SLSessionGetFetchSizeOperation
    extends AbstractGetFetchSizeOperation<GenericSLSession> {
        SLSessionGetFetchSizeOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeGetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout);
        }
    }

    static class SLSessionSetDataObjectNotationOperation
    extends SetDataObjectNotationOperation<GenericSLSession> {
        SLSessionSetDataObjectNotationOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeSetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout, session.getSLSessionData().getDataObjectNotation().toString());
        }
    }

    static class SLSessionGetDataObjectNotationOperation
    extends GetDataObjectNotationOperation<GenericSLSession> {
        SLSessionGetDataObjectNotationOperation() {
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return SLSessionDSLProvider.invokeGetCommand(super.invoke(statement, session, timeout), (GenericSLSession)this.callable, this, timeout);
        }
    }
}

