/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.SLCompleteRequest;
import com.streamscape.sef.dispatcher.SLInterruptRequest;
import com.streamscape.sef.dispatcher.SLSetInterruptRequest;
import com.streamscape.sef.dispatcher.SLStatementWrapper;
import com.streamscape.sef.dispatcher.SLTextWrapper;

interface SLRequestRaiser {
    public ImmutableEventDatagram raiseSystemRequest(ImmutableEventDatagram var1, long var2) throws Exception;

    public static SLResponse invokeLanguageRequest(SLRequestRaiser raiser, SLStatement statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(raiser, "e.sys.sl.StatementWrapper", new SLStatementWrapper(statement, timeout), timeout);
    }

    public static SLResponse invokeLanguageRequest(SLRequestRaiser raiser, String statement, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(raiser, "e.sys.sl.TextWrapper", new SLTextWrapper(statement, timeout), timeout);
    }

    public static SLResponse invokeCompleteRequest(SLRequestRaiser raiser, String command, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(raiser, "e.sys.sl.CompleteRequest", new SLCompleteRequest(command, timeout), timeout);
    }

    public static SLResponse setInterruptUnderlyingRequestOnTimeout(SLRequestRaiser raiser, boolean isInterruptUnderlyingRequestOnTimeout, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(raiser, "e.sys.sl.SetInterruptRequest", new SLSetInterruptRequest(isInterruptUnderlyingRequestOnTimeout, timeout), timeout);
    }

    public static SLResponse invokeInterruptRequest(SLRequestRaiser raiser, String command, long timeout) throws FabricComponentAccessorException {
        return SLRequestRaiser.invokeRequest(raiser, "e.sys.sl.InterruptRequest", new SLInterruptRequest(command, timeout), timeout);
    }

    public static SLResponse invokeRequest(SLRequestRaiser raiser, String eventId, Object wrapper, long timeout) throws FabricComponentAccessorException {
        try {
            ImmutableEventDatagram reply = raiser.raiseSystemRequest(SDOUtils.createOpaqueEvent(eventId, wrapper), timeout);
            if (reply == null) {
                return new SLResponse("Received response is null.", false);
            }
            if (!(reply instanceof OpaqueEvent)) {
                return new SLResponse("Received response has wrong type.", false);
            }
            SLResponse response = (SLResponse)((OpaqueEvent)reply).getData();
            SLRequestRaiser.processAccessibleObjects(response, raiser);
            return response;
        }
        catch (Exception exception) {
            if (exception instanceof FabricRequestException && exception.getCause() != null) {
                return new SLResponse(exception.getCause());
            }
            return new SLResponse(exception);
        }
    }

    public static void processAccessibleObjects(SLResponse response, Object accessor) {
        if (accessor instanceof AbstractComponentAccessor) {
            if (response.getRowSet() != null && response.getRowSet() instanceof AccessibleObjectProxy) {
                ((AccessibleObjectProxy)((Object)response.getRowSet())).setAccessor(accessor);
            }
            if (response.getObject() != null && response.getObject() instanceof AccessibleObjectProxy) {
                ((AccessibleObjectProxy)response.getObject()).setAccessor(accessor);
            }
            if (response.getObject() != null && response.getObject() instanceof Object[]) {
                Object[] array;
                for (Object object : array = (Object[])response.getObject()) {
                    if (!(object instanceof AccessibleObjectProxy)) continue;
                    ((AccessibleObjectProxy)object).setAccessor(accessor);
                }
            }
        }
    }
}

