/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLMessageSequenceId;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import java.util.function.Supplier;

public class SLOperationLogger {
    private static ThreadLocal<SLOperationLoggerContext> currentContext = new ThreadLocal();

    public static void setCurrentSession(MFSession session) {
        currentContext.set(new SLOperationLoggerContext(session));
    }

    public static void setCurrentContext(SLOperationLoggerContext context) {
        currentContext.set(context);
    }

    public static void unsetCurrentSession(MFSession session) {
        SLOperationLoggerContext context = currentContext.get();
        if (context != null && context.session == session) {
            currentContext.set(null);
        }
    }

    public static SLOperationLoggerContext getCurrentContext() {
        return currentContext.get();
    }

    public static SLMessageSequenceId getCurrentMessageCounter() {
        SLOperationLoggerContext context = currentContext.get();
        if (context != null) {
            return context.messageSequenceId;
        }
        return null;
    }

    public static void setSilenceMode(boolean silenceMode) {
        SLOperationLoggerContext context = currentContext.get();
        if (context != null) {
            context.silenceMode = silenceMode;
        }
    }

    public static boolean getSilenceMode() {
        SLOperationLoggerContext context = currentContext.get();
        if (context != null) {
            return context.silenceMode;
        }
        return false;
    }

    public static void log(Object object, String message) {
        SLOperationLogger.log(object, currentContext.get(), message);
    }

    public static void log(String message) {
        SLOperationLogger.log(null, message);
    }

    public static void logDebug(Object object, String message) {
        SLOperationLogger.log(object, Trace.Level.DEBUG, object instanceof Logger ? (Logger)object : null, message);
    }

    public static void logInfo(Object object, String message) {
        SLOperationLogger.log(object, Trace.Level.INFO, object instanceof Logger ? (Logger)object : null, message);
    }

    public static void logError(Object object, String message) {
        SLOperationLogger.log(object, Trace.Level.ERROR, object instanceof Logger ? (Logger)object : null, message);
    }

    public static void logDebug(Object object, Logger logger, String message) {
        SLOperationLogger.log(object, Trace.Level.DEBUG, logger, message);
    }

    public static void logInfo(Object object, Logger logger, String message) {
        SLOperationLogger.log(object, Trace.Level.INFO, logger, message);
    }

    public static void logError(Object object, Logger logger, String message) {
        SLOperationLogger.log(object, Trace.Level.ERROR, logger, message);
    }

    public static void log(Object object, Trace.Level level, Logger logger, String message) {
        SLOperationLogger.log(object, level, logger, currentContext.get(), message);
    }

    public static void log(Object object, SLOperationLoggerContext context, String message) {
        SLOperationLogger.log(object, Trace.Level.DEBUG, null, context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object object, Trace.Level level, Logger logger, SLOperationLoggerContext context, String message) {
        if (context != null && context.session != null && !context.silenceMode) {
            if (logger != null) {
                logger.log(level, message.trim());
            } else if (object != null) {
                Trace.log(object, level, message.trim(), new Object[0]);
            }
            try {
                SLOperationLoggerContext sLOperationLoggerContext = context;
                synchronized (sLOperationLoggerContext) {
                    if (context.messageSequenceId != null) {
                        context.messageSequenceId.incMessageSequenceId();
                    }
                    SLMessage slMessage = new SLMessage(message, context.session);
                    slMessage.setMessageSequenceId(context.messageSequenceId);
                    AbstractOperation.raiseSLMessage(slMessage);
                }
            }
            catch (Throwable exception) {
                Trace.logException(SLOperationLogger.class, exception, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SLResponse invokeWithLoggerWrap(MFSession session, SLOperationLoggerCallback callback, boolean exceptionAsText) {
        SLResponse response = null;
        SLOperationLogger.setCurrentSession(session);
        try {
            response = callback.call();
        }
        catch (UnsupportedRequestException exception) {
            response = new SLResponse(exception);
        }
        catch (Throwable exception) {
            Trace.logDebug(AbstractDSLProvider.class, "WARNING: " + exception.toString());
            response = exceptionAsText ? new SLResponse(Utils.formatExceptionWithUnrepeatedCauses(exception), false) : new SLResponse(exception);
        }
        finally {
            SLMessageSequenceId messageCounter;
            if (response != null && (messageCounter = SLOperationLogger.getCurrentMessageCounter()) != null) {
                response.setLastMessageSequenceId(messageCounter);
            }
            SLOperationLogger.unsetCurrentSession(session);
        }
        return response;
    }

    public static <T> T invokeSilently(Supplier<T> callback) {
        boolean silenceMode = SLOperationLogger.getSilenceMode();
        SLOperationLogger.setSilenceMode(true);
        try {
            T t = callback.get();
            return t;
        }
        finally {
            SLOperationLogger.setSilenceMode(silenceMode);
        }
    }

    public static class SLOperationLoggerContext {
        private MFSession session;
        private SLMessageSequenceId messageSequenceId;
        private boolean silenceMode;

        public SLOperationLoggerContext(MFSession session) {
            this.session = session;
            this.messageSequenceId = new SLMessageSequenceId();
            this.silenceMode = false;
        }
    }

    public static interface SLOperationLoggerCallback {
        public SLResponse call() throws Throwable;
    }
}

