/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.slex.slang.SLMessageListener;
import java.io.IOException;

public class SLFileMessageRaiserRemote
extends AbstractRuntimeFactory
implements SLFileMessageRaiser {
    private RequestConsumerReference consumerReference;
    private String componentName;
    private String slSessionName;
    private MFSession mfSession;
    private SLMessageListener responseListener;

    public SLFileMessageRaiserRemote(String componentName, String slSessionName, MFSession mfSession) {
        this.componentName = componentName;
        this.slSessionName = slSessionName;
        this.mfSession = mfSession;
    }

    public SLFileMessageRaiserRemote(String componentName, SLMessageListener responseListener) {
        this.componentName = componentName;
        this.responseListener = responseListener;
    }

    @Override
    public void open() throws IOException {
        if (this.componentName == null) {
            throw new IOException("Component name is not set.");
        }
        try {
            if (this.consumerReference == null) {
                this.consumerReference = SLFileMessageRaiserRemote.createRequestConsumerReference(this.componentName);
            }
        }
        catch (Exception exception) {
            throw new IOException("Opening SLFileMessageRaiserRemote failed.", exception);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public SLFileMessage raise(SLFileMessage fileMessage, long timeout) throws IOException {
        try {
            fileMessage.setComponentName(this.componentName);
            fileMessage.setSLSessionName(this.slSessionName);
            if (this.mfSession != null) {
                fileMessage.setSessionName(this.mfSession.getName());
                fileMessage.setResourceName(this.mfSession.getResourceName());
            }
            fileMessage.setTimeout(timeout);
            OpaqueDatagram event = OpaqueDatagramFactory.getInstance().createEvent("e.sys.sl.FileMessage");
            event.setData(fileMessage);
            event.setEventKey(this.componentName);
            ImmutableEventDatagram response = SLFileMessageRaiserRemote.getConnection().raiseSystemRequest(this.consumerReference, event, timeout);
            if (response instanceof OpaqueDatagram) {
                SLFileMessage message = (SLFileMessage)((OpaqueDatagram)response).getData();
                if (this.responseListener != null) {
                    this.responseListener.onMessage(message);
                }
                return message;
            }
            throw new IOException("Wrong response received '" + response.getClass().getSimpleName() + "', but expected 'OpaqueDatagram'.");
        }
        catch (Exception exception) {
            if (!(exception instanceof FabricRequestException)) {
                Trace.logDebug(this, "Exception when raising SLFileMessage.");
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
            } else if (exception.getCause() instanceof IOException) {
                throw (IOException)exception.getCause();
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }

    public static RequestConsumerReference createRequestConsumerReference(String componentName) throws Exception {
        String consumerName = componentName + ":" + SLFileMessage.getRequestConsumerName();
        RequestConsumerReference result = ((ModeratorImpl)SLFileMessageRaiserRemote.getConnection().getModerator()).lookupRequestConsumer(consumerName, false);
        if (result == null) {
            throw new Exception("Consumer '" + consumerName + "' not found.");
        }
        return result;
    }

    private static AbstractFabricConnection getConnection() {
        return SLFileMessageRaiserRemote.getContext().getSystemConnection();
    }
}

